# @HEADER
# ************************************************************************
#
#            TriBITS: Tribal Build, Integrate, and Test System
#                    Copyright 2013 Sandia Corporation
#
#
# Under the terms of Contract DE-AC04-94AL85000 with Sandia Corporation,
# the U.S. Government retains certain rights in this software.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are
# met:
#
# 1. Redistributions of source code must retain the above copyright
# notice, this list of conditions and the following disclaimer.
#
# 2. Redistributions in binary form must reproduce the above copyright
# notice, this list of conditions and the following disclaimer in the
# documentation and/or other materials provided with the distribution.
#
# 3. Neither the name of the Corporation nor the names of the
# contributors may be used to endorse or promote products derived from
# this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY SANDIA CORPORATION "AS IS" AND ANY
# EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
# PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL SANDIA CORPORATION OR THE
# CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
# EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
# PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
# PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
# LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
# NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
# SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# ************************************************************************
# @HEADER

##############################################################################
#
# CMake variable for use by Trilinos/SEACAS clients.
#
# Do not edit: This file was generated automatically by CMake.
#
##############################################################################


# Include guard
IF (SEACAS_CONFIG_INCLUDED)
  RETURN()
ENDIF()
SET(SEACAS_CONFIG_INCLUDED TRUE)

# Make sure CMAKE_CURRENT_LIST_DIR is usable
IF (NOT DEFINED CMAKE_CURRENT_LIST_DIR)
  GET_FILENAME_COMPONENT(_THIS_SCRIPT_PATH ${CMAKE_CURRENT_LIST_FILE} PATH)
  SET(CMAKE_CURRENT_LIST_DIR ${_THIS_SCRIPT_PATH})
ENDIF()


## ---------------------------------------------------------------------------
## Compilers used by Trilinos/SEACAS build
## ---------------------------------------------------------------------------

SET(SEACAS_CXX_COMPILER "/usr/bin/mpicxx")

SET(SEACAS_C_COMPILER "/usr/bin/mpicc")

SET(SEACAS_FORTRAN_COMPILER "/usr/bin/mpif90")


## ---------------------------------------------------------------------------
## Compiler flags used by Trilinos/SEACAS build
## ---------------------------------------------------------------------------

## Set compiler flags, including those determined by build type
SET(SEACAS_CXX_FLAGS "  -march=x86-64 -mtune=generic -O2 -pipe -fstack-protector-strong -fno-plt -std=c++11 -O3 -DNDEBUG")

SET(SEACAS_C_FLAGS "  -march=x86-64 -mtune=generic -O2 -pipe -fstack-protector-strong -fno-plt -O3 -DNDEBUG")

SET(SEACAS_FORTRAN_FLAGS " -O3")

## Extra link flags (e.g., specification of fortran libraries)
SET(SEACAS_EXTRA_LD_FLAGS "")

## This is the command-line entry used for setting rpaths. In a build
## with static libraries it will be empty.
SET(SEACAS_SHARED_LIB_RPATH_COMMAND "-Wl,-rpath,/usr/lib")
SET(SEACAS_BUILD_SHARED_LIBS "ON")

SET(SEACAS_LINKER /usr/bin/ld)
SET(SEACAS_AR /usr/bin/ar)

## ---------------------------------------------------------------------------
## Set library specifications and paths
## ---------------------------------------------------------------------------

## List of package include dirs
SET(SEACAS_INCLUDE_DIRS "${CMAKE_CURRENT_LIST_DIR}/../../../include")

## List of package library paths
SET(SEACAS_LIBRARY_DIRS "${CMAKE_CURRENT_LIST_DIR}/../../../lib")

## List of package libraries
SET(SEACAS_LIBRARIES "mapvarlib;fastqlib;blotlib;plt;svdi_cgi;svdi_cdr;suplib_cpp;suplib_c;suplib;supes;aprepro_lib;chaco;io_info_lib;Ionit;Iotr;Iohb;Iogn;Iovs;Iopg;Ioexo_fac;Iofx;Ioex;Ioss;nemesis;exoIIv2for32;exodus_for;exodus;pamgen_extras;pamgen;zoltan;kokkosalgorithms;kokkoscontainers;kokkoscore")

## Specification of directories for TPL headers
SET(SEACAS_TPL_INCLUDE_DIRS "/usr/include;/usr/include;/usr/include;/usr/include")

## Specification of directories for TPL libraries
SET(SEACAS_TPL_LIBRARY_DIRS "")

## List of required TPLs
SET(SEACAS_TPL_LIBRARIES "/usr/lib/libdl.so;/usr/lib/libX11.so;/usr/lib/libmatio.so;/usr/lib/libnetcdf.so")

## ---------------------------------------------------------------------------
## MPI specific variables
##   These variables are provided to make it easier to get the mpi libraries
##   and includes on systems that do not use the mpi wrappers for compiling
## ---------------------------------------------------------------------------

SET(SEACAS_MPI_LIBRARIES "")
SET(SEACAS_MPI_LIBRARY_DIRS "")
SET(SEACAS_MPI_INCLUDE_DIRS "")
SET(SEACAS_MPI_EXEC "/usr/bin/mpiexec")
SET(SEACAS_MPI_EXEC_MAX_NUMPROCS "4")
SET(SEACAS_MPI_EXEC_NUMPROCS_FLAG "-np")

## ---------------------------------------------------------------------------
## Set useful general variables
## ---------------------------------------------------------------------------

## The packages enabled for this project
SET(SEACAS_PACKAGE_LIST "SEACASEx2ex1v2;SEACASTxtexo;SEACASNumbers;SEACASNemspread;SEACASNemslice;SEACASMat2exo;SEACASMapvar-kd;SEACASMapvar;SEACASMapvarlib;SEACASGrope;SEACASGrepos;SEACASGenshell;SEACASGen3D;SEACASGjoin;SEACASFastq;SEACASEx1ex2v2;SEACASExo_format;SEACASExotxt;SEACASExomatlab;SEACASExodiff;SEACASExo2mat;SEACASEpu;SEACASEjoin;SEACASConjoin;SEACASBlot;SEACASAprepro;SEACASAlgebra;SEACASPLT;SEACASSVDI;SEACASSuplibCpp;SEACASSuplibC;SEACASSuplib;SEACASSupes;SEACASAprepro_lib;SEACASChaco;SEACASIoss;SEACASNemesis;SEACASExoIIv2for32;SEACASExodus_for;SEACASExodus;Pamgen;Zoltan;Kokkos;KokkosAlgorithms;KokkosContainers;KokkosCore")

## The TPLs enabled for this project
SET(SEACAS_TPL_LIST "DLlib;X11;Matio;Netcdf;Boost;MPI;Pthread")


# Include configuration of dependent packages
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../SEACASEx2ex1v2/SEACASEx2ex1v2Config.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../SEACASTxtexo/SEACASTxtexoConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../SEACASNumbers/SEACASNumbersConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../SEACASNemspread/SEACASNemspreadConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../SEACASNemslice/SEACASNemsliceConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../SEACASMat2exo/SEACASMat2exoConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../SEACASMapvar-kd/SEACASMapvar-kdConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../SEACASMapvar/SEACASMapvarConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../SEACASMapvarlib/SEACASMapvarlibConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../SEACASGrope/SEACASGropeConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../SEACASGrepos/SEACASGreposConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../SEACASGenshell/SEACASGenshellConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../SEACASGen3D/SEACASGen3DConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../SEACASGjoin/SEACASGjoinConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../SEACASFastq/SEACASFastqConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../SEACASEx1ex2v2/SEACASEx1ex2v2Config.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../SEACASExo_format/SEACASExo_formatConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../SEACASExotxt/SEACASExotxtConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../SEACASExomatlab/SEACASExomatlabConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../SEACASExodiff/SEACASExodiffConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../SEACASExo2mat/SEACASExo2matConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../SEACASEpu/SEACASEpuConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../SEACASEjoin/SEACASEjoinConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../SEACASConjoin/SEACASConjoinConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../SEACASBlot/SEACASBlotConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../SEACASAprepro/SEACASApreproConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../SEACASAlgebra/SEACASAlgebraConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../SEACASPLT/SEACASPLTConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../SEACASSVDI/SEACASSVDIConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../SEACASSuplibCpp/SEACASSuplibCppConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../SEACASSuplibC/SEACASSuplibCConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../SEACASSuplib/SEACASSuplibConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../SEACASSupes/SEACASSupesConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../SEACASAprepro_lib/SEACASAprepro_libConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../SEACASChaco/SEACASChacoConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../SEACASIoss/SEACASIossConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../SEACASNemesis/SEACASNemesisConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../SEACASExoIIv2for32/SEACASExoIIv2for32Config.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../SEACASExodus_for/SEACASExodus_forConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../SEACASExodus/SEACASExodusConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../Pamgen/PamgenConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../Zoltan/ZoltanConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../Kokkos/KokkosConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../KokkosAlgorithms/KokkosAlgorithmsConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../KokkosContainers/KokkosContainersConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../KokkosCore/KokkosCoreConfig.cmake")

