# @HEADER
# ************************************************************************
#
#            TriBITS: Tribal Build, Integrate, and Test System
#                    Copyright 2013 Sandia Corporation
#
#
# Under the terms of Contract DE-AC04-94AL85000 with Sandia Corporation,
# the U.S. Government retains certain rights in this software.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are
# met:
#
# 1. Redistributions of source code must retain the above copyright
# notice, this list of conditions and the following disclaimer.
#
# 2. Redistributions in binary form must reproduce the above copyright
# notice, this list of conditions and the following disclaimer in the
# documentation and/or other materials provided with the distribution.
#
# 3. Neither the name of the Corporation nor the names of the
# contributors may be used to endorse or promote products derived from
# this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY SANDIA CORPORATION "AS IS" AND ANY
# EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
# PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL SANDIA CORPORATION OR THE
# CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
# EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
# PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
# PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
# LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
# NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
# SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# ************************************************************************
# @HEADER

##############################################################################
#
# CMake variable for use by Trilinos/PyTrilinos clients.
#
# Do not edit: This file was generated automatically by CMake.
#
##############################################################################


# Include guard
IF (PyTrilinos_CONFIG_INCLUDED)
  RETURN()
ENDIF()
SET(PyTrilinos_CONFIG_INCLUDED TRUE)

# Make sure CMAKE_CURRENT_LIST_DIR is usable
IF (NOT DEFINED CMAKE_CURRENT_LIST_DIR)
  GET_FILENAME_COMPONENT(_THIS_SCRIPT_PATH ${CMAKE_CURRENT_LIST_FILE} PATH)
  SET(CMAKE_CURRENT_LIST_DIR ${_THIS_SCRIPT_PATH})
ENDIF()


## ---------------------------------------------------------------------------
## Compilers used by Trilinos/PyTrilinos build
## ---------------------------------------------------------------------------

SET(PyTrilinos_CXX_COMPILER "/usr/bin/mpicxx")

SET(PyTrilinos_C_COMPILER "/usr/bin/mpicc")

SET(PyTrilinos_FORTRAN_COMPILER "/usr/bin/mpif90")


## ---------------------------------------------------------------------------
## Compiler flags used by Trilinos/PyTrilinos build
## ---------------------------------------------------------------------------

## Set compiler flags, including those determined by build type
SET(PyTrilinos_CXX_FLAGS "  -march=x86-64 -mtune=generic -O2 -pipe -fstack-protector-strong -fno-plt -std=c++11 -O3 -DNDEBUG")

SET(PyTrilinos_C_FLAGS "  -march=x86-64 -mtune=generic -O2 -pipe -fstack-protector-strong -fno-plt -O3 -DNDEBUG")

SET(PyTrilinos_FORTRAN_FLAGS " -O3")

## Extra link flags (e.g., specification of fortran libraries)
SET(PyTrilinos_EXTRA_LD_FLAGS "")

## This is the command-line entry used for setting rpaths. In a build
## with static libraries it will be empty.
SET(PyTrilinos_SHARED_LIB_RPATH_COMMAND "-Wl,-rpath,/usr/lib")
SET(PyTrilinos_BUILD_SHARED_LIBS "ON")

SET(PyTrilinos_LINKER /usr/bin/ld)
SET(PyTrilinos_AR /usr/bin/ar)

## ---------------------------------------------------------------------------
## Set library specifications and paths
## ---------------------------------------------------------------------------

## List of package include dirs
SET(PyTrilinos_INCLUDE_DIRS "${CMAKE_CURRENT_LIST_DIR}/../../../include")

## List of package library paths
SET(PyTrilinos_LIBRARY_DIRS "${CMAKE_CURRENT_LIST_DIR}/../../../lib")

## List of package libraries
SET(PyTrilinos_LIBRARIES "pytrilinos;locathyra;locaepetra;localapack;loca;noxepetra;noxlapack;nox;stk_expreval;stk_mesh_fixtures;stk_transfer_impl;stk_search_util_base;stk_search;stk_unit_main;stk_unit_test_utils;stk_io_util;stk_io;stk_mesh_base;stk_topology;stk_util_use_cases;stk_util_registry;stk_util_diag;stk_util_env;stk_util_parallel;stk_util_util;teko;stratimikos;stratimikosbelos;stratimikosaztecoo;stratimikosamesos;stratimikosml;stratimikosifpack;ifpack2-adapters;ifpack2;anasazitpetra;ModeLaplace;anasaziepetra;anasazi;komplex;aprepro_lib;io_info_lib;Ionit;Iotr;Iohb;Iogn;Iovs;Iopg;Ioexo_fac;Iofx;Ioex;Ioss;exodus;amesos2;belostpetra;belosepetra;belos;ml;ifpack;zoltan2;pamgen_extras;pamgen;amesos;galeri-xpetra;galeri-epetra;aztecoo;dpliris;isorropia;xpetra-sup;xpetra;thyratpetra;thyraepetraext;thyraepetra;thyracore;domi;epetraext;trilinosss;tpetraext;tpetrainout;tpetra;kokkostsqr;tpetraclassiclinalg;tpetraclassicnodeapi;tpetraclassic;triutils;shards;zoltan;epetra;rtop;kokkoskernels;teuchoskokkoscomm;teuchoskokkoscompat;teuchosremainder;teuchosnumerics;teuchoscomm;teuchosparameterlist;teuchoscore;kokkosalgorithms;kokkoscontainers;kokkoscore;tpi;gtest")

## Specification of directories for TPL headers
SET(PyTrilinos_TPL_INCLUDE_DIRS "/usr/include;/usr/include;/usr/include")

## Specification of directories for TPL libraries
SET(PyTrilinos_TPL_LIBRARY_DIRS "")

## List of required TPLs
SET(PyTrilinos_TPL_LIBRARIES "/usr/lib/libdl.so;/usr/lib/libboost_program_options.so;/usr/lib/libboost_system.so;/usr/lib/libnetcdf.so;/usr/lib/liblapack.so;/usr/lib/libblas.so")

## ---------------------------------------------------------------------------
## MPI specific variables
##   These variables are provided to make it easier to get the mpi libraries
##   and includes on systems that do not use the mpi wrappers for compiling
## ---------------------------------------------------------------------------

SET(PyTrilinos_MPI_LIBRARIES "")
SET(PyTrilinos_MPI_LIBRARY_DIRS "")
SET(PyTrilinos_MPI_INCLUDE_DIRS "")
SET(PyTrilinos_MPI_EXEC "/usr/bin/mpiexec")
SET(PyTrilinos_MPI_EXEC_MAX_NUMPROCS "4")
SET(PyTrilinos_MPI_EXEC_NUMPROCS_FLAG "-np")

## ---------------------------------------------------------------------------
## Set useful general variables
## ---------------------------------------------------------------------------

## The packages enabled for this project
SET(PyTrilinos_PACKAGE_LIST "PyTrilinos;NOX;STK;STKExprEval;STKDoc_tests;STKUnit_tests;STKTransfer;STKSearchUtil;STKSearch;STKUnit_test_utils;STKIO;STKMesh;STKTopology;STKSimd;STKUtil;Teko;Stratimikos;Ifpack2;Anasazi;Komplex;SEACASAprepro_lib;SEACASIoss;SEACASExodus;Amesos2;Belos;ML;Ifpack;Zoltan2;Pamgen;Amesos;Galeri;AztecOO;Pliris;Isorropia;Xpetra;Thyra;ThyraTpetraAdapters;ThyraEpetraExtAdapters;ThyraEpetraAdapters;ThyraCore;Domi;EpetraExt;TrilinosSS;Tpetra;TpetraCore;TpetraTSQR;TpetraClassic;Triutils;Shards;Zoltan;Epetra;RTOp;KokkosKernels;Teuchos;TeuchosKokkosComm;TeuchosKokkosCompat;TeuchosRemainder;TeuchosNumerics;TeuchosComm;TeuchosParameterList;TeuchosCore;Kokkos;KokkosAlgorithms;KokkosContainers;KokkosCore;ThreadPool;Gtest")

## The TPLs enabled for this project
SET(PyTrilinos_TPL_LIST "DLlib;BoostLib;Netcdf;Boost;LAPACK;BLAS;MPI;Pthread")


# Include configuration of dependent packages
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../NOX/NOXConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../STK/STKConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../STKExprEval/STKExprEvalConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../STKDoc_tests/STKDoc_testsConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../STKUnit_tests/STKUnit_testsConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../STKTransfer/STKTransferConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../STKSearchUtil/STKSearchUtilConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../STKSearch/STKSearchConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../STKUnit_test_utils/STKUnit_test_utilsConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../STKIO/STKIOConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../STKMesh/STKMeshConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../STKTopology/STKTopologyConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../STKSimd/STKSimdConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../STKUtil/STKUtilConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../Teko/TekoConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../Stratimikos/StratimikosConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../Ifpack2/Ifpack2Config.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../Anasazi/AnasaziConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../Komplex/KomplexConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../SEACASAprepro_lib/SEACASAprepro_libConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../SEACASIoss/SEACASIossConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../SEACASExodus/SEACASExodusConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../Amesos2/Amesos2Config.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../Belos/BelosConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../ML/MLConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../Ifpack/IfpackConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../Zoltan2/Zoltan2Config.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../Pamgen/PamgenConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../Amesos/AmesosConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../Galeri/GaleriConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../AztecOO/AztecOOConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../Pliris/PlirisConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../Isorropia/IsorropiaConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../Xpetra/XpetraConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../Thyra/ThyraConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../ThyraTpetraAdapters/ThyraTpetraAdaptersConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../ThyraEpetraExtAdapters/ThyraEpetraExtAdaptersConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../ThyraEpetraAdapters/ThyraEpetraAdaptersConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../ThyraCore/ThyraCoreConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../Domi/DomiConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../EpetraExt/EpetraExtConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../TrilinosSS/TrilinosSSConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../Tpetra/TpetraConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../TpetraCore/TpetraCoreConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../TpetraTSQR/TpetraTSQRConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../TpetraClassic/TpetraClassicConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../Triutils/TriutilsConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../Shards/ShardsConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../Zoltan/ZoltanConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../Epetra/EpetraConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../RTOp/RTOpConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../KokkosKernels/KokkosKernelsConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../Teuchos/TeuchosConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../TeuchosKokkosComm/TeuchosKokkosCommConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../TeuchosKokkosCompat/TeuchosKokkosCompatConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../TeuchosRemainder/TeuchosRemainderConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../TeuchosNumerics/TeuchosNumericsConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../TeuchosComm/TeuchosCommConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../TeuchosParameterList/TeuchosParameterListConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../TeuchosCore/TeuchosCoreConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../Kokkos/KokkosConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../KokkosAlgorithms/KokkosAlgorithmsConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../KokkosContainers/KokkosContainersConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../KokkosCore/KokkosCoreConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../ThreadPool/ThreadPoolConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../Gtest/GtestConfig.cmake")

# Import PyTrilinos targets
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/PyTrilinosTargets.cmake")
