/*
// @HEADER
// ***********************************************************************
//
//          PyTrilinos: Python Interfaces to Trilinos Packages
//                 Copyright (2014) Sandia Corporation
//
// Under the terms of Contract DE-AC04-94AL85000 with Sandia
// Corporation, the U.S. Government retains certain rights in this
// software.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
// 1. Redistributions of source code must retain the above copyright
// notice, this list of conditions and the following disclaimer.
//
// 2. Redistributions in binary form must reproduce the above copyright
// notice, this list of conditions and the following disclaimer in the
// documentation and/or other materials provided with the distribution.
//
// 3. Neither the name of the Corporation nor the names of the
// contributors may be used to endorse or promote products derived from
// this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY SANDIA CORPORATION "AS IS" AND ANY
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL SANDIA CORPORATION OR THE
// CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
// EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
// PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
// PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
// LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
// NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
// Questions? Contact William F. Spotz (wfspotz@sandia.gov)
//
// ***********************************************************************
// @HEADER
*/

/* cmake/PyTrilinos_config.h.in.  Modified from version in src/.  */

/* Define if Epetra is enabled */
#define HAVE_EPETRA

/* Define if Tpetra is enabled */
#define HAVE_TPETRA

/* Define if Domi is enabled */
#define HAVE_DOMI

/* Define if Epetra namespace is enabled within NOX */
#define HAVE_NOX_EPETRA

/* Define if EpetraExt capabilities are enabled within NOX::Epetra */
#define HAVE_NOX_EPETRAEXT

/* Define if Petsc namespace is enabled within NOX */
/* #undef HAVE_NOX_PETSC */

/* Define ML options */
#define MLAPI_LC

/* Define if want to build default-packages */
/* #undef HAVE_DEFAULT_PACKAGES */

/* Define if want to build examples */
/* #undef HAVE_EXAMPLES */

/* define if we want to use MPI */
#define HAVE_MPI

/* define if we want to use Mpi4Py */
/* #undef HAVE_MPI4PY */

/* Define if want to build PyTrilinos */
/* #undef HAVE_PYTRILINOS */

/* Define if want to build with Amesos enabled */
#define HAVE_PYTRILINOS_AMESOS

/* Define if want to build with Anasazi enabled */
#define HAVE_PYTRILINOS_ANASAZI

/* Define if want to build with AztecOO enabled */
#define HAVE_PYTRILINOS_AZTECOO

/* Define if want to build AztecOO-Teuchos */
/* #undef HAVE_PYTRILINOS_AZTECOO_TEUCHOS */

/* Define if want to build with Belos enabled */
/* #undef HAVE_PYTRILINOS_BELOS */

/* Define if want to build with Claps enabled */
/* #undef HAVE_PYTRILINOS_CLAPS */

/* Define if want to build with Epetra enabled */
#define HAVE_PYTRILINOS_EPETRA

/* Define if want to build with EpetraExt enabled */
#define HAVE_PYTRILINOS_EPETRAEXT

/* Define if want to build EpetraExt-hdf5 */
/* #undef HAVE_PYTRILINOS_EPETRAEXT_HDF5 */

/* Define if want to build PyTrilinos-examples */
/* #undef HAVE_PYTRILINOS_EXAMPLES */

/* Define if want to build with Galeri enabled */
#define HAVE_PYTRILINOS_GALERI

/* Define if want to build with Ifpack enabled */
#define HAVE_PYTRILINOS_IFPACK

/* Define if want to build with Isorropia enabled */
#define HAVE_PYTRILINOS_ISORROPIA

/* Define if want to build with Kokkos enabled */
/* #undef HAVE_PYTRILINOS_KOKKOS */

/* Define if want to build with Komplex enabled */
#define HAVE_PYTRILINOS_KOMPLEX

/* Define if want to build with LOCA enabled */
/* #undef HAVE_PYTRILINOS_LOCA */

/* Define if want to build with Meros enabled */
/* #undef HAVE_PYTRILINOS_MEROS */

/* Define if want to build with ML enabled */
#define HAVE_PYTRILINOS_ML

/* Define if want to build with Moertel enabled */
/* #undef HAVE_PYTRILINOS_MOERTEL */

/* Define if want to build with Moocho enabled */
/* #undef HAVE_PYTRILINOS_MOOCHO */

/* Define if want to build with NOX enabled */
#define HAVE_PYTRILINOS_NOX

/* Define if want to build NOX-Epetra */
/* #undef HAVE_PYTRILINOS_NOX_EPETRA */

/* Define if want to build NOX-Epetra with EpetraExt */
/* #undef HAVE_PYTRILINOS_NOX_EPETRAEXT */

/* Define if want to build with RTOp enabled */
/* #undef HAVE_PYTRILINOS_RTOP */

/* Define if want to build with Rythmos enabled */
/* #undef HAVE_PYTRILINOS_RYTHMOS */

/* Define if want to build with Sacado enabled */
/* #undef HAVE_PYTRILINOS_SACADO */

/* Define if want to build with Stratimikos enabled */
/* #undef HAVE_PYTRILINOS_STRATIMIKOS */

/* Define if want to build PyTrilinos-tests */
/* #undef HAVE_PYTRILINOS_TESTS */

/* Define if want to build with Teuchos enabled */
/* #undef HAVE_PYTRILINOS_TEUCHOS */

/* Define if want to build with Thyra enabled */
/* #undef HAVE_PYTRILINOS_THYRA */

/* Define if want to build with Tpetra enabled */
#define HAVE_PYTRILINOS_TPETRA

/* Define if want to build with TriUtils enabled */
#define HAVE_PYTRILINOS_TRIUTILS

/* Define if want to build tests */
/* #undef HAVE_TESTS */

/* Define to 1 if you have the <unistd.h> header file. */
/* #undef HAVE_UNISTD_H */

/**********************************************************************/

/* PyTrilinos ordinal types */

#define PYTRILINOS_GLOBAL_ORD long long
#define PYTRILINOS_LOCAL_ORD  int

/**********************************************************************/

#ifdef SWIG

  #define COMPILER_ID GNU

  #if COMPILER_ID == Clang
    #if ! defined(__clang__)
      #define __clang__
    #endif
  #endif

  #if COMPILER_ID == GNU
    #if ! defined(__GNUC__)
      #define __GNUC__
    #endif
  #endif

  #if COMPILER_ID == Intel
    #if ! defined(__INTEL_COMPILER)
      #define __INTEL_COMPILER
    #endif
  #endif

#endif
