#ifndef PANZER_CORE_CONFIG_HPP
#define PANZER_CORE_CONFIG_HPP

#ifndef __cplusplus
#define __cplusplus
#endif

#define HAVE_MPI

// What AD Type are you going to use?
#define PANZER_FADTYPE Sacado::Fad::DFad<RealType>

/* #undef PANZER_DEBUG */
#define PANZER_HAVE_LONG_LONG_INT
#define HAVE_PANZER_EXPLICIT_INSTANTIATION
/* #undef PANZER_EXPLICIT_INSTANTIATION */

namespace panzer {
#ifdef PANZER_HAVE_LONG_LONG_INT
  typedef long long int Ordinal64;
#else
  #define PANZER_ORDINAL64_IS_INT
  typedef int Ordinal64;
#endif
typedef int index_t;
}

#ifndef PANZER_FUNC_TIME_MONITOR
#  define PANZER_TEUCHOS_TIME_MONITOR
#  define PANZER_FUNC_TIME_MONITOR(FUNCNAME) \
     TEUCHOS_FUNC_TIME_MONITOR_DIFF(FUNCNAME, PANZER)
#  define PANZER_FUNC_TIME_MONITOR_DIFF(FUNCNAME, DIFF) \
     TEUCHOS_FUNC_TIME_MONITOR_DIFF(FUNCNAME, DIFF)
#endif

#ifndef PANZER_DEPRECATED
#  if (__GNUC__ > 3 || (__GNUC__ == 3 && __GNUC_MINOR__ >= 1))
#    define PANZER_DEPRECATED  __attribute__((__deprecated__))
#  else
#    define PANZER_DEPRECATED
#  endif
#endif

#ifndef PANZER_DEPRECATED_MSG
#  if (__GNUC__ > 4 || (__GNUC__ == 4 && __GNUC_MINOR__ >= 5))
#    define PANZER_DEPRECATED_MSG(MSG)  __attribute__((__deprecated__ (#MSG) ))
#  elif (__GNUC__ > 3 || (__GNUC__ == 3 && __GNUC_MINOR__ >= 1))
#    define PANZER_DEPRECATED_MSG(MSG)  __attribute__((__deprecated__))
#  else
#    define PANZER_DEPRECATED_MSG(MSG)
#  endif
#endif



#endif
