#ifndef MUELU_CONFIG_HPP
#define MUELU_CONFIG_HPP

#ifndef F77_BLAS_MANGLE
 #define F77_BLAS_MANGLE(name,NAME) name ## _
#endif

/* Options */

#define HAVE_MPI

/* #undef HAVE_MUELU_DEBUG */

/* #undef HAVE_MUELU_EXPLICIT_INSTANTIATION */

/* #undef HAVE_MUELU_PROFILING */

/* #undef HAVE_MUELU_GOOGLE_PERFTOOLS */

/* #undef HAVE_MUELU_EXPERIMENTAL */

/* #undef HAVE_MUELU_ADDITIVE_VARIANT */

/* #undef HAVE_MUELU_BOOST_FOR_REAL */

/* #undef HAVE_MUELU_KOKKOS_REFACTOR */

/* Optional Dependencies */

#define HAVE_MUELU_AMESOS

#define HAVE_MUELU_AMESOS2

#define HAVE_MUELU_AZTECOO

#define HAVE_MUELU_BELOS

#define HAVE_MUELU_EPETRA

#define HAVE_MUELU_EPETRAEXT

#define HAVE_MUELU_GALERI

#define HAVE_MUELU_IFPACK

#define HAVE_MUELU_IFPACK2

#define HAVE_MUELU_INTREPID2

#define HAVE_MUELU_INTREPID2_REFACTOR

#define HAVE_MUELU_ISORROPIA

/* #undef HAVE_MUELU_KOKKOSCLASSIC */

#define HAVE_MUELU_KOKKOSCONTAINERS

#define HAVE_MUELU_KOKKOSCORE

#define HAVE_MUELU_ML

#define HAVE_MUELU_PAMGEN

#define HAVE_MUELU_TEKO

#define HAVE_MUELU_TPETRA

/* Whether Tpetra is enabled with LocalOrdinal = int and GlobalOrdinal = int */
#define HAVE_MUELU_TPETRA_INST_INT_INT

#define HAVE_MUELU_STRATIMIKOS

#define HAVE_MUELU_ZOLTAN

#define HAVE_MUELU_ZOLTAN2

/* Optional TPL */

#define HAVE_MUELU_BOOST

/* #undef HAVE_MUELU_TIMER_SYNCHRONIZATION */

/* #undef HAVE_MUELU_MATLAB */

/* #undef HAVE_MUELU_AMGX */

/* #undef HAVE_MUELU_CGAL */

/* Flags for active Tpetra nodes if Tpetra is enabled */
#define HAVE_MUELU_SERIAL
/* #undef HAVE_MUELU_PTHREAD */
/* #undef HAVE_MUELU_OPENMP */
/* #undef HAVE_MUELU_CUDA */

/* #undef HAVE_MUELU_BROKEN_TESTS */

/*  
 If deprecated warnings are on, and the compiler supports them, then
 define MUELU_DEPRECATED to emit deprecated warnings.  Otherwise,
 give it an empty definition.
*/
#ifndef MUELU_DEPRECATED
#  if (__GNUC__ > 3 || (__GNUC__ == 3 && __GNUC_MINOR__ >= 1))
#    define MUELU_DEPRECATED  __attribute__((__deprecated__))
#  else
#    define MUELU_DEPRECATED
#  endif
#endif

#ifndef MUELU_DEPRECATED_MSG
#  if (__GNUC__ > 4 || (__GNUC__ == 4 && __GNUC_MINOR__ >= 5))
#    define MUELU_DEPRECATED_MSG(MSG)  __attribute__((__deprecated__ (#MSG) ))
#  elif (__GNUC__ > 3 || (__GNUC__ == 3 && __GNUC_MINOR__ >= 1))
#    define MUELU_DEPRECATED_MSG(MSG)  __attribute__((__deprecated__))
#  else
#    define MUELU_DEPRECATED_MSG(MSG)
#  endif
#endif


#endif /* MUELU_CONFIG_HPP */
