#if !defined(KOKKOS_MACROS_HPP) || defined(KOKKOS_CORE_CONFIG_H)
#error "Don't include KokkosCore_config.h directly; include Kokkos_Macros.hpp instead."
#else
#define KOKKOS_CORE_CONFIG_H
#endif

/* The trivial 'src/build_common.sh' creates a config
 * that must stay in sync with this file.
 */
/* #undef KOKKOS_FOR_SIERRA */

#ifndef KOKKOS_FOR_SIERRA

/* #undef KOKKOS_HAVE_CUDA */
/* #undef KOKKOS_HAVE_OPENMP */
/* #undef KOKKOS_HAVE_PTHREAD */
/* #undef KOKKOS_HAVE_QTHREADS */
#define KOKKOS_HAVE_SERIAL
/* #undef KOKKOS_HAVE_Winthread */

/* #undef KOKKOS_HAVE_HWLOC */
/* #undef KOKKOS_ENABLE_HBWSPACE */
/* #undef KOKKOS_ENABLE_LIBRT */

/* #undef KOKKOS_HAVE_DEBUG */
/* #undef KOKKOS_ENABLE_DEBUG_BOUNDS_CHECK */
/* #undef KOKKOS_ENABLE_DEBUG_DUALVIEW_MODIFY_CHECK */
#define KOKKOS_ENABLE_PROFILING
/* #undef KOKKOS_ENABLE_PROFILING_LOAD_PRINT */

/* #undef KOKKOS_ENABLE_AGGRESSIVE_VECTORIZATION */

#ifdef KOKKOS_HAVE_CUDA

/* #undef KOKKOS_ENABLE_CUDA_LDG_INTRINSIC */

// mfh 16 Sep 2014: If passed in on the command line, that overrides
// any value of KOKKOS_USE_CUDA_UVM here.  Doing this should prevent build
// warnings like this one:
//
// packages/kokkos/core/src/KokkosCore_config.h:13:1: warning: "KOKKOS_USE_CUDA_UVM" redefined
//
// At some point, we should edit the test-build scripts in
// Trilinos/cmake/ctest/drivers/perseus/, and take
// -DKOKKOS_USE_CUDA_UVM from the command-line arguments there.  I
// hesitate to do that now, because I'm not sure if all the files are
// including KokkosCore_config.h (or a header file that includes it) like
// they should.
#ifndef KOKKOS_USE_CUDA_UVM
/* #undef KOKKOS_USE_CUDA_UVM */
#endif

/* #undef KOKKOS_HAVE_CUDA_RDC */
#ifdef KOKKOS_HAVE_CUDA_RDC
#define KOKKOS_CUDA_USE_RELOCATABLE_DEVICE_CODE 1
#endif

/* #undef KOKKOS_HAVE_CUDA_LAMBDA */
#ifdef KOKKOS_HAVE_CUDA_LAMBDA
#define KOKKOS_CUDA_USE_LAMBDA 1
#endif

#endif

/* #undef KOKKOS_CUDA_CLANG_WORKAROUND */

#ifndef __CUDA_ARCH__
/* #undef KOKKOS_ENABLE_ISA_X86_64 */
/* #undef KOKKOS_ENABLE_ISA_KNC */
/* #undef KOKKOS_ENABLE_ISA_POWERPCLE */
#endif

/* #undef KOKKOS_ARCH_ARMV80 */
/* #undef KOKKOS_ARCH_ARMV81 */
/* #undef KOKKOS_ARCH_ARMV8_THUNDERX */
/* #undef KOKKOS_ARCH_AVX */
/* #undef KOKKOS_ARCH_AVX2 */
/* #undef KOKKOS_ARCH_AVX512MIC */
/* #undef KOKKOS_ARCH_AVX512XEON */
/* #undef KOKKOS_ARCH_KNC */
/* #undef KOKKOS_ARCH_POWER8 */
/* #undef KOKKOS_ARCH_POWER9 */
/* #undef KOKKOS_ARCH_KEPLER */
/* #undef KOKKOS_ARCH_KEPLER30 */
/* #undef KOKKOS_ARCH_KEPLER32 */
/* #undef KOKKOS_ARCH_KEPLER35 */
/* #undef KOKKOS_ARCH_KEPLER37 */
/* #undef KOKKOS_ARCH_MAXWELL */
/* #undef KOKKOS_ARCH_MAXWELL50 */
/* #undef KOKKOS_ARCH_MAXWELL52 */
/* #undef KOKKOS_ARCH_MAXWELL53 */
/* #undef KOKKOS_ARCH_PASCAL */
/* #undef KOKKOS_ARCH_PASCAL60 */
/* #undef KOKKOS_ARCH_PASCAL61 */

// Don't forbid users from defining this macro on the command line,
// but still make sure that CMake logic can control its definition.
#ifndef KOKKOS_HAVE_CXX11_DISPATCH_LAMBDA
#define KOKKOS_HAVE_CXX11_DISPATCH_LAMBDA 1
#endif

// TODO: These are currently not used in Kokkos.  Should they be removed?
#define KOKKOS_HAVE_MPI
/* #undef KOKKOS_HAVE_CUSPARSE */

// TODO: No longer options in Kokkos.  Need to be removed.
/* #undef KOKKOS_USING_DEPRECATED_VIEW */
#define KOKKOS_HAVE_CXX11

#endif // KOKKOS_FOR_SIERRA
