/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox;

import java.io.Closeable;
import java.io.File;
import org.sejda.common.ComponentsUtility;
import org.sejda.core.notification.dsl.ApplicationEventsNotifier;
import org.sejda.core.support.io.IOUtils;
import org.sejda.core.support.io.MultipleOutputWriter;
import org.sejda.core.support.io.OutputWriters;
import org.sejda.core.support.io.model.FileOutput;
import org.sejda.core.support.prefix.NameGenerator;
import org.sejda.core.support.prefix.model.NameGenerationRequest;
import org.sejda.impl.sambox.component.DefaultPdfSourceOpener;
import org.sejda.impl.sambox.component.PDDocumentHandler;
import org.sejda.impl.sambox.component.PdfScaler;
import org.sejda.model.exception.TaskException;
import org.sejda.model.input.PdfSource;
import org.sejda.model.input.PdfSourceOpener;
import org.sejda.model.output.ExistingOutputPolicy;
import org.sejda.model.output.TaskOutput;
import org.sejda.model.output.TaskOutputDispatcher;
import org.sejda.model.parameter.ScaleParameters;
import org.sejda.model.parameter.base.TaskParameters;
import org.sejda.model.pdf.encryption.PdfAccessPermission;
import org.sejda.model.task.BaseTask;
import org.sejda.model.task.NotifiableTaskMetadata;
import org.sejda.model.task.TaskExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScaleTask
extends BaseTask<ScaleParameters> {
    private static final Logger LOG = LoggerFactory.getLogger(ScaleTask.class);
    private int totalSteps;
    private PDDocumentHandler documentHandler = null;
    private MultipleOutputWriter outputWriter;
    private PdfSourceOpener<PDDocumentHandler> documentLoader;
    private PdfScaler scaler;

    public void before(ScaleParameters parameters, TaskExecutionContext executionContext) throws TaskException {
        super.before((TaskParameters)parameters, executionContext);
        this.totalSteps = parameters.getSourceList().size();
        this.documentLoader = new DefaultPdfSourceOpener();
        this.outputWriter = OutputWriters.newMultipleOutputWriter((ExistingOutputPolicy)parameters.getExistingOutputPolicy(), (TaskExecutionContext)executionContext);
        this.scaler = new PdfScaler(parameters.getScaleType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ScaleParameters parameters) throws TaskException {
        int currentStep = 0;
        LOG.debug("Starting scale '{}'", (Object)parameters.getScaleType());
        for (PdfSource source : parameters.getSourceList()) {
            this.executionContext().assertTaskNotCancelled();
            ++currentStep;
            LOG.debug("Opening {}", (Object)source);
            try {
                this.documentHandler = (PDDocumentHandler)source.open(this.documentLoader);
                this.documentHandler.getPermissions().ensurePermission(PdfAccessPermission.MODIFY);
                this.documentHandler.setCreatorOnPDDocument();
                File tmpFile = IOUtils.createTemporaryBuffer((TaskOutput)parameters.getOutput());
                LOG.debug("Created output on temporary buffer {}", (Object)tmpFile);
                this.scaler.scale(this.documentHandler.getUnderlyingPDDocument(), parameters.scale);
                this.documentHandler.setVersionOnPDDocument(parameters.getVersion());
                this.documentHandler.setCompress(parameters.isCompress());
                this.documentHandler.savePDDocument(tmpFile);
                String outName = NameGenerator.nameGenerator((String)parameters.getOutputPrefix()).generate(NameGenerationRequest.nameRequest().originalName(source.getName()).fileNumber(currentStep));
                this.outputWriter.addOutput(FileOutput.file((File)tmpFile).name(outName));
            }
            finally {
                ComponentsUtility.nullSafeCloseQuietly((Closeable)this.documentHandler);
            }
            ApplicationEventsNotifier.notifyEvent((NotifiableTaskMetadata)this.executionContext().notifiableTaskMetadata()).stepsCompleted(currentStep).outOf(this.totalSteps);
        }
        parameters.getOutput().accept((TaskOutputDispatcher)this.outputWriter);
        LOG.debug("Input documents scaled and written to {}", (Object)parameters.getOutput());
    }

    public void after() {
        ComponentsUtility.nullSafeCloseQuietly((Closeable)this.documentHandler);
    }
}

