/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.core.support.prefix.processor;

import org.sejda.core.support.prefix.model.NameGenerationRequest;
import org.sejda.core.support.prefix.processor.PrefixProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LoggingPrefixProcessorDecorator
implements PrefixProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(LoggingPrefixProcessorDecorator.class);
    private PrefixProcessor decorated;

    public LoggingPrefixProcessorDecorator(PrefixProcessor decorated) {
        if (decorated == null) {
            throw new IllegalArgumentException("Decorated processor cannot be null.");
        }
        this.decorated = decorated;
    }

    @Override
    public String process(String inputPrefix, NameGenerationRequest request) {
        LOG.trace("Processing prefix '{}' with processor '{}'", (Object)inputPrefix, this.decorated.getClass());
        String retVal = this.decorated.process(inputPrefix, request);
        LOG.trace("Processed prefix value: '{}'", (Object)retVal);
        return retVal;
    }
}

