/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.selection.multiple;

import java.util.Comparator;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.util.Callback;
import org.apache.commons.lang3.StringUtils;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.ui.selection.multiple.SelectionTableColumn;
import org.pdfsam.ui.selection.multiple.SelectionTableRowData;
import org.pdfsam.ui.selection.multiple.TooltippedTextFieldTableCell;

public class PaceColumn
implements SelectionTableColumn<String> {
    @Override
    public String getColumnTitle() {
        return DefaultI18nContext.getInstance().i18n("Pace");
    }

    @Override
    public ObservableValue<String> getObservableValue(SelectionTableRowData data) {
        return data.pace;
    }

    @Override
    public String getTextValue(String item) {
        return StringUtils.defaultString((String)item, (String)"1");
    }

    @Override
    public Comparator<String> comparator() {
        return Comparator.naturalOrder();
    }

    @Override
    public TableColumn<SelectionTableRowData, String> getTableColumn() {
        TableColumn tableColumn = SelectionTableColumn.super.getTableColumn();
        tableColumn.setEditable(true);
        tableColumn.setOnEditCommit(t -> ((SelectionTableRowData)t.getTableView().getItems().get((int)t.getTablePosition().getRow())).pace.set((String)StringUtils.defaultIfBlank((CharSequence)((String)t.getNewValue()), (CharSequence)"1")));
        return tableColumn;
    }

    @Override
    public Callback<TableColumn<SelectionTableRowData, String>, TableCell<SelectionTableRowData, String>> cellFactory() {
        return new Callback<TableColumn<SelectionTableRowData, String>, TableCell<SelectionTableRowData, String>>(){

            public TableCell<SelectionTableRowData, String> call(TableColumn<SelectionTableRowData, String> param) {
                return new TooltippedTextFieldTableCell(DefaultI18nContext.getInstance().i18n("Double click to set the number of pages after which the task will switch to the next file"));
            }
        };
    }
}

