/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.alternatemix;

import java.util.Collection;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.pdfsam.alternatemix.AlternateMixParametersBuilder;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.support.params.TaskParametersBuildStep;
import org.pdfsam.ui.selection.multiple.FileColumn;
import org.pdfsam.ui.selection.multiple.IntColumn;
import org.pdfsam.ui.selection.multiple.LoadingColumn;
import org.pdfsam.ui.selection.multiple.LongColumn;
import org.pdfsam.ui.selection.multiple.MultipleSelectionPane;
import org.pdfsam.ui.selection.multiple.PaceColumn;
import org.pdfsam.ui.selection.multiple.PageRangesColumn;
import org.pdfsam.ui.selection.multiple.ReverseColumn;
import org.pdfsam.ui.selection.multiple.SelectionTableRowData;
import org.pdfsam.ui.selection.multiple.TableColumnProvider;
import org.sejda.model.input.PdfMixInput;
import org.sejda.model.input.PdfSource;

public class AlternateMixSelectionPane
extends MultipleSelectionPane
implements TaskParametersBuildStep<AlternateMixParametersBuilder> {
    public AlternateMixSelectionPane(String ownerModule) {
        super(ownerModule, true, true, new TableColumnProvider[]{new LoadingColumn(ownerModule), FileColumn.NAME, LongColumn.SIZE, IntColumn.PAGES, LongColumn.LAST_MODIFIED, new PageRangesColumn(DefaultI18nContext.getInstance().i18n("Double click to set pages you want to mix (ex: 2 or 5-23 or 2,5-7,12-)")), new PaceColumn(), new ReverseColumn()});
    }

    public void apply(AlternateMixParametersBuilder builder, Consumer<String> onError) {
        if (this.table().getItems().isEmpty()) {
            onError.accept(DefaultI18nContext.getInstance().i18n("No PDF document has been selected"));
        } else {
            for (SelectionTableRowData row : this.table().getItems()) {
                String step = ((String)StringUtils.defaultIfBlank((CharSequence)row.pace.get(), (CharSequence)"1")).trim();
                if (step.matches("[1-9]\\d*")) {
                    PdfMixInput input = new PdfMixInput((PdfSource)row.descriptor().toPdfFileSource(), row.reverse.get(), Integer.parseInt(step));
                    input.addAllPageRanges((Collection)row.toPageRangeSet());
                    builder.addInput(input);
                    continue;
                }
                onError.accept(DefaultI18nContext.getInstance().i18n("Select a positive integer number as pace"));
                break;
            }
        }
    }
}

