/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projectimport.eclipse.core.wizard;

import java.awt.Component;
import java.io.File;
import java.util.List;
import javax.swing.JComponent;
import org.netbeans.modules.projectimport.eclipse.core.EclipseProject;
import org.netbeans.modules.projectimport.eclipse.core.EclipseUtils;
import org.netbeans.modules.projectimport.eclipse.core.wizard.ImporterWizardPanel;
import org.netbeans.modules.projectimport.eclipse.core.wizard.ProjectImporterWizard;
import org.netbeans.modules.projectimport.eclipse.core.wizard.ProjectSelectionPanel;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;

final class ProjectWizardPanel
extends ImporterWizardPanel
implements WizardDescriptor.ValidatingPanel<WizardDescriptor> {
    private ProjectSelectionPanel panel = new ProjectSelectionPanel(this);

    ProjectWizardPanel() {
        this.initPanel(this.panel, 1);
    }

    public Component getComponent() {
        return this.panel;
    }

    List<EclipseProject> getProjects() {
        return this.panel.getProjects();
    }

    int getNumberOfImportedProject() {
        return this.panel.getNumberOfImportedProject();
    }

    String getDestination() {
        return this.panel.getDestination();
    }

    void loadProjects(File workspaceDir) {
        this.panel.loadProjects(workspaceDir);
    }

    public void validate() throws WizardValidationException {
        String dest = this.panel.getDestination();
        if (!(!this.panel.isSeparateFolder() || dest == null || new File(dest).isAbsolute() && EclipseUtils.isWritable(dest))) {
            String message = ProjectImporterWizard.getMessage("MSG_CannotCreateProjectInFolder", dest);
            this.setErrorMessage(message);
            throw new WizardValidationException((JComponent)this.panel, message, null);
        }
    }

    void fireProjectListChanged() {
        this.cs.fireChange();
    }
}

