/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.ui.repository;

import javax.swing.AbstractListModel;
import javax.swing.MutableComboBoxModel;

final class RepositoryComboModel
extends AbstractListModel
implements MutableComboBoxModel {
    private Object[] data = null;
    private Object selectedItem;
    private boolean clearSelection = false;

    RepositoryComboModel() {
    }

    void setData(Object[] data) {
        int newSize;
        if (data != null && data.length == 0) {
            data = null;
        }
        if (data == this.data) {
            return;
        }
        Object originalSelectedItem = this.selectedItem;
        int originalSize = this.data != null ? this.data.length : 0;
        int n = newSize = data != null ? data.length : 0;
        if (data == null) {
            this.data = null;
            this.selectedItem = null;
        } else {
            this.data = new Object[data.length];
            System.arraycopy(data, 0, this.data, 0, data.length);
            this.selectedItem = this.clearSelection ? null : (originalSelectedItem == null ? this.data[0] : (RepositoryComboModel.indexOf(originalSelectedItem, data) == -1 ? this.data[0] : originalSelectedItem));
        }
        this.fireContentsChanged(this, 0, Math.max(originalSize, newSize));
        assert (this.data == null || this.data.length > 0);
    }

    @Override
    public int getSize() {
        if (this.data == null) {
            return 0;
        }
        return this.data.length;
    }

    @Override
    public Object getElementAt(int index) {
        if (this.data == null) {
            return null;
        }
        if (index < 0 || index >= this.data.length) {
            return null;
        }
        return this.data[index];
    }

    @Override
    public void setSelectedItem(Object item) {
        this.selectedItem = item;
        this.clearSelection = item == null;
    }

    @Override
    public Object getSelectedItem() {
        return this.selectedItem;
    }

    public void addElement(Object newObj) {
        assert (this.data == null || this.data.length > 0);
        if (this.data == null) {
            this.data = new Object[]{newObj};
            if (!this.clearSelection) {
                this.selectedItem = newObj;
            }
        } else {
            Object[] newData = new Object[this.data.length + 1];
            System.arraycopy(this.data, 0, newData, 0, this.data.length);
            newData[this.data.length] = newObj;
            this.data = newData;
        }
        int lastIndex = this.data.length - 1;
        this.fireIntervalAdded(this, lastIndex, lastIndex);
    }

    public void insertElementAt(Object obj, int index) {
        int size = this.getSize();
        RepositoryComboModel.checkIndex(index, size);
        if (index == size) {
            this.addElement(obj);
        } else {
            Object[] newData = new Object[this.data.length + 1];
            System.arraycopy(this.data, index, newData, index + 1, size - index);
            if (index != 0) {
                System.arraycopy(this.data, 0, newData, 0, index);
            }
            newData[index] = obj;
            this.data = newData;
            this.fireIntervalAdded(this, index, index);
        }
    }

    @Override
    public void removeElement(Object obj) {
        int index = this.indexOf(obj);
        if (index != -1) {
            this.removeElementAt(index);
        }
    }

    @Override
    public void removeElementAt(int index) {
        if (this.isEmpty()) {
            throw new IllegalStateException("Cannot remove items from an empty model.");
        }
        int size = this.getSize();
        RepositoryComboModel.checkIndex(index, size - 1);
        Object removedItem = this.data[index];
        if (size == 1) {
            this.data = null;
        } else {
            Object[] newData = new Object[size - 1];
            if (index != 0) {
                System.arraycopy(this.data, 0, newData, 0, index);
            }
            if (index != size - 1) {
                System.arraycopy(this.data, index + 1, newData, index, size - index - 1);
            }
            this.data = newData;
        }
        if (removedItem == this.selectedItem) {
            this.selectedItem = null;
        }
        this.fireIntervalRemoved(this, index, index);
    }

    public boolean isEmpty() {
        assert (this.data == null || this.data.length > 0);
        return this.data == null;
    }

    private int indexOf(Object obj) {
        return RepositoryComboModel.indexOf(obj, this.data);
    }

    private static int indexOf(Object obj, Object[] data) {
        if (data == null || data.length == 0) {
            return -1;
        }
        for (int i = 0; i < data.length; ++i) {
            if (data[i] != obj) continue;
            return i;
        }
        return -1;
    }

    private static void checkIndex(int index, int upperBound) {
        if (index < 0 || index > upperBound) {
            throw new IndexOutOfBoundsException("index: " + index + "; bounds: (0, " + upperBound + ')');
        }
    }
}

