/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.settings;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.List;
import java.util.prefs.Preferences;
import org.netbeans.modules.bugtracking.tasks.TaskAttribute;
import org.openide.util.NbPreferences;

public class DashboardSettings {
    public static final String TASKS_LIMIT_SETTINGS_CHANGED = "dashboard.task_limit_changed";
    public static final String AUTO_SYNC_SETTINGS_CHANGED = "dashboard.auto_sync_changed";
    public static final String SORT_ATTRIBUTES_SETTINGS_CHANGED = "dashboard.sort_attributes_changed";
    private static DashboardSettings instance = null;
    private static final String AUTO_SYNC = "dashboard.auto_sync";
    private static final String AUTO_SYNC_VALUE = "dashboard.auto_sync_value";
    private static final String TASKS_LIMIT = "dashboard.tasks_limit";
    private static final String TASKS_LIMIT_VALUE = "dashboard.tasks_limit_value";
    private static final String TASKS_LIMIT_CATEGORY = "dashboard.tasks_limit_category";
    private static final String TASKS_LIMIT_QUERY = "dashboard.tasks_limit_query";
    private static final String FINISHED_TASK_FILTER = "dashboard.finished_task_filter";
    private static final String SHOW_SCHEDULE = "dashboard.show_schedule";
    private static final boolean DEFAULT_AUTO_SYNC = true;
    private static final int DEFAULT_AUTO_SYNC_VALUE = Integer.parseInt(System.getProperty("bugtracking.dashboard.autosync.interval", "15"));
    private static final boolean DEFAULT_TASKS_LIMIT = Boolean.parseBoolean(System.getProperty("bugtracking.dashboard.autosync", "true"));
    private static final int DEFAULT_TASKS_LIMIT_VALUE = Integer.parseInt(System.getProperty("bugtracking.dashboard.tasks.limit", "50"));
    private static final boolean DEFAULT_TASKS_LIMIT_CATEGORY = false;
    private static final boolean DEFAULT_TASKS_LIMIT_QUERY = true;
    private static final boolean DEFAULT_FINISHED_TASK_FILTER = true;
    private static final boolean DEFAULT_SHOW_SCHEDULE = true;
    private PropertyChangeSupport support = new PropertyChangeSupport(this);

    private DashboardSettings() {
    }

    public static DashboardSettings getInstance() {
        if (instance == null) {
            instance = new DashboardSettings();
        }
        return instance;
    }

    public void addPropertyChangedListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangedListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public boolean isAutoSync() {
        return this.getPreferences().getBoolean(AUTO_SYNC, true);
    }

    public void setAutoSync(boolean autoSync, boolean fireEvent) {
        this.getPreferences().putBoolean(AUTO_SYNC, autoSync);
        if (fireEvent) {
            this.fireSyncChangedEvent();
        }
    }

    public int getAutoSyncValue() {
        return this.getPreferences().getInt(AUTO_SYNC_VALUE, DEFAULT_AUTO_SYNC_VALUE);
    }

    public void setAutoSyncValue(int autoSyncValue, boolean fireEvent) {
        this.getPreferences().putInt(AUTO_SYNC_VALUE, autoSyncValue);
        if (fireEvent) {
            this.fireSyncChangedEvent();
        }
    }

    public boolean isTasksLimit() {
        return this.getPreferences().getBoolean(TASKS_LIMIT, DEFAULT_TASKS_LIMIT);
    }

    public void setTasksLimit(boolean tasksLimit, boolean fireEvent) {
        this.getPreferences().putBoolean(TASKS_LIMIT, tasksLimit);
        if (fireEvent) {
            this.fireLimitChangedEvent();
        }
    }

    public int getTasksLimitValue() {
        return this.getPreferences().getInt(TASKS_LIMIT_VALUE, DEFAULT_TASKS_LIMIT_VALUE);
    }

    public void setTasksLimitValue(int tasksLimitValue, boolean fireEvent) {
        this.getPreferences().putInt(TASKS_LIMIT_VALUE, tasksLimitValue);
        if (fireEvent) {
            this.fireLimitChangedEvent();
        }
    }

    public boolean isTasksLimitCategory() {
        return this.getPreferences().getBoolean(TASKS_LIMIT_CATEGORY, false);
    }

    public void setTasksLimitCategory(boolean tasksLimitCategory, boolean fireEvent) {
        this.getPreferences().putBoolean(TASKS_LIMIT_CATEGORY, tasksLimitCategory);
        if (fireEvent) {
            this.fireLimitChangedEvent();
        }
    }

    public boolean isTasksLimitQuery() {
        return this.getPreferences().getBoolean(TASKS_LIMIT_QUERY, true);
    }

    public void setTasksLimitQuery(boolean tasksLimitQuery, boolean fireEvent) {
        this.getPreferences().putBoolean(TASKS_LIMIT_QUERY, tasksLimitQuery);
        if (fireEvent) {
            this.fireLimitChangedEvent();
        }
    }

    public boolean showFinishedTasks() {
        return this.getPreferences().getBoolean(FINISHED_TASK_FILTER, true);
    }

    public void setShowFinishedTasks(boolean tasksLimitQuery) {
        this.getPreferences().putBoolean(FINISHED_TASK_FILTER, tasksLimitQuery);
    }

    public void updateSortingAttributes(List<TaskAttribute> attributes) {
        for (TaskAttribute taskAttribute : attributes) {
            taskAttribute.setRank(this.getPreferences().getInt(taskAttribute.getId(), taskAttribute.getRank()));
            taskAttribute.setAsceding(this.getPreferences().getBoolean(this.getAttributeAscedingId(taskAttribute.getId()), taskAttribute.isAsceding()));
        }
    }

    public void setSortingAttributes(List<TaskAttribute> attributes) {
        for (TaskAttribute taskAttribute : attributes) {
            this.getPreferences().putInt(taskAttribute.getId(), taskAttribute.getRank());
            this.getPreferences().putBoolean(this.getAttributeAscedingId(taskAttribute.getId()), taskAttribute.isAsceding());
        }
        this.fireSortChangedEvent();
    }

    public boolean showSchedule(String settingId) {
        return this.getPreferences().getBoolean("dashboard.show_schedule." + settingId, true);
    }

    public void updateShowSchedule(String settingId, boolean selected) {
        this.getPreferences().putBoolean("dashboard.show_schedule." + settingId, selected);
    }

    private String getAttributeAscedingId(String attributeId) {
        return attributeId + ".asceding";
    }

    private Preferences getPreferences() {
        return NbPreferences.forModule(DashboardSettings.class);
    }

    private void fireLimitChangedEvent() {
        this.support.firePropertyChange(TASKS_LIMIT_SETTINGS_CHANGED, null, null);
    }

    private void fireSyncChangedEvent() {
        this.support.firePropertyChange(AUTO_SYNC_SETTINGS_CHANGED, null, null);
    }

    private void fireSortChangedEvent() {
        this.support.firePropertyChange(SORT_ATTRIBUTES_SETTINGS_CHANGED, null, null);
    }
}

