/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.wireprotocol;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import org.netbeans.lib.profiler.wireprotocol.Response;

public class MonitoredNumbersResponse
extends Response {
    public static final int FREE_MEMORY_IDX = 0;
    public static final int TOTAL_MEMORY_IDX = 1;
    public static final int USER_THREADS_IDX = 2;
    public static final int SYSTEM_THREADS_IDX = 3;
    public static final int SURVIVING_GENERATIONS_IDX = 4;
    public static final int GC_TIME_IDX = 5;
    public static final int GC_PAUSE_IDX = 6;
    public static final int LOADED_CLASSES_IDX = 7;
    public static final int CPU_TIME_IDX = 8;
    public static final int TIMESTAMP_IDX = 9;
    public static final int GENERAL_NUMBERS_SIZE = 10;
    private long[] gcFinishs;
    private long[] gcStarts;
    private long[] generalNumbers = new long[10];
    private String[] newThreadClassNames;
    private int[] newThreadIds;
    private String[] newThreadNames;
    private long[] stateTimestamps = new long[10];
    private int[] threadIds = new int[10];
    private byte[] threadStates = new byte[100];
    private int nNewThreads;
    private int nThreadStates;
    private int nThreads;
    private int[] exactThreadIds;
    private byte[] exactThreadStates;
    private long[] exactTimeStamps;
    private int mode = 0;
    private int serverState = 0;
    private int serverProgress = -1;
    static final /* synthetic */ boolean $assertionsDisabled;

    public MonitoredNumbersResponse(long[] generalNumbers, int serverState, int serverProgress) {
        super(true, 9);
        this.generalNumbers = generalNumbers;
        this.nNewThreads = 0;
        this.serverState = serverState;
        this.serverProgress = serverProgress;
    }

    MonitoredNumbersResponse() {
        super(true, 9);
    }

    public void setDataOnNewThreads(int nNewThreads, int[] newThreadIds, String[] newThreadNames, String[] newThreadClassNames) {
        this.nNewThreads = nNewThreads;
        this.newThreadIds = newThreadIds;
        this.newThreadNames = newThreadNames;
        this.newThreadClassNames = newThreadClassNames;
    }

    public void setDataOnThreads(int nThreads, int nThreadStates, int[] threadIds, long[] stateTimestamps, byte[] threadStates) {
        this.mode = 1;
        this.nThreads = nThreads;
        this.nThreadStates = nThreadStates;
        this.threadIds = threadIds;
        this.stateTimestamps = stateTimestamps;
        this.threadStates = threadStates;
    }

    public void setExplicitDataOnThreads(int[] explicitThreads, byte[] explicitStates, long[] explicitTimeStamps) {
        if (!($assertionsDisabled || explicitStates.length == explicitThreads.length && explicitThreads.length == explicitTimeStamps.length)) {
            throw new AssertionError();
        }
        this.mode = 2;
        this.exactThreadIds = explicitThreads;
        this.exactThreadStates = explicitStates;
        this.exactTimeStamps = explicitTimeStamps;
    }

    public long[] getGCFinishs() {
        return this.gcFinishs;
    }

    public long[] getGCStarts() {
        return this.gcStarts;
    }

    public void setGCstartFinishData(long[] start, long[] finish) {
        this.gcStarts = start;
        this.gcFinishs = finish;
    }

    public long[] getGeneralMonitoredNumbers() {
        return this.generalNumbers;
    }

    public int getNNewThreads() {
        return this.nNewThreads;
    }

    public int getNThreadStates() {
        return this.nThreadStates;
    }

    public int getNThreads() {
        return this.nThreads;
    }

    public String[] getNewThreadClassNames() {
        return this.newThreadClassNames;
    }

    public int[] getNewThreadIds() {
        return this.newThreadIds;
    }

    public String[] getNewThreadNames() {
        return this.newThreadNames;
    }

    public long[] getStateTimestamps() {
        return this.stateTimestamps;
    }

    public int[] getThreadIds() {
        return this.threadIds;
    }

    public byte[] getThreadStates() {
        return this.threadStates;
    }

    public int getThreadsDataMode() {
        return this.mode;
    }

    public int[] getExactThreadIds() {
        return this.exactThreadIds;
    }

    public byte[] getExactThreadStates() {
        return this.exactThreadStates;
    }

    public long[] getExactStateTimestamps() {
        return this.exactTimeStamps;
    }

    public int getServerState() {
        return this.serverState;
    }

    public int getServerProgress() {
        return this.serverProgress;
    }

    public String toString() {
        return super.toString() + ", mode=" + this.mode + ", serverState=" + this.serverState + ", serverProgress=" + this.serverProgress;
    }

    void readObject(ObjectInputStream in) throws IOException {
        int i;
        int i2;
        this.mode = in.readInt();
        for (i2 = 0; i2 < this.generalNumbers.length; ++i2) {
            this.generalNumbers[i2] = in.readLong();
        }
        if (this.mode == 1) {
            int len;
            this.nThreads = in.readInt();
            this.nThreadStates = in.readInt();
            if (this.threadIds.length < this.nThreads) {
                this.threadIds = new int[this.nThreads];
            }
            if (this.stateTimestamps.length < this.nThreadStates) {
                this.stateTimestamps = new long[this.nThreadStates];
            }
            if (this.threadStates.length < (len = this.nThreads * this.nThreadStates)) {
                this.threadStates = new byte[len];
            }
            for (i = 0; i < this.nThreads; ++i) {
                this.threadIds[i] = in.readInt();
            }
            for (i = 0; i < this.nThreadStates; ++i) {
                this.stateTimestamps[i] = in.readLong();
            }
            in.readFully(this.threadStates, 0, len);
        } else if (this.mode == 2) {
            int exactLen = in.readInt();
            this.exactThreadIds = new int[exactLen];
            this.exactThreadStates = new byte[exactLen];
            this.exactTimeStamps = new long[exactLen];
            for (i = 0; i < exactLen; ++i) {
                this.exactThreadIds[i] = in.readInt();
                this.exactThreadStates[i] = in.readByte();
                this.exactTimeStamps[i] = in.readLong();
            }
        }
        this.nNewThreads = in.readInt();
        if (this.nNewThreads > 0) {
            if (this.newThreadIds == null || this.newThreadIds.length < this.nNewThreads) {
                this.newThreadIds = new int[this.nNewThreads];
                this.newThreadNames = new String[this.nNewThreads];
                this.newThreadClassNames = new String[this.nNewThreads];
            }
            for (i2 = 0; i2 < this.nNewThreads; ++i2) {
                this.newThreadIds[i2] = in.readInt();
                this.newThreadNames[i2] = in.readUTF();
                this.newThreadClassNames[i2] = in.readUTF();
            }
        }
        int arrSize = in.readInt();
        this.gcStarts = new long[arrSize];
        for (i2 = 0; i2 < arrSize; ++i2) {
            this.gcStarts[i2] = in.readLong();
        }
        arrSize = in.readInt();
        this.gcFinishs = new long[arrSize];
        for (i2 = 0; i2 < arrSize; ++i2) {
            this.gcFinishs[i2] = in.readLong();
        }
        Arrays.sort(this.gcStarts);
        Arrays.sort(this.gcFinishs);
        this.serverState = in.readInt();
        this.serverProgress = in.readInt();
    }

    void writeObject(ObjectOutputStream out) throws IOException {
        int i;
        out.writeInt(this.mode);
        for (i = 0; i < this.generalNumbers.length; ++i) {
            out.writeLong(this.generalNumbers[i]);
        }
        if (this.mode == 1) {
            out.writeInt(this.nThreads);
            out.writeInt(this.nThreadStates);
            for (i = 0; i < this.nThreads; ++i) {
                out.writeInt(this.threadIds[i]);
            }
            for (i = 0; i < this.nThreadStates; ++i) {
                out.writeLong(this.stateTimestamps[i]);
            }
            int len = this.nThreads * this.nThreadStates;
            out.write(this.threadStates, 0, len);
        } else if (this.mode == 2) {
            out.writeInt(this.exactThreadStates.length);
            for (i = 0; i < this.exactThreadIds.length; ++i) {
                out.writeInt(this.exactThreadIds[i]);
                out.writeByte(this.exactThreadStates[i]);
                out.writeLong(this.exactTimeStamps[i]);
            }
        }
        if (this.nNewThreads == 0) {
            out.writeInt(0);
        } else {
            out.writeInt(this.nNewThreads);
            for (i = 0; i < this.nNewThreads; ++i) {
                out.writeInt(this.newThreadIds[i]);
                out.writeUTF(this.newThreadNames[i]);
                out.writeUTF(this.newThreadClassNames[i]);
            }
        }
        out.writeInt(this.gcStarts.length);
        for (i = 0; i < this.gcStarts.length; ++i) {
            out.writeLong(this.gcStarts[i]);
        }
        out.writeInt(this.gcFinishs.length);
        for (i = 0; i < this.gcFinishs.length; ++i) {
            out.writeLong(this.gcFinishs[i]);
        }
        out.writeInt(this.serverState);
        out.writeInt(this.serverProgress);
    }

    static {
        $assertionsDisabled = !MonitoredNumbersResponse.class.desiredAssertionStatus();
    }
}

