/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.memory;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.text.Format;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.RowFilter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.filters.GenericFilter;
import org.netbeans.lib.profiler.results.CCTNode;
import org.netbeans.lib.profiler.results.cpu.PrestimeCPUCCTNode;
import org.netbeans.lib.profiler.results.memory.LivenessMemoryResultsDiff;
import org.netbeans.lib.profiler.results.memory.LivenessMemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.MemoryCCTManager;
import org.netbeans.lib.profiler.results.memory.MemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.PresoObjAllocCCTNode;
import org.netbeans.lib.profiler.results.memory.PresoObjLivenessCCTNode;
import org.netbeans.lib.profiler.ui.Formatters;
import org.netbeans.lib.profiler.ui.memory.MemoryJavaNameRenderer;
import org.netbeans.lib.profiler.ui.memory.MemoryView;
import org.netbeans.lib.profiler.ui.swing.ExportUtils;
import org.netbeans.lib.profiler.ui.swing.PopupButton;
import org.netbeans.lib.profiler.ui.swing.ProfilerTable;
import org.netbeans.lib.profiler.ui.swing.ProfilerTableContainer;
import org.netbeans.lib.profiler.ui.swing.ProfilerTreeTable;
import org.netbeans.lib.profiler.ui.swing.ProfilerTreeTableModel;
import org.netbeans.lib.profiler.ui.swing.SearchUtils;
import org.netbeans.lib.profiler.ui.swing.renderer.CheckBoxRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.HideableBarRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.NumberPercentRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.NumberRenderer;
import org.netbeans.lib.profiler.utils.StringUtils;
import org.netbeans.modules.profiler.api.icons.Icons;

abstract class LivenessTreeTableView
extends MemoryView {
    private LivenessTreeTableModel treeTableModel;
    private ProfilerTreeTable treeTable;
    private Map<TreeNode, ClientUtils.SourceCodeSelection> nodesMap;
    private final Set<ClientUtils.SourceCodeSelection> selection;
    private final boolean includeTotalAllocs;
    private boolean filterObjects = true;
    private boolean filterAllocations = false;
    private boolean searchObjects = true;
    private boolean searchAllocations = false;
    private HideableBarRenderer[] renderers;
    private NumberRenderer[] renderersEx;

    LivenessTreeTableView(Set<ClientUtils.SourceCodeSelection> selection, boolean includeTotalAllocs) {
        this.selection = selection;
        this.includeTotalAllocs = includeTotalAllocs;
        this.initUI();
    }

    @Override
    protected RowFilter getExcludesFilter() {
        return new RowFilter(){

            public boolean include(RowFilter.Entry entry) {
                PresoObjAllocCCTNode node = (PresoObjAllocCCTNode)entry.getIdentifier();
                CCTNode parent = node.getParent();
                if (parent == null) {
                    return true;
                }
                if (parent.getParent() == null) {
                    return !LivenessTreeTableView.this.filterObjects;
                }
                return !LivenessTreeTableView.this.filterAllocations;
            }
        };
    }

    @Override
    protected Component[] getFilterOptions() {
        PopupButton pb = new PopupButton(Icons.getIcon((String)"ProfilerIcons.TabCallTree")){

            @Override
            protected void populatePopup(JPopupMenu popup) {
                popup.add(new JCheckBoxMenuItem(MemoryView.SEARCH_CLASSES_SCOPE, LivenessTreeTableView.this.filterObjects){
                    {
                        if (!LivenessTreeTableView.this.filterAllocations) {
                            this.setEnabled(false);
                        }
                    }

                    @Override
                    protected void fireActionPerformed(ActionEvent e) {
                        super.fireActionPerformed(e);
                        LivenessTreeTableView.this.filterObjects = !LivenessTreeTableView.this.filterObjects;
                        LivenessTreeTableView.this.enableFilter();
                    }
                });
                popup.add(new JCheckBoxMenuItem(MemoryView.FILTER_ALLOCATIONS_SCOPE, LivenessTreeTableView.this.filterAllocations){
                    {
                        if (!LivenessTreeTableView.this.filterObjects) {
                            this.setEnabled(false);
                        }
                    }

                    @Override
                    protected void fireActionPerformed(ActionEvent e) {
                        super.fireActionPerformed(e);
                        LivenessTreeTableView.this.filterAllocations = !LivenessTreeTableView.this.filterAllocations;
                        LivenessTreeTableView.this.enableFilter();
                    }
                });
            }
        };
        pb.setToolTipText(FILTER_SCOPE_TOOLTIP);
        return new Component[]{Box.createHorizontalStrut(5), pb};
    }

    @Override
    protected SearchUtils.TreeHelper getSearchHelper() {
        return new SearchUtils.TreeHelper(){

            @Override
            public int getNodeType(TreeNode tnode) {
                PresoObjAllocCCTNode node = (PresoObjAllocCCTNode)tnode;
                CCTNode parent = node.getParent();
                if (parent == null) {
                    return 100;
                }
                if (parent.getParent() == null) {
                    if (LivenessTreeTableView.this.searchObjects) {
                        return LivenessTreeTableView.this.searchAllocations ? 10 : 11;
                    }
                    return LivenessTreeTableView.this.searchAllocations ? 100 : 101;
                }
                return LivenessTreeTableView.this.searchAllocations ? 10 : 101;
            }
        };
    }

    @Override
    protected Component[] getSearchOptions() {
        PopupButton pb = new PopupButton(Icons.getIcon((String)"ProfilerIcons.TabCallTree")){

            @Override
            protected void populatePopup(JPopupMenu popup) {
                popup.add(new JCheckBoxMenuItem(MemoryView.SEARCH_CLASSES_SCOPE, LivenessTreeTableView.this.searchObjects){
                    {
                        if (!LivenessTreeTableView.this.searchAllocations) {
                            this.setEnabled(false);
                        }
                    }

                    @Override
                    protected void fireActionPerformed(ActionEvent e) {
                        super.fireActionPerformed(e);
                        LivenessTreeTableView.this.searchObjects = !LivenessTreeTableView.this.searchObjects;
                    }
                });
                popup.add(new JCheckBoxMenuItem(MemoryView.SEARCH_ALLOCATIONS_SCOPE, LivenessTreeTableView.this.searchAllocations){
                    {
                        if (!LivenessTreeTableView.this.searchObjects) {
                            this.setEnabled(false);
                        }
                    }

                    @Override
                    protected void fireActionPerformed(ActionEvent e) {
                        super.fireActionPerformed(e);
                        LivenessTreeTableView.this.searchAllocations = !LivenessTreeTableView.this.searchAllocations;
                    }
                });
            }
        };
        pb.setToolTipText(SEARCH_SCOPE_TOOLTIP);
        return new Component[]{Box.createHorizontalStrut(5), pb};
    }

    @Override
    protected ProfilerTable getResultsComponent() {
        return this.treeTable;
    }

    @Override
    public void setData(MemoryResultsSnapshot snapshot, GenericFilter filter, int aggregation) {
        final boolean includeEmpty = filter != null;
        final boolean diff = snapshot instanceof LivenessMemoryResultsDiff;
        final LivenessMemoryResultsSnapshot _snapshot = (LivenessMemoryResultsSnapshot)snapshot;
        String[] _classNames = _snapshot.getClassNames();
        long[] _nTrackedAllocObjects = _snapshot.getNTrackedAllocObjects();
        long[] _objectsSizePerClass = _snapshot.getObjectsSizePerClass();
        int[] _nTrackedLiveObjects = _snapshot.getNTrackedLiveObjects();
        int[] _nTotalAllocObjects = _snapshot.getnTotalAllocObjects();
        float[] _avgObjectAge = _snapshot.getAvgObjectAge();
        int[] _maxSurvGen = _snapshot.getMaxSurvGen();
        int _nTrackedItems = Math.min(_snapshot.getNProfiledClasses(), _classNames.length);
        _nTrackedItems = Math.min(_nTrackedItems, _nTotalAllocObjects.length);
        class Node
        extends PresoObjLivenessCCTNode {
            Node(String className, long nTrackedAllocObjects, long objectsSizePerClass, int nTrackedLiveObjects, int nTotalAllocObjects, float avgObjectAge, int maxSurvGen) {
                super(className, nTrackedAllocObjects, objectsSizePerClass, nTrackedLiveObjects, nTotalAllocObjects, avgObjectAge, maxSurvGen);
            }

            public CCTNode[] getChildren() {
                if (this.children == null) {
                    MemoryCCTManager callGraphManager = new MemoryCCTManager((MemoryResultsSnapshot)_snapshot, _i, true);
                    PresoObjAllocCCTNode root = callGraphManager.getRootNode();
                    this.setChildren(root == null ? new PresoObjAllocCCTNode[]{} : (PresoObjAllocCCTNode[])root.getChildren());
                }
                return this.children;
            }

            public boolean isLeaf() {
                if (this.children == null) {
                    return includeEmpty ? this.nCalls == 0L : false;
                }
                return super.isLeaf();
            }

            public int getChildCount() {
                if (this.children == null) {
                    this.getChildren();
                }
                return super.getChildCount();
            }
        }
        ArrayList<Node> nodes = new ArrayList<Node>();
        final HashMap<Node, ClientUtils.SourceCodeSelection> _nodesMap = new HashMap<Node, ClientUtils.SourceCodeSelection>();
        long totalLiveBytes = 0L;
        long _totalLiveBytes = 0L;
        long totalLiveObjects = 0L;
        long _totalLiveObjects = 0L;
        long totalTrackedAlloc = 0L;
        long _totalTrackedAlloc = 0L;
        long totalTotalAlloc = 0L;
        long _totalTotalAlloc = 0L;
        for (int i = 0; i < _nTrackedItems; ++i) {
            Node node;
            if (diff) {
                totalLiveBytes = Math.max(totalLiveBytes, _objectsSizePerClass[i]);
                _totalLiveBytes = Math.min(_totalLiveBytes, _objectsSizePerClass[i]);
                totalLiveObjects = Math.max(totalLiveObjects, (long)_nTrackedLiveObjects[i]);
                _totalLiveObjects = Math.min(_totalLiveObjects, (long)_nTrackedLiveObjects[i]);
                totalTrackedAlloc = Math.max(totalTrackedAlloc, _nTrackedAllocObjects[i]);
                _totalTrackedAlloc = Math.min(_totalTrackedAlloc, _nTrackedAllocObjects[i]);
                if (this.includeTotalAllocs) {
                    totalTotalAlloc = Math.max(totalTotalAlloc, (long)_nTotalAllocObjects[i]);
                    _totalTotalAlloc = Math.min(_totalTotalAlloc, (long)_nTotalAllocObjects[i]);
                }
            } else {
                totalLiveBytes += _objectsSizePerClass[i];
                totalLiveObjects += (long)_nTrackedLiveObjects[i];
                totalTrackedAlloc += _nTrackedAllocObjects[i];
                if (this.includeTotalAllocs) {
                    totalTotalAlloc += (long)_nTotalAllocObjects[i];
                }
            }
            final int _i = i;
            if (!includeEmpty) {
                if (_nTrackedLiveObjects[i] <= 0) continue;
                node = new Node(_classNames[i], _nTrackedAllocObjects[i], _objectsSizePerClass[i], _nTrackedLiveObjects[i], _nTotalAllocObjects[i], _avgObjectAge[i], _maxSurvGen[i]);
                nodes.add(node);
                _nodesMap.put(node, new ClientUtils.SourceCodeSelection(_classNames[i], "*", null));
                continue;
            }
            if (!filter.passes(_classNames[i].replace('.', '/'))) continue;
            node = new Node(_classNames[i], _nTrackedAllocObjects[i], _objectsSizePerClass[i], _nTrackedLiveObjects[i], _nTotalAllocObjects[i], _avgObjectAge[i], _maxSurvGen[i]);
            nodes.add(node);
            _nodesMap.put(node, new ClientUtils.SourceCodeSelection(_classNames[i], "*", null));
        }
        final long __totalLiveBytes = !diff ? totalLiveBytes : Math.max(Math.abs(totalLiveBytes), Math.abs(_totalLiveBytes));
        final long __totalLiveObjects = !diff ? totalLiveObjects : Math.max(Math.abs(totalLiveObjects), Math.abs(_totalLiveObjects));
        final long __totalTrackedAlloc = !diff ? totalTrackedAlloc : Math.max(Math.abs(totalTrackedAlloc), Math.abs(_totalTrackedAlloc));
        final long __totalTotalAlloc = !diff ? totalTotalAlloc : Math.max(Math.abs(totalTotalAlloc), Math.abs(_totalTotalAlloc));
        final PresoObjLivenessCCTNode root = PresoObjLivenessCCTNode.rootNode((PresoObjLivenessCCTNode[])nodes.toArray(new PresoObjLivenessCCTNode[0]));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LivenessTreeTableView.this.nodesMap = _nodesMap;
                LivenessTreeTableView.this.renderers[0].setMaxValue(__totalLiveBytes);
                LivenessTreeTableView.this.renderers[1].setMaxValue(__totalLiveObjects);
                LivenessTreeTableView.this.renderers[2].setMaxValue(__totalTrackedAlloc);
                if (LivenessTreeTableView.this.includeTotalAllocs) {
                    LivenessTreeTableView.this.renderers[3].setMaxValue(__totalTotalAlloc);
                }
                LivenessTreeTableView.this.renderers[0].setDiffMode(diff);
                LivenessTreeTableView.this.renderers[1].setDiffMode(diff);
                LivenessTreeTableView.this.renderers[2].setDiffMode(diff);
                if (LivenessTreeTableView.this.includeTotalAllocs) {
                    LivenessTreeTableView.this.renderers[3].setDiffMode(diff);
                }
                LivenessTreeTableView.this.renderersEx[0].setDiffMode(diff);
                LivenessTreeTableView.this.renderersEx[1].setDiffMode(diff);
                LivenessTreeTableView.this.treeTableModel.setRoot((TreeNode)root);
            }
        });
    }

    @Override
    public void resetData() {
        final PresoObjLivenessCCTNode root = PresoObjLivenessCCTNode.rootNode((PresoObjLivenessCCTNode[])new PresoObjLivenessCCTNode[0]);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LivenessTreeTableView.this.nodesMap = null;
                LivenessTreeTableView.this.renderers[0].setMaxValue(0L);
                LivenessTreeTableView.this.renderers[1].setMaxValue(0L);
                LivenessTreeTableView.this.renderers[2].setMaxValue(0L);
                if (LivenessTreeTableView.this.includeTotalAllocs) {
                    LivenessTreeTableView.this.renderers[3].setMaxValue(0L);
                }
                LivenessTreeTableView.this.renderers[0].setDiffMode(false);
                LivenessTreeTableView.this.renderers[1].setDiffMode(false);
                LivenessTreeTableView.this.renderers[2].setDiffMode(false);
                if (LivenessTreeTableView.this.includeTotalAllocs) {
                    LivenessTreeTableView.this.renderers[3].setDiffMode(false);
                }
                LivenessTreeTableView.this.renderersEx[0].setDiffMode(false);
                LivenessTreeTableView.this.renderersEx[1].setDiffMode(false);
                LivenessTreeTableView.this.treeTableModel.setRoot((TreeNode)root);
            }
        });
    }

    @Override
    public void showSelectionColumn() {
        this.treeTable.setColumnVisibility(0, true);
    }

    @Override
    public void refreshSelection() {
        this.treeTableModel.dataChanged();
    }

    @Override
    public ExportUtils.ExportProvider[] getExportProviders() {
        ExportUtils.ExportProvider[] exportProviderArray;
        if (this.treeTable.getRowCount() == 0) {
            exportProviderArray = null;
        } else {
            ExportUtils.ExportProvider[] exportProviderArray2 = new ExportUtils.ExportProvider[4];
            exportProviderArray2[0] = new ExportUtils.CSVExportProvider(this.treeTable);
            exportProviderArray2[1] = new ExportUtils.HTMLExportProvider((ProfilerTable)this.treeTable, EXPORT_ALLOCATED_LIVE);
            exportProviderArray2[2] = new ExportUtils.XMLExportProvider((ProfilerTable)this.treeTable, EXPORT_ALLOCATED_LIVE);
            exportProviderArray = exportProviderArray2;
            exportProviderArray2[3] = new ExportUtils.PNGExportProvider(this.treeTable);
        }
        return exportProviderArray;
    }

    @Override
    protected abstract void performDefaultAction(ClientUtils.SourceCodeSelection var1);

    protected abstract void populatePopup(JPopupMenu var1, Object var2, ClientUtils.SourceCodeSelection var3);

    protected void popupShowing() {
    }

    protected void popupHidden() {
    }

    private void initUI() {
        String[] stringArray;
        int offset = this.selection == null ? -1 : 0;
        this.treeTableModel = new LivenessTreeTableModel((TreeNode)PrestimeCPUCCTNode.EMPTY);
        this.treeTable = new ProfilerTreeTable(this.treeTableModel, true, true, new int[]{1 + offset}){

            public ClientUtils.SourceCodeSelection getUserValueForRow(int row) {
                return LivenessTreeTableView.this.getUserValueForRow(row);
            }

            @Override
            protected void populatePopup(JPopupMenu popup, Object value, Object userValue) {
                LivenessTreeTableView.this.populatePopup(popup, value, (ClientUtils.SourceCodeSelection)userValue);
            }

            @Override
            protected void popupShowing() {
                LivenessTreeTableView.this.popupShowing();
            }

            @Override
            protected void popupHidden() {
                LivenessTreeTableView.this.popupHidden();
            }
        };
        if (this.selection == null) {
            String[] stringArray2 = new String[7];
            stringArray2[0] = NAME_COLUMN_TOOLTIP;
            stringArray2[1] = LIVE_SIZE_COLUMN_TOOLTIP;
            stringArray2[2] = LIVE_COUNT_COLUMN_TOOLTIP;
            stringArray2[3] = ALLOC_COUNT_COLUMN_TOOLTIP;
            stringArray2[4] = AVG_AGE_COLUMN_TOOLTIP;
            stringArray2[5] = GENERATIONS_COLUMN_TOOLTIP;
            stringArray = stringArray2;
            stringArray2[6] = TOTAL_ALLOC_COUNT_COLUMN_TOOLTIP;
        } else {
            String[] stringArray3 = new String[8];
            stringArray3[0] = SELECTED_COLUMN_TOOLTIP;
            stringArray3[1] = NAME_COLUMN_TOOLTIP;
            stringArray3[2] = LIVE_SIZE_COLUMN_TOOLTIP;
            stringArray3[3] = LIVE_COUNT_COLUMN_TOOLTIP;
            stringArray3[4] = ALLOC_COUNT_COLUMN_TOOLTIP;
            stringArray3[5] = AVG_AGE_COLUMN_TOOLTIP;
            stringArray3[6] = GENERATIONS_COLUMN_TOOLTIP;
            stringArray = stringArray3;
            stringArray3[7] = TOTAL_ALLOC_COUNT_COLUMN_TOOLTIP;
        }
        this.treeTable.setColumnToolTips(stringArray);
        this.treeTable.providePopupMenu(true);
        this.treeTable.setDefaultAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = LivenessTreeTableView.this.treeTable.getSelectedRow();
                ClientUtils.SourceCodeSelection userValue = LivenessTreeTableView.this.getUserValueForRow(row);
                if (userValue != null) {
                    LivenessTreeTableView.this.performDefaultAction(userValue);
                }
            }
        });
        this.treeTable.setRootVisible(false);
        this.treeTable.setShowsRootHandles(true);
        this.treeTable.makeTreeAutoExpandable(2);
        this.treeTable.setMainColumn(1 + offset);
        this.treeTable.setFitWidthColumn(1 + offset);
        this.treeTable.setSortColumn(2 + offset);
        this.treeTable.setDefaultSortOrder(1 + offset, SortOrder.ASCENDING);
        if (this.selection != null) {
            this.treeTable.setColumnVisibility(0, false);
        }
        this.treeTable.setColumnVisibility(5 + offset, false);
        if (this.includeTotalAllocs) {
            this.treeTable.setColumnVisibility(7 + offset, false);
        }
        this.renderers = new HideableBarRenderer[4];
        this.renderers[0] = new HideableBarRenderer(new NumberPercentRenderer(Formatters.bytesFormat()));
        this.renderers[1] = new HideableBarRenderer(new NumberPercentRenderer());
        this.renderers[2] = new HideableBarRenderer(new NumberPercentRenderer());
        this.renderers[3] = new HideableBarRenderer(new NumberPercentRenderer(){

            @Override
            public void setValue(Object value, int row) {
                if (value == null || ((Number)value).longValue() == -1L) {
                    super.setValue(null, row);
                } else {
                    super.setValue(value, row);
                }
            }
        });
        this.renderers[0].setMaxValue(123456789L);
        this.renderers[1].setMaxValue(12345678L);
        this.renderers[2].setMaxValue(12345678L);
        this.renderers[3].setMaxValue(12345678L);
        this.renderersEx = new NumberRenderer[2];
        this.renderersEx[0] = new NumberRenderer(){

            @Override
            protected String getValueString(Object value, int row, Format format) {
                if (value == null) {
                    return "-";
                }
                float _value = ((Float)value).floatValue();
                String s = StringUtils.floatPerCentToString((float)_value);
                if (this.renderingDiff && _value >= 0.0f) {
                    s = '+' + s;
                }
                return s;
            }
        };
        this.renderersEx[1] = new NumberRenderer();
        if (this.selection != null) {
            this.treeTable.setColumnRenderer(0, new CheckBoxRenderer(){
                private boolean visible;

                @Override
                public void setValue(Object value, int row) {
                    TreePath path = LivenessTreeTableView.this.treeTable.getPathForRow(row);
                    this.visible = LivenessTreeTableView.this.nodesMap.containsKey((TreeNode)path.getLastPathComponent());
                    if (this.visible) {
                        super.setValue(value, row);
                    }
                }

                @Override
                public void paint(Graphics g) {
                    if (this.visible) {
                        super.paint(g);
                    } else {
                        g.setColor(this.getBackground());
                        g.fillRect(0, 0, this.size.width, this.size.height);
                    }
                }
            });
        }
        this.treeTable.setTreeCellRenderer(new MemoryJavaNameRenderer());
        this.treeTable.setColumnRenderer(2 + offset, this.renderers[0]);
        this.treeTable.setColumnRenderer(3 + offset, this.renderers[1]);
        this.treeTable.setColumnRenderer(4 + offset, this.renderers[2]);
        this.treeTable.setColumnRenderer(5 + offset, this.renderersEx[0]);
        this.treeTable.setColumnRenderer(6 + offset, this.renderersEx[1]);
        if (this.includeTotalAllocs) {
            this.treeTable.setColumnRenderer(7 + offset, this.renderers[3]);
        }
        if (this.selection != null) {
            int w = new JLabel((String)this.treeTable.getColumnName((int)0)).getPreferredSize().width;
            this.treeTable.setDefaultColumnWidth(0, w + 15);
        }
        this.treeTable.setDefaultColumnWidth(2 + offset, this.renderers[0].getOptimalWidth());
        this.treeTable.setDefaultColumnWidth(3 + offset, this.renderers[1].getMaxNoBarWidth());
        this.treeTable.setDefaultColumnWidth(4 + offset, this.renderers[2].getMaxNoBarWidth());
        this.treeTable.setDefaultColumnWidth(5 + offset, this.renderers[2].getNoBarWidth() - 25);
        if (this.includeTotalAllocs) {
            this.treeTable.setDefaultColumnWidth(7 + offset, this.renderers[3].getMaxNoBarWidth());
        }
        ProfilerTableContainer tableContainer = new ProfilerTableContainer(this.treeTable, false, null);
        this.setLayout(new BorderLayout());
        this.add((Component)tableContainer, "Center");
    }

    @Override
    protected ClientUtils.SourceCodeSelection getUserValueForRow(int row) {
        PresoObjLivenessCCTNode node = (PresoObjLivenessCCTNode)this.treeTable.getValueForRow(row);
        if (node == null || node.isFiltered()) {
            return null;
        }
        String[] name = node.getMethodClassNameAndSig();
        return new ClientUtils.SourceCodeSelection(name[0], name[1], name[2]);
    }

    private class LivenessTreeTableModel
    extends ProfilerTreeTableModel.Abstract {
        private final int columns;

        LivenessTreeTableModel(TreeNode root) {
            super(root);
            this.columns = 6 + (LivenessTreeTableView.this.selection == null ? 0 : 1) + (LivenessTreeTableView.this.includeTotalAllocs ? 1 : 0);
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (LivenessTreeTableView.this.selection == null) {
                ++columnIndex;
            }
            if (columnIndex == 1) {
                return MemoryView.COLUMN_NAME;
            }
            if (columnIndex == 2) {
                return MemoryView.COLUMN_LIVE_BYTES;
            }
            if (columnIndex == 3) {
                return MemoryView.COLUMN_LIVE_OBJECTS;
            }
            if (columnIndex == 4) {
                return MemoryView.COLUMN_ALLOCATED_OBJECTS;
            }
            if (columnIndex == 5) {
                return MemoryView.COLUMN_AVG_AGE;
            }
            if (columnIndex == 6) {
                return MemoryView.COLUMN_GENERATIONS;
            }
            if (columnIndex == 7) {
                return MemoryView.COLUMN_TOTAL_ALLOCATED_OBJECTS;
            }
            if (columnIndex == 0) {
                return MemoryView.COLUMN_SELECTED;
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (LivenessTreeTableView.this.selection == null) {
                ++columnIndex;
            }
            if (columnIndex == 1) {
                return JTree.class;
            }
            if (columnIndex == 2) {
                return Long.class;
            }
            if (columnIndex == 3) {
                return Integer.class;
            }
            if (columnIndex == 4) {
                return Long.class;
            }
            if (columnIndex == 5) {
                return Float.class;
            }
            if (columnIndex == 6) {
                return Integer.class;
            }
            if (columnIndex == 7) {
                return Integer.class;
            }
            if (columnIndex == 0) {
                return Boolean.class;
            }
            return null;
        }

        @Override
        public int getColumnCount() {
            return this.columns;
        }

        @Override
        public Object getValueAt(TreeNode node, int columnIndex) {
            PresoObjLivenessCCTNode livenessNode = (PresoObjLivenessCCTNode)node;
            if (LivenessTreeTableView.this.selection == null) {
                ++columnIndex;
            }
            if (columnIndex == 1) {
                return livenessNode.getNodeName();
            }
            if (columnIndex == 2) {
                return livenessNode.totalObjSize;
            }
            if (columnIndex == 3) {
                return livenessNode.nLiveObjects;
            }
            if (columnIndex == 4) {
                return livenessNode.nCalls;
            }
            if (columnIndex == 5) {
                return Float.valueOf(livenessNode.avgObjectAge);
            }
            if (columnIndex == 6) {
                return livenessNode.survGen;
            }
            if (columnIndex == 7) {
                return livenessNode.nTotalAllocObjects;
            }
            if (columnIndex == 0) {
                if (LivenessTreeTableView.this.selection.isEmpty()) {
                    return Boolean.FALSE;
                }
                return LivenessTreeTableView.this.selection.contains(LivenessTreeTableView.this.nodesMap.get(node));
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, TreeNode node, int columnIndex) {
            if (LivenessTreeTableView.this.selection == null) {
                ++columnIndex;
            }
            if (columnIndex == 0) {
                if (Boolean.TRUE.equals(aValue)) {
                    LivenessTreeTableView.this.selection.add(LivenessTreeTableView.this.nodesMap.get(node));
                } else {
                    LivenessTreeTableView.this.selection.remove(LivenessTreeTableView.this.nodesMap.get(node));
                }
            }
        }

        @Override
        public boolean isCellEditable(TreeNode node, int columnIndex) {
            if (LivenessTreeTableView.this.selection == null) {
                ++columnIndex;
            }
            if (columnIndex != 0) {
                return false;
            }
            return LivenessTreeTableView.this.nodesMap.containsKey(node);
        }
    }
}

