/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.issuetable;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.netbeans.modules.bugtracking.issuetable.FindInQueryBar;
import org.netbeans.modules.bugtracking.issuetable.IssueTable;
import org.openide.util.actions.CallbackSystemAction;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;

class FindInQuerySupport {
    private final FindInQueryBar bar;
    private final AncestorListener ancestorListener;
    private final IssueTable issueTable;

    private FindInQuerySupport(IssueTable issueTable) {
        this.issueTable = issueTable;
        this.bar = new FindInQueryBar(this);
        this.bar.setVisible(false);
        this.ancestorListener = new AncestorListener(){
            private Action sfa;

            @Override
            public void ancestorAdded(AncestorEvent ae) {
                TopComponent tc = this.findTC(ae.getComponent());
                if (tc != null) {
                    ActionMap actionMap = tc.getActionMap();
                    CallbackSystemAction a = (CallbackSystemAction)SystemAction.get(org.openide.actions.FindAction.class);
                    this.sfa = actionMap.get(a.getActionMapKey());
                    actionMap.put(a.getActionMapKey(), new FindAction());
                }
            }

            @Override
            public void ancestorRemoved(AncestorEvent ae) {
                TopComponent tc = this.findTC(ae.getComponent());
                if (tc != null && this.sfa != null) {
                    ActionMap actionMap = tc.getActionMap();
                    CallbackSystemAction a = (CallbackSystemAction)SystemAction.get(org.openide.actions.FindAction.class);
                    actionMap.put(a.getActionMapKey(), this.sfa);
                    this.sfa = null;
                }
            }

            @Override
            public void ancestorMoved(AncestorEvent ae) {
            }

            private TopComponent findTC(Component cmp) {
                Container parent;
                while ((parent = cmp.getParent()) != null) {
                    cmp = parent;
                    if (!(parent instanceof TopComponent)) continue;
                    return (TopComponent)cmp;
                }
                return null;
            }
        };
    }

    static FindInQuerySupport create(IssueTable issueTable) {
        return new FindInQuerySupport(issueTable);
    }

    FindInQueryBar getFindBar() {
        return this.bar;
    }

    public AncestorListener getAncestorListener() {
        return this.ancestorListener;
    }

    void reset() {
        if (this.issueTable != null) {
            this.issueTable.resetFilterBySummary();
        }
    }

    protected void updatePattern() {
        if (this.issueTable != null) {
            this.issueTable.setFilterBySummary(this.bar.getText(), this.bar.getRegularExpression(), this.bar.getWholeWords(), this.bar.getMatchCase());
        }
    }

    protected void cancel() {
        this.reset();
        this.bar.setVisible(false);
    }

    protected void switchHighlight(boolean on) {
        if (this.issueTable != null) {
            this.issueTable.switchFilterBySummaryHighlight(on);
        }
    }

    private class FindAction
    extends AbstractAction {
        private FindAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (FindInQuerySupport.this.issueTable == null) {
                return;
            }
            if (FindInQuerySupport.this.bar.isVisible()) {
                FindInQuerySupport.this.updatePattern();
            } else {
                FindInQuerySupport.this.bar.setVisible(true);
                FindInQuerySupport.this.updatePattern();
            }
            FindInQuerySupport.this.bar.requestFocusInWindow();
        }
    }
}

