/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text.dom;

import java.lang.ref.WeakReference;
import javax.swing.text.BadLocationException;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.xml.lexer.XMLTokenId;
import org.netbeans.modules.xml.text.api.dom.SyntaxElement;
import org.netbeans.modules.xml.text.api.dom.XMLSyntaxSupport;
import org.w3c.dom.Node;

public abstract class BaseSyntaxElement
implements SyntaxElement {
    protected XMLSyntaxSupport support;
    private WeakReference<Token> first;
    private WeakReference<BaseSyntaxElement> previous;
    private WeakReference<BaseSyntaxElement> next;
    protected int offset;
    protected int length;

    BaseSyntaxElement(XMLSyntaxSupport support, Token<XMLTokenId> token, int start, int end) {
        this.support = support;
        this.offset = start;
        this.length = end - start;
        this.first = new WeakReference<Token<XMLTokenId>>(token);
    }

    protected Token first() {
        Token cached_first = (Token)this.first.get();
        if (cached_first != null) {
            return cached_first;
        }
        try {
            Token<XMLTokenId> new_first = this.support.getNextToken(this.offset);
            this.first = new WeakReference<Token<XMLTokenId>>(new_first);
            return new_first;
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    @Override
    public int getElementOffset() {
        return this.offset;
    }

    @Override
    public int getElementLength() {
        return this.length;
    }

    void setNext(BaseSyntaxElement se) {
        this.next = new WeakReference<BaseSyntaxElement>(se);
    }

    void setPrevious(BaseSyntaxElement se) {
        this.previous = new WeakReference<BaseSyntaxElement>(se);
    }

    @Override
    public BaseSyntaxElement getPrevious() {
        BaseSyntaxElement cached_previous;
        BaseSyntaxElement baseSyntaxElement = cached_previous = this.previous == null ? null : (BaseSyntaxElement)this.previous.get();
        if (cached_previous != null) {
            return cached_previous;
        }
        try {
            if (this.offset == 0) {
                return null;
            }
            BaseSyntaxElement new_previous = (BaseSyntaxElement)this.support.getElementChain(this.getElementOffset() - 1);
            if (new_previous != null) {
                this.setPrevious(new_previous);
                new_previous.setNext(this);
                if (new_previous.offset == this.offset) {
                    return null;
                }
            }
            return new_previous;
        }
        catch (BadLocationException ex) {
            return null;
        }
    }

    @Override
    public BaseSyntaxElement getNext() {
        BaseSyntaxElement cached_next;
        BaseSyntaxElement baseSyntaxElement = cached_next = this.next == null ? null : (BaseSyntaxElement)this.next.get();
        if (cached_next != null) {
            return cached_next;
        }
        try {
            BaseSyntaxElement new_next = (BaseSyntaxElement)this.support.getElementChain(this.offset + this.length + 1);
            if (new_next != null) {
                this.setNext(new_next);
                new_next.setPrevious(this);
                if (new_next.offset == this.offset) {
                    return null;
                }
            }
            return new_next;
        }
        catch (BadLocationException ex) {
            return null;
        }
    }

    public String toString() {
        String content = "?";
        return "SyntaxElement [offset=" + this.offset + "; length=" + this.length + " ;type = " + this.getClass().getName() + "; content:" + content + "]";
    }

    public int hashCode() {
        return super.hashCode() ^ this.offset ^ this.length;
    }

    public boolean equals(Object obj) {
        return obj instanceof BaseSyntaxElement && ((BaseSyntaxElement)obj).offset == this.offset;
    }

    public String getName() {
        return null;
    }

    public static class Error
    extends BaseSyntaxElement {
        public Error(XMLSyntaxSupport support, Token first, int start, int end) {
            super(support, (Token<XMLTokenId>)first, start, end);
        }

        @Override
        public String toString() {
            return "Error" + super.toString();
        }

        @Override
        public int getType() {
            return -1;
        }

        public Node getNode() {
            return null;
        }

        @Override
        public SyntaxElement getParentElement() {
            BaseSyntaxElement x;
            for (x = this; x != null && x.getType() != 1; x = ((BaseSyntaxElement)x).getPrevious()) {
            }
            return x;
        }
    }
}

