/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.axi;

import java.util.List;
import org.netbeans.modules.xml.axi.AXIComponent;
import org.netbeans.modules.xml.axi.AXIModel;
import org.netbeans.modules.xml.axi.Attribute;
import org.netbeans.modules.xml.axi.ContentModel;
import org.netbeans.modules.xml.axi.Element;
import org.netbeans.modules.xml.axi.SchemaGenerator;
import org.netbeans.modules.xml.axi.visitor.AXIVisitor;
import org.netbeans.modules.xml.schema.model.Form;
import org.netbeans.modules.xml.schema.model.SchemaComponent;

public abstract class AXIDocument
extends AXIComponent {
    private String namespace;
    private String version;
    private String language;
    private Form attributeFormDefault;
    private Form elementFormDefault;
    public static final String PROP_TARGET_NAMESPACE = "targetNamespace";
    public static final String PROP_LANGUAGE = "language";
    public static final String PROP_VERSION = "version";
    public static final String PROP_ATTRIBUTE_FORM_DEFAULT = "attributeFormDefault";
    public static final String PROP_ELEMENT_FORM_DEFAULT = "elementFormDefault";
    public static final String PROP_SCHEMA_DESIGN_PATTERN = "schemaDesignPattern";

    public AXIDocument(AXIModel model) {
        super(model);
    }

    public AXIDocument(AXIModel model, SchemaComponent schemaComponent) {
        super(model, schemaComponent);
    }

    @Override
    public void accept(AXIVisitor visitor) {
        visitor.visit(this);
    }

    public List<Element> getElements() {
        return this.getChildren(Element.class);
    }

    public List<Attribute> getAttributes() {
        return this.getChildren(Attribute.class);
    }

    public List<ContentModel> getContentModels() {
        return this.getChildren(ContentModel.class);
    }

    public void addContentModel(ContentModel contentModel) {
        this.appendChild("contentModel", contentModel);
    }

    public void removeContentModel(ContentModel contentModel) {
        this.removeChild("contentModel", contentModel);
    }

    public void addElement(Element element) {
        this.appendChild("element", element);
    }

    public void removeElement(Element element) {
        this.removeChild("element", element);
    }

    @Override
    public String getTargetNamespace() {
        return this.namespace;
    }

    public void setTargetNamespace(String value) {
        String oldValue = this.getTargetNamespace();
        if (oldValue == null && value == null || oldValue != null && oldValue.equals(value)) {
            return;
        }
        this.namespace = value;
        this.firePropertyChangeEvent(PROP_TARGET_NAMESPACE, oldValue, value);
    }

    public void setVersion(String value) {
        String oldValue = this.getVersion();
        if (oldValue == null && value == null || oldValue != null && oldValue.equals(value)) {
            return;
        }
        this.version = value;
        this.firePropertyChangeEvent(PROP_VERSION, oldValue, value);
    }

    public String getVersion() {
        return this.version;
    }

    public void setLanguage(String value) {
        String oldValue = this.getLanguage();
        if (oldValue == null && value == null || oldValue != null && oldValue.equals(value)) {
            return;
        }
        this.language = value;
        this.firePropertyChangeEvent(PROP_LANGUAGE, oldValue, value);
    }

    public String getLanguage() {
        return this.language;
    }

    public void setElementFormDefault(Form value) {
        Form oldValue = this.getElementFormDefault();
        if (oldValue == null && value == null || oldValue != null && oldValue.equals((Object)value)) {
            return;
        }
        this.elementFormDefault = value;
        this.firePropertyChangeEvent(PROP_ELEMENT_FORM_DEFAULT, oldValue, value);
    }

    public Form getElementFormDefault() {
        return this.elementFormDefault;
    }

    public void setAttributeFormDefault(Form value) {
        Form oldValue = this.getAttributeFormDefault();
        if (oldValue == null && value == null || oldValue != null && oldValue.equals((Object)value)) {
            return;
        }
        this.attributeFormDefault = value;
        this.firePropertyChangeEvent(PROP_ATTRIBUTE_FORM_DEFAULT, oldValue, value);
    }

    public Form getAttributeFormDefault() {
        return this.attributeFormDefault;
    }

    public void setSchemaDesignPattern(SchemaGenerator.Pattern value) {
        SchemaGenerator.Pattern oldValue = this.getSchemaDesignPattern();
        if (oldValue == null && value == null || oldValue != null && oldValue == value) {
            return;
        }
        if (this.getModel() != null) {
            this.getModel().setSchemaDesignPattern(value);
        }
        this.firePropertyChangeEvent(PROP_SCHEMA_DESIGN_PATTERN, (Object)oldValue, (Object)value);
    }

    public SchemaGenerator.Pattern getSchemaDesignPattern() {
        return this.getModel() != null ? this.getModel().getSchemaDesignPattern() : null;
    }
}

