/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.wizard.components.panels;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.EventObject;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.netbeans.installer.Installer;
import org.netbeans.installer.product.Registry;
import org.netbeans.installer.product.RegistryNode;
import org.netbeans.installer.product.RegistryType;
import org.netbeans.installer.product.components.Group;
import org.netbeans.installer.product.components.Product;
import org.netbeans.installer.product.dependencies.Conflict;
import org.netbeans.installer.product.dependencies.Requirement;
import org.netbeans.installer.utils.ErrorManager;
import org.netbeans.installer.utils.ResourceUtils;
import org.netbeans.installer.utils.StringUtils;
import org.netbeans.installer.utils.SystemUtils;
import org.netbeans.installer.utils.exceptions.NativeException;
import org.netbeans.installer.utils.helper.Dependency;
import org.netbeans.installer.utils.helper.Status;
import org.netbeans.installer.utils.helper.Version;
import org.netbeans.installer.utils.helper.swing.NbiCheckBox;
import org.netbeans.installer.utils.helper.swing.NbiLabel;
import org.netbeans.installer.utils.helper.swing.NbiPanel;
import org.netbeans.installer.utils.helper.swing.NbiScrollPane;
import org.netbeans.installer.utils.helper.swing.NbiTextPane;
import org.netbeans.installer.utils.helper.swing.NbiTree;
import org.netbeans.installer.wizard.components.panels.ErrorMessagePanel;
import org.netbeans.installer.wizard.containers.SwingContainer;
import org.netbeans.installer.wizard.ui.SwingUi;
import org.netbeans.installer.wizard.ui.WizardUi;

public class ComponentsSelectionPanel
extends ErrorMessagePanel {
    public static final String DESCRIPTION_INSTALL_PROPERTY = "description.install";
    public static final String DESCRIPTION_UNINSTALL_PROPERTY = "description.uninstall";
    public static final String FEATURE_DESCRIPTION_TITLE_PROPERTY = "feature.description.title";
    public static final String DEFAULT_TITLE = ResourceUtils.getString(ComponentsSelectionPanel.class, "CSP.title");
    public static final String DEFAULT_DESCRIPTION = ResourceUtils.getString(ComponentsSelectionPanel.class, "CSP.description.both");
    public static final String DEFAULT_DESCRIPTION_INSTALL = ResourceUtils.getString(ComponentsSelectionPanel.class, "CSP.description.install");
    public static final String DEFAULT_DESCRIPTION_UNINSTALL = ResourceUtils.getString(ComponentsSelectionPanel.class, "CSP.description.uninstall");
    public static final String DEFAULT_FEATURE_DESCRIPTION_TITLE = ResourceUtils.getString(ComponentsSelectionPanel.class, "CSP.feature.description.title");
    public static final String COMPONENT_DESCRIPTION_TEXT_PROPERTY = "component.description.text";
    public static final String COMPONENT_DESCRIPTION_CONTENT_TYPE_PROPERTY = "component.description.content.type";
    public static final String SIZES_LABEL_TEXT_PROPERTY = "sizes.label.text";
    public static final String SIZES_LABEL_TEXT_NO_DOWNLOAD_PROPERTY = "sizes.label.text.no.download";
    public static final String DEFAULT_INSTALLATION_SIZE_PROPERTY = "default.installation.size";
    public static final String DEFAULT_DOWNLOAD_SIZE_PROPERTY = "default.download.size";
    public static final String DEFAULT_COMPONENT_DESCRIPTION_TEXT = ResourceUtils.getString(ComponentsSelectionPanel.class, "CSP.component.description.text");
    public static final String DEFAULT_COMPONENT_DESCRIPTION_CONTENT_TYPE = ResourceUtils.getString(ComponentsSelectionPanel.class, "CSP.component.description.content.type");
    public static final String DEFAULT_SIZES_LABEL_TEXT = ResourceUtils.getString(ComponentsSelectionPanel.class, "CSP.sizes.label.text");
    public static final String DEFAULT_SIZES_LABEL_TEXT_NO_DOWNLOAD = ResourceUtils.getString(ComponentsSelectionPanel.class, "CSP.sizes.label.text.no.download");
    public static final String DEFAULT_INSTALLATION_SIZE = ResourceUtils.getString(ComponentsSelectionPanel.class, "CSP.default.installation.size");
    public static final String DEFAULT_DOWNLOAD_SIZE = ResourceUtils.getString(ComponentsSelectionPanel.class, "CSP.default.download.size");
    public static final String ERROR_NO_CHANGES_PROPERTY = "error.no.changes.both";
    public static final String ERROR_NO_CHANGES_INSTALL_ONLY_PROPERTY = "error.no.changes.install";
    public static final String ERROR_NO_CHANGES_UNINSTALL_ONLY_PROPERTY = "error.no.changes.uninstall";
    public static final String ERROR_REQUIREMENT_INSTALL_PROPERTY = "error.requirement.install";
    public static final String ERROR_CONFLICT_INSTALL_PROPERTY = "error.conflict.install";
    public static final String ERROR_REQUIREMENT_UNINSTALL_PROPERTY = "error.requirement.uninstall";
    public static final String ERROR_NO_ENOUGH_SPACE_TO_DOWNLOAD_PROPERTY = "error.not.enough.space.to.download";
    public static final String ERROR_NO_ENOUGH_SPACE_TO_EXTRACT_PROPERTY = "error.not.enough.space.to.extract";
    public static final String ERROR_CANNOT_CHECK_SPACE_PROPERTY = "error.cannot.check.space";
    public static final String DEFAULT_ERROR_NO_CHANGES = ResourceUtils.getString(ComponentsSelectionPanel.class, "CSP.error.no.changes.both");
    public static final String DEFAULT_ERROR_NO_CHANGES_INSTALL_ONLY = ResourceUtils.getString(ComponentsSelectionPanel.class, "CSP.error.no.changes.install");
    public static final String DEFAULT_ERROR_NO_CHANGES_UNINSTALL_ONLY = ResourceUtils.getString(ComponentsSelectionPanel.class, "CSP.error.no.changes.uninstall");
    public static final String DEFAULT_ERROR_REQUIREMENT_INSTALL = ResourceUtils.getString(ComponentsSelectionPanel.class, "CSP.error.requirement.install");
    public static final String DEFAULT_ERROR_CONFLICT_INSTALL = ResourceUtils.getString(ComponentsSelectionPanel.class, "CSP.error.conflict.install");
    public static final String DEFAULT_ERROR_REQUIREMENT_UNINSTALL = ResourceUtils.getString(ComponentsSelectionPanel.class, "CSP.error.requirement.uninstall");
    public static final String DEFAULT_ERROR_NO_ENOUGH_SPACE_TO_DOWNLOAD = ResourceUtils.getString(ComponentsSelectionPanel.class, "CSP.error.not.enough.space.to.download");
    public static final String DEFAULT_ERROR_NO_ENOUGH_SPACE_TO_EXTRACT = ResourceUtils.getString(ComponentsSelectionPanel.class, "CSP.error.not.enough.space.to.extract");
    public static final String DEFAULT_ERROR_CANNOT_CHECK_SPACE = ResourceUtils.getString(ComponentsSelectionPanel.class, "CSP.error.cannot.check.space");
    public static final long REQUIRED_SPACE_ADDITION = 0xA00000L;

    public ComponentsSelectionPanel() {
        this.setProperty("title", DEFAULT_TITLE);
        this.setProperty("description", DEFAULT_DESCRIPTION);
        this.setProperty(DESCRIPTION_INSTALL_PROPERTY, DEFAULT_DESCRIPTION_INSTALL);
        this.setProperty(DESCRIPTION_UNINSTALL_PROPERTY, DEFAULT_DESCRIPTION_UNINSTALL);
        this.setProperty(FEATURE_DESCRIPTION_TITLE_PROPERTY, DEFAULT_FEATURE_DESCRIPTION_TITLE);
        this.setProperty(COMPONENT_DESCRIPTION_TEXT_PROPERTY, DEFAULT_COMPONENT_DESCRIPTION_TEXT);
        this.setProperty(COMPONENT_DESCRIPTION_CONTENT_TYPE_PROPERTY, DEFAULT_COMPONENT_DESCRIPTION_CONTENT_TYPE);
        this.setProperty(SIZES_LABEL_TEXT_PROPERTY, DEFAULT_SIZES_LABEL_TEXT);
        this.setProperty(SIZES_LABEL_TEXT_NO_DOWNLOAD_PROPERTY, DEFAULT_SIZES_LABEL_TEXT_NO_DOWNLOAD);
        this.setProperty(DEFAULT_INSTALLATION_SIZE_PROPERTY, DEFAULT_INSTALLATION_SIZE);
        this.setProperty(DEFAULT_DOWNLOAD_SIZE_PROPERTY, DEFAULT_DOWNLOAD_SIZE);
        this.setProperty(ERROR_NO_CHANGES_PROPERTY, DEFAULT_ERROR_NO_CHANGES);
        this.setProperty(ERROR_NO_CHANGES_INSTALL_ONLY_PROPERTY, DEFAULT_ERROR_NO_CHANGES_INSTALL_ONLY);
        this.setProperty(ERROR_NO_CHANGES_UNINSTALL_ONLY_PROPERTY, DEFAULT_ERROR_NO_CHANGES_UNINSTALL_ONLY);
        this.setProperty(ERROR_REQUIREMENT_INSTALL_PROPERTY, DEFAULT_ERROR_REQUIREMENT_INSTALL);
        this.setProperty(ERROR_CONFLICT_INSTALL_PROPERTY, DEFAULT_ERROR_CONFLICT_INSTALL);
        this.setProperty(ERROR_REQUIREMENT_UNINSTALL_PROPERTY, DEFAULT_ERROR_REQUIREMENT_UNINSTALL);
        this.setProperty(ERROR_NO_ENOUGH_SPACE_TO_DOWNLOAD_PROPERTY, DEFAULT_ERROR_NO_ENOUGH_SPACE_TO_DOWNLOAD);
        this.setProperty(ERROR_NO_ENOUGH_SPACE_TO_EXTRACT_PROPERTY, DEFAULT_ERROR_NO_ENOUGH_SPACE_TO_EXTRACT);
        this.setProperty(ERROR_CANNOT_CHECK_SPACE_PROPERTY, DEFAULT_ERROR_CANNOT_CHECK_SPACE);
    }

    @Override
    public WizardUi getWizardUi() {
        if (this.wizardUi == null) {
            this.wizardUi = new ComponentsSelectionPanelUi(this);
        }
        return this.wizardUi;
    }

    @Override
    public boolean canExecuteForward() {
        return this.canExecute();
    }

    @Override
    public boolean canExecuteBackward() {
        return this.canExecute();
    }

    @Override
    public void initialize() {
        if (!this.isThereAnythingVisibleToInstall()) {
            this.setProperty("description", this.getProperty(DESCRIPTION_UNINSTALL_PROPERTY));
        }
        if (!this.isThereAnythingVisibleToUninstall()) {
            this.setProperty("description", this.getProperty(DESCRIPTION_INSTALL_PROPERTY));
        }
    }

    private boolean canExecute() {
        return !Boolean.getBoolean("nbi.product.force.install") && !Boolean.getBoolean("nbi.product.force.uninstall");
    }

    private boolean isThereAnythingVisibleToInstall() {
        Registry registry = Registry.getInstance();
        LinkedList<Product> toInstall = new LinkedList<Product>();
        toInstall.addAll(registry.getProducts(Status.NOT_INSTALLED));
        toInstall.addAll(registry.getProducts(Status.TO_BE_INSTALLED));
        for (Product product : toInstall) {
            if (!product.isVisible()) continue;
            return true;
        }
        return false;
    }

    private boolean isThereAnythingVisibleToUninstall() {
        Registry registry = Registry.getInstance();
        LinkedList<Product> toUninstall = new LinkedList<Product>();
        toUninstall.addAll(registry.getProducts(Status.INSTALLED));
        toUninstall.addAll(registry.getProducts(Status.TO_BE_UNINSTALLED));
        for (Product product : toUninstall) {
            if (!product.isVisible()) continue;
            return true;
        }
        return false;
    }

    public static class ComponentsTreeCell
    implements TreeCellRenderer,
    TreeCellEditor {
        private List<CellEditorListener> listeners = new LinkedList<CellEditorListener>();
        private NbiPanel panel;
        private NbiCheckBox checkBox;
        private NbiLabel iconLabel;
        private NbiLabel titleLabel;
        private NbiLabel statusLabel;
        private Color foreground = UIManager.getColor("Tree.textForeground");
        private Color background = UIManager.getColor("Tree.textBackground");
        private Color selectionForeground = UIManager.getColor("Tree.selectionForeground");
        private Color selectionBackground = UIManager.getColor("Tree.selectionBackground");

        public ComponentsTreeCell() {
            this.initComponents();
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean focus) {
            return this.getComponent(tree, value, selected, expanded, leaf, row, focus);
        }

        @Override
        public Component getTreeCellEditorComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row) {
            return this.getComponent(tree, value, selected, expanded, leaf, row, true);
        }

        @Override
        public Object getCellEditorValue() {
            return null;
        }

        @Override
        public boolean isCellEditable(EventObject event) {
            return true;
        }

        @Override
        public boolean shouldSelectCell(EventObject event) {
            return true;
        }

        @Override
        public boolean stopCellEditing() {
            this.fireEditingStopped();
            return true;
        }

        @Override
        public void cancelCellEditing() {
            this.fireEditingCanceled();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addCellEditorListener(CellEditorListener listener) {
            List<CellEditorListener> list = this.listeners;
            synchronized (list) {
                this.listeners.add(listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeCellEditorListener(CellEditorListener listener) {
            List<CellEditorListener> list = this.listeners;
            synchronized (list) {
                this.listeners.remove(listener);
            }
        }

        private void initComponents() {
            this.panel = new NbiPanel();
            this.panel.setLayout(new GridBagLayout());
            this.panel.setOpaque(false);
            this.checkBox = new NbiCheckBox();
            this.checkBox.setOpaque(false);
            this.checkBox.setFocusable(false);
            this.checkBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    this.stopCellEditing();
                }
            });
            this.iconLabel = new NbiLabel();
            this.iconLabel.setFocusable(false);
            this.iconLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent event) {
                    this.cancelCellEditing();
                }

                @Override
                public void mousePressed(MouseEvent event) {
                    this.cancelCellEditing();
                }

                @Override
                public void mouseReleased(MouseEvent event) {
                    this.cancelCellEditing();
                }
            });
            this.titleLabel = new NbiLabel();
            this.titleLabel.setFocusable(false);
            this.titleLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent event) {
                    this.cancelCellEditing();
                }

                @Override
                public void mousePressed(MouseEvent event) {
                    this.cancelCellEditing();
                }

                @Override
                public void mouseReleased(MouseEvent event) {
                    this.cancelCellEditing();
                }
            });
            this.statusLabel = new NbiLabel();
            this.statusLabel.setForeground(Color.GRAY);
            this.statusLabel.setFocusable(false);
            this.statusLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent event) {
                    this.cancelCellEditing();
                }

                @Override
                public void mousePressed(MouseEvent event) {
                    this.cancelCellEditing();
                }

                @Override
                public void mouseReleased(MouseEvent event) {
                    this.cancelCellEditing();
                }
            });
            this.panel.add((Component)this.checkBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.panel.add((Component)this.iconLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.panel.add((Component)this.titleLabel, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.panel.add((Component)this.statusLabel, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireEditingStopped() {
            CellEditorListener[] clone;
            List<CellEditorListener> list = this.listeners;
            synchronized (list) {
                clone = this.listeners.toArray(new CellEditorListener[0]);
            }
            ChangeEvent event = new ChangeEvent(this);
            for (CellEditorListener listener : clone) {
                listener.editingStopped(event);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireEditingCanceled() {
            CellEditorListener[] clone;
            List<CellEditorListener> list = this.listeners;
            synchronized (list) {
                clone = this.listeners.toArray(new CellEditorListener[0]);
            }
            ChangeEvent event = new ChangeEvent(this);
            for (CellEditorListener listener : clone) {
                listener.editingCanceled(event);
            }
        }

        private JComponent getComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean focus) {
            if (selected) {
                this.titleLabel.setOpaque(true);
                this.titleLabel.setForeground(this.selectionForeground);
                this.titleLabel.setBackground(this.selectionBackground);
            } else {
                this.titleLabel.setOpaque(false);
                this.titleLabel.setForeground(this.foreground);
                this.titleLabel.setBackground(this.background);
            }
            if (value instanceof Product) {
                Product product = (Product)value;
                String title = " " + product.getDisplayName() + " ";
                String status = " [" + product.getStatus().getDisplayName() + "]";
                String tooltip = title + status;
                this.iconLabel.setIcon(product.getIcon());
                this.iconLabel.setToolTipText(tooltip);
                this.titleLabel.setText(title);
                this.titleLabel.setToolTipText(tooltip);
                this.statusLabel.setText(status);
                this.statusLabel.setToolTipText(tooltip);
                this.checkBox.setVisible(true);
                this.checkBox.setToolTipText(tooltip);
                if (product.getStatus() == Status.INSTALLED || product.getStatus() == Status.TO_BE_INSTALLED) {
                    this.checkBox.setSelected(true);
                } else {
                    this.checkBox.setSelected(false);
                }
            } else if (value instanceof Group) {
                Group group = (Group)value;
                String title = " " + group.getDisplayName() + " ";
                String status = "";
                String tooltip = title + "";
                this.iconLabel.setIcon(group.getIcon());
                this.iconLabel.setToolTipText(tooltip);
                this.titleLabel.setText(title);
                this.titleLabel.setToolTipText(tooltip);
                this.statusLabel.setText("");
                this.statusLabel.setToolTipText(tooltip);
                this.checkBox.setVisible(false);
            }
            if (UIManager.getLookAndFeel().getID().equals("GTK")) {
                this.panel.setOpaque(false);
            }
            return this.panel;
        }
    }

    public static class ComponentsTreeModel
    implements TreeModel {
        private List<TreeModelListener> listeners = new LinkedList<TreeModelListener>();

        @Override
        public Object getRoot() {
            return Registry.getInstance().getRegistryRoot();
        }

        @Override
        public Object getChild(Object node, int index) {
            return ((RegistryNode)node).getVisibleChildren().get(index);
        }

        @Override
        public int getChildCount(Object node) {
            return ((RegistryNode)node).getVisibleChildren().size();
        }

        @Override
        public boolean isLeaf(Object node) {
            return ((RegistryNode)node).getVisibleChildren().size() == 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void valueForPathChanged(TreePath path, Object value) {
            TreeModelListener[] clone;
            if (path.getLastPathComponent() instanceof Product) {
                Product product = (Product)path.getLastPathComponent();
                switch (product.getStatus()) {
                    case NOT_INSTALLED: {
                        product.setStatus(Status.TO_BE_INSTALLED);
                        this.updateRequirements(product);
                        break;
                    }
                    case TO_BE_INSTALLED: {
                        product.setStatus(Status.NOT_INSTALLED);
                        break;
                    }
                    case INSTALLED: {
                        product.setStatus(Status.TO_BE_UNINSTALLED);
                        break;
                    }
                    case TO_BE_UNINSTALLED: {
                        product.setStatus(Status.INSTALLED);
                    }
                }
            }
            List<TreeModelListener> list = this.listeners;
            synchronized (list) {
                clone = this.listeners.toArray(new TreeModelListener[0]);
            }
            TreeModelEvent event = new TreeModelEvent((Object)this, path);
            for (TreeModelListener listener : clone) {
                listener.treeNodesChanged(event);
            }
        }

        @Override
        public int getIndexOfChild(Object node, Object child) {
            return ((RegistryNode)node).getVisibleChildren().indexOf(child);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addTreeModelListener(TreeModelListener listener) {
            List<TreeModelListener> list = this.listeners;
            synchronized (list) {
                this.listeners.add(listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeTreeModelListener(TreeModelListener listener) {
            List<TreeModelListener> list = this.listeners;
            synchronized (list) {
                this.listeners.remove(listener);
            }
        }

        private void updateRequirements(Product product) {
            for (Dependency requirement : product.getDependencies(Requirement.class)) {
                List<Product> requirees = Registry.getInstance().getProducts(requirement);
                boolean requireesNeedUpdate = true;
                RegistryNode correctRequiree = null;
                for (Product requiree : requirees) {
                    Version version = requiree.getVersion();
                    if (requiree.getStatus() == Status.INSTALLED || requiree.getStatus() == Status.TO_BE_INSTALLED) {
                        requireesNeedUpdate = false;
                        break;
                    }
                    if (correctRequiree != null && !((Product)correctRequiree).getVersion().olderThan(version)) continue;
                    correctRequiree = requiree;
                }
                if (!requireesNeedUpdate || requirees.isEmpty()) continue;
                this.valueForPathChanged(correctRequiree.getTreePath(), null);
            }
        }
    }

    public static class ComponentsSelectionPanelSwingUi
    extends ErrorMessagePanel.ErrorMessagePanelSwingUi {
        private ComponentsSelectionPanel panel;
        private NbiTree componentsTree;
        private NbiScrollPane componentsScrollPane;
        private NbiTextPane descriptionPane;
        private NbiScrollPane descriptionScrollPane;
        private NbiLabel sizesLabel;

        public ComponentsSelectionPanelSwingUi(ComponentsSelectionPanel component, SwingContainer container) {
            super(component, container);
            this.panel = component;
            this.initComponents();
        }

        @Override
        protected void initialize() {
            this.descriptionPane.setContentType(this.panel.getProperty(ComponentsSelectionPanel.COMPONENT_DESCRIPTION_CONTENT_TYPE_PROPERTY));
            if (!this.panel.isThereAnythingVisibleToInstall()) {
                this.sizesLabel.setVisible(false);
            }
            this.updateDescription();
            this.updateSizes();
            super.initialize();
        }

        @Override
        protected String validateInput() {
            Registry registry = Registry.getInstance();
            List<Product> toInstall = registry.getProducts(Status.TO_BE_INSTALLED);
            List<Product> toUninstall = registry.getProducts(Status.TO_BE_UNINSTALLED);
            if (toInstall.size() == 0 && toUninstall.size() == 0) {
                if (!this.panel.isThereAnythingVisibleToInstall()) {
                    return this.panel.getProperty(ComponentsSelectionPanel.ERROR_NO_CHANGES_UNINSTALL_ONLY_PROPERTY);
                }
                if (!this.panel.isThereAnythingVisibleToUninstall()) {
                    return this.panel.getProperty(ComponentsSelectionPanel.ERROR_NO_CHANGES_INSTALL_ONLY_PROPERTY);
                }
                return this.panel.getProperty(ComponentsSelectionPanel.ERROR_NO_CHANGES_PROPERTY);
            }
            for (Product product : toInstall) {
                boolean satisfied;
                for (Dependency requirement : product.getDependencies(Requirement.class)) {
                    List<Product> requirees = registry.getProducts(requirement);
                    satisfied = false;
                    for (Product product2 : requirees) {
                        if (product2.getStatus() != Status.TO_BE_INSTALLED && product2.getStatus() != Status.INSTALLED) continue;
                        satisfied = true;
                        break;
                    }
                    if (satisfied) continue;
                    return StringUtils.format(this.panel.getProperty(ComponentsSelectionPanel.ERROR_REQUIREMENT_INSTALL_PROPERTY), product.getDisplayName(), requirees.get(0).getDisplayName());
                }
                for (Dependency conflict : product.getDependencies(Conflict.class)) {
                    List<Product> conflictees = registry.getProducts(conflict);
                    satisfied = true;
                    Product unsatisfiedConflict = null;
                    Iterator iterator = conflictees.iterator();
                    while (iterator.hasNext()) {
                        Product conflictee = (Product)iterator.next();
                        if (conflictee.getStatus() != Status.TO_BE_INSTALLED && conflictee.getStatus() != Status.INSTALLED) continue;
                        satisfied = false;
                        unsatisfiedConflict = conflictee;
                        break;
                    }
                    if (satisfied) continue;
                    return StringUtils.format(this.panel.getProperty(ComponentsSelectionPanel.ERROR_CONFLICT_INSTALL_PROPERTY), product.getDisplayName(), unsatisfiedConflict.getDisplayName());
                }
            }
            for (Product product : toUninstall) {
                for (Product dependent : registry.getProducts()) {
                    if (dependent.getStatus() == Status.TO_BE_UNINSTALLED || dependent.getStatus() == Status.NOT_INSTALLED) continue;
                    for (Dependency requirement : dependent.getDependencies(Requirement.class)) {
                        List<Product> requirees = registry.getProducts(requirement);
                        if (!requirees.contains(product)) continue;
                        boolean bl = false;
                        for (Product requiree : requirees) {
                            if (requiree.getStatus() != Status.INSTALLED) continue;
                            bl = true;
                            break;
                        }
                        if (bl) continue;
                        return StringUtils.format(this.panel.getProperty(ComponentsSelectionPanel.ERROR_REQUIREMENT_UNINSTALL_PROPERTY), product.getDisplayName(), dependent.getDisplayName());
                    }
                }
            }
            String template = this.panel.getProperty(ComponentsSelectionPanel.ERROR_NO_ENOUGH_SPACE_TO_EXTRACT_PROPERTY);
            for (Product product : toInstall) {
                if (product.getRegistryType() != RegistryType.REMOTE) continue;
                template = this.panel.getProperty(ComponentsSelectionPanel.ERROR_NO_ENOUGH_SPACE_TO_DOWNLOAD_PROPERTY);
                break;
            }
            try {
                if (!Boolean.getBoolean("no.space.check")) {
                    File file = Installer.getInstance().getLocalDirectory();
                    long availableSize = SystemUtils.getFreeSpace(file);
                    long requiredSize = 0L;
                    for (Product product : toInstall) {
                        requiredSize += product.getDownloadSize();
                    }
                    if (availableSize < (requiredSize += 0xA00000L)) {
                        return StringUtils.format(template, file, StringUtils.formatSize(requiredSize - availableSize));
                    }
                }
            }
            catch (NativeException nativeException) {
                ErrorManager.notifyError(this.panel.getProperty(ComponentsSelectionPanel.ERROR_CANNOT_CHECK_SPACE_PROPERTY), nativeException);
            }
            return null;
        }

        @Override
        public JComponent getDefaultFocusOwner() {
            return this.componentsTree;
        }

        private void initComponents() {
            this.componentsTree = new NbiTree();
            this.componentsTree.setModel(new ComponentsTreeModel());
            this.componentsTree.setCellRenderer(new ComponentsTreeCell());
            this.componentsTree.setEditable(true);
            this.componentsTree.setCellEditor(new ComponentsTreeCell());
            this.componentsTree.setShowsRootHandles(true);
            this.componentsTree.setRootVisible(false);
            this.componentsTree.setBorder(new EmptyBorder(5, 5, 5, 5));
            this.componentsTree.setRowHeight(new JCheckBox().getPreferredSize().height);
            this.componentsTree.getSelectionModel().setSelectionMode(1);
            this.componentsTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent event) {
                    this.updateDescription();
                }
            });
            this.componentsTree.getModel().addTreeModelListener(new TreeModelListener(){

                @Override
                public void treeNodesChanged(TreeModelEvent event) {
                    this.updateSizes();
                    this.updateErrorMessage();
                }

                @Override
                public void treeNodesInserted(TreeModelEvent event) {
                }

                @Override
                public void treeNodesRemoved(TreeModelEvent event) {
                }

                @Override
                public void treeStructureChanged(TreeModelEvent event) {
                }
            });
            this.componentsTree.getActionMap().put("checkbox.update", new AbstractAction("checkbox.update"){

                @Override
                public void actionPerformed(ActionEvent event) {
                    TreePath path = componentsTree.getSelectionPath();
                    if (path != null) {
                        componentsTree.getModel().valueForPathChanged(path, null);
                    }
                }
            });
            this.componentsTree.getInputMap().put(KeyStroke.getKeyStroke(32, 0, false), "checkbox.update");
            this.componentsScrollPane = new NbiScrollPane(this.componentsTree);
            this.descriptionPane = new NbiTextPane();
            this.descriptionPane.setBorder(new EmptyBorder(5, 5, 5, 5));
            this.descriptionScrollPane = new NbiScrollPane(this.descriptionPane);
            this.descriptionScrollPane.setVerticalScrollBarPolicy(20);
            this.descriptionScrollPane.setBorder(new TitledBorder(this.panel.getProperty(ComponentsSelectionPanel.FEATURE_DESCRIPTION_TITLE_PROPERTY)));
            this.sizesLabel = new NbiLabel();
            this.add((Component)this.componentsScrollPane, new GridBagConstraints(0, 0, 1, 1, 0.7, 1.0, 19, 1, new Insets(11, 11, 0, 0), 0, 0));
            this.add((Component)this.descriptionScrollPane, new GridBagConstraints(1, 0, 1, 1, 0.3, 1.0, 19, 1, new Insets(11, 6, 0, 11), 0, 0));
            this.add((Component)this.sizesLabel, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 21, 2, new Insets(6, 11, 0, 11), 0, 0));
            for (RegistryNode node : Registry.getInstance().getNodes()) {
                if (!node.getExpand()) continue;
                this.componentsTree.expandPath(node.getTreePath());
            }
            if (UIManager.getLookAndFeel().getID().equals("GTK")) {
                this.descriptionPane.setOpaque(true);
            }
        }

        private void updateDescription() {
            TreePath path = this.componentsTree.getSelectionPath();
            if (path != null) {
                RegistryNode node = (RegistryNode)path.getLastPathComponent();
                this.descriptionPane.setText(node.getDescription());
            } else {
                this.descriptionPane.clearText();
            }
            this.descriptionPane.setCaretPosition(0);
        }

        private void updateSizes() {
            Registry registry = Registry.getInstance();
            long installationSize = 0L;
            long downloadSize = 0L;
            for (Product product : registry.getProductsToInstall()) {
                installationSize += product.getRequiredDiskSpace();
                downloadSize += product.getDownloadSize();
            }
            String template = this.panel.getProperty(ComponentsSelectionPanel.SIZES_LABEL_TEXT_NO_DOWNLOAD_PROPERTY);
            for (RegistryNode remoteNode : registry.getNodes(RegistryType.REMOTE)) {
                if (!remoteNode.isVisible()) continue;
                template = this.panel.getProperty(ComponentsSelectionPanel.SIZES_LABEL_TEXT_PROPERTY);
            }
            if (installationSize == 0L) {
                this.sizesLabel.setText(StringUtils.format(template, this.panel.getProperty(ComponentsSelectionPanel.DEFAULT_INSTALLATION_SIZE_PROPERTY), this.panel.getProperty(ComponentsSelectionPanel.DEFAULT_DOWNLOAD_SIZE_PROPERTY)));
            } else {
                this.sizesLabel.setText(StringUtils.format(template, StringUtils.formatSize(installationSize), StringUtils.formatSize(downloadSize)));
            }
        }
    }

    public static class ComponentsSelectionPanelUi
    extends ErrorMessagePanel.ErrorMessagePanelUi {
        private ComponentsSelectionPanel panel;

        public ComponentsSelectionPanelUi(ComponentsSelectionPanel panel) {
            super(panel);
            this.panel = panel;
        }

        @Override
        public SwingUi getSwingUi(SwingContainer container) {
            if (this.swingUi == null) {
                this.swingUi = new ComponentsSelectionPanelSwingUi(this.panel, container);
            }
            return super.getSwingUi(container);
        }
    }
}

