/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.wizards;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.spring.api.SpringUtilities;
import org.openide.awt.Mnemonics;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public final class SpringXMLConfigNamespacesVisual
extends JPanel {
    private Library springLibrary;
    private ClassPath classPath;
    private boolean addSpringToClassPath;
    private JButton addSpringButton;
    private JComboBox cbSpringVersion;
    private JScrollPane includesScrollPane;
    private JTable includesTable;
    private JLabel springNotOnClassPathLabel;
    private boolean libsInitialized = false;
    private List<Library> springLibs = new ArrayList<Library>();
    private Set<String> usedPrefixes = new HashSet<String>();

    public SpringXMLConfigNamespacesVisual() {
        this.initComponents();
        this.includesTable.getParent().setBackground(this.includesTable.getBackground());
        TableColumn col1 = this.includesTable.getColumnModel().getColumn(0);
        col1.setMaxWidth(0);
        this.includesTable.getSelectionModel().setSelectionMode(0);
        this.includesTable.revalidate();
    }

    @Override
    public String getName() {
        return NbBundle.getMessage(SpringXMLConfigNamespacesVisual.class, (String)"LBL_Namespaces_Include_Step");
    }

    public void setClassPath(ClassPath classPath) {
        this.classPath = classPath;
        this.updateClassPathWarning();
    }

    private void updateClassPathWarning() {
        boolean alreadyAdded = this.classPath != null && SpringUtilities.containsSpring(this.classPath);
        boolean needToAdd = !alreadyAdded && !this.addSpringToClassPath;
        this.springNotOnClassPathLabel.setVisible(needToAdd);
        this.addSpringButton.setVisible(needToAdd);
        this.cbSpringVersion.setVisible(needToAdd);
        if (needToAdd) {
            this.initLibraries();
        }
    }

    private void initComponents() {
        this.includesScrollPane = new JScrollPane();
        this.includesTable = new JTable();
        this.addSpringButton = new JButton();
        this.springNotOnClassPathLabel = new JLabel();
        this.cbSpringVersion = new JComboBox();
        this.includesTable.setModel(new DefaultTableModel(new Object[][]{{null, "aop - http://www.springframework.org/schema/aop"}, {null, "c - http://www.springframework.org/schema/c"}, {null, "context - http://www.springframework.org/schema/context"}, {null, "flow - http://www.springframework.org/schema/webflow-config"}, {null, "jee - http://www.springframework.org/schema/jee"}, {null, "jms - http://www.springframework.org/schema/jms"}, {null, "lang - http://www.springframework.org/schema/lang"}, {null, "osgi - http://www.springframework.org/schema/osgi"}, {null, "p - http://www.springframework.org/schema/p"}, {null, "tx - http://www.springframework.org/schema/tx"}, {null, "util - http://www.springframework.org/schema/util"}}, new String[]{"", ""}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Boolean.class, String.class};
                this.canEdit = new boolean[]{true, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.includesTable.setShowHorizontalLines(false);
        this.includesTable.setShowVerticalLines(false);
        this.includesTable.setShowGrid(false);
        this.includesTable.setDragEnabled(false);
        this.includesTable.setIntercellSpacing(new Dimension(0, 0));
        this.includesScrollPane.setViewportView(this.includesTable);
        Mnemonics.setLocalizedText((AbstractButton)this.addSpringButton, (String)NbBundle.getMessage(SpringXMLConfigNamespacesVisual.class, (String)"LBL_AddSpringFramework"));
        this.addSpringButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpringXMLConfigNamespacesVisual.this.addSpringButtonActionPerformed(evt);
            }
        });
        this.springNotOnClassPathLabel.setIcon(new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/spring/beans/resources/warning.gif")));
        Mnemonics.setLocalizedText((JLabel)this.springNotOnClassPathLabel, (String)NbBundle.getMessage(SpringXMLConfigNamespacesVisual.class, (String)"LBL_SpringNotOnClassPath"));
        this.cbSpringVersion.setModel(new DefaultComboBoxModel<String>(new String[]{"No Library found"}));
        this.cbSpringVersion.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpringXMLConfigNamespacesVisual.this.cbSpringVersionActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.includesScrollPane, -1, 513, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.addSpringButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbSpringVersion, -2, -1, -2)).addComponent(this.springNotOnClassPathLabel)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.includesScrollPane, -2, 196, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 36, Short.MAX_VALUE).addComponent(this.springNotOnClassPathLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.addSpringButton).addComponent(this.cbSpringVersion, -2, -1, -2))));
    }

    private void addSpringButtonActionPerformed(ActionEvent evt) {
        this.addSpringToClassPath = true;
        this.updateClassPathWarning();
    }

    private void cbSpringVersionActionPerformed(ActionEvent evt) {
        this.springLibrary = this.springLibs.get(this.cbSpringVersion.getSelectedIndex());
    }

    public String[] getIncludedNamespaces() {
        ArrayList<String> incs = new ArrayList<String>();
        TableModel model = this.includesTable.getModel();
        for (int i = 0; i < model.getRowCount(); ++i) {
            Boolean selected = (Boolean)model.getValueAt(i, 0);
            if (selected == null || selected != Boolean.TRUE) continue;
            String namespace = (String)model.getValueAt(i, 1);
            incs.add(namespace);
        }
        return incs.toArray(new String[0]);
    }

    public boolean getAddSpringToClassPath() {
        return this.addSpringToClassPath;
    }

    public Library getSpringLibrary() {
        return this.springLibrary;
    }

    private String generatePrefix(String namespace) {
        String prefix = namespace.substring(namespace.lastIndexOf("/") + 1).toLowerCase();
        int i = 1;
        String newPrefix = prefix;
        while (this.usedPrefixes.contains(newPrefix)) {
            newPrefix = prefix + i++;
        }
        this.usedPrefixes.add(newPrefix);
        return newPrefix;
    }

    private void initLibraries() {
        if (!this.libsInitialized) {
            Vector<String> items = new Vector<String>();
            this.springLibs.clear();
            for (Library library : SpringUtilities.getJavaLibraries()) {
                if (!SpringUtilities.isSpringLibrary(library)) continue;
                items.add(library.getDisplayName());
                this.springLibs.add(library);
            }
            this.cbSpringVersion.setModel(new DefaultComboBoxModel(items));
            this.springLibrary = this.springLibs.get(this.cbSpringVersion.getSelectedIndex());
            this.libsInitialized = true;
            this.repaint();
        }
    }
}

