/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.dependency.graph.traversal;

import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.apache.maven.shared.dependency.graph.filter.DependencyNodeFilter;
import org.apache.maven.shared.dependency.graph.traversal.DependencyNodeVisitor;

public class FilteringDependencyNodeVisitor
implements DependencyNodeVisitor {
    private final DependencyNodeVisitor visitor;
    private final DependencyNodeFilter filter;

    public FilteringDependencyNodeVisitor(DependencyNodeVisitor visitor, DependencyNodeFilter filter) {
        this.visitor = visitor;
        this.filter = filter;
    }

    public boolean visit(DependencyNode node) {
        boolean visit = this.filter.accept(node) ? this.visitor.visit(node) : true;
        return visit;
    }

    public boolean endVisit(DependencyNode node) {
        boolean visit = this.filter.accept(node) ? this.visitor.endVisit(node) : true;
        return visit;
    }

    public DependencyNodeVisitor getDependencyNodeVisitor() {
        return this.visitor;
    }

    public DependencyNodeFilter getDependencyNodeFilter() {
        return this.filter;
    }
}

