/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.config.ir.compiler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.logstash.config.ir.compiler.MethodLevelSyntaxElement;
import org.logstash.config.ir.compiler.SyntaxElement;
import org.logstash.config.ir.compiler.SyntaxFactory;

final class Closure
implements MethodLevelSyntaxElement {
    public static final Closure EMPTY = new Closure(Collections.emptyList());
    private final List<MethodLevelSyntaxElement> statements;

    public static Closure wrap(MethodLevelSyntaxElement ... statements) {
        Closure closure = new Closure();
        for (MethodLevelSyntaxElement statement : statements) {
            if (statement instanceof Closure) {
                closure.add((Closure)statement);
                continue;
            }
            closure.add(statement);
        }
        return closure;
    }

    Closure() {
        this(new ArrayList<MethodLevelSyntaxElement>());
    }

    private Closure(List<MethodLevelSyntaxElement> statements) {
        this.statements = statements;
    }

    public Closure add(Closure statement) {
        this.statements.addAll(statement.statements);
        return this;
    }

    public Closure add(MethodLevelSyntaxElement statement) {
        this.statements.add(statement);
        return this;
    }

    public boolean empty() {
        return this.statements.isEmpty();
    }

    @Override
    public String generateCode() {
        return this.statements.isEmpty() ? "" : SyntaxFactory.join(this.statements.stream().map(SyntaxElement::generateCode).collect(Collectors.joining(";\n")), ";");
    }
}

