/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.crypto.impl.TlsAEADCipherImpl;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;

public class JceChaCha20Poly1305
implements TlsAEADCipherImpl {
    private static final byte[] ZEROES = new byte[15];
    protected final Cipher cipher;
    protected final Mac mac;
    protected final int cipherMode;
    protected SecretKey cipherKey;
    protected byte[] additionalData;

    public JceChaCha20Poly1305(JcaJceHelper jcaJceHelper, boolean bl) throws GeneralSecurityException {
        this.cipher = jcaJceHelper.createCipher("ChaCha7539");
        this.mac = jcaJceHelper.createMac("Poly1305");
        this.cipherMode = bl ? 1 : 2;
    }

    public int doFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws IOException {
        try {
            if (this.cipherMode == 1) {
                int n4 = n2;
                byte[] byArray3 = new byte[64 + n4];
                System.arraycopy(byArray, n, byArray3, 64, n4);
                if (byArray3.length != this.cipher.doFinal(byArray3, 0, byArray3.length, byArray3, 0)) {
                    throw new IllegalStateException();
                }
                System.arraycopy(byArray3, 64, byArray2, n3, n4);
                this.initMAC(byArray3);
                this.updateMAC(this.additionalData, 0, this.additionalData.length);
                this.updateMAC(byArray3, 64, n4);
                byte[] byArray4 = new byte[16];
                Pack.longToLittleEndian((long)((long)this.additionalData.length & 0xFFFFFFFFL), (byte[])byArray4, (int)0);
                Pack.longToLittleEndian((long)((long)n4 & 0xFFFFFFFFL), (byte[])byArray4, (int)8);
                this.mac.update(byArray4, 0, 16);
                this.mac.doFinal(byArray2, n3 + n4);
                return n4 + 16;
            }
            int n5 = n2 - 16;
            byte[] byArray5 = new byte[64 + n5];
            System.arraycopy(byArray, n, byArray5, 64, n5);
            if (byArray5.length != this.cipher.doFinal(byArray5, 0, byArray5.length, byArray5, 0)) {
                throw new IllegalStateException();
            }
            this.initMAC(byArray5);
            this.updateMAC(this.additionalData, 0, this.additionalData.length);
            this.updateMAC(byArray, n, n5);
            byte[] byArray6 = new byte[16];
            Pack.longToLittleEndian((long)((long)this.additionalData.length & 0xFFFFFFFFL), (byte[])byArray6, (int)0);
            Pack.longToLittleEndian((long)((long)n5 & 0xFFFFFFFFL), (byte[])byArray6, (int)8);
            this.mac.update(byArray6, 0, 16);
            this.mac.doFinal(byArray6, 0);
            byte[] byArray7 = Arrays.copyOfRange((byte[])byArray, (int)(n + n5), (int)(n + n2));
            if (!Arrays.constantTimeAreEqual((byte[])byArray6, (byte[])byArray7)) {
                throw new TlsFatalAlert(20);
            }
            System.arraycopy(byArray5, 64, byArray2, n3, n5);
            return n5;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new RuntimeException(generalSecurityException);
        }
    }

    public int getOutputSize(int n) {
        return this.cipherMode == 1 ? n + 16 : n - 16;
    }

    public void init(byte[] byArray, int n, byte[] byArray2) throws IOException {
        if (byArray == null || byArray.length != 12 || n != 16) {
            throw new TlsFatalAlert(80);
        }
        try {
            this.cipher.init(this.cipherMode, (Key)this.cipherKey, new IvParameterSpec(byArray));
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new RuntimeException(generalSecurityException);
        }
        this.additionalData = byArray2;
    }

    public void setKey(byte[] byArray, int n, int n2) throws IOException {
        this.cipherKey = new SecretKeySpec(byArray, n, n2, "ChaCha7539");
    }

    protected void initMAC(byte[] byArray) throws InvalidKeyException {
        this.mac.init(new SecretKeySpec(byArray, 0, 32, "Poly1305"));
        for (int i = 0; i < 64; ++i) {
            byArray[i] = 0;
        }
    }

    protected void updateMAC(byte[] byArray, int n, int n2) {
        this.mac.update(byArray, n, n2);
        int n3 = n2 % 16;
        if (n3 != 0) {
            this.mac.update(ZEROES, 0, 16 - n3);
        }
    }
}

