/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tools;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.languagetool.FakeLanguage;
import org.languagetool.Language;
import org.languagetool.TestTools;
import org.languagetool.rules.Category;
import org.languagetool.rules.CategoryId;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.PatternRule;
import org.languagetool.rules.patterns.PatternToken;
import org.languagetool.tools.RuleMatchAsXmlSerializer;
import org.languagetool.tools.StringTools;
import org.languagetool.tools.Tools;

public class RuleMatchAsXmlSerializerTest {
    private static final RuleMatchAsXmlSerializer SERIALIZER = new RuleMatchAsXmlSerializer();
    private static final Language LANG = TestTools.getDemoLanguage();

    @Test
    public void testLanguageAttributes() throws IOException {
        String xml1 = SERIALIZER.ruleMatchesToXml(Collections.emptyList(), "Fake", 5, StringTools.ApiPrintMode.NORMAL_API, LANG, Collections.emptyList());
        Assert.assertTrue((boolean)xml1.contains("shortname=\"xx-XX\""));
        Assert.assertTrue((boolean)xml1.contains("name=\"Testlanguage\""));
        String xml2 = SERIALIZER.ruleMatchesToXml(Collections.emptyList(), "Fake", 5, LANG, (Language)new FakeLanguage());
        Assert.assertTrue((boolean)xml2.contains("shortname=\"xx-XX\""));
        Assert.assertTrue((boolean)xml2.contains("name=\"Testlanguage\""));
        Assert.assertTrue((boolean)xml2.contains("shortname=\"yy\""));
        Assert.assertTrue((boolean)xml2.contains("name=\"FakeLanguage\""));
        Assert.assertThat((Object)StringUtils.countMatches((CharSequence)xml2, (CharSequence)"<matches"), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)StringUtils.countMatches((CharSequence)xml2, (CharSequence)"</matches>"), (Matcher)Is.is((Object)1));
    }

    @Test
    public void testApiModes() throws IOException {
        String xmlStart = SERIALIZER.ruleMatchesToXml(Collections.emptyList(), "Fake", 5, StringTools.ApiPrintMode.START_API, LANG, Collections.emptyList());
        Assert.assertThat((Object)StringUtils.countMatches((CharSequence)xmlStart, (CharSequence)"<matches"), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)StringUtils.countMatches((CharSequence)xmlStart, (CharSequence)"</matches>"), (Matcher)Is.is((Object)0));
        String xmlMiddle = SERIALIZER.ruleMatchesToXml(Collections.emptyList(), "Fake", 5, StringTools.ApiPrintMode.CONTINUE_API, LANG, Collections.emptyList());
        Assert.assertThat((Object)StringUtils.countMatches((CharSequence)xmlMiddle, (CharSequence)"<matches"), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)StringUtils.countMatches((CharSequence)xmlMiddle, (CharSequence)"</matches>"), (Matcher)Is.is((Object)0));
        String xmlEnd = SERIALIZER.ruleMatchesToXml(Collections.emptyList(), "Fake", 5, StringTools.ApiPrintMode.END_API, LANG, Collections.emptyList());
        Assert.assertThat((Object)StringUtils.countMatches((CharSequence)xmlEnd, (CharSequence)"<matches"), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)StringUtils.countMatches((CharSequence)xmlEnd, (CharSequence)"</matches>"), (Matcher)Is.is((Object)1));
        String xml = SERIALIZER.ruleMatchesToXml(Collections.emptyList(), "Fake", 5, StringTools.ApiPrintMode.NORMAL_API, LANG, Collections.emptyList());
        Assert.assertThat((Object)StringUtils.countMatches((CharSequence)xml, (CharSequence)"<matches"), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)StringUtils.countMatches((CharSequence)xml, (CharSequence)"</matches>"), (Matcher)Is.is((Object)1));
    }

    @Test
    public void testRuleMatchesToXML() throws IOException {
        ArrayList<RuleMatch> matches = new ArrayList<RuleMatch>();
        String text = "This is an test sentence. Here's another sentence with more text.";
        FakeRule rule = new FakeRule();
        RuleMatch match = new RuleMatch((Rule)rule, null, 8, 10, "myMessage");
        match.setColumn(99);
        match.setEndColumn(100);
        match.setLine(44);
        match.setEndLine(45);
        matches.add(match);
        String xml = SERIALIZER.ruleMatchesToXml(matches, text, 5, StringTools.ApiPrintMode.NORMAL_API, LANG, Collections.emptyList());
        Assert.assertTrue((boolean)xml.startsWith("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"));
        Pattern matchesPattern = Pattern.compile(".*<matches software=\"LanguageTool\" version=\"4.4\" buildDate=\".*?\">.*", 32);
        java.util.regex.Matcher matcher = matchesPattern.matcher(xml);
        Assert.assertTrue((String)("Did not find expected '<matches>' element ('" + matchesPattern + "'), got:\n" + xml), (boolean)matcher.matches());
        Assert.assertTrue((boolean)xml.contains(">\n<error fromy=\"44\" fromx=\"98\" toy=\"45\" tox=\"99\" ruleId=\"FAKE_ID\" msg=\"myMessage\" replacements=\"\" context=\"...s is an test...\" contextoffset=\"8\" offset=\"8\" errorlength=\"2\" category=\"Miscellaneous\" categoryid=\"MISC\" locqualityissuetype=\"misspelling\"/>\n</matches>\n"));
    }

    @Test
    public void testRuleMatchesToXMLWithCategory() throws IOException {
        ArrayList<RuleMatch> matches = new ArrayList<RuleMatch>();
        String text = "This is a test sentence.";
        List patternTokens = Collections.emptyList();
        PatternRule patternRule = new PatternRule("MY_ID", LANG, patternTokens, "my description", "my message", "short message");
        patternRule.setCategory(new Category(new CategoryId("TEST_ID"), "MyCategory"));
        RuleMatch match = new RuleMatch((Rule)patternRule, null, 8, 10, "myMessage");
        match.setColumn(99);
        match.setEndColumn(100);
        match.setLine(44);
        match.setEndLine(45);
        matches.add(match);
        String xml = SERIALIZER.ruleMatchesToXml(matches, text, 5, LANG, LANG);
        Assert.assertTrue((boolean)xml.contains(">\n<error fromy=\"44\" fromx=\"98\" toy=\"45\" tox=\"99\" ruleId=\"MY_ID\" msg=\"myMessage\" replacements=\"\" context=\"...s is a test ...\" contextoffset=\"8\" offset=\"8\" errorlength=\"2\" category=\"MyCategory\" categoryid=\"TEST_ID\" locqualityissuetype=\"uncategorized\"/>\n</matches>\n"));
        patternRule.setCategory(new Category(new CategoryId("CAT_ID"), "MyCategory"));
        RuleMatch match2 = new RuleMatch((Rule)patternRule, null, 8, 10, "myMessage");
        String xml2 = SERIALIZER.ruleMatchesToXml(Collections.singletonList(match2), text, 5, LANG, LANG);
        Assert.assertTrue((boolean)xml2.contains("category=\"MyCategory\""));
        Assert.assertTrue((boolean)xml2.contains("categoryid=\"CAT_ID\""));
    }

    @Test
    public void testRuleMatchesWithShortMessage() throws IOException {
        ArrayList<RuleMatch> matches = new ArrayList<RuleMatch>();
        String text = "This is a test sentence.";
        RuleMatch match = new RuleMatch((Rule)new FakeRule(), null, 8, 10, "myMessage", "short message");
        matches.add(match);
        String xml = SERIALIZER.ruleMatchesToXml(matches, text, 5, LANG, null);
        Assert.assertTrue((boolean)xml.contains("shortmsg=\"short message\""));
    }

    @Test
    public void testRuleMatchesWithUrlToXML() throws IOException {
        ArrayList<RuleMatch> matches = new ArrayList<RuleMatch>();
        String text = "This is an test sentence. Here's another sentence with more text.";
        RuleMatch match = new RuleMatch((Rule)new FakeRule(){

            public URL getUrl() {
                return Tools.getUrl((String)"http://server.org?id=1&foo=bar");
            }
        }, null, 8, 10, "myMessage");
        match.setColumn(99);
        match.setEndColumn(100);
        match.setLine(44);
        match.setEndLine(45);
        matches.add(match);
        String xml = SERIALIZER.ruleMatchesToXml(matches, text, 5, StringTools.ApiPrintMode.NORMAL_API, LANG, Collections.emptyList());
        Assert.assertTrue((boolean)xml.contains(">\n<error fromy=\"44\" fromx=\"98\" toy=\"45\" tox=\"99\" ruleId=\"FAKE_ID\" msg=\"myMessage\" replacements=\"\" context=\"...s is an test...\" contextoffset=\"8\" offset=\"8\" errorlength=\"2\" url=\"http://server.org?id=1&amp;foo=bar\" category=\"Miscellaneous\" categoryid=\"MISC\" locqualityissuetype=\"misspelling\"/>\n</matches>\n"));
    }

    @Test
    public void testRuleMatchesToXMLEscapeBug() throws IOException {
        ArrayList<RuleMatch> matches = new ArrayList<RuleMatch>();
        String text = "This is \"an test sentence. Here's another sentence with more text.";
        RuleMatch match = new RuleMatch((Rule)new FakeRule(), null, 9, 11, "myMessage");
        match.setColumn(99);
        match.setEndColumn(100);
        match.setLine(44);
        match.setEndLine(45);
        matches.add(match);
        String xml = SERIALIZER.ruleMatchesToXml(matches, text, 5, StringTools.ApiPrintMode.NORMAL_API, LANG, Collections.emptyList());
        Assert.assertTrue((boolean)xml.contains(">\n<error fromy=\"44\" fromx=\"98\" toy=\"45\" tox=\"99\" ruleId=\"FAKE_ID\" msg=\"myMessage\" replacements=\"\" context=\"... is &quot;an test...\" contextoffset=\"8\" offset=\"9\" errorlength=\"2\" category=\"Miscellaneous\" categoryid=\"MISC\" locqualityissuetype=\"misspelling\"/>\n</matches>\n"));
    }

    private static class FakeRule
    extends PatternRule {
        FakeRule() {
            super("FAKE_ID", TestTools.getDemoLanguage(), Collections.singletonList(new PatternToken("foo", true, false, false)), "My fake description", "Fake message", "Fake short message");
        }

        public ITSIssueType getLocQualityIssueType() {
            return ITSIssueType.Misspelling;
        }
    }
}

