/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.gui;

import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.LinguServices;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.Rule;

public class Configuration {
    static final int DEFAULT_SERVER_PORT = 8081;
    static final int DEFAULT_NUM_CHECK_PARAS = 5;
    static final int FONT_STYLE_INVALID = -1;
    static final int FONT_SIZE_INVALID = -1;
    static final Color STYLE_COLOR = new Color(0, 175, 0);
    private static final String CONFIG_FILE = ".languagetool.cfg";
    private static final String DISABLED_RULES_KEY = "disabledRules";
    private static final String ENABLED_RULES_KEY = "enabledRules";
    private static final String DISABLED_CATEGORIES_KEY = "disabledCategories";
    private static final String ENABLED_CATEGORIES_KEY = "enabledCategories";
    private static final String ENABLED_RULES_ONLY_KEY = "enabledRulesOnly";
    private static final String LANGUAGE_KEY = "language";
    private static final String MOTHER_TONGUE_KEY = "motherTongue";
    private static final String NGRAM_DIR_KEY = "ngramDir";
    private static final String WORD2VEC_DIR_KEY = "word2vecDir";
    private static final String AUTO_DETECT_KEY = "autoDetect";
    private static final String TAGGER_SHOWS_DISAMBIG_LOG_KEY = "taggerShowsDisambigLog";
    private static final String SERVER_RUN_KEY = "serverMode";
    private static final String SERVER_PORT_KEY = "serverPort";
    private static final String PARA_CHECK_KEY = "numberParagraphs";
    private static final String RESET_CHECK_KEY = "doResetCheck";
    private static final String USE_GUI_KEY = "useGUIConfig";
    private static final String FONT_NAME_KEY = "font.name";
    private static final String FONT_STYLE_KEY = "font.style";
    private static final String FONT_SIZE_KEY = "font.size";
    private static final String LF_NAME_KEY = "lookAndFeelName";
    private static final String ERROR_COLORS_KEY = "errorColors";
    private static final String UNDERLINE_COLORS_KEY = "underlineColors";
    private static final String CONFIGURABLE_RULE_VALUES_KEY = "configurableRuleValues";
    private static final String LT_SWITCHED_OFF_KEY = "ltSwitchedOff";
    private static final String DELIMITER = ",";
    private static final String COLOR_SPLITTER_REGEXP = "(?<=:#[0-9A-Fa-f]{6}),\\s*";
    private static final String COLOR_SPLITTER_REGEXP_COLON = ":(?=#[0-9A-Fa-f]{6})";
    private static final String CONFIGURABLE_RULE_SPLITTER_REGEXP = "(?<=[0-9]),\\s*";
    private static final String EXTERNAL_RULE_DIRECTORY = "extRulesDirectory";
    private final Map<String, String> configForOtherLanguages = new HashMap<String, String>();
    private final Map<ITSIssueType, Color> errorColors = new HashMap<ITSIssueType, Color>();
    private final Map<String, Color> underlineColors = new HashMap<String, Color>();
    private final Map<String, Integer> configurableRuleValues = new HashMap<String, Integer>();
    private final Set<String> styleLikeCategories = new HashSet<String>();
    private final Map<String, String> specialTabCategories = new HashMap<String, String>();
    private File configFile;
    private Set<String> disabledRuleIds = new HashSet<String>();
    private Set<String> enabledRuleIds = new HashSet<String>();
    private Set<String> disabledCategoryNames = new HashSet<String>();
    private Set<String> enabledCategoryNames = new HashSet<String>();
    private boolean enabledRulesOnly = false;
    private Language language;
    private Language motherTongue;
    private File ngramDirectory;
    private File word2vecDirectory;
    private boolean runServer;
    private boolean autoDetect;
    private boolean taggerShowsDisambigLog;
    private boolean guiConfig;
    private String fontName;
    private int fontStyle = -1;
    private int fontSize = -1;
    private int serverPort = 8081;
    private int numParasToCheck = 5;
    private boolean doResetCheck = false;
    private String externalRuleDirectory;
    private String lookAndFeelName;
    private boolean switchOff = false;

    public Configuration(Language lang) throws IOException {
        this(new File(System.getProperty("user.home")), CONFIG_FILE, lang);
    }

    public Configuration(File baseDir, Language lang) throws IOException {
        this(baseDir, CONFIG_FILE, lang);
    }

    public Configuration(File baseDir, String filename, Language lang) throws IOException {
        this(baseDir, filename, lang, null);
    }

    public Configuration(File baseDir, String filename, Language lang, LinguServices linguServices) throws IOException {
        if (baseDir == null || !baseDir.isDirectory()) {
            throw new IllegalArgumentException("Cannot open file " + filename + " in directory " + baseDir);
        }
        this.configFile = new File(baseDir, filename);
        this.loadConfiguration(lang);
    }

    private Configuration() {
    }

    Configuration copy(Configuration configuration) {
        Configuration copy = new Configuration();
        copy.restoreState(configuration);
        return copy;
    }

    void restoreState(Configuration configuration) {
        this.configFile = configuration.configFile;
        this.language = configuration.language;
        this.motherTongue = configuration.motherTongue;
        this.ngramDirectory = configuration.ngramDirectory;
        this.word2vecDirectory = configuration.word2vecDirectory;
        this.runServer = configuration.runServer;
        this.autoDetect = configuration.autoDetect;
        this.taggerShowsDisambigLog = configuration.taggerShowsDisambigLog;
        this.guiConfig = configuration.guiConfig;
        this.fontName = configuration.fontName;
        this.fontStyle = configuration.fontStyle;
        this.fontSize = configuration.fontSize;
        this.serverPort = configuration.serverPort;
        this.numParasToCheck = configuration.numParasToCheck;
        this.doResetCheck = configuration.doResetCheck;
        this.lookAndFeelName = configuration.lookAndFeelName;
        this.externalRuleDirectory = configuration.externalRuleDirectory;
        this.disabledRuleIds.clear();
        this.disabledRuleIds.addAll(configuration.disabledRuleIds);
        this.enabledRuleIds.clear();
        this.enabledRuleIds.addAll(configuration.enabledRuleIds);
        this.disabledCategoryNames.clear();
        this.disabledCategoryNames.addAll(configuration.disabledCategoryNames);
        this.enabledCategoryNames.clear();
        this.enabledCategoryNames.addAll(configuration.enabledCategoryNames);
        this.configForOtherLanguages.clear();
        for (String string : configuration.configForOtherLanguages.keySet()) {
            this.configForOtherLanguages.put(string, configuration.configForOtherLanguages.get(string));
        }
        this.underlineColors.clear();
        for (Map.Entry entry : configuration.underlineColors.entrySet()) {
            this.underlineColors.put((String)entry.getKey(), (Color)entry.getValue());
        }
        this.configurableRuleValues.clear();
        for (Map.Entry entry : configuration.configurableRuleValues.entrySet()) {
            this.configurableRuleValues.put((String)entry.getKey(), (Integer)entry.getValue());
        }
        this.styleLikeCategories.clear();
        this.styleLikeCategories.addAll(configuration.styleLikeCategories);
        this.specialTabCategories.clear();
        for (Map.Entry entry : configuration.specialTabCategories.entrySet()) {
            this.specialTabCategories.put((String)entry.getKey(), (String)entry.getValue());
        }
    }

    public Set<String> getDisabledRuleIds() {
        return this.disabledRuleIds;
    }

    public Set<String> getEnabledRuleIds() {
        return this.enabledRuleIds;
    }

    public Set<String> getDisabledCategoryNames() {
        return this.disabledCategoryNames;
    }

    public Set<String> getEnabledCategoryNames() {
        return this.enabledCategoryNames;
    }

    public void setDisabledRuleIds(Set<String> ruleIds) {
        this.disabledRuleIds = ruleIds;
        this.enabledRuleIds.removeAll(ruleIds);
    }

    public void setEnabledRuleIds(Set<String> ruleIds) {
        this.enabledRuleIds = ruleIds;
    }

    public void setDisabledCategoryNames(Set<String> categoryNames) {
        this.disabledCategoryNames = categoryNames;
    }

    public void setEnabledCategoryNames(Set<String> categoryNames) {
        this.enabledCategoryNames = categoryNames;
    }

    public boolean getEnabledRulesOnly() {
        return this.enabledRulesOnly;
    }

    public Language getLanguage() {
        return this.language;
    }

    public void setLanguage(Language language) {
        this.language = language;
    }

    public Language getMotherTongue() {
        return this.motherTongue;
    }

    public void setMotherTongue(Language motherTongue) {
        this.motherTongue = motherTongue;
    }

    public boolean getAutoDetect() {
        return this.autoDetect;
    }

    public void setAutoDetect(boolean autoDetect) {
        this.autoDetect = autoDetect;
    }

    public boolean getTaggerShowsDisambigLog() {
        return this.taggerShowsDisambigLog;
    }

    public void setTaggerShowsDisambigLog(boolean taggerShowsDisambigLog) {
        this.taggerShowsDisambigLog = taggerShowsDisambigLog;
    }

    public boolean getRunServer() {
        return this.runServer;
    }

    public void setRunServer(boolean runServer) {
        this.runServer = runServer;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public void setUseGUIConfig(boolean useGUIConfig) {
        this.guiConfig = useGUIConfig;
    }

    public boolean getUseGUIConfig() {
        return this.guiConfig;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    public String getExternalRuleDirectory() {
        return this.externalRuleDirectory;
    }

    public void setExternalRuleDirectory(String path) {
        this.externalRuleDirectory = path;
    }

    public int getNumParasToCheck() {
        return this.numParasToCheck;
    }

    public void setNumParasToCheck(int numParas) {
        this.numParasToCheck = numParas;
    }

    public boolean isResetCheck() {
        return this.doResetCheck;
    }

    public void setDoResetCheck(boolean resetCheck) {
        this.doResetCheck = resetCheck;
    }

    public String getFontName() {
        return this.fontName;
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
    }

    public int getFontStyle() {
        return this.fontStyle;
    }

    public void setFontStyle(int fontStyle) {
        this.fontStyle = fontStyle;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
    }

    public String getLookAndFeelName() {
        return this.lookAndFeelName;
    }

    public void setLookAndFeelName(String lookAndFeelName) {
        this.lookAndFeelName = lookAndFeelName;
    }

    @Nullable
    public File getNgramDirectory() {
        return this.ngramDirectory;
    }

    public void setNgramDirectory(File dir) {
        this.ngramDirectory = dir;
    }

    @Nullable
    public File getWord2VecDirectory() {
        return this.word2vecDirectory;
    }

    public void setWord2VecDirectory(File dir) {
        this.word2vecDirectory = dir;
    }

    public Map<ITSIssueType, Color> getErrorColors() {
        return this.errorColors;
    }

    public boolean isStyleCategory(String category) {
        return this.styleLikeCategories.contains(category);
    }

    public void initStyleCategories(List<Rule> allRules) {
        for (Rule rule : allRules) {
            if (rule.getCategory().getTabName() != null && !this.specialTabCategories.containsKey(rule.getCategory().getName())) {
                this.specialTabCategories.put(rule.getCategory().getName(), rule.getCategory().getTabName());
            }
            if (!rule.getLocQualityIssueType().toString().equalsIgnoreCase("STYLE") && !rule.getLocQualityIssueType().toString().equalsIgnoreCase("REGISTER") && !rule.getCategory().getId().toString().equals("STYLE") && !rule.getCategory().getId().toString().equals("TYPOGRAPHY") || this.styleLikeCategories.contains(rule.getCategory().getName())) continue;
            this.styleLikeCategories.add(rule.getCategory().getName());
        }
    }

    public boolean isSpecialTabCategory(String category) {
        return this.specialTabCategories.containsKey(category);
    }

    public boolean isInSpecialTab(String category, String tabName) {
        if (this.specialTabCategories.containsKey(category)) {
            return this.specialTabCategories.get(category).equals(tabName);
        }
        return false;
    }

    public String[] getSpecialTabNames() {
        HashSet<String> tabNames = new HashSet<String>();
        for (Map.Entry<String, String> entry : this.specialTabCategories.entrySet()) {
            if (tabNames.contains(entry.getValue())) continue;
            tabNames.add(entry.getValue());
        }
        return tabNames.toArray(new String[tabNames.size()]);
    }

    public Set<String> getSpecialTabCategories(String tabName) {
        HashSet<String> tabCategories = new HashSet<String>();
        for (Map.Entry<String, String> entry : this.specialTabCategories.entrySet()) {
            if (!entry.getKey().equals(tabName)) continue;
            tabCategories.add(entry.getKey());
        }
        return tabCategories;
    }

    public Map<String, Color> getUnderlineColors() {
        return this.underlineColors;
    }

    public Color getUnderlineColor(String category) {
        if (this.underlineColors.containsKey(category)) {
            return this.underlineColors.get(category);
        }
        if (this.styleLikeCategories.contains(category)) {
            return STYLE_COLOR;
        }
        return Color.blue;
    }

    public void setUnderlineColor(String category, Color col) {
        this.underlineColors.put(category, col);
    }

    public void setDefaultUnderlineColor(String category) {
        this.underlineColors.remove(category);
    }

    public Map<String, Integer> getConfigurableValues() {
        return this.configurableRuleValues;
    }

    public int getConfigurableValue(String ruleID) {
        if (this.configurableRuleValues.containsKey(ruleID)) {
            return this.configurableRuleValues.get(ruleID);
        }
        return -1;
    }

    public void setConfigurableValue(String ruleID, int value) {
        this.configurableRuleValues.put(ruleID, value);
    }

    public boolean isSwitchedOff() {
        return this.switchOff;
    }

    public void setSwitchedOff(boolean switchOff, Language lang) throws IOException {
        this.switchOff = switchOff;
        this.saveConfiguration(lang);
    }

    private void loadConfiguration(Language lang) throws IOException {
        String qualifier = this.getQualifier(lang);
        try (FileInputStream fis = new FileInputStream(this.configFile);){
            String switchOffString;
            String resetCheckString;
            String paraCheckString;
            String extRules;
            String word2vecDir;
            String ngramDir;
            String motherTongueStr;
            Properties props = new Properties();
            props.load(fis);
            this.disabledRuleIds.addAll(this.getListFromProperties(props, DISABLED_RULES_KEY + qualifier));
            this.enabledRuleIds.addAll(this.getListFromProperties(props, ENABLED_RULES_KEY + qualifier));
            this.disabledCategoryNames.addAll(this.getListFromProperties(props, DISABLED_CATEGORIES_KEY + qualifier));
            this.enabledCategoryNames.addAll(this.getListFromProperties(props, ENABLED_CATEGORIES_KEY + qualifier));
            this.enabledRulesOnly = "true".equals(props.get(ENABLED_RULES_ONLY_KEY));
            String languageStr = (String)props.get(LANGUAGE_KEY);
            if (languageStr != null) {
                this.language = Languages.getLanguageForShortCode((String)languageStr);
            }
            if ((motherTongueStr = (String)props.get(MOTHER_TONGUE_KEY)) != null && !motherTongueStr.equals("xx")) {
                this.motherTongue = Languages.getLanguageForShortCode((String)motherTongueStr);
            }
            if ((ngramDir = (String)props.get(NGRAM_DIR_KEY)) != null) {
                this.ngramDirectory = new File(ngramDir);
            }
            if ((word2vecDir = (String)props.get(WORD2VEC_DIR_KEY)) != null) {
                this.word2vecDirectory = new File(word2vecDir);
            }
            this.autoDetect = "true".equals(props.get(AUTO_DETECT_KEY));
            this.taggerShowsDisambigLog = "true".equals(props.get(TAGGER_SHOWS_DISAMBIG_LOG_KEY));
            this.guiConfig = "true".equals(props.get(USE_GUI_KEY));
            this.runServer = "true".equals(props.get(SERVER_RUN_KEY));
            this.fontName = (String)props.get(FONT_NAME_KEY);
            if (props.get(FONT_STYLE_KEY) != null) {
                try {
                    this.fontStyle = Integer.parseInt((String)props.get(FONT_STYLE_KEY));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (props.get(FONT_SIZE_KEY) != null) {
                try {
                    this.fontSize = Integer.parseInt((String)props.get(FONT_SIZE_KEY));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            this.lookAndFeelName = (String)props.get(LF_NAME_KEY);
            String serverPortString = (String)props.get(SERVER_PORT_KEY);
            if (serverPortString != null) {
                this.serverPort = Integer.parseInt(serverPortString);
            }
            if ((extRules = (String)props.get(EXTERNAL_RULE_DIRECTORY)) != null) {
                this.externalRuleDirectory = extRules;
            }
            if ((paraCheckString = (String)props.get(PARA_CHECK_KEY)) != null) {
                this.numParasToCheck = Integer.parseInt(paraCheckString);
            }
            if ((resetCheckString = (String)props.get(RESET_CHECK_KEY)) != null) {
                this.doResetCheck = Boolean.parseBoolean(resetCheckString);
            }
            if ((switchOffString = (String)props.get(LT_SWITCHED_OFF_KEY)) != null) {
                this.switchOff = Boolean.parseBoolean(switchOffString);
            }
            String rulesValuesString = (String)props.get(CONFIGURABLE_RULE_VALUES_KEY);
            this.parseConfigurableRuleValues(rulesValuesString);
            String colorsString = (String)props.get(ERROR_COLORS_KEY);
            this.parseErrorColors(colorsString);
            String underlineColorsString = (String)props.get(UNDERLINE_COLORS_KEY);
            this.parseUnderlineColors(underlineColorsString);
            this.loadConfigForOtherLanguages(lang, props);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    private void parseErrorColors(String colorsString) {
        if (StringUtils.isNotEmpty((CharSequence)colorsString)) {
            String[] typeToColorList;
            for (String typeToColor : typeToColorList = colorsString.split(COLOR_SPLITTER_REGEXP)) {
                String[] typeAndColor = typeToColor.split(COLOR_SPLITTER_REGEXP_COLON);
                if (typeAndColor.length != 2) {
                    throw new RuntimeException("Could not parse type and color, colon expected: '" + typeToColor + "'");
                }
                ITSIssueType type = ITSIssueType.getIssueType((String)typeAndColor[0]);
                String hexColor = typeAndColor[1];
                this.errorColors.put(type, Color.decode(hexColor));
            }
        }
    }

    private void parseUnderlineColors(String colorsString) {
        if (StringUtils.isNotEmpty((CharSequence)colorsString)) {
            String[] typeToColorList;
            for (String typeToColor : typeToColorList = colorsString.split(COLOR_SPLITTER_REGEXP)) {
                String[] typeAndColor = typeToColor.split(COLOR_SPLITTER_REGEXP_COLON);
                if (typeAndColor.length != 2) {
                    throw new RuntimeException("Could not parse type and color, colon expected: '" + typeToColor + "'");
                }
                this.underlineColors.put(typeAndColor[0], Color.decode(typeAndColor[1]));
            }
        }
    }

    private void parseConfigurableRuleValues(String rulesValueString) {
        if (StringUtils.isNotEmpty((CharSequence)rulesValueString)) {
            String[] ruleToValueList;
            for (String ruleToValue : ruleToValueList = rulesValueString.split(CONFIGURABLE_RULE_SPLITTER_REGEXP)) {
                String[] ruleAndValue = ruleToValue.split(":");
                if (ruleAndValue.length != 2) {
                    throw new RuntimeException("Could not parse rule and value, colon expected: '" + ruleToValue + "'");
                }
                this.configurableRuleValues.put(ruleAndValue[0], Integer.parseInt(ruleAndValue[1]));
            }
        }
    }

    private String getQualifier(Language lang) {
        String qualifier = "";
        if (lang != null) {
            qualifier = "." + lang.getShortCodeWithCountryAndVariant();
        }
        return qualifier;
    }

    private void loadConfigForOtherLanguages(Language lang, Properties prop) {
        for (Language otherLang : Languages.get()) {
            if (otherLang.equals((Object)lang)) continue;
            String languageSuffix = "." + otherLang.getShortCodeWithCountryAndVariant();
            this.storeConfigKeyFromProp(prop, DISABLED_RULES_KEY + languageSuffix);
            this.storeConfigKeyFromProp(prop, ENABLED_RULES_KEY + languageSuffix);
            this.storeConfigKeyFromProp(prop, DISABLED_CATEGORIES_KEY + languageSuffix);
        }
    }

    private void storeConfigKeyFromProp(Properties prop, String key) {
        if (prop.containsKey(key)) {
            this.configForOtherLanguages.put(key, prop.getProperty(key));
        }
    }

    private Collection<? extends String> getListFromProperties(Properties props, String key) {
        String value = (String)props.get(key);
        ArrayList<String> list = new ArrayList<String>();
        if (value != null && !value.isEmpty()) {
            String[] names = value.split(DELIMITER);
            list.addAll(Arrays.asList(names));
        }
        return list;
    }

    public void saveConfiguration(Language lang) throws IOException {
        Properties props = new Properties();
        String qualifier = this.getQualifier(lang);
        this.addListToProperties(props, DISABLED_RULES_KEY + qualifier, this.disabledRuleIds);
        this.addListToProperties(props, ENABLED_RULES_KEY + qualifier, this.enabledRuleIds);
        this.addListToProperties(props, DISABLED_CATEGORIES_KEY + qualifier, this.disabledCategoryNames);
        this.addListToProperties(props, ENABLED_CATEGORIES_KEY + qualifier, this.enabledCategoryNames);
        if (this.language != null && !this.language.isExternal()) {
            props.setProperty(LANGUAGE_KEY, this.language.getShortCodeWithCountryAndVariant());
        }
        if (this.motherTongue != null) {
            props.setProperty(MOTHER_TONGUE_KEY, this.motherTongue.getShortCode());
        }
        if (this.ngramDirectory != null) {
            props.setProperty(NGRAM_DIR_KEY, this.ngramDirectory.getAbsolutePath());
        }
        if (this.word2vecDirectory != null) {
            props.setProperty(WORD2VEC_DIR_KEY, this.word2vecDirectory.getAbsolutePath());
        }
        props.setProperty(AUTO_DETECT_KEY, Boolean.toString(this.autoDetect));
        props.setProperty(TAGGER_SHOWS_DISAMBIG_LOG_KEY, Boolean.toString(this.taggerShowsDisambigLog));
        props.setProperty(USE_GUI_KEY, Boolean.toString(this.guiConfig));
        props.setProperty(SERVER_RUN_KEY, Boolean.toString(this.runServer));
        props.setProperty(SERVER_PORT_KEY, Integer.toString(this.serverPort));
        props.setProperty(PARA_CHECK_KEY, Integer.toString(this.numParasToCheck));
        props.setProperty(RESET_CHECK_KEY, Boolean.toString(this.doResetCheck));
        if (this.switchOff) {
            props.setProperty(LT_SWITCHED_OFF_KEY, Boolean.toString(this.switchOff));
        }
        if (this.fontName != null) {
            props.setProperty(FONT_NAME_KEY, this.fontName);
        }
        if (this.fontStyle != -1) {
            props.setProperty(FONT_STYLE_KEY, Integer.toString(this.fontStyle));
        }
        if (this.fontSize != -1) {
            props.setProperty(FONT_SIZE_KEY, Integer.toString(this.fontSize));
        }
        if (this.lookAndFeelName != null) {
            props.setProperty(LF_NAME_KEY, this.lookAndFeelName);
        }
        if (this.externalRuleDirectory != null) {
            props.setProperty(EXTERNAL_RULE_DIRECTORY, this.externalRuleDirectory);
        }
        StringBuilder sbRV = new StringBuilder();
        for (Map.Entry<String, Integer> entry : this.configurableRuleValues.entrySet()) {
            sbRV.append(entry.getKey()).append(":").append(Integer.toString(entry.getValue())).append(", ");
        }
        props.setProperty(CONFIGURABLE_RULE_VALUES_KEY, sbRV.toString());
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<ITSIssueType, Color> entry : this.errorColors.entrySet()) {
            String string2 = Integer.toHexString(entry.getValue().getRGB());
            string2 = string2.substring(2, string2.length());
            sb.append(entry.getKey()).append(":#").append(string2).append(", ");
        }
        props.setProperty(ERROR_COLORS_KEY, sb.toString());
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, Color> entry : this.underlineColors.entrySet()) {
            String rgb = Integer.toHexString(entry.getValue().getRGB());
            rgb = rgb.substring(2, rgb.length());
            stringBuilder.append(entry.getKey()).append(":#").append(rgb).append(", ");
        }
        props.setProperty(UNDERLINE_COLORS_KEY, stringBuilder.toString());
        for (String string : this.configForOtherLanguages.keySet()) {
            props.setProperty(string, this.configForOtherLanguages.get(string));
        }
        Throwable throwable = null;
        try (FileOutputStream fileOutputStream = new FileOutputStream(this.configFile);){
            props.store(fileOutputStream, "LanguageTool configuration (4.4/" + JLanguageTool.BUILD_DATE + ")");
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throw throwable2;
        }
    }

    private void addListToProperties(Properties props, String key, Set<String> list) {
        if (list == null) {
            props.setProperty(key, "");
        } else {
            props.setProperty(key, String.join((CharSequence)DELIMITER, list));
        }
    }
}

