/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import javajs.util.CU;
import javajs.util.P3;
import javajs.util.PT;
import org.jmol.jvxl.data.JvxlCoder;
import org.jmol.jvxl.readers.PolygonFileReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.util.Logger;

class PmeshReader
extends PolygonFileReader {
    private boolean isBinary;
    protected int nPolygons;
    protected String pmeshError;
    protected String type;
    protected boolean isClosedFace;
    protected int fixedCount;
    protected boolean onePerLine;
    protected int vertexBase;
    protected int[] vertexMap;
    protected String[] tokens = new String[0];
    protected int iToken = 0;

    PmeshReader() {
    }

    @Override
    void init2(SurfaceGenerator surfaceGenerator, BufferedReader bufferedReader) {
        this.init2PR(surfaceGenerator, bufferedReader);
    }

    protected void init2PR(SurfaceGenerator surfaceGenerator, BufferedReader bufferedReader) {
        this.init2PFR(surfaceGenerator, bufferedReader);
        String string = (String)((Object[])surfaceGenerator.getReaderData())[0];
        if (string == null) {
            return;
        }
        this.type = "pmesh";
        this.setHeader();
        this.isBinary = this.checkBinary(string);
        this.isClosedFace = !this.isBinary;
    }

    protected void setHeader() {
        this.jvxlFileHeaderBuffer.append(String.valueOf(this.type) + " file format\nvertices and triangles only\n");
        JvxlCoder.jvxlCreateHeaderWithoutTitleOrAtoms(this.volumeData, this.jvxlFileHeaderBuffer);
    }

    protected boolean checkBinary(String string) {
        block3: {
            this.br.mark(4);
            char[] cArray = new char[5];
            this.br.read(cArray, 0, 5);
            if (!new String(cArray).startsWith("PM\u0001\u0000")) break block3;
            this.br.close();
            this.binarydoc = this.newBinaryDocument();
            this.setStream(string, cArray[4] == '\u0000');
            return true;
        }
        try {
            this.br.reset();
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        return false;
    }

    @Override
    void getSurfaceData() throws Exception {
        if (this.readVerticesAndPolygons()) {
            Logger.info(String.valueOf(this.isBinary ? "binary " : "") + this.type + " file contains " + this.nVertices + " vertices and " + this.nPolygons + " polygons for " + this.nTriangles + " triangles");
        } else {
            Logger.error(String.valueOf(this.params.fileName) + ": " + (this.pmeshError == null ? "Error reading pmesh data " : this.pmeshError));
        }
    }

    protected boolean readVerticesAndPolygons() {
        block5: {
            block4: {
                if (!this.isBinary || this.readBinaryHeader()) break block4;
                return false;
            }
            try {
                if (this.readVertices() && this.readPolygons()) {
                    return true;
                }
            }
            catch (Exception exception) {
                if (this.pmeshError != null) break block5;
                this.pmeshError = String.valueOf(this.type) + " ERROR: " + exception;
            }
        }
        return false;
    }

    boolean readBinaryHeader() {
        this.pmeshError = "could not read binary Pmesh file header";
        try {
            byte[] byArray = new byte[64];
            this.binarydoc.readByteArray(byArray, 0, 8);
            this.nVertices = this.binarydoc.readInt();
            this.nPolygons = this.binarydoc.readInt();
            this.binarydoc.readByteArray(byArray, 0, 64);
        }
        catch (Exception exception) {
            this.pmeshError = String.valueOf(this.pmeshError) + " " + exception.toString();
            this.binarydoc.close();
            return false;
        }
        this.pmeshError = null;
        return true;
    }

    protected boolean readVertices() throws Exception {
        return this.readVerticesPM();
    }

    protected boolean readVerticesPM() throws Exception {
        this.pmeshError = String.valueOf(this.type) + " ERROR: vertex count must be positive";
        if (!this.isBinary) {
            this.nVertices = this.getInt();
            if (this.nVertices == Integer.MIN_VALUE) {
                this.nVertices = this.getInt();
            }
        }
        if (this.onePerLine) {
            this.iToken = Integer.MAX_VALUE;
        }
        if (this.nVertices <= 0) {
            this.pmeshError = String.valueOf(this.pmeshError) + " (" + this.nVertices + ")";
            return false;
        }
        this.pmeshError = String.valueOf(this.type) + " ERROR: invalid vertex list";
        this.vertexMap = new int[this.nVertices];
        int n = 0;
        while (n < this.nVertices) {
            P3 p3 = P3.new3(this.getFloat(), this.getFloat(), this.getFloat());
            if (this.isAnisotropic) {
                this.setVertexAnisotropy(p3);
            }
            if (Logger.debugging) {
                Logger.debug(String.valueOf(n) + ": " + p3);
            }
            this.vertexMap[n] = this.addVertexCopy(p3, 0.0f, n, false);
            if (this.onePerLine) {
                this.iToken = Integer.MAX_VALUE;
            }
            ++n;
        }
        this.pmeshError = null;
        return true;
    }

    protected boolean readPolygons() throws Exception {
        return this.readPolygonsPM();
    }

    protected boolean readPolygonsPM() throws Exception {
        this.pmeshError = String.valueOf(this.type) + " ERROR: polygon count must be zero or positive";
        if (!this.isBinary) {
            this.nPolygons = this.getInt();
        }
        if (this.onePerLine) {
            this.iToken = Integer.MAX_VALUE;
        }
        int[] nArray = new int[5];
        if (this.nPolygons == -1) {
            this.nPolygons = Integer.MAX_VALUE;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < this.nPolygons) {
            int n3;
            boolean bl;
            int n4;
            int n5 = n4 = this.fixedCount == 0 ? this.getInt() : this.fixedCount;
            if (n4 == 0) break;
            ++n;
            boolean bl2 = bl = n4 < 0;
            if (bl) {
                n4 = -n4;
            }
            if ((n3 = n4 - (n4 > 3 && this.isClosedFace ? 1 : 0)) < 1 || n3 > 4) {
                this.pmeshError = String.valueOf(this.type) + " ERROR: bad polygon (must have 1-4 vertices) at #" + (n2 + 1);
                return false;
            }
            boolean bl3 = true;
            int n6 = 0;
            while (n6 < n4) {
                nArray[n6] = this.getInt() - this.vertexBase;
                if (nArray[n6] < 0 || nArray[n6] >= this.nVertices) {
                    this.pmeshError = String.valueOf(this.type) + " ERROR: invalid vertex index: " + nArray[n6];
                    return false;
                }
                nArray[n6] = this.vertexMap[nArray[n6]];
                if (nArray[n6] < 0) {
                    bl3 = false;
                }
                ++n6;
            }
            if (this.onePerLine) {
                this.iToken = Integer.MAX_VALUE;
            }
            if (bl3) {
                if (n3 < 3) {
                    n6 = n3;
                    while (n6 < 3) {
                        nArray[n6] = nArray[n6 - 1];
                        ++n6;
                    }
                }
                n6 = 0;
                if (bl) {
                    if (this.isBinary) {
                        n6 = this.getInt();
                    } else {
                        String string = this.nextToken();
                        try {
                            n6 = string.startsWith("0x") ? PT.parseIntRadix(string.substring(2), 16) : this.parseIntStr(string);
                        }
                        catch (Throwable throwable) {
                            n6 = Integer.MIN_VALUE;
                        }
                        if (n6 == Integer.MIN_VALUE) {
                            n6 = CU.getArgbFromString(string);
                        }
                    }
                    n6 |= 0xFF000000;
                }
                if (n3 == 4) {
                    this.nTriangles += 2;
                    this.addTriangleCheck(nArray[0], nArray[1], nArray[3], 5, 0, false, n6);
                    this.addTriangleCheck(nArray[1], nArray[2], nArray[3], 3, 0, false, n6);
                } else {
                    ++this.nTriangles;
                    this.addTriangleCheck(nArray[0], nArray[1], nArray[2], 7, 0, false, n6);
                }
            }
            ++n2;
        }
        if (this.isBinary) {
            this.nBytes = this.binarydoc.getPosition();
        }
        this.nPolygons = n;
        return true;
    }

    private String nextToken() throws Exception {
        while (this.iToken >= this.tokens.length) {
            this.iToken = 0;
            this.rd();
            this.tokens = this.getTokens();
        }
        return this.tokens[this.iToken++];
    }

    private int getInt() throws Exception {
        return this.isBinary ? this.binarydoc.readInt() : this.parseIntStr(this.nextToken());
    }

    private float getFloat() throws Exception {
        return this.isBinary ? this.binarydoc.readFloat() : this.parseFloatStr(this.nextToken());
    }
}

