/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.recomp;

import java.io.File;
import java.util.Collection;
import java.util.List;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.tasks.compile.incremental.classpath.ClasspathSnapshotData;
import org.gradle.api.internal.tasks.compile.incremental.classpath.ClasspathSnapshotDataSerializer;
import org.gradle.api.internal.tasks.compile.incremental.processing.AnnotationProcessingData;
import org.gradle.internal.serialize.AbstractSerializer;
import org.gradle.internal.serialize.BaseSerializerFactory;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.ListSerializer;

public class PreviousCompilationData {
    private final File destinationDir;
    private final AnnotationProcessingData annotationProcessingData;
    private final ClasspathSnapshotData classpathSnapshot;
    private final List<File> annotationProcessorPath;

    public PreviousCompilationData(File destinationDir, AnnotationProcessingData annotationProcessingData, ClasspathSnapshotData classpathSnapshot, List<File> annotationProcessorPath) {
        this.destinationDir = destinationDir;
        this.annotationProcessingData = annotationProcessingData;
        this.classpathSnapshot = classpathSnapshot;
        this.annotationProcessorPath = annotationProcessorPath;
    }

    public File getDestinationDir() {
        return this.destinationDir;
    }

    public AnnotationProcessingData getAnnotationProcessingData() {
        return this.annotationProcessingData;
    }

    public ClasspathSnapshotData getClasspathSnapshot() {
        return this.classpathSnapshot;
    }

    public List<File> getAnnotationProcessorPath() {
        return this.annotationProcessorPath;
    }

    public static class Serializer
    extends AbstractSerializer<PreviousCompilationData> {
        private final ClasspathSnapshotDataSerializer classpathSnapshotDataSerializer = new ClasspathSnapshotDataSerializer();
        private final ListSerializer<File> processorPathSerializer = new ListSerializer(BaseSerializerFactory.FILE_SERIALIZER);
        private final AnnotationProcessingData.Serializer annotationProcessingDataSerializer;

        public Serializer(StringInterner interner) {
            this.annotationProcessingDataSerializer = new AnnotationProcessingData.Serializer(interner);
        }

        public PreviousCompilationData read(Decoder decoder) throws Exception {
            File destinationDir = (File)BaseSerializerFactory.FILE_SERIALIZER.read(decoder);
            ClasspathSnapshotData classpathSnapshot = this.classpathSnapshotDataSerializer.read(decoder);
            List processorPath = (List)this.processorPathSerializer.read(decoder);
            AnnotationProcessingData annotationProcessingData = this.annotationProcessingDataSerializer.read(decoder);
            return new PreviousCompilationData(destinationDir, annotationProcessingData, classpathSnapshot, processorPath);
        }

        public void write(Encoder encoder, PreviousCompilationData value) throws Exception {
            BaseSerializerFactory.FILE_SERIALIZER.write(encoder, (Object)value.destinationDir);
            this.classpathSnapshotDataSerializer.write(encoder, value.classpathSnapshot);
            this.processorPathSerializer.write(encoder, (Collection)value.annotationProcessorPath);
            this.annotationProcessingDataSerializer.write(encoder, value.annotationProcessingData);
        }
    }
}

