/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.specs;

import com.google.common.collect.ObjectArrays;
import groovy.lang.Closure;
import org.gradle.api.Incubating;
import org.gradle.api.specs.CompositeSpec;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.internal.ClosureSpec;

public class AndSpec<T>
extends CompositeSpec<T> {
    public static final AndSpec<?> EMPTY = new AndSpec();

    public AndSpec() {
    }

    public AndSpec(Spec<? super T> ... specs) {
        super(specs);
    }

    public AndSpec(Iterable<? extends Spec<? super T>> specs) {
        super(specs);
    }

    public boolean isSatisfiedBy(T object) {
        Spec[] specs;
        for (Spec spec : specs = this.getSpecsArray()) {
            if (spec.isSatisfiedBy(object)) continue;
            return false;
        }
        return true;
    }

    public AndSpec<T> and(Spec<? super T> ... specs) {
        if (specs.length == 0) {
            return this;
        }
        Spec[] thisSpecs = this.getSpecsArray();
        int thisLength = thisSpecs.length;
        if (thisLength == 0) {
            return new AndSpec<T>(specs);
        }
        Spec[] combinedSpecs = (Spec[])AndSpec.uncheckedCast((Object)ObjectArrays.newArray(Spec.class, (int)(thisLength + specs.length)));
        System.arraycopy(thisSpecs, 0, combinedSpecs, 0, thisLength);
        System.arraycopy(specs, 0, combinedSpecs, thisLength, specs.length);
        return new AndSpec<T>(combinedSpecs);
    }

    @Incubating
    public AndSpec<T> and(Spec<? super T> spec) {
        return this.and(new Spec[]{spec});
    }

    public AndSpec<T> and(Closure spec) {
        return this.and((Spec<? super T>)new ClosureSpec(spec));
    }

    public static <T> AndSpec<T> empty() {
        return (AndSpec)((Object)AndSpec.uncheckedCast(EMPTY));
    }
}

