# -*- encoding:utf-8; warn-indent:false; frozen_string_literal: true  -*-

# line 1 "lib/parser/lexer.rl"

# line 3 "lib/parser/lexer.rl"
#
# === BEFORE YOU START ===
#
# Read the Ruby Hacking Guide chapter 11, available in English at
# http://whitequark.org/blog/2013/04/01/ruby-hacking-guide-ch-11-finite-state-lexer/
#
# Remember two things about Ragel scanners:
#
#   1) Longest match wins.
#
#   2) If two matches have the same length, the first
#      in source code wins.
#
# General rules of making Ragel and Bison happy:
#
#  * `p` (position) and `@te` contain the index of the character
#    they're pointing to ("current"), plus one. `@ts` contains the index
#    of the corresponding character. The code for extracting matched token is:
#
#       @source_buffer.slice(@ts...@te)
#
#  * If your input is `foooooooobar` and the rule is:
#
#       'f' 'o'+
#
#    the result will be:
#
#       foooooooobar
#       ^ ts=0   ^ p=te=9
#
#  * A Ragel lexer action should not emit more than one token, unless
#    you know what you are doing.
#
#  * All Ragel commands (fnext, fgoto, ...) end with a semicolon.
#
#  * If an action emits the token and transitions to another state, use
#    these Ragel commands:
#
#       emit($whatever)
#       fnext $next_state; fbreak;
#
#    If you perform `fgoto` in an action which does not emit a token nor
#    rewinds the stream pointer, the parser's side-effectful,
#    context-sensitive lookahead actions will break in a hard to detect
#    and debug way.
#
#  * If an action does not emit a token:
#
#       fgoto $next_state;
#
#  * If an action features lookbehind, i.e. matches characters with the
#    intent of passing them to another action:
#
#       p = @ts - 1
#       fgoto $next_state;
#
#    or, if the lookbehind consists of a single character:
#
#       fhold; fgoto $next_state;
#
#  * Ragel merges actions. So, if you have `e_lparen = '(' %act` and
#    `c_lparen = '('` and a lexer action `e_lparen | c_lparen`, the result
#    _will_ invoke the action `act`.
#
#    e_something stands for "something with **e**mbedded action".
#
#  * EOF is explicit and is matched by `c_eof`. If you want to introspect
#    the state of the lexer, add this rule to the state:
#
#       c_eof => do_eof;
#
#  * If you proceed past EOF, the lexer will complain:
#
#       NoMethodError: undefined method `ord' for nil:NilClass
#

class Parser::Lexer

  
# line 85 "lib/parser/lexer.rb"
class << self
	attr_accessor :_lex_trans_keys
	private :_lex_trans_keys, :_lex_trans_keys=
end
self._lex_trans_keys = [
	0, 0, 101, 101, 103, 103, 
	105, 105, 110, 110, 69, 
	69, 78, 78, 68, 68, 
	95, 95, 95, 95, 0, 26, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 45, 
	0, 77, 0, 77, 0, 92, 
	0, 26, 0, 26, 0, 
	45, 0, 99, 0, 26, 
	67, 99, 45, 45, 0, 92, 
	0, 77, 0, 102, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 45, 0, 77, 
	0, 77, 0, 92, 0, 
	26, 0, 26, 0, 45, 
	0, 99, 0, 26, 67, 99, 
	45, 45, 0, 92, 0, 
	77, 0, 102, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 26, 0, 
	127, 58, 58, 58, 58, 
	0, 127, 58, 58, 60, 60, 
	62, 62, 10, 10, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 115, 115, 
	99, 99, 117, 117, 101, 101, 
	108, 116, 101, 101, 115, 
	115, 115, 115, 105, 105, 
	108, 108, 105, 105, 108, 108, 
	58, 58, 0, 127, 10, 
	10, 0, 127, 9, 92, 
	10, 10, 9, 92, 58, 58, 
	98, 98, 101, 101, 103, 
	103, 105, 105, 110, 110, 
	0, 122, 61, 61, 9, 92, 
	9, 92, 9, 92, 9, 
	92, 9, 92, 10, 10, 
	0, 127, 0, 127, 61, 126, 
	0, 127, 0, 127, 93, 
	93, 0, 127, 0, 127, 
	10, 10, 34, 34, 10, 10, 
	39, 39, 0, 127, 96, 
	96, 0, 45, 0, 77, 
	0, 77, 0, 92, 0, 26, 
	0, 26, 0, 45, 0, 
	99, 0, 26, 67, 99, 
	45, 45, 0, 92, 0, 77, 
	0, 102, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 58, 58, 
	58, 58, 0, 127, 43, 
	57, 48, 57, 48, 57, 
	48, 57, 48, 57, 115, 115, 
	99, 99, 117, 117, 101, 
	101, 99, 99, 117, 117, 
	101, 101, 0, 127, 58, 58, 
	9, 92, 9, 92, 9, 
	92, 9, 92, 9, 92, 
	9, 92, 60, 60, 10, 10, 
	9, 46, 46, 46, 0, 
	95, 9, 32, 0, 0, 
	10, 10, 10, 10, 98, 98, 
	9, 32, 10, 10, 95, 
	95, 0, 92, 9, 32, 
	36, 123, 0, 127, 48, 57, 
	0, 120, 0, 0, 0, 
	0, 48, 55, 48, 55, 
	0, 0, 0, 0, 0, 92, 
	0, 0, 0, 0, 0, 
	0, 0, 92, 45, 45, 
	0, 0, 0, 0, 0, 0, 
	0, 92, 0, 45, 0, 
	92, 0, 92, 0, 0, 
	0, 0, 0, 92, 0, 45, 
	10, 10, 0, 92, 48, 
	123, 48, 102, 48, 102, 
	48, 102, 0, 0, 0, 125, 
	0, 125, 0, 0, 0, 
	125, 0, 0, 0, 125, 
	0, 125, 0, 125, 0, 125, 
	0, 0, 0, 125, 0, 
	125, 0, 125, 0, 125, 
	0, 125, 0, 125, 0, 0, 
	0, 0, 48, 102, 0, 
	0, 0, 92, 36, 123, 
	0, 127, 48, 57, 0, 120, 
	0, 0, 0, 0, 48, 
	55, 48, 55, 0, 0, 
	0, 0, 0, 92, 0, 0, 
	0, 0, 0, 0, 0, 
	92, 45, 45, 0, 0, 
	0, 0, 0, 0, 0, 92, 
	0, 45, 0, 92, 0, 
	92, 0, 0, 0, 0, 
	0, 92, 0, 45, 10, 10, 
	0, 92, 48, 123, 48, 
	102, 48, 102, 48, 102, 
	0, 0, 0, 125, 0, 125, 
	0, 0, 0, 125, 0, 
	0, 0, 125, 0, 125, 
	0, 125, 0, 125, 0, 0, 
	0, 125, 0, 125, 0, 
	125, 0, 125, 0, 125, 
	0, 125, 0, 0, 0, 0, 
	48, 102, 0, 0, 0, 
	92, 9, 32, 0, 26, 
	0, 92, 0, 26, 0, 35, 
	36, 123, 0, 127, 48, 
	57, 0, 26, 0, 35, 
	9, 32, 36, 123, 0, 127, 
	48, 57, 0, 32, 9, 
	32, 65, 122, 65, 122, 
	36, 64, 0, 127, 48, 57, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 9, 32, 
	0, 0, 61, 126, 10, 10, 
	10, 10, 0, 127, 0, 
	127, 48, 57, 115, 115, 
	38, 38, 42, 42, 64, 64, 
	58, 58, 60, 61, 62, 
	62, 61, 126, 61, 61, 
	61, 62, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	93, 93, 10, 10, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 124, 
	124, 0, 127, 0, 127, 
	9, 32, 10, 10, 10, 10, 
	10, 10, 0, 0, 0, 
	127, 0, 127, 61, 61, 
	0, 0, 9, 32, 0, 0, 
	61, 126, 10, 10, 10, 
	10, 38, 38, 42, 42, 
	64, 64, 60, 61, 62, 62, 
	61, 126, 61, 61, 61, 
	62, 0, 127, 93, 93, 
	10, 10, 124, 124, 0, 126, 
	0, 127, 0, 61, 9, 
	61, 9, 61, 0, 0, 
	9, 61, 9, 62, 46, 46, 
	46, 46, 58, 58, 9, 
	32, 0, 0, 0, 127, 
	0, 0, 9, 124, 0, 0, 
	10, 10, 10, 10, 0, 
	0, 9, 61, 58, 58, 
	60, 60, 62, 62, 9, 32, 
	10, 10, 0, 127, 102, 
	102, 101, 101, 110, 110, 
	104, 104, 0, 127, 0, 127, 
	0, 127, 0, 0, 0, 
	127, 10, 10, 0, 123, 
	9, 32, 10, 10, 10, 10, 
	10, 10, 0, 0, 111, 
	111, 0, 0, 0, 127, 
	0, 127, 9, 32, 0, 0, 
	10, 10, 10, 10, 10, 
	10, 0, 0, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 58, 61, 0, 0, 
	61, 126, 61, 61, 0, 
	0, 0, 0, 0, 0, 
	9, 32, 61, 61, 9, 32, 
	61, 126, 10, 10, 10, 
	10, 65, 122, 0, 122, 
	38, 61, 0, 0, 42, 61, 
	61, 61, 9, 92, 9, 
	92, 9, 92, 46, 46, 
	46, 46, 0, 26, 0, 127, 
	0, 127, 61, 61, 0, 
	0, 61, 126, 61, 62, 
	0, 0, 0, 0, 0, 0, 
	0, 0, 61, 126, 0, 
	127, 48, 57, 38, 38, 
	42, 42, 64, 64, 60, 61, 
	62, 62, 61, 61, 61, 
	62, 124, 124, 64, 64, 
	60, 61, 0, 0, 62, 62, 
	61, 126, 61, 62, 0, 
	122, 0, 0, 0, 127, 
	0, 127, 0, 120, 0, 0, 
	0, 0, 48, 55, 48, 
	55, 0, 0, 0, 0, 
	0, 92, 0, 0, 0, 0, 
	0, 0, 0, 92, 45, 
	45, 0, 0, 0, 0, 
	0, 0, 0, 92, 0, 45, 
	0, 92, 0, 92, 0, 
	0, 0, 0, 0, 92, 
	0, 45, 10, 10, 0, 92, 
	48, 123, 48, 102, 48, 
	102, 48, 102, 0, 0, 
	0, 125, 0, 125, 0, 0, 
	0, 125, 0, 0, 0, 
	125, 0, 125, 0, 125, 
	0, 125, 0, 0, 0, 125, 
	0, 125, 0, 125, 0, 
	125, 0, 125, 0, 125, 
	0, 125, 0, 125, 0, 125, 
	0, 125, 0, 125, 0, 
	125, 0, 125, 0, 125, 
	0, 125, 0, 125, 0, 125, 
	0, 125, 0, 125, 0, 
	0, 0, 0, 48, 102, 
	0, 0, 0, 127, 0, 127, 
	0, 127, 0, 0, 10, 
	10, 0, 0, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 61, 126, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 0, 61, 124, 
	0, 92, 9, 32, 0, 0, 
	10, 10, 10, 10, 10, 
	10, 0, 0, 0, 127, 
	0, 127, 9, 32, 0, 0, 
	10, 10, 10, 10, 10, 
	10, 0, 0, 0, 127, 
	0, 127, 61, 61, 0, 0, 
	9, 32, 0, 0, 61, 
	126, 10, 10, 10, 10, 
	0, 127, 0, 127, 48, 57, 
	61, 61, 38, 61, 0, 
	0, 0, 0, 42, 61, 
	61, 62, 46, 57, 46, 46, 
	48, 101, 48, 95, 46, 
	120, 48, 114, 43, 57, 
	48, 105, 102, 102, 0, 0, 
	101, 105, 0, 0, 0, 
	0, 48, 114, 48, 114, 
	48, 114, 48, 114, 105, 114, 
	102, 102, 0, 0, 101, 
	105, 115, 115, 0, 0, 
	0, 0, 48, 114, 48, 114, 
	48, 114, 48, 114, 48, 
	114, 48, 114, 48, 114, 
	48, 114, 46, 114, 48, 114, 
	46, 114, 48, 114, 58, 
	58, 60, 61, 62, 62, 
	61, 126, 61, 61, 61, 62, 
	0, 127, 0, 127, 0, 
	0, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 0, 10, 
	10, 0, 0, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 9, 92, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 0, 61, 124, 
	0, 0, 9, 46, 9, 46, 
	46, 46, 10, 61, 10, 
	10, 10, 101, 10, 110, 
	10, 100, 10, 10, 0
]

class << self
	attr_accessor :_lex_key_spans
	private :_lex_key_spans, :_lex_key_spans=
end
self._lex_key_spans = [
	0, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 27, 128, 128, 128, 128, 46, 
	78, 78, 93, 27, 27, 46, 100, 27, 
	33, 1, 93, 78, 103, 128, 128, 128, 
	128, 46, 78, 78, 93, 27, 27, 46, 
	100, 27, 33, 1, 93, 78, 103, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 27, 128, 1, 1, 
	128, 1, 1, 1, 1, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 1, 
	1, 1, 1, 9, 1, 1, 1, 1, 
	1, 1, 1, 1, 128, 1, 128, 84, 
	1, 84, 1, 1, 1, 1, 1, 1, 
	123, 1, 84, 84, 84, 84, 84, 1, 
	128, 128, 66, 128, 128, 1, 128, 128, 
	1, 1, 1, 1, 128, 1, 46, 78, 
	78, 93, 27, 27, 46, 100, 27, 33, 
	1, 93, 78, 103, 128, 128, 128, 128, 
	128, 128, 1, 1, 128, 15, 10, 10, 
	10, 10, 1, 1, 1, 1, 1, 1, 
	1, 128, 1, 84, 84, 84, 84, 84, 
	84, 1, 1, 38, 1, 96, 24, 0, 
	1, 1, 1, 24, 1, 1, 93, 24, 
	88, 128, 10, 121, 0, 0, 8, 8, 
	0, 0, 93, 0, 0, 0, 93, 1, 
	0, 0, 0, 93, 46, 93, 93, 0, 
	0, 93, 46, 1, 93, 76, 55, 55, 
	55, 0, 126, 126, 0, 126, 0, 126, 
	126, 126, 126, 0, 126, 126, 126, 126, 
	126, 126, 0, 0, 55, 0, 93, 88, 
	128, 10, 121, 0, 0, 8, 8, 0, 
	0, 93, 0, 0, 0, 93, 1, 0, 
	0, 0, 93, 46, 93, 93, 0, 0, 
	93, 46, 1, 93, 76, 55, 55, 55, 
	0, 126, 126, 0, 126, 0, 126, 126, 
	126, 126, 0, 126, 126, 126, 126, 126, 
	126, 0, 0, 55, 0, 93, 24, 27, 
	93, 27, 36, 88, 128, 10, 27, 36, 
	24, 88, 128, 10, 33, 24, 58, 58, 
	29, 128, 10, 128, 128, 128, 128, 24, 
	0, 66, 1, 1, 128, 128, 10, 1, 
	1, 1, 1, 1, 2, 1, 66, 1, 
	2, 128, 128, 128, 128, 128, 128, 128, 
	1, 1, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 1, 128, 128, 
	24, 1, 1, 1, 0, 128, 128, 1, 
	0, 24, 0, 66, 1, 1, 1, 1, 
	1, 2, 1, 66, 1, 2, 128, 1, 
	1, 1, 127, 128, 62, 53, 53, 0, 
	53, 54, 1, 1, 1, 24, 0, 128, 
	0, 116, 0, 1, 1, 0, 53, 1, 
	1, 1, 24, 1, 128, 1, 1, 1, 
	1, 128, 128, 128, 0, 128, 1, 124, 
	24, 1, 1, 1, 0, 1, 0, 128, 
	128, 24, 0, 1, 1, 1, 0, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 4, 0, 66, 1, 0, 0, 0, 
	24, 1, 24, 66, 1, 1, 58, 123, 
	24, 0, 20, 1, 84, 84, 84, 1, 
	1, 27, 128, 128, 1, 0, 66, 2, 
	0, 0, 0, 0, 66, 128, 10, 1, 
	1, 1, 2, 1, 1, 2, 1, 1, 
	2, 0, 1, 66, 2, 123, 0, 128, 
	128, 121, 0, 0, 8, 8, 0, 0, 
	93, 0, 0, 0, 93, 1, 0, 0, 
	0, 93, 46, 93, 93, 0, 0, 93, 
	46, 1, 93, 76, 55, 55, 55, 0, 
	126, 126, 0, 126, 0, 126, 126, 126, 
	126, 0, 126, 126, 126, 126, 126, 126, 
	126, 126, 126, 126, 126, 126, 126, 126, 
	126, 126, 126, 126, 126, 0, 0, 55, 
	0, 128, 128, 128, 0, 1, 0, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 66, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 0, 64, 
	93, 24, 0, 1, 1, 1, 0, 128, 
	128, 24, 0, 1, 1, 1, 0, 128, 
	128, 1, 0, 24, 0, 66, 1, 1, 
	128, 128, 10, 1, 24, 0, 0, 20, 
	2, 12, 1, 54, 48, 75, 67, 15, 
	58, 1, 0, 5, 0, 0, 67, 67, 
	67, 67, 10, 1, 0, 5, 1, 0, 
	0, 67, 67, 67, 67, 67, 67, 67, 
	67, 69, 67, 69, 67, 1, 2, 1, 
	66, 1, 2, 128, 128, 0, 128, 128, 
	128, 128, 128, 128, 0, 1, 0, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 84, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 0, 64, 
	0, 38, 38, 1, 52, 1, 92, 101, 
	91, 1
]

class << self
	attr_accessor :_lex_index_offsets
	private :_lex_index_offsets, :_lex_index_offsets=
end
self._lex_index_offsets = [
	0, 0, 2, 4, 6, 8, 10, 12, 
	14, 16, 18, 46, 175, 304, 433, 562, 
	609, 688, 767, 861, 889, 917, 964, 1065, 
	1093, 1127, 1129, 1223, 1302, 1406, 1535, 1664, 
	1793, 1922, 1969, 2048, 2127, 2221, 2249, 2277, 
	2324, 2425, 2453, 2487, 2489, 2583, 2662, 2766, 
	2895, 3024, 3153, 3282, 3411, 3540, 3669, 3798, 
	3927, 4056, 4185, 4314, 4443, 4471, 4600, 4602, 
	4604, 4733, 4735, 4737, 4739, 4741, 4870, 4999, 
	5128, 5257, 5386, 5515, 5644, 5773, 5902, 6031, 
	6160, 6289, 6418, 6547, 6676, 6805, 6934, 7063, 
	7065, 7067, 7069, 7071, 7081, 7083, 7085, 7087, 
	7089, 7091, 7093, 7095, 7097, 7226, 7228, 7357, 
	7442, 7444, 7529, 7531, 7533, 7535, 7537, 7539, 
	7541, 7665, 7667, 7752, 7837, 7922, 8007, 8092, 
	8094, 8223, 8352, 8419, 8548, 8677, 8679, 8808, 
	8937, 8939, 8941, 8943, 8945, 9074, 9076, 9123, 
	9202, 9281, 9375, 9403, 9431, 9478, 9579, 9607, 
	9641, 9643, 9737, 9816, 9920, 10049, 10178, 10307, 
	10436, 10565, 10694, 10696, 10698, 10827, 10843, 10854, 
	10865, 10876, 10887, 10889, 10891, 10893, 10895, 10897, 
	10899, 10901, 11030, 11032, 11117, 11202, 11287, 11372, 
	11457, 11542, 11544, 11546, 11585, 11587, 11684, 11709, 
	11710, 11712, 11714, 11716, 11741, 11743, 11745, 11839, 
	11864, 11953, 12082, 12093, 12215, 12216, 12217, 12226, 
	12235, 12236, 12237, 12331, 12332, 12333, 12334, 12428, 
	12430, 12431, 12432, 12433, 12527, 12574, 12668, 12762, 
	12763, 12764, 12858, 12905, 12907, 13001, 13078, 13134, 
	13190, 13246, 13247, 13374, 13501, 13502, 13629, 13630, 
	13757, 13884, 14011, 14138, 14139, 14266, 14393, 14520, 
	14647, 14774, 14901, 14902, 14903, 14959, 14960, 15054, 
	15143, 15272, 15283, 15405, 15406, 15407, 15416, 15425, 
	15426, 15427, 15521, 15522, 15523, 15524, 15618, 15620, 
	15621, 15622, 15623, 15717, 15764, 15858, 15952, 15953, 
	15954, 16048, 16095, 16097, 16191, 16268, 16324, 16380, 
	16436, 16437, 16564, 16691, 16692, 16819, 16820, 16947, 
	17074, 17201, 17328, 17329, 17456, 17583, 17710, 17837, 
	17964, 18091, 18092, 18093, 18149, 18150, 18244, 18269, 
	18297, 18391, 18419, 18456, 18545, 18674, 18685, 18713, 
	18750, 18775, 18864, 18993, 19004, 19038, 19063, 19122, 
	19181, 19211, 19340, 19351, 19480, 19609, 19738, 19867, 
	19892, 19893, 19960, 19962, 19964, 20093, 20222, 20233, 
	20235, 20237, 20239, 20241, 20243, 20246, 20248, 20315, 
	20317, 20320, 20449, 20578, 20707, 20836, 20965, 21094, 
	21223, 21225, 21227, 21356, 21485, 21614, 21743, 21872, 
	22001, 22130, 22259, 22388, 22517, 22646, 22775, 22904, 
	23033, 23162, 23291, 23420, 23549, 23678, 23807, 23936, 
	24065, 24194, 24323, 24452, 24581, 24710, 24839, 24968, 
	25097, 25226, 25355, 25484, 25613, 25742, 25871, 26000, 
	26129, 26258, 26387, 26516, 26645, 26774, 26903, 27032, 
	27161, 27290, 27419, 27548, 27677, 27806, 27935, 28064, 
	28193, 28322, 28451, 28580, 28709, 28838, 28967, 29096, 
	29225, 29354, 29483, 29612, 29741, 29870, 29999, 30128, 
	30257, 30386, 30515, 30644, 30773, 30902, 31031, 31160, 
	31289, 31418, 31547, 31676, 31805, 31934, 31936, 32065, 
	32194, 32219, 32221, 32223, 32225, 32226, 32355, 32484, 
	32486, 32487, 32512, 32513, 32580, 32582, 32584, 32586, 
	32588, 32590, 32593, 32595, 32662, 32664, 32667, 32796, 
	32798, 32800, 32802, 32930, 33059, 33122, 33176, 33230, 
	33231, 33285, 33340, 33342, 33344, 33346, 33371, 33372, 
	33501, 33502, 33619, 33620, 33622, 33624, 33625, 33679, 
	33681, 33683, 33685, 33710, 33712, 33841, 33843, 33845, 
	33847, 33849, 33978, 34107, 34236, 34237, 34366, 34368, 
	34493, 34518, 34520, 34522, 34524, 34525, 34527, 34528, 
	34657, 34786, 34811, 34812, 34814, 34816, 34818, 34819, 
	34948, 35077, 35206, 35335, 35464, 35593, 35722, 35851, 
	35980, 36109, 36238, 36367, 36496, 36625, 36754, 36883, 
	37012, 37141, 37146, 37147, 37214, 37216, 37217, 37218, 
	37219, 37244, 37246, 37271, 37338, 37340, 37342, 37401, 
	37525, 37550, 37551, 37572, 37574, 37659, 37744, 37829, 
	37831, 37833, 37861, 37990, 38119, 38121, 38122, 38189, 
	38192, 38193, 38194, 38195, 38196, 38263, 38392, 38403, 
	38405, 38407, 38409, 38412, 38414, 38416, 38419, 38421, 
	38423, 38426, 38427, 38429, 38496, 38499, 38623, 38624, 
	38753, 38882, 39004, 39005, 39006, 39015, 39024, 39025, 
	39026, 39120, 39121, 39122, 39123, 39217, 39219, 39220, 
	39221, 39222, 39316, 39363, 39457, 39551, 39552, 39553, 
	39647, 39694, 39696, 39790, 39867, 39923, 39979, 40035, 
	40036, 40163, 40290, 40291, 40418, 40419, 40546, 40673, 
	40800, 40927, 40928, 41055, 41182, 41309, 41436, 41563, 
	41690, 41817, 41944, 42071, 42198, 42325, 42452, 42579, 
	42706, 42833, 42960, 43087, 43214, 43341, 43342, 43343, 
	43399, 43400, 43529, 43658, 43787, 43788, 43790, 43791, 
	43920, 44049, 44178, 44307, 44436, 44565, 44694, 44823, 
	44952, 45081, 45210, 45339, 45468, 45597, 45726, 45855, 
	45984, 46113, 46242, 46371, 46500, 46629, 46758, 46887, 
	47016, 47145, 47274, 47403, 47532, 47661, 47790, 47919, 
	48048, 48177, 48306, 48435, 48564, 48693, 48822, 48951, 
	49080, 49209, 49338, 49467, 49596, 49725, 49854, 49983, 
	50112, 50241, 50370, 50499, 50628, 50757, 50886, 51015, 
	51144, 51273, 51402, 51531, 51660, 51727, 51856, 51985, 
	52114, 52243, 52372, 52501, 52630, 52759, 52888, 53017, 
	53146, 53275, 53404, 53533, 53662, 53791, 53920, 54049, 
	54178, 54307, 54436, 54565, 54694, 54823, 54952, 54953, 
	55018, 55112, 55137, 55138, 55140, 55142, 55144, 55145, 
	55274, 55403, 55428, 55429, 55431, 55433, 55435, 55436, 
	55565, 55694, 55696, 55697, 55722, 55723, 55790, 55792, 
	55794, 55923, 56052, 56063, 56065, 56090, 56091, 56092, 
	56113, 56116, 56129, 56131, 56186, 56235, 56311, 56379, 
	56395, 56454, 56456, 56457, 56463, 56464, 56465, 56533, 
	56601, 56669, 56737, 56748, 56750, 56751, 56757, 56759, 
	56760, 56761, 56829, 56897, 56965, 57033, 57101, 57169, 
	57237, 57305, 57375, 57443, 57513, 57581, 57583, 57586, 
	57588, 57655, 57657, 57660, 57789, 57918, 57919, 58048, 
	58177, 58306, 58435, 58564, 58693, 58694, 58696, 58697, 
	58826, 58955, 59084, 59213, 59342, 59471, 59600, 59729, 
	59858, 59987, 60116, 60245, 60374, 60503, 60632, 60761, 
	60890, 61019, 61148, 61277, 61406, 61535, 61664, 61793, 
	61922, 62051, 62180, 62309, 62438, 62567, 62696, 62825, 
	62954, 63083, 63212, 63341, 63470, 63555, 63684, 63813, 
	63942, 64071, 64200, 64329, 64458, 64587, 64716, 64845, 
	64974, 65103, 65232, 65361, 65490, 65619, 65748, 65877, 
	66006, 66135, 66264, 66393, 66522, 66651, 66780, 66909, 
	67038, 67167, 67296, 67425, 67554, 67683, 67812, 67941, 
	68070, 68199, 68328, 68457, 68586, 68715, 68844, 68973, 
	69102, 69231, 69360, 69489, 69618, 69747, 69876, 70005, 
	70134, 70263, 70392, 70521, 70650, 70779, 70908, 71037, 
	71166, 71295, 71424, 71553, 71682, 71811, 71940, 71941, 
	72006, 72007, 72046, 72085, 72087, 72140, 72142, 72235, 
	72337, 72429
]

class << self
	attr_accessor :_lex_indicies
	private :_lex_indicies, :_lex_indicies=
end
self._lex_indicies = [
	1, 0, 2, 0, 3, 0, 4, 0, 
	5, 0, 6, 0, 7, 0, 8, 0, 
	9, 0, 10, 0, 0, 0, 10, 0, 
	0, 0, 0, 0, 11, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 10, 0, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 14, 
	14, 12, 14, 12, 14, 14, 12, 12, 
	14, 14, 14, 15, 14, 14, 16, 16, 
	16, 16, 16, 16, 16, 16, 16, 16, 
	14, 14, 14, 14, 14, 14, 14, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 12, 14, 12, 12, 13, 14, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 12, 12, 12, 14, 12, 13, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 14, 
	14, 14, 14, 14, 14, 14, 14, 14, 
	14, 12, 12, 12, 12, 12, 12, 12, 
	14, 14, 14, 14, 14, 14, 14, 14, 
	14, 14, 14, 14, 14, 14, 14, 14, 
	14, 14, 14, 14, 14, 14, 14, 14, 
	14, 14, 12, 12, 12, 12, 14, 12, 
	14, 14, 14, 14, 14, 14, 14, 14, 
	14, 14, 14, 14, 14, 14, 14, 14, 
	14, 14, 14, 14, 14, 14, 14, 14, 
	14, 14, 12, 12, 12, 12, 12, 14, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 12, 12, 12, 12, 12, 12, 
	17, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 12, 12, 12, 12, 13, 
	12, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 12, 12, 12, 12, 12, 
	13, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 12, 12, 12, 12, 12, 
	12, 12, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 12, 12, 12, 12, 
	13, 12, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 12, 12, 12, 12, 
	12, 13, 18, 19, 19, 19, 18, 19, 
	19, 19, 19, 19, 19, 19, 19, 19, 
	19, 19, 19, 19, 19, 19, 19, 19, 
	19, 19, 19, 19, 18, 19, 19, 19, 
	19, 19, 19, 19, 19, 19, 19, 19, 
	19, 19, 19, 19, 19, 19, 19, 20, 
	19, 18, 21, 21, 21, 18, 21, 21, 
	21, 21, 21, 22, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 18, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 23, 21, 
	18, 21, 21, 21, 18, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 18, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 24, 21, 18, 
	25, 25, 25, 18, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 18, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 26, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 27, 25, 18, 28, 28, 
	28, 18, 28, 28, 28, 28, 28, 29, 
	28, 28, 28, 28, 28, 28, 28, 28, 
	28, 28, 28, 28, 28, 28, 28, 18, 
	28, 18, 28, 28, 28, 18, 28, 28, 
	28, 28, 28, 28, 28, 28, 28, 28, 
	28, 28, 28, 28, 28, 28, 28, 28, 
	28, 28, 28, 18, 28, 18, 19, 19, 
	19, 18, 19, 19, 19, 19, 19, 19, 
	19, 19, 19, 19, 19, 19, 19, 19, 
	19, 19, 19, 19, 19, 19, 19, 18, 
	19, 19, 19, 19, 19, 19, 19, 19, 
	19, 19, 19, 19, 19, 19, 19, 19, 
	19, 19, 30, 19, 18, 31, 31, 31, 
	18, 31, 31, 31, 31, 31, 32, 31, 
	31, 31, 31, 31, 31, 31, 31, 31, 
	31, 31, 31, 31, 31, 31, 18, 31, 
	31, 31, 31, 31, 31, 31, 31, 31, 
	31, 31, 31, 31, 31, 31, 31, 31, 
	31, 31, 31, 31, 31, 31, 31, 31, 
	31, 31, 31, 31, 31, 31, 31, 31, 
	31, 31, 31, 31, 31, 31, 31, 33, 
	31, 31, 31, 31, 31, 31, 31, 31, 
	31, 31, 31, 31, 31, 31, 31, 31, 
	31, 31, 31, 31, 31, 31, 31, 31, 
	34, 31, 31, 31, 31, 31, 31, 35, 
	31, 18, 31, 31, 31, 18, 31, 31, 
	31, 31, 31, 31, 31, 31, 31, 31, 
	31, 31, 31, 31, 31, 31, 31, 31, 
	31, 31, 31, 18, 31, 36, 18, 18, 
	18, 18, 18, 18, 18, 18, 18, 18, 
	18, 18, 18, 18, 18, 18, 18, 18, 
	18, 18, 18, 18, 18, 18, 18, 18, 
	18, 18, 18, 18, 18, 37, 18, 37, 
	18, 18, 38, 38, 38, 18, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 18, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	39, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 40, 38, 18, 
	21, 21, 21, 18, 21, 21, 21, 21, 
	21, 22, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 18, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 24, 21, 18, 41, 
	41, 41, 18, 41, 41, 41, 41, 41, 
	41, 41, 41, 41, 41, 41, 41, 41, 
	41, 41, 41, 41, 41, 41, 41, 41, 
	18, 41, 41, 41, 41, 41, 41, 41, 
	41, 41, 41, 41, 41, 41, 41, 41, 
	41, 41, 41, 41, 41, 41, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	41, 41, 41, 41, 41, 41, 41, 42, 
	42, 42, 42, 42, 42, 41, 41, 41, 
	41, 41, 41, 41, 41, 41, 41, 41, 
	41, 41, 41, 41, 41, 41, 41, 41, 
	41, 41, 41, 41, 41, 41, 41, 42, 
	42, 42, 42, 42, 42, 41, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 45, 
	45, 43, 45, 43, 45, 45, 43, 43, 
	45, 45, 45, 46, 45, 45, 47, 47, 
	47, 47, 47, 47, 47, 47, 47, 47, 
	45, 45, 45, 45, 45, 45, 45, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 43, 45, 43, 43, 44, 45, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 43, 43, 43, 45, 43, 44, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 43, 43, 43, 43, 43, 43, 43, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 43, 43, 43, 43, 45, 43, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 43, 43, 43, 43, 43, 45, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 43, 43, 43, 43, 43, 43, 
	48, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 43, 43, 43, 43, 44, 
	43, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 43, 43, 43, 43, 43, 
	44, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 43, 43, 43, 43, 43, 
	43, 43, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 43, 43, 43, 43, 
	44, 43, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 43, 43, 43, 43, 
	43, 44, 49, 50, 50, 50, 49, 50, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 50, 49, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 51, 
	50, 49, 52, 52, 52, 49, 52, 52, 
	52, 52, 52, 53, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 49, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 54, 52, 
	49, 52, 52, 52, 49, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 49, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 55, 52, 49, 
	56, 56, 56, 49, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 49, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 57, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 58, 56, 49, 59, 59, 
	59, 49, 59, 59, 59, 59, 59, 60, 
	59, 59, 59, 59, 59, 59, 59, 59, 
	59, 59, 59, 59, 59, 59, 59, 49, 
	59, 49, 59, 59, 59, 49, 59, 59, 
	59, 59, 59, 59, 59, 59, 59, 59, 
	59, 59, 59, 59, 59, 59, 59, 59, 
	59, 59, 59, 49, 59, 49, 50, 50, 
	50, 49, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 49, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 61, 50, 49, 62, 62, 62, 
	49, 62, 62, 62, 62, 62, 63, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 49, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 64, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	65, 62, 62, 62, 62, 62, 62, 66, 
	62, 49, 62, 62, 62, 49, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 49, 62, 67, 49, 49, 
	49, 49, 49, 49, 49, 49, 49, 49, 
	49, 49, 49, 49, 49, 49, 49, 49, 
	49, 49, 49, 49, 49, 49, 49, 49, 
	49, 49, 49, 49, 49, 68, 49, 68, 
	49, 49, 69, 69, 69, 49, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 49, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	70, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 71, 69, 49, 
	52, 52, 52, 49, 52, 52, 52, 52, 
	52, 53, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 49, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 55, 52, 49, 72, 
	72, 72, 49, 72, 72, 72, 72, 72, 
	72, 72, 72, 72, 72, 72, 72, 72, 
	72, 72, 72, 72, 72, 72, 72, 72, 
	49, 72, 72, 72, 72, 72, 72, 72, 
	72, 72, 72, 72, 72, 72, 72, 72, 
	72, 72, 72, 72, 72, 72, 73, 73, 
	73, 73, 73, 73, 73, 73, 73, 73, 
	72, 72, 72, 72, 72, 72, 72, 73, 
	73, 73, 73, 73, 73, 72, 72, 72, 
	72, 72, 72, 72, 72, 72, 72, 72, 
	72, 72, 72, 72, 72, 72, 72, 72, 
	72, 72, 72, 72, 72, 72, 72, 73, 
	73, 73, 73, 73, 73, 72, 74, 74, 
	74, 74, 74, 74, 74, 74, 74, 74, 
	74, 74, 74, 74, 74, 74, 74, 74, 
	74, 74, 74, 74, 74, 74, 74, 74, 
	74, 74, 74, 74, 74, 74, 74, 76, 
	76, 74, 76, 74, 76, 76, 74, 74, 
	76, 76, 76, 77, 76, 76, 78, 78, 
	78, 78, 78, 78, 78, 78, 78, 78, 
	76, 76, 76, 76, 76, 76, 76, 75, 
	75, 75, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 75, 75, 75, 75, 75, 
	75, 74, 76, 74, 74, 75, 76, 75, 
	75, 75, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 75, 75, 75, 75, 75, 
	75, 74, 74, 74, 76, 74, 75, 74, 
	74, 74, 74, 74, 74, 74, 74, 74, 
	74, 74, 74, 74, 74, 74, 74, 74, 
	74, 74, 74, 74, 74, 74, 74, 74, 
	74, 74, 74, 74, 74, 74, 74, 74, 
	74, 74, 74, 74, 74, 74, 74, 74, 
	74, 74, 74, 74, 74, 74, 74, 76, 
	76, 76, 76, 76, 76, 76, 76, 76, 
	76, 74, 74, 74, 74, 74, 74, 74, 
	76, 76, 76, 76, 76, 76, 76, 76, 
	76, 76, 76, 76, 76, 76, 76, 76, 
	76, 76, 76, 76, 76, 76, 76, 76, 
	76, 76, 74, 74, 74, 74, 76, 74, 
	76, 76, 76, 76, 76, 76, 76, 76, 
	76, 76, 76, 76, 76, 76, 76, 76, 
	76, 76, 76, 76, 76, 76, 76, 76, 
	76, 76, 74, 74, 74, 74, 74, 76, 
	74, 74, 74, 74, 74, 74, 74, 74, 
	74, 74, 74, 74, 74, 74, 74, 74, 
	74, 74, 74, 74, 74, 74, 74, 74, 
	74, 74, 74, 74, 74, 74, 74, 74, 
	74, 74, 74, 74, 74, 74, 74, 74, 
	74, 74, 74, 74, 74, 74, 74, 74, 
	75, 75, 75, 75, 75, 75, 75, 75, 
	75, 75, 74, 74, 74, 74, 74, 74, 
	79, 75, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 74, 74, 74, 74, 75, 
	74, 75, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 74, 74, 74, 74, 74, 
	75, 74, 74, 74, 74, 74, 74, 74, 
	74, 74, 74, 74, 74, 74, 74, 74, 
	74, 74, 74, 74, 74, 74, 74, 74, 
	74, 74, 74, 74, 74, 74, 74, 74, 
	74, 74, 74, 74, 74, 74, 74, 74, 
	74, 74, 74, 74, 74, 74, 74, 74, 
	74, 75, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 74, 74, 74, 74, 74, 
	74, 74, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 75, 74, 74, 74, 74, 
	75, 74, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 75, 74, 74, 74, 74, 
	74, 75, 80, 80, 80, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 80, 80, 
	80, 80, 80, 82, 82, 80, 82, 80, 
	82, 82, 80, 80, 82, 82, 82, 83, 
	82, 82, 84, 84, 84, 84, 84, 84, 
	84, 84, 84, 84, 82, 82, 82, 82, 
	82, 82, 82, 81, 81, 81, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 81, 
	81, 81, 81, 81, 81, 80, 82, 80, 
	80, 81, 82, 81, 81, 81, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 81, 
	81, 81, 81, 81, 81, 80, 80, 80, 
	82, 80, 81, 80, 80, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 80, 80, 
	80, 80, 80, 82, 82, 82, 82, 82, 
	82, 82, 82, 82, 82, 80, 80, 80, 
	80, 80, 80, 80, 82, 82, 82, 82, 
	82, 82, 82, 82, 82, 82, 82, 82, 
	82, 82, 82, 82, 82, 82, 82, 82, 
	82, 82, 82, 82, 82, 82, 80, 80, 
	80, 80, 82, 80, 82, 82, 82, 82, 
	82, 82, 82, 82, 82, 82, 82, 82, 
	82, 82, 82, 82, 82, 82, 82, 82, 
	82, 82, 82, 82, 82, 82, 80, 80, 
	80, 80, 80, 82, 80, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 80, 80, 
	80, 80, 80, 80, 81, 81, 81, 81, 
	81, 81, 81, 81, 81, 81, 80, 80, 
	80, 80, 80, 80, 85, 81, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 80, 
	80, 80, 80, 81, 80, 81, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 80, 
	80, 80, 80, 80, 81, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 80, 80, 
	80, 80, 80, 80, 80, 81, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 80, 
	80, 80, 80, 80, 80, 80, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 81, 
	80, 80, 80, 80, 81, 80, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 81, 
	80, 80, 80, 80, 80, 81, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 87, 
	87, 88, 87, 88, 87, 87, 88, 88, 
	87, 87, 87, 89, 87, 87, 90, 90, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	87, 87, 87, 87, 87, 87, 87, 86, 
	86, 86, 86, 86, 86, 86, 86, 86, 
	86, 86, 86, 86, 86, 86, 86, 86, 
	86, 86, 86, 86, 86, 86, 86, 86, 
	86, 88, 87, 88, 88, 86, 87, 86, 
	86, 86, 86, 86, 86, 86, 86, 86, 
	86, 86, 86, 86, 86, 86, 86, 86, 
	86, 86, 86, 86, 86, 86, 86, 86, 
	86, 88, 88, 88, 87, 88, 86, 88, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 87, 
	87, 87, 87, 87, 87, 87, 87, 87, 
	87, 88, 88, 88, 88, 88, 88, 88, 
	87, 87, 87, 87, 87, 87, 87, 87, 
	87, 87, 87, 87, 87, 87, 87, 87, 
	87, 87, 87, 87, 87, 87, 87, 87, 
	87, 87, 88, 88, 88, 88, 87, 88, 
	87, 87, 87, 87, 87, 87, 87, 87, 
	87, 87, 87, 87, 87, 87, 87, 87, 
	87, 87, 87, 87, 87, 87, 87, 87, 
	87, 87, 88, 88, 88, 88, 88, 87, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	91, 91, 91, 91, 91, 91, 91, 91, 
	91, 91, 88, 88, 88, 88, 88, 88, 
	92, 91, 91, 91, 91, 91, 91, 91, 
	91, 91, 91, 91, 91, 91, 91, 91, 
	91, 91, 91, 91, 91, 91, 91, 91, 
	91, 91, 91, 88, 88, 88, 88, 91, 
	88, 91, 91, 91, 91, 91, 91, 91, 
	91, 91, 91, 91, 91, 91, 91, 91, 
	91, 91, 91, 91, 91, 91, 91, 91, 
	91, 91, 91, 88, 88, 88, 88, 88, 
	91, 88, 88, 88, 88, 88, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	88, 93, 93, 93, 93, 93, 93, 93, 
	93, 93, 93, 88, 88, 88, 88, 88, 
	88, 88, 93, 93, 93, 93, 93, 93, 
	93, 93, 93, 93, 93, 93, 93, 93, 
	93, 93, 93, 93, 93, 93, 93, 93, 
	93, 93, 93, 93, 88, 88, 88, 88, 
	93, 88, 93, 93, 93, 93, 93, 93, 
	93, 93, 93, 93, 93, 93, 93, 93, 
	93, 93, 93, 93, 93, 93, 93, 93, 
	93, 93, 93, 93, 88, 88, 88, 88, 
	88, 93, 94, 94, 94, 94, 94, 94, 
	94, 94, 94, 94, 94, 94, 94, 94, 
	94, 94, 94, 94, 94, 94, 94, 94, 
	94, 94, 94, 94, 94, 94, 94, 94, 
	94, 94, 94, 94, 94, 94, 94, 94, 
	94, 94, 94, 94, 94, 94, 94, 94, 
	94, 94, 95, 95, 95, 95, 95, 95, 
	95, 95, 95, 95, 94, 94, 94, 94, 
	94, 94, 94, 95, 95, 95, 95, 95, 
	95, 95, 95, 95, 95, 95, 95, 95, 
	95, 95, 95, 95, 95, 95, 95, 95, 
	95, 95, 95, 95, 95, 94, 94, 94, 
	94, 95, 94, 95, 95, 95, 95, 95, 
	95, 95, 95, 95, 95, 95, 95, 95, 
	95, 95, 95, 95, 95, 95, 95, 95, 
	95, 95, 95, 95, 95, 94, 94, 94, 
	94, 94, 95, 96, 97, 97, 97, 96, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 96, 97, 98, 
	98, 98, 98, 98, 98, 98, 98, 98, 
	98, 98, 98, 98, 98, 98, 98, 98, 
	98, 98, 98, 98, 98, 98, 98, 98, 
	98, 98, 98, 98, 98, 98, 98, 98, 
	100, 98, 98, 98, 98, 98, 98, 98, 
	98, 98, 98, 98, 98, 98, 98, 99, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	99, 101, 98, 98, 98, 98, 100, 98, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	99, 99, 98, 98, 98, 98, 99, 98, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	99, 99, 98, 98, 98, 98, 98, 99, 
	101, 98, 98, 102, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 105, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 106, 103, 
	103, 103, 103, 105, 103, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 103, 
	103, 103, 103, 104, 103, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 103, 
	103, 103, 103, 103, 104, 106, 103, 108, 
	107, 109, 107, 110, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 112, 107, 
	112, 112, 112, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 112, 107, 107, 
	107, 107, 113, 114, 107, 115, 107, 116, 
	117, 118, 119, 120, 113, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 121, 
	107, 122, 118, 123, 124, 107, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	125, 126, 118, 127, 111, 107, 111, 111, 
	111, 111, 111, 111, 111, 111, 128, 111, 
	111, 111, 111, 111, 111, 111, 111, 129, 
	111, 111, 130, 111, 131, 111, 111, 111, 
	132, 133, 107, 127, 107, 111, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 134, 
	107, 134, 134, 134, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 134, 107, 
	107, 107, 107, 135, 136, 107, 137, 107, 
	138, 139, 140, 141, 142, 135, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	143, 107, 144, 140, 145, 146, 107, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 147, 148, 140, 109, 104, 107, 104, 
	104, 104, 104, 104, 104, 104, 104, 149, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	150, 104, 104, 151, 104, 152, 104, 104, 
	104, 153, 154, 107, 109, 107, 104, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	105, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 106, 107, 107, 107, 107, 105, 107, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 107, 107, 107, 107, 104, 107, 
	104, 104, 104, 104, 104, 155, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 107, 107, 107, 107, 107, 104, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 105, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 106, 107, 107, 107, 107, 105, 
	107, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 107, 107, 107, 107, 104, 
	107, 104, 104, 104, 104, 156, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 107, 107, 107, 107, 107, 
	104, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 105, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 106, 107, 107, 107, 107, 
	105, 107, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 107, 107, 107, 107, 
	104, 107, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 157, 104, 104, 104, 
	104, 104, 104, 104, 107, 107, 107, 107, 
	107, 104, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 105, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 106, 107, 107, 107, 
	107, 105, 107, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 107, 107, 107, 
	107, 104, 107, 104, 104, 158, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 107, 107, 107, 
	107, 107, 104, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 105, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 106, 107, 107, 
	107, 107, 105, 107, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 107, 107, 
	107, 107, 104, 107, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	159, 104, 104, 104, 104, 104, 107, 107, 
	107, 107, 107, 104, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 105, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 106, 107, 
	107, 107, 107, 105, 107, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 107, 
	107, 107, 107, 104, 107, 104, 104, 104, 
	104, 155, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 107, 
	107, 107, 107, 107, 104, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 105, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 106, 
	107, 107, 107, 107, 105, 107, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	107, 107, 107, 107, 104, 107, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 160, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	107, 107, 107, 107, 107, 104, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 105, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	106, 107, 107, 107, 107, 105, 107, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 107, 107, 107, 107, 104, 107, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 161, 104, 104, 104, 104, 104, 
	104, 104, 162, 104, 104, 104, 104, 104, 
	104, 107, 107, 107, 107, 107, 104, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	105, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 106, 107, 107, 107, 107, 105, 107, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 107, 107, 107, 107, 104, 107, 
	104, 104, 104, 104, 163, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 107, 107, 107, 107, 107, 104, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 105, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 106, 107, 107, 107, 107, 105, 
	107, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 107, 107, 107, 107, 104, 
	107, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 164, 104, 104, 104, 104, 
	104, 104, 104, 107, 107, 107, 107, 107, 
	104, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 105, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 106, 107, 107, 107, 107, 
	105, 107, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 107, 107, 107, 107, 
	104, 107, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 155, 104, 104, 104, 
	104, 104, 104, 104, 107, 107, 107, 107, 
	107, 104, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 105, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 106, 107, 107, 107, 
	107, 105, 107, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 107, 107, 107, 
	107, 104, 107, 104, 104, 104, 104, 104, 
	104, 104, 104, 165, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 107, 107, 107, 
	107, 107, 104, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 105, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 106, 107, 107, 
	107, 107, 105, 107, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 107, 107, 
	107, 107, 104, 107, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 155, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 107, 107, 
	107, 107, 107, 104, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 105, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 106, 107, 
	107, 107, 107, 105, 107, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 107, 
	107, 107, 107, 104, 107, 104, 104, 104, 
	104, 104, 104, 104, 166, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 107, 
	107, 107, 107, 107, 104, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 105, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 106, 
	107, 107, 107, 107, 105, 107, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	107, 107, 107, 107, 104, 107, 104, 104, 
	104, 104, 104, 104, 104, 104, 167, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	107, 107, 107, 107, 107, 104, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 105, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	106, 107, 107, 107, 107, 105, 107, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 107, 107, 107, 107, 104, 107, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 159, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 107, 107, 107, 107, 107, 104, 169, 
	168, 170, 168, 171, 168, 140, 168, 172, 
	168, 168, 168, 168, 168, 168, 168, 173, 
	168, 174, 168, 175, 168, 140, 168, 176, 
	168, 140, 168, 177, 168, 171, 168, 179, 
	178, 180, 180, 180, 180, 180, 180, 180, 
	180, 180, 182, 180, 182, 182, 182, 180, 
	180, 180, 180, 180, 180, 180, 180, 180, 
	180, 180, 180, 180, 180, 180, 180, 180, 
	180, 182, 180, 180, 180, 180, 180, 180, 
	180, 183, 180, 180, 180, 180, 180, 180, 
	180, 180, 180, 180, 180, 180, 180, 180, 
	180, 180, 180, 180, 180, 180, 180, 180, 
	180, 180, 181, 181, 181, 181, 181, 181, 
	181, 181, 181, 181, 181, 181, 181, 181, 
	181, 181, 181, 181, 181, 181, 181, 181, 
	181, 181, 181, 181, 180, 184, 180, 180, 
	181, 180, 181, 181, 181, 185, 181, 181, 
	181, 181, 181, 181, 181, 181, 181, 181, 
	181, 181, 181, 181, 181, 181, 181, 181, 
	181, 181, 181, 181, 180, 180, 180, 180, 
	180, 181, 186, 180, 180, 180, 180, 180, 
	180, 180, 180, 180, 180, 188, 180, 188, 
	188, 188, 180, 180, 180, 180, 180, 180, 
	180, 180, 180, 180, 180, 180, 180, 180, 
	180, 180, 180, 180, 188, 180, 180, 180, 
	180, 180, 180, 180, 189, 180, 180, 180, 
	180, 180, 180, 180, 180, 180, 180, 180, 
	180, 180, 180, 180, 180, 180, 180, 180, 
	180, 180, 180, 180, 180, 187, 187, 187, 
	187, 187, 187, 187, 187, 187, 187, 187, 
	187, 187, 187, 187, 187, 187, 187, 187, 
	187, 187, 187, 187, 187, 187, 187, 180, 
	190, 180, 180, 187, 180, 187, 187, 187, 
	191, 187, 187, 187, 187, 187, 187, 187, 
	187, 187, 187, 187, 187, 187, 187, 187, 
	187, 187, 187, 187, 187, 187, 187, 180, 
	180, 180, 180, 180, 187, 193, 192, 193, 
	193, 193, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 193, 192, 192, 192, 
	192, 192, 192, 192, 194, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	195, 192, 196, 192, 197, 192, 197, 197, 
	197, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 197, 192, 192, 192, 192, 
	192, 192, 192, 198, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 199, 
	192, 200, 201, 203, 202, 204, 202, 205, 
	202, 206, 202, 207, 202, 208, 209, 209, 
	209, 208, 209, 209, 209, 209, 209, 209, 
	209, 209, 209, 209, 209, 209, 209, 209, 
	209, 209, 209, 209, 209, 209, 209, 208, 
	209, 209, 209, 209, 209, 209, 209, 209, 
	209, 209, 209, 209, 209, 209, 209, 209, 
	209, 209, 209, 209, 209, 209, 209, 209, 
	209, 209, 209, 209, 209, 209, 209, 209, 
	209, 209, 209, 209, 209, 209, 210, 210, 
	210, 210, 210, 210, 210, 210, 210, 210, 
	210, 210, 210, 210, 210, 210, 210, 210, 
	210, 210, 210, 210, 210, 210, 210, 210, 
	209, 209, 209, 209, 209, 209, 210, 210, 
	210, 210, 210, 210, 210, 210, 210, 210, 
	210, 210, 210, 210, 210, 210, 210, 210, 
	210, 210, 210, 210, 210, 210, 210, 210, 
	209, 211, 200, 212, 213, 212, 212, 212, 
	200, 200, 200, 200, 200, 200, 200, 200, 
	200, 200, 200, 200, 200, 200, 200, 200, 
	200, 200, 212, 200, 200, 214, 200, 200, 
	200, 200, 200, 200, 200, 200, 200, 200, 
	200, 200, 215, 215, 215, 215, 215, 215, 
	215, 215, 215, 215, 200, 200, 200, 200, 
	200, 200, 200, 200, 200, 200, 200, 200, 
	200, 200, 200, 200, 200, 200, 200, 200, 
	200, 200, 200, 200, 200, 200, 200, 200, 
	200, 200, 200, 200, 200, 200, 216, 200, 
	217, 218, 217, 217, 217, 200, 200, 200, 
	200, 200, 200, 200, 200, 200, 200, 200, 
	200, 200, 200, 200, 200, 200, 200, 217, 
	200, 200, 219, 200, 200, 200, 200, 200, 
	200, 200, 200, 200, 200, 200, 200, 220, 
	220, 220, 220, 220, 220, 220, 220, 220, 
	220, 200, 200, 200, 200, 200, 200, 200, 
	200, 200, 200, 200, 200, 200, 200, 200, 
	200, 200, 200, 200, 200, 200, 200, 200, 
	200, 200, 200, 200, 200, 200, 200, 200, 
	200, 200, 200, 221, 200, 223, 224, 223, 
	223, 223, 222, 222, 222, 222, 222, 222, 
	222, 222, 222, 222, 222, 222, 222, 222, 
	222, 222, 222, 222, 223, 222, 222, 225, 
	222, 222, 222, 222, 222, 222, 222, 222, 
	222, 222, 222, 222, 226, 226, 226, 226, 
	226, 226, 226, 226, 226, 226, 222, 222, 
	222, 222, 222, 222, 222, 222, 222, 222, 
	222, 222, 222, 222, 222, 222, 222, 222, 
	222, 222, 222, 222, 222, 222, 222, 222, 
	222, 222, 222, 222, 222, 222, 222, 222, 
	227, 222, 229, 230, 229, 229, 229, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 229, 228, 228, 231, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 232, 232, 232, 232, 232, 232, 232, 
	232, 232, 232, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 233, 228, 229, 
	234, 229, 229, 229, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 229, 228, 
	228, 231, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 232, 232, 
	232, 232, 232, 232, 232, 232, 232, 232, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 233, 228, 213, 200, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 237, 
	237, 235, 237, 235, 237, 237, 235, 235, 
	237, 237, 237, 238, 237, 237, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	237, 237, 237, 237, 237, 237, 237, 236, 
	236, 236, 236, 236, 236, 236, 236, 236, 
	236, 236, 236, 236, 236, 236, 236, 236, 
	236, 236, 236, 236, 236, 236, 236, 236, 
	236, 235, 237, 235, 235, 236, 237, 236, 
	236, 236, 236, 236, 236, 236, 236, 236, 
	236, 236, 236, 236, 236, 236, 236, 236, 
	236, 236, 236, 236, 236, 236, 236, 236, 
	236, 235, 235, 235, 237, 235, 236, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 237, 
	237, 237, 237, 237, 237, 237, 237, 237, 
	237, 235, 235, 235, 235, 235, 235, 235, 
	237, 237, 237, 237, 237, 237, 237, 237, 
	237, 237, 237, 237, 237, 237, 237, 237, 
	237, 237, 237, 237, 237, 237, 237, 237, 
	237, 237, 235, 235, 235, 235, 237, 235, 
	237, 237, 237, 237, 237, 237, 237, 237, 
	237, 237, 237, 237, 237, 237, 237, 237, 
	237, 237, 237, 237, 237, 237, 237, 237, 
	237, 237, 235, 235, 235, 235, 235, 237, 
	240, 237, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 237, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 241, 236, 236, 236, 236, 
	236, 236, 236, 236, 236, 236, 236, 236, 
	236, 236, 236, 236, 236, 236, 236, 236, 
	236, 236, 236, 236, 236, 236, 235, 235, 
	235, 235, 236, 235, 236, 236, 236, 236, 
	236, 236, 236, 236, 236, 236, 236, 236, 
	236, 236, 236, 236, 236, 236, 236, 236, 
	236, 236, 236, 236, 236, 236, 235, 235, 
	235, 235, 235, 236, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 236, 236, 236, 
	236, 236, 236, 236, 236, 236, 236, 236, 
	236, 236, 236, 236, 236, 236, 236, 236, 
	236, 236, 236, 236, 236, 236, 236, 235, 
	235, 235, 235, 236, 235, 236, 236, 236, 
	236, 236, 236, 236, 236, 236, 236, 236, 
	236, 236, 236, 236, 236, 236, 236, 236, 
	236, 236, 236, 236, 236, 236, 236, 235, 
	235, 235, 235, 235, 236, 240, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 243, 235, 235, 235, 235, 244, 235, 
	235, 235, 235, 235, 245, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 211, 235, 235, 235, 
	242, 242, 242, 242, 242, 242, 242, 242, 
	242, 242, 242, 242, 242, 242, 242, 242, 
	242, 242, 242, 242, 242, 242, 242, 242, 
	242, 242, 235, 235, 235, 235, 242, 246, 
	242, 242, 242, 242, 242, 242, 242, 242, 
	242, 242, 242, 242, 242, 242, 242, 242, 
	242, 242, 242, 242, 242, 242, 242, 242, 
	242, 242, 235, 235, 235, 245, 235, 242, 
	248, 248, 248, 248, 248, 248, 248, 248, 
	248, 248, 249, 248, 248, 248, 248, 248, 
	248, 248, 248, 248, 248, 248, 248, 248, 
	248, 248, 248, 248, 248, 248, 248, 248, 
	248, 248, 248, 248, 248, 248, 248, 248, 
	248, 248, 248, 248, 248, 248, 248, 248, 
	247, 247, 247, 247, 247, 247, 247, 247, 
	247, 247, 248, 248, 248, 248, 248, 248, 
	248, 247, 247, 247, 247, 247, 247, 247, 
	247, 247, 247, 247, 247, 247, 247, 247, 
	247, 247, 247, 247, 247, 247, 247, 247, 
	247, 247, 247, 248, 248, 248, 248, 247, 
	248, 247, 247, 247, 247, 247, 247, 247, 
	247, 247, 247, 247, 247, 247, 247, 247, 
	247, 247, 247, 247, 247, 247, 247, 247, 
	247, 247, 247, 248, 248, 248, 248, 248, 
	247, 251, 250, 252, 243, 249, 248, 252, 
	244, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 243, 235, 235, 235, 235, 
	244, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 242, 242, 242, 242, 242, 242, 
	242, 242, 242, 242, 242, 242, 242, 242, 
	242, 242, 242, 242, 242, 242, 242, 242, 
	242, 242, 242, 242, 235, 235, 235, 235, 
	242, 246, 242, 242, 242, 242, 242, 242, 
	242, 242, 242, 242, 242, 242, 242, 242, 
	242, 242, 242, 242, 242, 242, 242, 242, 
	242, 242, 242, 242, 235, 235, 235, 235, 
	235, 242, 252, 246, 253, 254, 254, 254, 
	253, 254, 254, 254, 254, 254, 254, 254, 
	254, 254, 254, 254, 254, 254, 254, 254, 
	254, 254, 254, 254, 254, 254, 253, 254, 
	254, 254, 254, 254, 254, 254, 254, 254, 
	254, 254, 254, 254, 254, 254, 254, 254, 
	254, 255, 254, 253, 256, 256, 256, 253, 
	256, 256, 256, 256, 256, 257, 256, 256, 
	256, 256, 256, 256, 256, 256, 256, 256, 
	256, 256, 256, 256, 256, 253, 256, 256, 
	256, 256, 256, 256, 256, 256, 256, 256, 
	256, 256, 256, 256, 256, 256, 256, 256, 
	256, 256, 256, 256, 256, 256, 256, 256, 
	256, 256, 256, 256, 256, 256, 256, 256, 
	256, 256, 256, 256, 256, 256, 256, 256, 
	256, 256, 256, 256, 256, 256, 256, 256, 
	258, 256, 253, 256, 256, 256, 253, 256, 
	256, 256, 256, 256, 256, 256, 256, 256, 
	256, 256, 256, 256, 256, 256, 256, 256, 
	256, 256, 256, 256, 253, 256, 256, 256, 
	256, 256, 256, 256, 256, 256, 256, 256, 
	256, 256, 256, 256, 256, 256, 256, 256, 
	256, 256, 256, 256, 256, 256, 256, 256, 
	256, 256, 256, 256, 256, 256, 256, 256, 
	256, 256, 256, 256, 256, 256, 256, 256, 
	256, 256, 256, 256, 256, 256, 256, 259, 
	256, 253, 260, 260, 260, 253, 260, 260, 
	260, 260, 260, 260, 260, 260, 260, 260, 
	260, 260, 260, 260, 260, 260, 260, 260, 
	260, 260, 260, 253, 260, 260, 260, 260, 
	260, 260, 260, 260, 260, 260, 260, 260, 
	260, 260, 260, 260, 260, 260, 260, 260, 
	260, 260, 260, 260, 260, 260, 260, 260, 
	260, 260, 260, 260, 260, 260, 260, 260, 
	261, 260, 260, 260, 260, 260, 260, 260, 
	260, 260, 260, 260, 260, 260, 260, 260, 
	260, 260, 260, 260, 260, 260, 260, 260, 
	260, 260, 260, 260, 260, 262, 260, 253, 
	263, 263, 263, 253, 263, 263, 263, 263, 
	263, 264, 263, 263, 263, 263, 263, 263, 
	263, 263, 263, 263, 263, 263, 263, 263, 
	263, 253, 263, 253, 263, 263, 263, 253, 
	263, 263, 263, 263, 263, 263, 263, 263, 
	263, 263, 263, 263, 263, 263, 263, 263, 
	263, 263, 263, 263, 263, 253, 263, 253, 
	254, 254, 254, 253, 254, 254, 254, 254, 
	254, 254, 254, 254, 254, 254, 254, 254, 
	254, 254, 254, 254, 254, 254, 254, 254, 
	254, 253, 254, 254, 254, 254, 254, 254, 
	254, 254, 254, 254, 254, 254, 254, 254, 
	254, 254, 254, 254, 265, 254, 253, 266, 
	266, 266, 253, 266, 266, 266, 266, 266, 
	267, 266, 266, 266, 266, 266, 266, 266, 
	266, 266, 266, 266, 266, 266, 266, 266, 
	253, 266, 266, 266, 266, 266, 266, 266, 
	266, 266, 266, 266, 266, 266, 266, 266, 
	266, 266, 266, 266, 266, 266, 266, 266, 
	266, 266, 266, 266, 266, 266, 266, 266, 
	266, 266, 266, 266, 266, 266, 266, 266, 
	266, 268, 266, 266, 266, 266, 266, 266, 
	266, 266, 266, 266, 266, 266, 266, 266, 
	266, 266, 266, 266, 266, 266, 266, 266, 
	266, 266, 269, 266, 266, 266, 266, 266, 
	266, 270, 266, 253, 266, 266, 266, 253, 
	266, 266, 266, 266, 266, 266, 266, 266, 
	266, 266, 266, 266, 266, 266, 266, 266, 
	266, 266, 266, 266, 266, 253, 266, 271, 
	253, 253, 253, 253, 253, 253, 253, 253, 
	253, 253, 253, 253, 253, 253, 253, 253, 
	253, 253, 253, 253, 253, 253, 253, 253, 
	253, 253, 253, 253, 253, 253, 253, 272, 
	253, 272, 253, 253, 273, 273, 273, 253, 
	273, 273, 273, 273, 273, 273, 273, 273, 
	273, 273, 273, 273, 273, 273, 273, 273, 
	273, 273, 273, 273, 273, 253, 273, 273, 
	273, 273, 273, 273, 273, 273, 273, 273, 
	273, 273, 273, 273, 273, 273, 273, 273, 
	273, 273, 273, 273, 273, 273, 273, 273, 
	273, 273, 273, 273, 273, 273, 273, 273, 
	273, 273, 274, 273, 273, 273, 273, 273, 
	273, 273, 273, 273, 273, 273, 273, 273, 
	273, 273, 273, 273, 273, 273, 273, 273, 
	273, 273, 273, 273, 273, 273, 273, 275, 
	273, 253, 256, 256, 256, 253, 256, 256, 
	256, 256, 256, 257, 256, 256, 256, 256, 
	256, 256, 256, 256, 256, 256, 256, 256, 
	256, 256, 256, 253, 256, 256, 256, 256, 
	256, 256, 256, 256, 256, 256, 256, 256, 
	256, 256, 256, 256, 256, 256, 256, 256, 
	256, 256, 256, 256, 256, 256, 256, 256, 
	256, 256, 256, 256, 256, 256, 256, 256, 
	256, 256, 256, 256, 256, 256, 256, 256, 
	256, 256, 256, 256, 256, 256, 259, 256, 
	253, 276, 276, 276, 253, 276, 276, 276, 
	276, 276, 276, 276, 276, 276, 276, 276, 
	276, 276, 276, 276, 276, 276, 276, 276, 
	276, 276, 253, 276, 276, 276, 276, 276, 
	276, 276, 276, 276, 276, 276, 276, 276, 
	276, 276, 276, 276, 276, 276, 276, 276, 
	277, 277, 277, 277, 277, 277, 277, 277, 
	277, 277, 276, 276, 276, 276, 276, 276, 
	276, 277, 277, 277, 277, 277, 277, 276, 
	276, 276, 276, 276, 276, 276, 276, 276, 
	276, 276, 276, 276, 276, 276, 276, 276, 
	276, 276, 276, 276, 276, 276, 276, 276, 
	276, 277, 277, 277, 277, 277, 277, 276, 
	200, 200, 200, 200, 200, 200, 200, 200, 
	200, 200, 200, 200, 200, 200, 200, 200, 
	200, 200, 200, 200, 200, 200, 200, 200, 
	200, 200, 200, 200, 200, 200, 200, 200, 
	200, 279, 200, 200, 200, 200, 200, 200, 
	200, 200, 200, 200, 200, 200, 200, 200, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 280, 200, 200, 281, 200, 279, 
	200, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 200, 200, 200, 200, 278, 
	200, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 200, 200, 200, 200, 200, 
	278, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 279, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 280, 235, 235, 281, 235, 
	279, 235, 278, 278, 278, 278, 278, 278, 
	282, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 235, 235, 235, 235, 
	278, 235, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 235, 235, 235, 235, 
	235, 278, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 279, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 280, 235, 235, 281, 
	235, 279, 235, 278, 278, 278, 278, 278, 
	278, 278, 278, 283, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 235, 235, 235, 
	235, 278, 235, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 235, 235, 235, 
	235, 235, 278, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 279, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 280, 235, 235, 
	281, 235, 279, 235, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 284, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 235, 235, 
	235, 235, 278, 235, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 235, 235, 
	235, 235, 235, 278, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 279, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 280, 235, 
	235, 281, 235, 279, 235, 278, 278, 278, 
	284, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 235, 
	235, 235, 235, 278, 235, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 235, 
	235, 235, 235, 235, 278, 285, 285, 285, 
	285, 285, 285, 285, 285, 285, 285, 285, 
	285, 285, 285, 285, 285, 285, 285, 285, 
	285, 285, 285, 285, 285, 285, 285, 285, 
	285, 285, 285, 285, 285, 285, 287, 285, 
	285, 285, 285, 285, 285, 285, 285, 285, 
	285, 285, 285, 285, 285, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 288, 
	285, 285, 285, 285, 287, 285, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	285, 285, 285, 285, 286, 285, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	285, 285, 285, 285, 285, 286, 288, 285, 
	285, 289, 290, 290, 290, 290, 290, 290, 
	290, 290, 290, 290, 290, 290, 290, 290, 
	290, 290, 290, 290, 290, 290, 290, 290, 
	290, 290, 290, 290, 290, 290, 290, 290, 
	290, 290, 290, 290, 290, 290, 290, 290, 
	290, 290, 290, 290, 290, 290, 290, 290, 
	290, 290, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 290, 290, 290, 290, 
	290, 290, 290, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 290, 290, 290, 
	290, 291, 290, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 290, 290, 290, 
	290, 290, 291, 293, 292, 293, 292, 292, 
	294, 294, 294, 294, 294, 294, 294, 294, 
	294, 294, 292, 294, 294, 294, 294, 294, 
	294, 294, 294, 294, 294, 292, 295, 295, 
	295, 295, 295, 295, 295, 295, 295, 295, 
	292, 297, 297, 297, 297, 297, 297, 297, 
	297, 297, 297, 296, 298, 298, 298, 298, 
	298, 298, 298, 298, 298, 298, 296, 300, 
	299, 301, 299, 302, 299, 303, 299, 305, 
	304, 306, 304, 307, 304, 290, 290, 290, 
	290, 290, 290, 290, 290, 290, 290, 290, 
	290, 290, 290, 290, 290, 290, 290, 290, 
	290, 290, 290, 290, 290, 290, 290, 290, 
	290, 290, 290, 290, 290, 290, 290, 290, 
	290, 290, 290, 290, 290, 290, 290, 290, 
	290, 290, 290, 290, 290, 308, 308, 308, 
	308, 308, 308, 308, 308, 308, 308, 290, 
	290, 290, 290, 290, 290, 290, 308, 308, 
	308, 308, 308, 308, 308, 308, 308, 308, 
	308, 308, 308, 308, 308, 308, 308, 308, 
	308, 308, 308, 308, 308, 308, 308, 308, 
	290, 290, 290, 290, 308, 290, 308, 308, 
	308, 308, 308, 308, 308, 308, 308, 308, 
	308, 308, 308, 308, 308, 308, 308, 308, 
	308, 308, 308, 308, 308, 308, 308, 308, 
	290, 290, 290, 290, 290, 308, 309, 296, 
	310, 311, 310, 310, 310, 296, 296, 296, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	296, 296, 296, 296, 296, 296, 296, 310, 
	296, 296, 312, 296, 296, 296, 296, 296, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	296, 296, 296, 313, 296, 296, 296, 296, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	296, 296, 296, 314, 296, 315, 316, 315, 
	315, 315, 296, 296, 296, 296, 296, 296, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	296, 296, 296, 296, 315, 296, 296, 317, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	318, 296, 296, 296, 296, 296, 296, 296, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	319, 296, 321, 322, 321, 321, 321, 320, 
	320, 320, 320, 320, 320, 320, 320, 320, 
	320, 320, 320, 320, 320, 320, 320, 320, 
	320, 321, 320, 320, 323, 320, 320, 320, 
	320, 320, 320, 320, 320, 320, 320, 320, 
	320, 320, 320, 320, 320, 320, 320, 320, 
	320, 320, 320, 320, 320, 324, 320, 320, 
	320, 320, 320, 320, 320, 320, 320, 320, 
	320, 320, 320, 320, 320, 320, 320, 320, 
	320, 320, 320, 320, 320, 320, 320, 320, 
	320, 320, 320, 320, 320, 325, 320, 327, 
	328, 327, 327, 327, 326, 326, 326, 326, 
	326, 326, 326, 326, 326, 326, 326, 326, 
	326, 326, 326, 326, 326, 326, 327, 326, 
	326, 329, 326, 326, 326, 326, 326, 326, 
	326, 326, 326, 326, 326, 326, 326, 326, 
	326, 326, 326, 326, 326, 326, 326, 326, 
	326, 326, 330, 326, 326, 326, 326, 326, 
	326, 326, 326, 326, 326, 326, 326, 326, 
	326, 326, 326, 326, 326, 326, 326, 326, 
	326, 326, 326, 326, 326, 326, 326, 326, 
	326, 326, 331, 326, 327, 328, 327, 327, 
	327, 326, 326, 326, 326, 326, 326, 326, 
	326, 326, 326, 326, 326, 326, 326, 326, 
	326, 326, 326, 327, 326, 326, 329, 326, 
	326, 326, 326, 326, 326, 326, 326, 326, 
	326, 326, 326, 326, 326, 326, 326, 326, 
	326, 326, 326, 326, 326, 326, 326, 332, 
	326, 326, 326, 326, 326, 326, 326, 326, 
	326, 326, 326, 326, 326, 326, 326, 326, 
	326, 326, 326, 326, 326, 326, 326, 326, 
	326, 326, 326, 326, 326, 326, 326, 331, 
	326, 327, 333, 327, 327, 327, 326, 326, 
	326, 326, 326, 326, 326, 326, 326, 326, 
	326, 326, 326, 326, 326, 326, 326, 326, 
	327, 326, 326, 329, 326, 326, 326, 326, 
	326, 326, 326, 326, 326, 326, 326, 326, 
	326, 326, 326, 326, 326, 326, 326, 326, 
	326, 326, 326, 326, 330, 326, 326, 326, 
	326, 326, 326, 326, 326, 326, 326, 326, 
	326, 326, 326, 326, 326, 326, 326, 326, 
	326, 326, 326, 326, 326, 326, 326, 326, 
	326, 326, 326, 326, 331, 326, 334, 296, 
	311, 296, 336, 335, 336, 336, 336, 335, 
	335, 335, 335, 335, 335, 335, 335, 335, 
	335, 335, 335, 335, 335, 335, 335, 335, 
	335, 336, 335, 335, 335, 335, 335, 337, 
	335, 335, 335, 335, 335, 335, 335, 338, 
	335, 339, 335, 341, 340, 340, 340, 341, 
	340, 340, 340, 340, 342, 343, 342, 342, 
	342, 340, 340, 340, 340, 340, 340, 340, 
	340, 340, 340, 340, 340, 341, 340, 340, 
	340, 340, 340, 342, 340, 340, 344, 340, 
	340, 340, 340, 340, 340, 340, 340, 340, 
	340, 340, 340, 340, 340, 340, 340, 340, 
	340, 340, 340, 340, 340, 340, 340, 340, 
	345, 340, 340, 340, 340, 340, 340, 340, 
	340, 340, 340, 340, 340, 340, 340, 340, 
	340, 340, 340, 340, 340, 340, 340, 340, 
	340, 340, 340, 340, 340, 340, 340, 346, 
	340, 340, 347, 340, 342, 348, 342, 342, 
	342, 348, 348, 348, 348, 348, 348, 348, 
	348, 348, 348, 348, 348, 348, 348, 348, 
	348, 348, 348, 342, 348, 349, 350, 351, 
	352, 353, 355, 354, 357, 358, 357, 357, 
	357, 356, 356, 356, 356, 356, 356, 356, 
	356, 356, 356, 356, 356, 356, 356, 356, 
	356, 356, 356, 357, 356, 343, 354, 359, 
	354, 361, 360, 360, 360, 361, 360, 360, 
	360, 360, 362, 363, 362, 362, 362, 360, 
	360, 360, 360, 360, 360, 360, 360, 360, 
	360, 360, 360, 361, 360, 360, 360, 360, 
	360, 362, 360, 360, 364, 360, 360, 360, 
	360, 360, 360, 360, 360, 360, 360, 360, 
	360, 360, 360, 360, 360, 360, 360, 360, 
	360, 360, 360, 360, 360, 360, 360, 360, 
	360, 360, 360, 360, 360, 360, 360, 360, 
	360, 360, 360, 360, 360, 360, 360, 360, 
	360, 360, 360, 360, 360, 360, 360, 360, 
	360, 360, 360, 360, 360, 365, 360, 362, 
	366, 362, 362, 362, 366, 366, 366, 366, 
	366, 366, 366, 366, 366, 366, 366, 366, 
	366, 366, 366, 366, 366, 366, 362, 366, 
	368, 367, 367, 367, 367, 367, 367, 367, 
	367, 367, 367, 367, 367, 367, 367, 367, 
	367, 367, 367, 367, 367, 367, 367, 367, 
	367, 367, 367, 367, 369, 367, 367, 367, 
	367, 367, 367, 367, 367, 367, 367, 367, 
	367, 367, 367, 367, 367, 367, 367, 367, 
	367, 367, 367, 367, 367, 367, 367, 367, 
	367, 367, 367, 367, 367, 367, 367, 367, 
	367, 367, 367, 367, 367, 367, 367, 367, 
	367, 367, 367, 367, 367, 367, 367, 367, 
	367, 367, 367, 367, 367, 367, 367, 370, 
	367, 371, 371, 371, 371, 371, 371, 371, 
	371, 371, 371, 371, 371, 371, 371, 371, 
	371, 371, 371, 371, 371, 371, 371, 371, 
	371, 371, 371, 371, 371, 371, 371, 371, 
	371, 371, 371, 371, 371, 371, 371, 371, 
	371, 371, 371, 371, 371, 371, 371, 371, 
	371, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 371, 371, 371, 371, 371, 
	371, 371, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 371, 371, 371, 371, 
	13, 371, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 371, 371, 371, 371, 
	371, 13, 16, 16, 16, 16, 16, 16, 
	16, 16, 16, 16, 371, 374, 373, 373, 
	373, 374, 373, 373, 373, 373, 373, 373, 
	373, 373, 373, 373, 373, 373, 373, 373, 
	373, 373, 373, 373, 373, 373, 373, 374, 
	373, 373, 373, 373, 373, 373, 373, 373, 
	373, 373, 373, 373, 373, 373, 373, 373, 
	373, 373, 373, 373, 373, 375, 375, 375, 
	375, 375, 375, 375, 375, 373, 373, 373, 
	373, 373, 373, 373, 373, 373, 373, 373, 
	376, 373, 373, 373, 373, 373, 373, 373, 
	373, 373, 377, 373, 373, 373, 373, 373, 
	373, 373, 373, 373, 373, 373, 373, 373, 
	373, 373, 373, 373, 373, 373, 373, 373, 
	378, 373, 373, 373, 373, 373, 373, 373, 
	373, 373, 373, 373, 373, 373, 373, 373, 
	373, 373, 379, 373, 373, 380, 373, 381, 
	382, 384, 384, 384, 384, 384, 384, 384, 
	384, 383, 385, 385, 385, 385, 385, 385, 
	385, 385, 383, 383, 386, 386, 38, 38, 
	38, 386, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 386, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 38, 39, 38, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	38, 387, 38, 388, 389, 390, 390, 38, 
	38, 38, 390, 38, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	390, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 39, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 391, 38, 37, 390, 392, 393, 
	394, 394, 25, 25, 25, 394, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 394, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	26, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 395, 25, 390, 
	19, 19, 19, 390, 19, 19, 19, 19, 
	19, 19, 19, 19, 19, 19, 19, 19, 
	19, 19, 19, 19, 19, 19, 19, 19, 
	19, 390, 19, 19, 19, 19, 19, 19, 
	19, 19, 19, 19, 19, 19, 19, 19, 
	19, 19, 19, 19, 396, 19, 386, 25, 
	25, 25, 386, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	386, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 26, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 27, 25, 386, 397, 397, 397, 
	386, 397, 397, 397, 397, 397, 397, 397, 
	397, 397, 397, 397, 397, 397, 397, 397, 
	397, 397, 397, 397, 397, 397, 386, 397, 
	397, 397, 397, 397, 397, 397, 397, 397, 
	397, 397, 397, 397, 397, 397, 397, 397, 
	397, 397, 397, 397, 397, 397, 397, 397, 
	397, 397, 397, 397, 397, 397, 397, 397, 
	397, 397, 397, 397, 397, 397, 397, 397, 
	397, 397, 397, 397, 397, 397, 397, 397, 
	397, 397, 397, 397, 397, 397, 397, 397, 
	397, 397, 397, 397, 397, 397, 397, 397, 
	398, 397, 399, 400, 400, 397, 397, 397, 
	400, 397, 397, 397, 397, 397, 397, 397, 
	397, 397, 397, 397, 397, 397, 397, 397, 
	397, 397, 397, 397, 397, 397, 400, 397, 
	397, 397, 397, 397, 397, 397, 397, 397, 
	397, 397, 397, 397, 397, 397, 397, 397, 
	397, 397, 397, 397, 397, 397, 397, 397, 
	397, 397, 397, 397, 397, 397, 397, 397, 
	397, 397, 397, 397, 397, 397, 397, 397, 
	397, 397, 397, 397, 397, 397, 397, 397, 
	397, 397, 397, 397, 397, 397, 397, 397, 
	397, 397, 397, 397, 397, 397, 397, 397, 
	401, 397, 400, 19, 19, 19, 400, 19, 
	19, 19, 19, 19, 19, 19, 19, 19, 
	19, 19, 19, 19, 19, 19, 19, 19, 
	19, 19, 19, 19, 400, 19, 19, 19, 
	19, 19, 19, 19, 19, 19, 19, 19, 
	19, 19, 19, 19, 19, 19, 19, 396, 
	19, 402, 400, 400, 25, 25, 25, 400, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 400, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 26, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 27, 
	25, 404, 404, 404, 404, 404, 404, 404, 
	404, 404, 404, 403, 403, 403, 403, 403, 
	403, 403, 404, 404, 404, 404, 404, 404, 
	403, 403, 403, 403, 403, 403, 403, 403, 
	403, 403, 403, 403, 403, 403, 403, 403, 
	403, 403, 403, 403, 403, 403, 403, 403, 
	403, 403, 404, 404, 404, 404, 404, 404, 
	403, 403, 403, 403, 403, 403, 403, 403, 
	403, 403, 403, 403, 403, 403, 403, 403, 
	403, 403, 403, 403, 405, 403, 406, 406, 
	406, 406, 406, 406, 406, 406, 406, 406, 
	403, 403, 403, 403, 403, 403, 403, 406, 
	406, 406, 406, 406, 406, 403, 403, 403, 
	403, 403, 403, 403, 403, 403, 403, 403, 
	403, 403, 403, 403, 403, 403, 403, 403, 
	403, 403, 403, 403, 403, 403, 403, 406, 
	406, 406, 406, 406, 406, 403, 407, 407, 
	407, 407, 407, 407, 407, 407, 407, 407, 
	403, 403, 403, 403, 403, 403, 403, 407, 
	407, 407, 407, 407, 407, 403, 403, 403, 
	403, 403, 403, 403, 403, 403, 403, 403, 
	403, 403, 403, 403, 403, 403, 403, 403, 
	403, 403, 403, 403, 403, 403, 403, 407, 
	407, 407, 407, 407, 407, 403, 408, 408, 
	408, 408, 408, 408, 408, 408, 408, 408, 
	403, 403, 403, 403, 403, 403, 403, 408, 
	408, 408, 408, 408, 408, 403, 403, 403, 
	403, 403, 403, 403, 403, 403, 403, 403, 
	403, 403, 403, 403, 403, 403, 403, 403, 
	403, 403, 403, 403, 403, 403, 403, 408, 
	408, 408, 408, 408, 408, 403, 409, 412, 
	411, 411, 411, 412, 411, 411, 411, 411, 
	413, 411, 411, 411, 411, 411, 411, 411, 
	411, 411, 411, 411, 411, 411, 411, 411, 
	411, 412, 411, 411, 411, 411, 411, 413, 
	411, 411, 411, 411, 411, 411, 411, 411, 
	411, 411, 411, 411, 411, 411, 411, 414, 
	414, 414, 414, 414, 414, 414, 414, 414, 
	414, 411, 411, 411, 411, 411, 411, 411, 
	414, 414, 414, 414, 414, 414, 411, 411, 
	411, 411, 411, 411, 411, 411, 411, 411, 
	411, 411, 411, 411, 411, 411, 411, 411, 
	411, 411, 411, 411, 411, 411, 411, 411, 
	414, 414, 414, 414, 414, 414, 411, 411, 
	411, 411, 411, 411, 411, 411, 411, 411, 
	411, 411, 411, 411, 411, 411, 411, 411, 
	411, 411, 411, 411, 415, 411, 412, 411, 
	411, 411, 412, 411, 411, 411, 411, 410, 
	411, 411, 411, 411, 411, 411, 411, 411, 
	411, 411, 411, 411, 411, 411, 411, 411, 
	412, 411, 411, 411, 411, 411, 410, 411, 
	411, 411, 411, 411, 411, 411, 411, 411, 
	411, 411, 411, 411, 411, 411, 416, 416, 
	416, 416, 416, 416, 416, 416, 416, 416, 
	411, 411, 411, 411, 411, 411, 411, 416, 
	416, 416, 416, 416, 416, 411, 411, 411, 
	411, 411, 411, 411, 411, 411, 411, 411, 
	411, 411, 411, 411, 411, 411, 411, 411, 
	411, 411, 411, 411, 411, 411, 411, 416, 
	416, 416, 416, 416, 416, 411, 411, 411, 
	411, 411, 411, 411, 411, 411, 411, 411, 
	411, 411, 411, 411, 411, 411, 411, 411, 
	411, 411, 411, 417, 411, 410, 412, 416, 
	416, 416, 412, 416, 416, 416, 416, 410, 
	416, 416, 416, 416, 416, 416, 416, 416, 
	416, 416, 416, 416, 416, 416, 416, 416, 
	412, 416, 416, 416, 416, 416, 410, 416, 
	416, 416, 416, 416, 416, 416, 416, 416, 
	416, 416, 416, 416, 416, 416, 416, 416, 
	416, 416, 416, 416, 416, 416, 416, 416, 
	416, 416, 416, 416, 416, 416, 416, 416, 
	416, 416, 416, 416, 416, 416, 416, 416, 
	416, 416, 416, 416, 416, 416, 416, 416, 
	416, 416, 416, 416, 416, 416, 416, 416, 
	416, 416, 416, 416, 416, 416, 416, 416, 
	416, 416, 416, 416, 416, 416, 416, 416, 
	416, 416, 416, 416, 416, 416, 416, 416, 
	416, 416, 416, 416, 416, 416, 416, 416, 
	416, 416, 416, 410, 416, 418, 412, 419, 
	419, 419, 412, 419, 419, 419, 419, 413, 
	419, 419, 419, 419, 419, 419, 419, 419, 
	419, 419, 419, 419, 419, 419, 419, 419, 
	412, 419, 419, 419, 419, 419, 413, 419, 
	419, 419, 419, 419, 419, 419, 419, 419, 
	419, 419, 419, 419, 419, 419, 414, 414, 
	414, 414, 414, 414, 414, 414, 414, 414, 
	419, 419, 419, 419, 419, 419, 419, 414, 
	414, 414, 414, 414, 414, 419, 419, 419, 
	419, 419, 419, 419, 419, 419, 419, 419, 
	419, 419, 419, 419, 419, 419, 419, 419, 
	419, 419, 419, 419, 419, 419, 419, 414, 
	414, 414, 414, 414, 414, 419, 419, 419, 
	419, 419, 419, 419, 419, 419, 419, 419, 
	419, 419, 419, 419, 419, 419, 419, 419, 
	419, 419, 419, 410, 419, 412, 419, 419, 
	419, 412, 419, 419, 419, 419, 410, 419, 
	419, 419, 419, 419, 419, 419, 419, 419, 
	419, 419, 419, 419, 419, 419, 419, 412, 
	419, 419, 419, 419, 419, 410, 419, 419, 
	419, 419, 419, 419, 419, 419, 419, 419, 
	419, 419, 419, 419, 419, 416, 416, 416, 
	416, 416, 416, 416, 416, 416, 416, 419, 
	419, 419, 419, 419, 419, 419, 416, 416, 
	416, 416, 416, 416, 419, 419, 419, 419, 
	419, 419, 419, 419, 419, 419, 419, 419, 
	419, 419, 419, 419, 419, 419, 419, 419, 
	419, 419, 419, 419, 419, 419, 416, 416, 
	416, 416, 416, 416, 419, 419, 419, 419, 
	419, 419, 419, 419, 419, 419, 419, 419, 
	419, 419, 419, 419, 419, 419, 419, 419, 
	419, 419, 412, 419, 412, 419, 419, 419, 
	412, 419, 419, 419, 419, 420, 419, 419, 
	419, 419, 419, 419, 419, 419, 419, 419, 
	419, 419, 419, 419, 419, 419, 412, 419, 
	419, 419, 419, 419, 420, 419, 419, 419, 
	419, 419, 419, 419, 419, 419, 419, 419, 
	419, 419, 419, 419, 421, 421, 421, 421, 
	421, 421, 421, 421, 421, 421, 419, 419, 
	419, 419, 419, 419, 419, 421, 421, 421, 
	421, 421, 421, 419, 419, 419, 419, 419, 
	419, 419, 419, 419, 419, 419, 419, 419, 
	419, 419, 419, 419, 419, 419, 419, 419, 
	419, 419, 419, 419, 419, 421, 421, 421, 
	421, 421, 421, 419, 419, 419, 419, 419, 
	419, 419, 419, 419, 419, 419, 419, 419, 
	419, 419, 419, 419, 419, 419, 419, 419, 
	419, 422, 419, 412, 419, 419, 419, 412, 
	419, 419, 419, 419, 420, 419, 419, 419, 
	419, 419, 419, 419, 419, 419, 419, 419, 
	419, 419, 419, 419, 419, 412, 419, 419, 
	419, 419, 419, 420, 419, 419, 419, 419, 
	419, 419, 419, 419, 419, 419, 419, 419, 
	419, 419, 419, 414, 414, 414, 414, 414, 
	414, 414, 414, 414, 414, 419, 419, 419, 
	419, 419, 419, 419, 414, 414, 414, 414, 
	414, 414, 419, 419, 419, 419, 419, 419, 
	419, 419, 419, 419, 419, 419, 419, 419, 
	419, 419, 419, 419, 419, 419, 419, 419, 
	419, 419, 419, 419, 414, 414, 414, 414, 
	414, 414, 419, 419, 419, 419, 419, 419, 
	419, 419, 419, 419, 419, 419, 419, 419, 
	419, 419, 419, 419, 419, 419, 419, 419, 
	422, 419, 423, 412, 419, 419, 419, 412, 
	419, 419, 419, 419, 420, 419, 419, 419, 
	419, 419, 419, 419, 419, 419, 419, 419, 
	419, 419, 419, 419, 419, 412, 419, 419, 
	419, 419, 419, 420, 419, 419, 419, 419, 
	419, 419, 419, 419, 419, 419, 419, 419, 
	419, 419, 419, 424, 424, 424, 424, 424, 
	424, 424, 424, 424, 424, 419, 419, 419, 
	419, 419, 419, 419, 424, 424, 424, 424, 
	424, 424, 419, 419, 419, 419, 419, 419, 
	419, 419, 419, 419, 419, 419, 419, 419, 
	419, 419, 419, 419, 419, 419, 419, 419, 
	419, 419, 419, 419, 424, 424, 424, 424, 
	424, 424, 419, 419, 419, 419, 419, 419, 
	419, 419, 419, 419, 419, 419, 419, 419, 
	419, 419, 419, 419, 419, 419, 419, 419, 
	422, 419, 412, 419, 419, 419, 412, 419, 
	419, 419, 419, 420, 419, 419, 419, 419, 
	419, 419, 419, 419, 419, 419, 419, 419, 
	419, 419, 419, 419, 412, 419, 419, 419, 
	419, 419, 420, 419, 419, 419, 419, 419, 
	419, 419, 419, 419, 419, 419, 419, 419, 
	419, 419, 425, 425, 425, 425, 425, 425, 
	425, 425, 425, 425, 419, 419, 419, 419, 
	419, 419, 419, 425, 425, 425, 425, 425, 
	425, 419, 419, 419, 419, 419, 419, 419, 
	419, 419, 419, 419, 419, 419, 419, 419, 
	419, 419, 419, 419, 419, 419, 419, 419, 
	419, 419, 419, 425, 425, 425, 425, 425, 
	425, 419, 419, 419, 419, 419, 419, 419, 
	419, 419, 419, 419, 419, 419, 419, 419, 
	419, 419, 419, 419, 419, 419, 419, 422, 
	419, 412, 419, 419, 419, 412, 419, 419, 
	419, 419, 420, 419, 419, 419, 419, 419, 
	419, 419, 419, 419, 419, 419, 419, 419, 
	419, 419, 419, 412, 419, 419, 419, 419, 
	419, 420, 419, 419, 419, 419, 419, 419, 
	419, 419, 419, 419, 419, 419, 419, 419, 
	419, 426, 426, 426, 426, 426, 426, 426, 
	426, 426, 426, 419, 419, 419, 419, 419, 
	419, 419, 426, 426, 426, 426, 426, 426, 
	419, 419, 419, 419, 419, 419, 419, 419, 
	419, 419, 419, 419, 419, 419, 419, 419, 
	419, 419, 419, 419, 419, 419, 419, 419, 
	419, 419, 426, 426, 426, 426, 426, 426, 
	419, 419, 419, 419, 419, 419, 419, 419, 
	419, 419, 419, 419, 419, 419, 419, 419, 
	419, 419, 419, 419, 419, 419, 422, 419, 
	412, 419, 419, 419, 412, 419, 419, 419, 
	419, 420, 419, 419, 419, 419, 419, 419, 
	419, 419, 419, 419, 419, 419, 419, 419, 
	419, 419, 412, 419, 419, 419, 419, 419, 
	420, 419, 419, 419, 419, 419, 419, 419, 
	419, 419, 419, 419, 419, 419, 419, 419, 
	427, 427, 427, 427, 427, 427, 427, 427, 
	427, 427, 419, 419, 419, 419, 419, 419, 
	419, 427, 427, 427, 427, 427, 427, 419, 
	419, 419, 419, 419, 419, 419, 419, 419, 
	419, 419, 419, 419, 419, 419, 419, 419, 
	419, 419, 419, 419, 419, 419, 419, 419, 
	419, 427, 427, 427, 427, 427, 427, 419, 
	419, 419, 419, 419, 419, 419, 419, 419, 
	419, 419, 419, 419, 419, 419, 419, 419, 
	419, 419, 419, 419, 419, 422, 419, 412, 
	419, 419, 419, 412, 419, 419, 419, 419, 
	420, 419, 419, 419, 419, 419, 419, 419, 
	419, 419, 419, 419, 419, 419, 419, 419, 
	419, 412, 419, 419, 419, 419, 419, 420, 
	419, 419, 419, 419, 419, 419, 419, 419, 
	419, 419, 419, 419, 419, 419, 419, 428, 
	428, 428, 428, 428, 428, 428, 428, 428, 
	428, 419, 419, 419, 419, 419, 419, 419, 
	428, 428, 428, 428, 428, 428, 419, 419, 
	419, 419, 419, 419, 419, 419, 419, 419, 
	419, 419, 419, 419, 419, 419, 419, 419, 
	419, 419, 419, 419, 419, 419, 419, 419, 
	428, 428, 428, 428, 428, 428, 419, 419, 
	419, 419, 419, 419, 419, 419, 419, 419, 
	419, 419, 419, 419, 419, 419, 419, 419, 
	419, 419, 419, 419, 422, 419, 412, 419, 
	419, 419, 412, 419, 419, 419, 419, 410, 
	419, 419, 419, 419, 419, 419, 419, 419, 
	419, 419, 419, 419, 419, 419, 419, 419, 
	412, 419, 419, 419, 419, 419, 410, 419, 
	419, 419, 419, 419, 419, 419, 419, 419, 
	419, 419, 419, 419, 419, 419, 428, 428, 
	428, 428, 428, 428, 428, 428, 428, 428, 
	419, 419, 419, 419, 419, 419, 419, 428, 
	428, 428, 428, 428, 428, 419, 419, 419, 
	419, 419, 419, 419, 419, 419, 419, 419, 
	419, 419, 419, 419, 419, 419, 419, 419, 
	419, 419, 419, 419, 419, 419, 419, 428, 
	428, 428, 428, 428, 428, 419, 419, 419, 
	419, 419, 419, 419, 419, 419, 419, 419, 
	419, 419, 419, 419, 419, 419, 419, 419, 
	419, 419, 419, 410, 419, 429, 430, 432, 
	432, 432, 432, 432, 432, 432, 432, 432, 
	432, 431, 431, 431, 431, 431, 431, 431, 
	432, 432, 432, 432, 432, 432, 431, 431, 
	431, 431, 431, 431, 431, 431, 431, 431, 
	431, 431, 431, 431, 431, 431, 431, 431, 
	431, 431, 431, 431, 431, 431, 431, 431, 
	432, 432, 432, 432, 432, 432, 431, 431, 
	434, 433, 433, 433, 434, 433, 433, 433, 
	433, 433, 435, 433, 433, 433, 433, 433, 
	433, 433, 433, 433, 433, 433, 433, 433, 
	433, 433, 434, 433, 433, 433, 433, 433, 
	433, 433, 433, 436, 433, 433, 433, 433, 
	433, 433, 433, 433, 433, 433, 433, 433, 
	433, 433, 433, 433, 433, 433, 433, 433, 
	433, 433, 433, 433, 433, 433, 433, 433, 
	433, 433, 433, 433, 433, 433, 433, 433, 
	433, 433, 433, 433, 433, 433, 433, 433, 
	433, 433, 433, 433, 433, 433, 433, 433, 
	433, 433, 433, 433, 437, 433, 439, 438, 
	438, 438, 438, 438, 438, 438, 438, 438, 
	438, 438, 438, 438, 438, 438, 438, 438, 
	438, 438, 438, 438, 438, 438, 438, 438, 
	438, 438, 440, 438, 438, 438, 438, 438, 
	438, 438, 438, 438, 438, 438, 438, 438, 
	438, 438, 438, 438, 438, 438, 438, 438, 
	438, 438, 438, 438, 438, 438, 438, 438, 
	438, 438, 438, 438, 438, 438, 438, 438, 
	438, 438, 438, 438, 438, 438, 438, 438, 
	438, 438, 438, 438, 438, 438, 438, 438, 
	438, 438, 438, 438, 438, 441, 438, 442, 
	442, 442, 442, 442, 442, 442, 442, 442, 
	442, 442, 442, 442, 442, 442, 442, 442, 
	442, 442, 442, 442, 442, 442, 442, 442, 
	442, 442, 442, 442, 442, 442, 442, 442, 
	442, 442, 442, 442, 442, 442, 442, 442, 
	442, 442, 442, 442, 442, 442, 442, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 442, 442, 442, 442, 442, 442, 442, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 442, 442, 442, 442, 44, 442, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 442, 442, 442, 442, 442, 44, 
	47, 47, 47, 47, 47, 47, 47, 47, 
	47, 47, 442, 445, 444, 444, 444, 445, 
	444, 444, 444, 444, 444, 444, 444, 444, 
	444, 444, 444, 444, 444, 444, 444, 444, 
	444, 444, 444, 444, 444, 445, 444, 444, 
	444, 444, 444, 444, 444, 444, 444, 444, 
	444, 444, 444, 444, 444, 444, 444, 444, 
	444, 444, 444, 446, 446, 446, 446, 446, 
	446, 446, 446, 444, 444, 444, 444, 444, 
	444, 444, 444, 444, 444, 444, 447, 444, 
	444, 444, 444, 444, 444, 444, 444, 444, 
	448, 444, 444, 444, 444, 444, 444, 444, 
	444, 444, 444, 444, 444, 444, 444, 444, 
	444, 444, 444, 444, 444, 444, 449, 444, 
	444, 444, 444, 444, 444, 444, 444, 444, 
	444, 444, 444, 444, 444, 444, 444, 444, 
	450, 444, 444, 451, 444, 452, 453, 455, 
	455, 455, 455, 455, 455, 455, 455, 454, 
	456, 456, 456, 456, 456, 456, 456, 456, 
	454, 454, 457, 457, 69, 69, 69, 457, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 457, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 70, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 458, 
	69, 459, 460, 461, 461, 69, 69, 69, 
	461, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 461, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 70, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	462, 69, 68, 461, 463, 464, 465, 465, 
	56, 56, 56, 465, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 465, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 57, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 466, 56, 461, 50, 50, 
	50, 461, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 461, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 467, 50, 457, 56, 56, 56, 
	457, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 457, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 57, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	58, 56, 457, 468, 468, 468, 457, 468, 
	468, 468, 468, 468, 468, 468, 468, 468, 
	468, 468, 468, 468, 468, 468, 468, 468, 
	468, 468, 468, 468, 457, 468, 468, 468, 
	468, 468, 468, 468, 468, 468, 468, 468, 
	468, 468, 468, 468, 468, 468, 468, 468, 
	468, 468, 468, 468, 468, 468, 468, 468, 
	468, 468, 468, 468, 468, 468, 468, 468, 
	468, 468, 468, 468, 468, 468, 468, 468, 
	468, 468, 468, 468, 468, 468, 468, 468, 
	468, 468, 468, 468, 468, 468, 468, 468, 
	468, 468, 468, 468, 468, 468, 469, 468, 
	470, 471, 471, 468, 468, 468, 471, 468, 
	468, 468, 468, 468, 468, 468, 468, 468, 
	468, 468, 468, 468, 468, 468, 468, 468, 
	468, 468, 468, 468, 471, 468, 468, 468, 
	468, 468, 468, 468, 468, 468, 468, 468, 
	468, 468, 468, 468, 468, 468, 468, 468, 
	468, 468, 468, 468, 468, 468, 468, 468, 
	468, 468, 468, 468, 468, 468, 468, 468, 
	468, 468, 468, 468, 468, 468, 468, 468, 
	468, 468, 468, 468, 468, 468, 468, 468, 
	468, 468, 468, 468, 468, 468, 468, 468, 
	468, 468, 468, 468, 468, 468, 472, 468, 
	471, 50, 50, 50, 471, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 471, 50, 50, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 50, 50, 467, 50, 473, 
	471, 471, 56, 56, 56, 471, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 471, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	57, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 58, 56, 475, 
	475, 475, 475, 475, 475, 475, 475, 475, 
	475, 474, 474, 474, 474, 474, 474, 474, 
	475, 475, 475, 475, 475, 475, 474, 474, 
	474, 474, 474, 474, 474, 474, 474, 474, 
	474, 474, 474, 474, 474, 474, 474, 474, 
	474, 474, 474, 474, 474, 474, 474, 474, 
	475, 475, 475, 475, 475, 475, 474, 474, 
	474, 474, 474, 474, 474, 474, 474, 474, 
	474, 474, 474, 474, 474, 474, 474, 474, 
	474, 474, 476, 474, 477, 477, 477, 477, 
	477, 477, 477, 477, 477, 477, 474, 474, 
	474, 474, 474, 474, 474, 477, 477, 477, 
	477, 477, 477, 474, 474, 474, 474, 474, 
	474, 474, 474, 474, 474, 474, 474, 474, 
	474, 474, 474, 474, 474, 474, 474, 474, 
	474, 474, 474, 474, 474, 477, 477, 477, 
	477, 477, 477, 474, 478, 478, 478, 478, 
	478, 478, 478, 478, 478, 478, 474, 474, 
	474, 474, 474, 474, 474, 478, 478, 478, 
	478, 478, 478, 474, 474, 474, 474, 474, 
	474, 474, 474, 474, 474, 474, 474, 474, 
	474, 474, 474, 474, 474, 474, 474, 474, 
	474, 474, 474, 474, 474, 478, 478, 478, 
	478, 478, 478, 474, 479, 479, 479, 479, 
	479, 479, 479, 479, 479, 479, 474, 474, 
	474, 474, 474, 474, 474, 479, 479, 479, 
	479, 479, 479, 474, 474, 474, 474, 474, 
	474, 474, 474, 474, 474, 474, 474, 474, 
	474, 474, 474, 474, 474, 474, 474, 474, 
	474, 474, 474, 474, 474, 479, 479, 479, 
	479, 479, 479, 474, 480, 483, 482, 482, 
	482, 483, 482, 482, 482, 482, 484, 482, 
	482, 482, 482, 482, 482, 482, 482, 482, 
	482, 482, 482, 482, 482, 482, 482, 483, 
	482, 482, 482, 482, 482, 484, 482, 482, 
	482, 482, 482, 482, 482, 482, 482, 482, 
	482, 482, 482, 482, 482, 485, 485, 485, 
	485, 485, 485, 485, 485, 485, 485, 482, 
	482, 482, 482, 482, 482, 482, 485, 485, 
	485, 485, 485, 485, 482, 482, 482, 482, 
	482, 482, 482, 482, 482, 482, 482, 482, 
	482, 482, 482, 482, 482, 482, 482, 482, 
	482, 482, 482, 482, 482, 482, 485, 485, 
	485, 485, 485, 485, 482, 482, 482, 482, 
	482, 482, 482, 482, 482, 482, 482, 482, 
	482, 482, 482, 482, 482, 482, 482, 482, 
	482, 482, 486, 482, 483, 482, 482, 482, 
	483, 482, 482, 482, 482, 481, 482, 482, 
	482, 482, 482, 482, 482, 482, 482, 482, 
	482, 482, 482, 482, 482, 482, 483, 482, 
	482, 482, 482, 482, 481, 482, 482, 482, 
	482, 482, 482, 482, 482, 482, 482, 482, 
	482, 482, 482, 482, 487, 487, 487, 487, 
	487, 487, 487, 487, 487, 487, 482, 482, 
	482, 482, 482, 482, 482, 487, 487, 487, 
	487, 487, 487, 482, 482, 482, 482, 482, 
	482, 482, 482, 482, 482, 482, 482, 482, 
	482, 482, 482, 482, 482, 482, 482, 482, 
	482, 482, 482, 482, 482, 487, 487, 487, 
	487, 487, 487, 482, 482, 482, 482, 482, 
	482, 482, 482, 482, 482, 482, 482, 482, 
	482, 482, 482, 482, 482, 482, 482, 482, 
	482, 488, 482, 481, 483, 487, 487, 487, 
	483, 487, 487, 487, 487, 481, 487, 487, 
	487, 487, 487, 487, 487, 487, 487, 487, 
	487, 487, 487, 487, 487, 487, 483, 487, 
	487, 487, 487, 487, 481, 487, 487, 487, 
	487, 487, 487, 487, 487, 487, 487, 487, 
	487, 487, 487, 487, 487, 487, 487, 487, 
	487, 487, 487, 487, 487, 487, 487, 487, 
	487, 487, 487, 487, 487, 487, 487, 487, 
	487, 487, 487, 487, 487, 487, 487, 487, 
	487, 487, 487, 487, 487, 487, 487, 487, 
	487, 487, 487, 487, 487, 487, 487, 487, 
	487, 487, 487, 487, 487, 487, 487, 487, 
	487, 487, 487, 487, 487, 487, 487, 487, 
	487, 487, 487, 487, 487, 487, 487, 487, 
	487, 487, 487, 487, 487, 487, 487, 487, 
	487, 481, 487, 489, 483, 490, 490, 490, 
	483, 490, 490, 490, 490, 484, 490, 490, 
	490, 490, 490, 490, 490, 490, 490, 490, 
	490, 490, 490, 490, 490, 490, 483, 490, 
	490, 490, 490, 490, 484, 490, 490, 490, 
	490, 490, 490, 490, 490, 490, 490, 490, 
	490, 490, 490, 490, 485, 485, 485, 485, 
	485, 485, 485, 485, 485, 485, 490, 490, 
	490, 490, 490, 490, 490, 485, 485, 485, 
	485, 485, 485, 490, 490, 490, 490, 490, 
	490, 490, 490, 490, 490, 490, 490, 490, 
	490, 490, 490, 490, 490, 490, 490, 490, 
	490, 490, 490, 490, 490, 485, 485, 485, 
	485, 485, 485, 490, 490, 490, 490, 490, 
	490, 490, 490, 490, 490, 490, 490, 490, 
	490, 490, 490, 490, 490, 490, 490, 490, 
	490, 481, 490, 483, 490, 490, 490, 483, 
	490, 490, 490, 490, 481, 490, 490, 490, 
	490, 490, 490, 490, 490, 490, 490, 490, 
	490, 490, 490, 490, 490, 483, 490, 490, 
	490, 490, 490, 481, 490, 490, 490, 490, 
	490, 490, 490, 490, 490, 490, 490, 490, 
	490, 490, 490, 487, 487, 487, 487, 487, 
	487, 487, 487, 487, 487, 490, 490, 490, 
	490, 490, 490, 490, 487, 487, 487, 487, 
	487, 487, 490, 490, 490, 490, 490, 490, 
	490, 490, 490, 490, 490, 490, 490, 490, 
	490, 490, 490, 490, 490, 490, 490, 490, 
	490, 490, 490, 490, 487, 487, 487, 487, 
	487, 487, 490, 490, 490, 490, 490, 490, 
	490, 490, 490, 490, 490, 490, 490, 490, 
	490, 490, 490, 490, 490, 490, 490, 490, 
	483, 490, 483, 490, 490, 490, 483, 490, 
	490, 490, 490, 491, 490, 490, 490, 490, 
	490, 490, 490, 490, 490, 490, 490, 490, 
	490, 490, 490, 490, 483, 490, 490, 490, 
	490, 490, 491, 490, 490, 490, 490, 490, 
	490, 490, 490, 490, 490, 490, 490, 490, 
	490, 490, 492, 492, 492, 492, 492, 492, 
	492, 492, 492, 492, 490, 490, 490, 490, 
	490, 490, 490, 492, 492, 492, 492, 492, 
	492, 490, 490, 490, 490, 490, 490, 490, 
	490, 490, 490, 490, 490, 490, 490, 490, 
	490, 490, 490, 490, 490, 490, 490, 490, 
	490, 490, 490, 492, 492, 492, 492, 492, 
	492, 490, 490, 490, 490, 490, 490, 490, 
	490, 490, 490, 490, 490, 490, 490, 490, 
	490, 490, 490, 490, 490, 490, 490, 493, 
	490, 483, 490, 490, 490, 483, 490, 490, 
	490, 490, 491, 490, 490, 490, 490, 490, 
	490, 490, 490, 490, 490, 490, 490, 490, 
	490, 490, 490, 483, 490, 490, 490, 490, 
	490, 491, 490, 490, 490, 490, 490, 490, 
	490, 490, 490, 490, 490, 490, 490, 490, 
	490, 485, 485, 485, 485, 485, 485, 485, 
	485, 485, 485, 490, 490, 490, 490, 490, 
	490, 490, 485, 485, 485, 485, 485, 485, 
	490, 490, 490, 490, 490, 490, 490, 490, 
	490, 490, 490, 490, 490, 490, 490, 490, 
	490, 490, 490, 490, 490, 490, 490, 490, 
	490, 490, 485, 485, 485, 485, 485, 485, 
	490, 490, 490, 490, 490, 490, 490, 490, 
	490, 490, 490, 490, 490, 490, 490, 490, 
	490, 490, 490, 490, 490, 490, 493, 490, 
	494, 483, 490, 490, 490, 483, 490, 490, 
	490, 490, 491, 490, 490, 490, 490, 490, 
	490, 490, 490, 490, 490, 490, 490, 490, 
	490, 490, 490, 483, 490, 490, 490, 490, 
	490, 491, 490, 490, 490, 490, 490, 490, 
	490, 490, 490, 490, 490, 490, 490, 490, 
	490, 495, 495, 495, 495, 495, 495, 495, 
	495, 495, 495, 490, 490, 490, 490, 490, 
	490, 490, 495, 495, 495, 495, 495, 495, 
	490, 490, 490, 490, 490, 490, 490, 490, 
	490, 490, 490, 490, 490, 490, 490, 490, 
	490, 490, 490, 490, 490, 490, 490, 490, 
	490, 490, 495, 495, 495, 495, 495, 495, 
	490, 490, 490, 490, 490, 490, 490, 490, 
	490, 490, 490, 490, 490, 490, 490, 490, 
	490, 490, 490, 490, 490, 490, 493, 490, 
	483, 490, 490, 490, 483, 490, 490, 490, 
	490, 491, 490, 490, 490, 490, 490, 490, 
	490, 490, 490, 490, 490, 490, 490, 490, 
	490, 490, 483, 490, 490, 490, 490, 490, 
	491, 490, 490, 490, 490, 490, 490, 490, 
	490, 490, 490, 490, 490, 490, 490, 490, 
	496, 496, 496, 496, 496, 496, 496, 496, 
	496, 496, 490, 490, 490, 490, 490, 490, 
	490, 496, 496, 496, 496, 496, 496, 490, 
	490, 490, 490, 490, 490, 490, 490, 490, 
	490, 490, 490, 490, 490, 490, 490, 490, 
	490, 490, 490, 490, 490, 490, 490, 490, 
	490, 496, 496, 496, 496, 496, 496, 490, 
	490, 490, 490, 490, 490, 490, 490, 490, 
	490, 490, 490, 490, 490, 490, 490, 490, 
	490, 490, 490, 490, 490, 493, 490, 483, 
	490, 490, 490, 483, 490, 490, 490, 490, 
	491, 490, 490, 490, 490, 490, 490, 490, 
	490, 490, 490, 490, 490, 490, 490, 490, 
	490, 483, 490, 490, 490, 490, 490, 491, 
	490, 490, 490, 490, 490, 490, 490, 490, 
	490, 490, 490, 490, 490, 490, 490, 497, 
	497, 497, 497, 497, 497, 497, 497, 497, 
	497, 490, 490, 490, 490, 490, 490, 490, 
	497, 497, 497, 497, 497, 497, 490, 490, 
	490, 490, 490, 490, 490, 490, 490, 490, 
	490, 490, 490, 490, 490, 490, 490, 490, 
	490, 490, 490, 490, 490, 490, 490, 490, 
	497, 497, 497, 497, 497, 497, 490, 490, 
	490, 490, 490, 490, 490, 490, 490, 490, 
	490, 490, 490, 490, 490, 490, 490, 490, 
	490, 490, 490, 490, 493, 490, 483, 490, 
	490, 490, 483, 490, 490, 490, 490, 491, 
	490, 490, 490, 490, 490, 490, 490, 490, 
	490, 490, 490, 490, 490, 490, 490, 490, 
	483, 490, 490, 490, 490, 490, 491, 490, 
	490, 490, 490, 490, 490, 490, 490, 490, 
	490, 490, 490, 490, 490, 490, 498, 498, 
	498, 498, 498, 498, 498, 498, 498, 498, 
	490, 490, 490, 490, 490, 490, 490, 498, 
	498, 498, 498, 498, 498, 490, 490, 490, 
	490, 490, 490, 490, 490, 490, 490, 490, 
	490, 490, 490, 490, 490, 490, 490, 490, 
	490, 490, 490, 490, 490, 490, 490, 498, 
	498, 498, 498, 498, 498, 490, 490, 490, 
	490, 490, 490, 490, 490, 490, 490, 490, 
	490, 490, 490, 490, 490, 490, 490, 490, 
	490, 490, 490, 493, 490, 483, 490, 490, 
	490, 483, 490, 490, 490, 490, 491, 490, 
	490, 490, 490, 490, 490, 490, 490, 490, 
	490, 490, 490, 490, 490, 490, 490, 483, 
	490, 490, 490, 490, 490, 491, 490, 490, 
	490, 490, 490, 490, 490, 490, 490, 490, 
	490, 490, 490, 490, 490, 499, 499, 499, 
	499, 499, 499, 499, 499, 499, 499, 490, 
	490, 490, 490, 490, 490, 490, 499, 499, 
	499, 499, 499, 499, 490, 490, 490, 490, 
	490, 490, 490, 490, 490, 490, 490, 490, 
	490, 490, 490, 490, 490, 490, 490, 490, 
	490, 490, 490, 490, 490, 490, 499, 499, 
	499, 499, 499, 499, 490, 490, 490, 490, 
	490, 490, 490, 490, 490, 490, 490, 490, 
	490, 490, 490, 490, 490, 490, 490, 490, 
	490, 490, 493, 490, 483, 490, 490, 490, 
	483, 490, 490, 490, 490, 481, 490, 490, 
	490, 490, 490, 490, 490, 490, 490, 490, 
	490, 490, 490, 490, 490, 490, 483, 490, 
	490, 490, 490, 490, 481, 490, 490, 490, 
	490, 490, 490, 490, 490, 490, 490, 490, 
	490, 490, 490, 490, 499, 499, 499, 499, 
	499, 499, 499, 499, 499, 499, 490, 490, 
	490, 490, 490, 490, 490, 499, 499, 499, 
	499, 499, 499, 490, 490, 490, 490, 490, 
	490, 490, 490, 490, 490, 490, 490, 490, 
	490, 490, 490, 490, 490, 490, 490, 490, 
	490, 490, 490, 490, 490, 499, 499, 499, 
	499, 499, 499, 490, 490, 490, 490, 490, 
	490, 490, 490, 490, 490, 490, 490, 490, 
	490, 490, 490, 490, 490, 490, 490, 490, 
	490, 481, 490, 500, 501, 503, 503, 503, 
	503, 503, 503, 503, 503, 503, 503, 502, 
	502, 502, 502, 502, 502, 502, 503, 503, 
	503, 503, 503, 503, 502, 502, 502, 502, 
	502, 502, 502, 502, 502, 502, 502, 502, 
	502, 502, 502, 502, 502, 502, 502, 502, 
	502, 502, 502, 502, 502, 502, 503, 503, 
	503, 503, 503, 503, 502, 502, 505, 504, 
	504, 504, 505, 504, 504, 504, 504, 506, 
	507, 506, 506, 506, 504, 504, 504, 504, 
	504, 504, 504, 504, 504, 504, 504, 504, 
	505, 504, 504, 504, 504, 504, 506, 504, 
	504, 504, 504, 504, 504, 504, 504, 504, 
	504, 504, 504, 504, 504, 504, 504, 504, 
	504, 504, 504, 504, 504, 504, 504, 504, 
	504, 504, 504, 504, 504, 504, 504, 504, 
	504, 504, 504, 504, 504, 504, 504, 504, 
	504, 504, 504, 504, 504, 504, 504, 504, 
	504, 504, 504, 504, 504, 504, 504, 504, 
	504, 504, 508, 504, 506, 509, 506, 506, 
	506, 509, 509, 509, 509, 509, 509, 509, 
	509, 509, 509, 509, 509, 509, 509, 509, 
	509, 509, 509, 506, 509, 510, 511, 511, 
	511, 510, 511, 511, 511, 511, 511, 511, 
	511, 511, 511, 511, 511, 511, 511, 511, 
	511, 511, 511, 511, 511, 511, 511, 510, 
	511, 513, 512, 512, 512, 513, 512, 512, 
	512, 512, 512, 514, 512, 512, 512, 512, 
	512, 512, 512, 512, 512, 512, 512, 512, 
	512, 512, 512, 513, 512, 512, 512, 512, 
	512, 512, 512, 512, 512, 512, 512, 512, 
	512, 512, 512, 512, 512, 512, 512, 512, 
	512, 512, 512, 512, 512, 512, 512, 512, 
	512, 512, 512, 512, 512, 512, 512, 512, 
	512, 512, 512, 512, 512, 512, 512, 512, 
	512, 512, 512, 512, 512, 512, 512, 512, 
	512, 512, 512, 512, 512, 512, 512, 512, 
	512, 512, 512, 512, 512, 515, 512, 516, 
	517, 517, 517, 516, 517, 517, 517, 517, 
	517, 518, 517, 517, 517, 517, 517, 517, 
	517, 517, 517, 517, 517, 517, 517, 517, 
	517, 516, 517, 520, 519, 519, 519, 520, 
	519, 519, 519, 519, 519, 521, 519, 519, 
	519, 519, 519, 519, 519, 519, 519, 519, 
	519, 519, 519, 519, 519, 520, 519, 519, 
	519, 519, 519, 519, 519, 519, 522, 519, 
	524, 523, 523, 523, 523, 523, 523, 523, 
	523, 523, 523, 523, 523, 523, 523, 523, 
	523, 523, 523, 523, 523, 523, 523, 523, 
	523, 523, 523, 523, 525, 523, 523, 523, 
	523, 523, 523, 523, 523, 523, 523, 523, 
	523, 523, 523, 523, 523, 523, 523, 523, 
	523, 523, 523, 523, 523, 523, 523, 523, 
	523, 523, 523, 523, 523, 523, 523, 523, 
	523, 523, 523, 523, 523, 523, 523, 523, 
	523, 523, 523, 523, 523, 523, 523, 523, 
	523, 523, 523, 523, 523, 523, 523, 526, 
	523, 527, 527, 527, 527, 527, 527, 527, 
	527, 527, 527, 527, 527, 527, 527, 527, 
	527, 527, 527, 527, 527, 527, 527, 527, 
	527, 527, 527, 527, 527, 527, 527, 527, 
	527, 527, 527, 527, 527, 527, 527, 527, 
	527, 527, 527, 527, 527, 527, 527, 527, 
	527, 75, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 527, 527, 527, 527, 527, 
	527, 527, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 75, 527, 527, 527, 527, 
	75, 527, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 75, 527, 527, 527, 527, 
	527, 75, 78, 78, 78, 78, 78, 78, 
	78, 78, 78, 78, 527, 529, 528, 528, 
	528, 529, 528, 528, 528, 528, 528, 530, 
	528, 528, 528, 528, 528, 528, 528, 528, 
	528, 528, 528, 528, 528, 528, 528, 529, 
	528, 532, 531, 531, 531, 532, 531, 531, 
	531, 531, 533, 534, 533, 533, 533, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 532, 531, 531, 531, 531, 
	531, 533, 531, 531, 535, 531, 533, 536, 
	533, 533, 533, 536, 536, 536, 536, 536, 
	536, 536, 536, 536, 536, 536, 536, 536, 
	536, 536, 536, 536, 536, 533, 536, 538, 
	537, 537, 537, 537, 537, 537, 537, 537, 
	537, 537, 537, 537, 537, 537, 537, 537, 
	537, 537, 537, 537, 537, 537, 537, 537, 
	537, 537, 537, 539, 537, 537, 537, 537, 
	537, 537, 537, 537, 537, 537, 537, 537, 
	537, 537, 537, 537, 537, 537, 537, 537, 
	537, 537, 537, 537, 537, 537, 537, 537, 
	537, 537, 537, 537, 537, 537, 537, 537, 
	537, 537, 537, 537, 537, 537, 537, 537, 
	537, 537, 537, 537, 537, 537, 537, 537, 
	537, 537, 537, 537, 537, 537, 540, 537, 
	541, 541, 541, 541, 541, 541, 541, 541, 
	541, 541, 541, 541, 541, 541, 541, 541, 
	541, 541, 541, 541, 541, 541, 541, 541, 
	541, 541, 541, 541, 541, 541, 541, 541, 
	541, 541, 541, 541, 541, 541, 541, 541, 
	541, 541, 541, 541, 541, 541, 541, 541, 
	81, 81, 81, 81, 81, 81, 81, 81, 
	81, 81, 541, 541, 541, 541, 541, 541, 
	541, 81, 81, 81, 81, 81, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 81, 
	81, 81, 81, 541, 541, 541, 541, 81, 
	541, 81, 81, 81, 81, 81, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 81, 
	81, 81, 81, 541, 541, 541, 541, 541, 
	81, 84, 84, 84, 84, 84, 84, 84, 
	84, 84, 84, 541, 543, 542, 542, 542, 
	543, 542, 542, 542, 542, 544, 545, 544, 
	544, 544, 542, 542, 542, 542, 542, 542, 
	542, 542, 542, 542, 542, 542, 543, 542, 
	542, 542, 542, 542, 544, 542, 544, 546, 
	544, 544, 544, 546, 546, 546, 546, 546, 
	546, 546, 546, 546, 546, 546, 546, 546, 
	546, 546, 546, 546, 546, 544, 546, 548, 
	548, 548, 548, 548, 548, 548, 548, 548, 
	548, 548, 548, 548, 548, 548, 548, 548, 
	548, 548, 548, 548, 548, 548, 548, 548, 
	548, 547, 547, 547, 547, 547, 547, 548, 
	548, 548, 548, 548, 548, 548, 548, 548, 
	548, 548, 548, 548, 548, 548, 548, 548, 
	548, 548, 548, 548, 548, 548, 548, 548, 
	548, 547, 548, 548, 548, 548, 548, 548, 
	548, 548, 548, 548, 548, 548, 548, 548, 
	548, 548, 548, 548, 548, 548, 548, 548, 
	548, 548, 548, 548, 549, 549, 549, 549, 
	549, 549, 548, 548, 548, 548, 548, 548, 
	548, 548, 548, 548, 548, 548, 548, 548, 
	548, 548, 548, 548, 548, 548, 548, 548, 
	548, 548, 548, 548, 549, 550, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	88, 551, 88, 552, 552, 552, 552, 552, 
	552, 552, 552, 552, 552, 552, 552, 552, 
	552, 552, 552, 552, 552, 552, 552, 552, 
	552, 552, 552, 552, 552, 552, 552, 552, 
	552, 552, 552, 552, 552, 552, 552, 552, 
	552, 552, 552, 552, 552, 552, 552, 552, 
	552, 552, 552, 86, 86, 86, 86, 86, 
	86, 86, 86, 86, 86, 552, 552, 552, 
	552, 552, 552, 552, 86, 86, 86, 86, 
	86, 86, 86, 86, 86, 86, 86, 86, 
	86, 86, 86, 86, 86, 86, 86, 86, 
	86, 86, 86, 86, 86, 86, 552, 552, 
	552, 552, 86, 552, 86, 86, 86, 86, 
	86, 86, 86, 86, 86, 86, 86, 86, 
	86, 86, 86, 86, 86, 86, 86, 86, 
	86, 86, 86, 86, 86, 86, 552, 552, 
	552, 552, 552, 86, 90, 90, 90, 90, 
	90, 90, 90, 90, 90, 90, 552, 553, 
	553, 553, 553, 553, 553, 553, 553, 553, 
	553, 553, 553, 553, 553, 553, 553, 553, 
	553, 553, 553, 553, 553, 553, 553, 553, 
	553, 553, 553, 553, 553, 553, 553, 553, 
	553, 553, 553, 553, 553, 553, 553, 553, 
	553, 553, 553, 553, 553, 553, 553, 91, 
	91, 91, 91, 91, 91, 91, 91, 91, 
	91, 553, 553, 553, 553, 553, 553, 553, 
	91, 91, 91, 91, 91, 91, 91, 91, 
	91, 91, 91, 91, 91, 91, 91, 91, 
	91, 91, 91, 91, 91, 91, 91, 91, 
	91, 91, 553, 553, 553, 553, 91, 553, 
	91, 91, 91, 91, 91, 91, 91, 91, 
	91, 91, 91, 91, 91, 91, 91, 91, 
	91, 91, 91, 91, 91, 91, 91, 91, 
	91, 91, 553, 553, 553, 553, 553, 91, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	93, 93, 93, 93, 93, 93, 93, 93, 
	93, 93, 554, 554, 554, 554, 554, 554, 
	554, 93, 93, 93, 93, 93, 93, 93, 
	93, 93, 93, 93, 93, 93, 93, 93, 
	93, 93, 93, 93, 93, 93, 93, 93, 
	93, 93, 93, 554, 554, 554, 554, 93, 
	554, 93, 93, 93, 93, 93, 93, 93, 
	93, 93, 93, 93, 93, 93, 93, 93, 
	93, 93, 93, 93, 93, 93, 93, 93, 
	93, 93, 93, 554, 554, 554, 554, 554, 
	93, 556, 557, 557, 557, 556, 557, 557, 
	557, 557, 558, 559, 558, 558, 558, 557, 
	557, 557, 557, 557, 557, 557, 557, 557, 
	557, 557, 557, 556, 557, 557, 557, 557, 
	557, 558, 560, 557, 561, 562, 563, 564, 
	557, 557, 557, 565, 566, 557, 566, 557, 
	567, 557, 557, 557, 557, 557, 557, 557, 
	557, 557, 557, 568, 557, 569, 570, 571, 
	557, 557, 572, 573, 572, 572, 574, 572, 
	572, 572, 572, 572, 572, 572, 572, 572, 
	572, 572, 572, 572, 572, 572, 572, 572, 
	572, 572, 572, 572, 575, 576, 557, 567, 
	577, 567, 578, 579, 580, 581, 582, 583, 
	555, 555, 584, 555, 555, 555, 585, 586, 
	587, 555, 555, 588, 589, 590, 591, 555, 
	592, 555, 593, 555, 557, 594, 557, 566, 
	557, 555, 595, 595, 595, 595, 595, 595, 
	595, 595, 595, 595, 595, 595, 595, 595, 
	595, 595, 595, 595, 595, 595, 595, 595, 
	595, 595, 595, 595, 595, 595, 595, 595, 
	595, 595, 595, 596, 595, 595, 595, 595, 
	595, 595, 595, 595, 595, 595, 595, 595, 
	595, 595, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 595, 595, 595, 596, 
	595, 596, 595, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 595, 595, 595, 
	595, 555, 595, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 595, 595, 595, 
	595, 595, 555, 558, 597, 558, 558, 558, 
	597, 597, 597, 597, 597, 597, 597, 597, 
	597, 597, 597, 597, 597, 597, 597, 597, 
	597, 597, 558, 597, 598, 567, 599, 599, 
	567, 599, 599, 599, 599, 599, 599, 599, 
	599, 599, 599, 599, 599, 599, 599, 599, 
	599, 599, 599, 599, 599, 599, 599, 599, 
	599, 599, 599, 599, 599, 599, 599, 599, 
	599, 599, 599, 599, 599, 599, 599, 599, 
	599, 599, 599, 599, 599, 599, 599, 599, 
	599, 599, 599, 599, 599, 599, 599, 599, 
	599, 599, 599, 599, 599, 599, 567, 599, 
	600, 601, 602, 603, 604, 604, 604, 604, 
	604, 604, 604, 604, 604, 604, 604, 604, 
	604, 604, 604, 604, 604, 604, 604, 604, 
	604, 604, 604, 604, 604, 604, 604, 604, 
	604, 604, 604, 604, 604, 95, 95, 604, 
	95, 604, 95, 95, 604, 604, 95, 95, 
	95, 606, 95, 95, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 95, 95, 
	95, 95, 95, 95, 95, 605, 605, 605, 
	605, 605, 605, 605, 605, 605, 605, 605, 
	605, 605, 605, 605, 605, 605, 605, 605, 
	605, 605, 605, 605, 605, 605, 605, 604, 
	95, 604, 604, 605, 95, 605, 605, 605, 
	605, 605, 605, 605, 605, 605, 605, 605, 
	605, 605, 605, 605, 605, 605, 605, 605, 
	605, 605, 605, 605, 605, 605, 605, 604, 
	604, 604, 95, 604, 605, 608, 608, 608, 
	608, 608, 608, 608, 608, 608, 608, 608, 
	608, 608, 608, 608, 608, 608, 608, 608, 
	608, 608, 608, 608, 608, 608, 608, 608, 
	608, 608, 608, 608, 608, 608, 608, 608, 
	608, 608, 608, 608, 608, 608, 608, 608, 
	608, 608, 608, 608, 608, 605, 605, 605, 
	605, 605, 605, 605, 605, 605, 605, 608, 
	608, 608, 608, 608, 608, 608, 605, 605, 
	605, 605, 605, 605, 605, 605, 605, 605, 
	605, 605, 605, 605, 605, 605, 605, 605, 
	605, 605, 605, 605, 605, 605, 605, 605, 
	608, 608, 608, 608, 605, 608, 605, 605, 
	605, 605, 605, 605, 605, 605, 605, 605, 
	605, 605, 605, 605, 605, 605, 605, 605, 
	605, 605, 605, 605, 605, 605, 605, 605, 
	608, 608, 608, 608, 608, 605, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	608, 609, 599, 567, 599, 567, 599, 567, 
	599, 611, 610, 567, 612, 599, 567, 599, 
	613, 567, 604, 604, 604, 604, 604, 604, 
	604, 604, 604, 604, 604, 604, 604, 604, 
	604, 604, 604, 604, 604, 604, 604, 604, 
	604, 604, 604, 604, 604, 604, 604, 604, 
	604, 604, 604, 604, 604, 604, 604, 604, 
	604, 604, 604, 604, 604, 604, 604, 604, 
	604, 604, 604, 604, 604, 604, 604, 604, 
	604, 604, 604, 604, 604, 604, 604, 604, 
	604, 567, 604, 567, 599, 567, 567, 599, 
	595, 595, 595, 595, 595, 595, 595, 595, 
	595, 595, 595, 595, 595, 595, 595, 595, 
	595, 595, 595, 595, 595, 595, 595, 595, 
	595, 595, 595, 595, 595, 595, 595, 595, 
	595, 596, 595, 595, 595, 595, 595, 595, 
	595, 595, 595, 595, 595, 595, 595, 595, 
	572, 572, 572, 572, 572, 572, 572, 572, 
	572, 572, 595, 595, 595, 596, 595, 596, 
	595, 572, 572, 572, 572, 572, 572, 572, 
	572, 572, 572, 572, 572, 572, 572, 572, 
	572, 572, 572, 572, 572, 572, 572, 572, 
	572, 572, 572, 595, 595, 595, 595, 572, 
	595, 572, 572, 572, 572, 572, 572, 572, 
	572, 572, 572, 572, 572, 572, 572, 572, 
	572, 572, 572, 572, 572, 572, 572, 572, 
	572, 572, 572, 595, 595, 595, 595, 595, 
	572, 614, 614, 614, 614, 614, 614, 614, 
	614, 614, 614, 614, 614, 614, 614, 614, 
	614, 614, 614, 614, 614, 614, 614, 614, 
	614, 614, 614, 614, 614, 614, 614, 614, 
	614, 614, 596, 614, 614, 614, 614, 614, 
	614, 614, 614, 614, 614, 614, 614, 614, 
	614, 572, 572, 572, 572, 572, 572, 572, 
	572, 572, 572, 614, 614, 614, 596, 614, 
	596, 614, 572, 572, 572, 572, 615, 572, 
	572, 572, 572, 572, 572, 572, 572, 572, 
	572, 572, 572, 572, 572, 572, 572, 572, 
	572, 572, 572, 572, 614, 614, 614, 614, 
	572, 614, 572, 572, 572, 572, 572, 572, 
	572, 572, 572, 572, 572, 572, 572, 572, 
	572, 572, 572, 572, 572, 572, 572, 572, 
	572, 572, 572, 572, 614, 614, 614, 614, 
	614, 572, 614, 614, 614, 614, 614, 614, 
	614, 614, 614, 614, 614, 614, 614, 614, 
	614, 614, 614, 614, 614, 614, 614, 614, 
	614, 614, 614, 614, 614, 614, 614, 614, 
	614, 614, 614, 596, 614, 614, 614, 614, 
	614, 614, 614, 614, 614, 614, 614, 614, 
	614, 614, 572, 572, 572, 572, 572, 572, 
	572, 572, 572, 572, 614, 614, 614, 596, 
	614, 596, 614, 572, 572, 572, 572, 572, 
	572, 616, 572, 572, 572, 572, 572, 572, 
	572, 572, 572, 572, 572, 572, 572, 572, 
	572, 572, 572, 572, 572, 614, 614, 614, 
	614, 572, 614, 572, 572, 572, 572, 572, 
	572, 572, 572, 572, 572, 572, 572, 572, 
	572, 572, 572, 572, 572, 572, 572, 572, 
	572, 572, 572, 572, 572, 614, 614, 614, 
	614, 614, 572, 614, 614, 614, 614, 614, 
	614, 614, 614, 614, 614, 614, 614, 614, 
	614, 614, 614, 614, 614, 614, 614, 614, 
	614, 614, 614, 614, 614, 614, 614, 614, 
	614, 614, 614, 614, 596, 614, 614, 614, 
	614, 614, 614, 614, 614, 614, 614, 614, 
	614, 614, 614, 572, 572, 572, 572, 572, 
	572, 572, 572, 572, 572, 614, 614, 614, 
	596, 614, 596, 614, 572, 572, 572, 572, 
	572, 572, 572, 572, 617, 572, 572, 572, 
	572, 572, 572, 572, 572, 572, 572, 572, 
	572, 572, 572, 572, 572, 572, 614, 614, 
	614, 614, 572, 614, 572, 572, 572, 572, 
	572, 572, 572, 572, 572, 572, 572, 572, 
	572, 572, 572, 572, 572, 572, 572, 572, 
	572, 572, 572, 572, 572, 572, 614, 614, 
	614, 614, 614, 572, 614, 614, 614, 614, 
	614, 614, 614, 614, 614, 614, 614, 614, 
	614, 614, 614, 614, 614, 614, 614, 614, 
	614, 614, 614, 614, 614, 614, 614, 614, 
	614, 614, 614, 614, 614, 596, 614, 614, 
	614, 614, 614, 614, 614, 614, 614, 614, 
	614, 614, 614, 614, 572, 572, 572, 572, 
	572, 572, 572, 572, 572, 572, 614, 614, 
	614, 596, 614, 596, 614, 572, 572, 572, 
	572, 572, 572, 572, 572, 572, 572, 572, 
	572, 572, 618, 572, 572, 572, 572, 572, 
	572, 572, 572, 572, 572, 572, 572, 614, 
	614, 614, 614, 572, 614, 572, 572, 572, 
	572, 572, 572, 572, 572, 572, 572, 572, 
	572, 572, 572, 572, 572, 572, 572, 572, 
	572, 572, 572, 572, 572, 572, 572, 614, 
	614, 614, 614, 614, 572, 614, 614, 614, 
	614, 614, 614, 614, 614, 614, 614, 614, 
	614, 614, 614, 614, 614, 614, 614, 614, 
	614, 614, 614, 614, 614, 614, 614, 614, 
	614, 614, 614, 614, 614, 614, 596, 614, 
	614, 614, 614, 614, 614, 614, 614, 614, 
	614, 614, 614, 614, 614, 572, 572, 572, 
	572, 572, 572, 572, 572, 572, 572, 614, 
	614, 614, 596, 614, 596, 614, 572, 572, 
	572, 572, 572, 572, 572, 572, 572, 572, 
	572, 572, 572, 619, 572, 572, 572, 572, 
	572, 572, 572, 572, 572, 572, 572, 572, 
	614, 614, 614, 614, 572, 614, 572, 572, 
	572, 572, 572, 572, 572, 572, 572, 572, 
	572, 572, 572, 572, 572, 572, 572, 572, 
	572, 572, 572, 572, 572, 572, 572, 572, 
	614, 614, 614, 614, 614, 572, 614, 614, 
	614, 614, 614, 614, 614, 614, 614, 614, 
	614, 614, 614, 614, 614, 614, 614, 614, 
	614, 614, 614, 614, 614, 614, 614, 614, 
	614, 614, 614, 614, 614, 614, 614, 596, 
	614, 614, 614, 614, 614, 614, 614, 614, 
	614, 614, 614, 614, 614, 614, 572, 572, 
	572, 572, 572, 572, 572, 572, 572, 572, 
	614, 614, 614, 596, 614, 596, 614, 572, 
	572, 572, 618, 572, 572, 572, 572, 572, 
	572, 572, 572, 572, 572, 572, 572, 572, 
	572, 572, 572, 572, 572, 572, 572, 572, 
	572, 614, 614, 614, 614, 572, 614, 572, 
	572, 572, 572, 572, 572, 572, 572, 572, 
	572, 572, 572, 572, 572, 572, 572, 572, 
	572, 572, 572, 572, 572, 572, 572, 572, 
	572, 614, 614, 614, 614, 614, 572, 613, 
	604, 559, 604, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 596, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 620, 620, 620, 
	596, 620, 596, 620, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 620, 620, 
	620, 620, 621, 620, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 620, 620, 
	620, 620, 620, 555, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 596, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 620, 620, 
	620, 596, 620, 596, 620, 555, 555, 555, 
	555, 622, 623, 555, 555, 555, 555, 555, 
	624, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 620, 
	620, 620, 620, 555, 620, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 620, 
	620, 620, 620, 620, 555, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 596, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 620, 
	620, 620, 596, 620, 596, 620, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 625, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	620, 620, 620, 620, 555, 620, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	620, 620, 620, 620, 620, 555, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 596, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	620, 620, 620, 596, 620, 596, 620, 555, 
	555, 626, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 620, 620, 620, 620, 555, 620, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 620, 620, 620, 620, 620, 555, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	596, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 620, 620, 620, 596, 620, 596, 620, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 627, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 620, 620, 620, 620, 555, 620, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 620, 620, 620, 620, 620, 555, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 596, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 620, 620, 620, 596, 620, 596, 
	620, 555, 555, 555, 628, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 620, 620, 620, 620, 555, 
	620, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 620, 620, 620, 620, 620, 
	555, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 596, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 620, 620, 620, 596, 620, 
	596, 620, 555, 555, 555, 555, 555, 555, 
	555, 555, 629, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 620, 620, 620, 620, 
	555, 620, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 620, 620, 620, 620, 
	620, 555, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 596, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 620, 620, 620, 596, 
	620, 596, 620, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	630, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 620, 620, 620, 
	620, 555, 620, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 620, 620, 620, 
	620, 620, 555, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 596, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 620, 620, 620, 
	596, 620, 596, 620, 555, 555, 555, 555, 
	555, 555, 631, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 620, 620, 
	620, 620, 555, 620, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 620, 620, 
	620, 620, 620, 555, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 596, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 620, 620, 
	620, 596, 620, 596, 620, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 620, 
	620, 620, 620, 632, 620, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 620, 
	620, 620, 620, 620, 555, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 596, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 620, 
	620, 620, 596, 620, 596, 620, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	620, 620, 620, 620, 633, 620, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	620, 620, 620, 620, 620, 555, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 596, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	620, 620, 620, 596, 620, 596, 620, 555, 
	555, 555, 555, 555, 555, 555, 555, 634, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 620, 620, 620, 620, 555, 620, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 620, 620, 620, 620, 620, 555, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	596, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 620, 620, 620, 596, 620, 596, 620, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 635, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 620, 620, 620, 620, 555, 620, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 620, 620, 620, 620, 620, 555, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 596, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 620, 620, 620, 596, 620, 596, 
	620, 555, 555, 555, 555, 631, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 620, 620, 620, 620, 555, 
	620, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 620, 620, 620, 620, 620, 
	555, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 596, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 620, 620, 620, 596, 620, 
	596, 620, 555, 555, 555, 555, 555, 555, 
	555, 555, 636, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 620, 620, 620, 620, 
	555, 620, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 620, 620, 620, 620, 
	620, 555, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 596, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 620, 620, 620, 596, 
	620, 596, 620, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	635, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 620, 620, 620, 
	620, 555, 620, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 620, 620, 620, 
	620, 620, 555, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 596, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 620, 620, 620, 
	596, 620, 596, 620, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 620, 620, 
	620, 620, 555, 620, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 637, 
	555, 638, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 620, 620, 
	620, 620, 620, 555, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 596, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 620, 620, 
	620, 596, 620, 596, 620, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 620, 
	620, 620, 620, 555, 620, 555, 555, 555, 
	555, 555, 555, 555, 555, 639, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 620, 
	620, 620, 620, 620, 555, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 596, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 620, 
	620, 620, 596, 620, 596, 620, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	620, 620, 620, 620, 555, 620, 640, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	620, 620, 620, 620, 620, 555, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 596, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	620, 620, 620, 596, 620, 596, 620, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 620, 620, 620, 620, 555, 620, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 633, 555, 555, 555, 555, 555, 555, 
	555, 620, 620, 620, 620, 620, 555, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	596, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 620, 620, 620, 596, 620, 596, 620, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 620, 620, 620, 620, 555, 620, 
	555, 555, 555, 633, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 620, 620, 620, 620, 620, 555, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 596, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 620, 620, 620, 596, 620, 596, 
	620, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 620, 620, 620, 620, 555, 
	620, 555, 555, 555, 555, 641, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 642, 555, 555, 555, 555, 555, 
	555, 555, 555, 620, 620, 620, 620, 620, 
	555, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 596, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 620, 620, 620, 596, 620, 
	596, 620, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 620, 620, 620, 620, 
	555, 620, 555, 555, 555, 555, 555, 555, 
	643, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 620, 620, 620, 620, 
	620, 555, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 596, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 620, 620, 620, 596, 
	620, 596, 620, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 620, 620, 620, 
	620, 555, 620, 555, 555, 555, 555, 555, 
	555, 555, 555, 644, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 620, 620, 620, 
	620, 620, 555, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 596, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 620, 620, 620, 
	596, 620, 596, 620, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 620, 620, 
	620, 620, 555, 620, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 633, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 620, 620, 
	620, 620, 620, 555, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 596, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 620, 620, 
	620, 596, 620, 596, 620, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 620, 
	620, 620, 620, 555, 620, 555, 555, 555, 
	555, 645, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 620, 
	620, 620, 620, 620, 555, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 596, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 620, 
	620, 620, 596, 620, 596, 620, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	620, 620, 620, 620, 555, 620, 646, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	620, 620, 620, 620, 620, 555, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 596, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	620, 620, 620, 596, 620, 596, 620, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 620, 620, 620, 620, 555, 620, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 633, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 620, 620, 620, 620, 620, 555, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	596, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 620, 620, 620, 596, 620, 596, 620, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 620, 620, 620, 620, 555, 620, 
	647, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 648, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 620, 620, 620, 620, 620, 555, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 596, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 620, 620, 620, 596, 620, 596, 
	620, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 620, 620, 620, 620, 555, 
	620, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 649, 555, 555, 555, 555, 
	555, 555, 555, 620, 620, 620, 620, 620, 
	555, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 596, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 620, 620, 620, 596, 620, 
	596, 620, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 620, 620, 620, 620, 
	555, 620, 555, 555, 555, 555, 633, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 620, 620, 620, 620, 
	620, 555, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 596, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 620, 620, 620, 596, 
	620, 596, 620, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 620, 620, 620, 
	620, 555, 620, 650, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 620, 620, 620, 
	620, 620, 555, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 596, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 620, 620, 620, 
	596, 620, 596, 620, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 620, 620, 
	620, 620, 555, 620, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 640, 555, 
	555, 555, 555, 555, 555, 555, 620, 620, 
	620, 620, 620, 555, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 596, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 620, 620, 
	620, 596, 620, 596, 620, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 620, 
	620, 620, 620, 555, 620, 555, 555, 555, 
	555, 651, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 633, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 620, 
	620, 620, 620, 620, 555, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 596, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 620, 
	620, 620, 596, 620, 596, 620, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	620, 620, 620, 620, 555, 620, 555, 555, 
	555, 555, 555, 652, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	620, 620, 620, 620, 620, 555, 653, 653, 
	653, 653, 653, 653, 653, 653, 653, 653, 
	653, 653, 653, 653, 653, 653, 653, 653, 
	653, 653, 653, 653, 653, 653, 653, 653, 
	653, 653, 653, 653, 653, 653, 653, 596, 
	653, 653, 653, 653, 653, 653, 653, 653, 
	653, 653, 653, 653, 653, 653, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	653, 653, 653, 596, 653, 596, 653, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 653, 653, 653, 653, 555, 653, 555, 
	555, 555, 555, 555, 555, 555, 555, 654, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 653, 653, 653, 653, 653, 555, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	596, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 620, 620, 620, 596, 620, 596, 620, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 620, 620, 620, 620, 555, 620, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 655, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 620, 620, 620, 620, 620, 555, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 596, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 620, 620, 620, 596, 620, 596, 
	620, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 620, 620, 620, 620, 555, 
	620, 555, 555, 555, 555, 656, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 620, 620, 620, 620, 620, 
	555, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 596, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 620, 620, 620, 596, 620, 
	596, 620, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 620, 620, 620, 620, 
	555, 620, 555, 555, 555, 657, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 620, 620, 620, 620, 
	620, 555, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 596, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 620, 620, 620, 596, 
	620, 658, 620, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 620, 620, 620, 
	620, 555, 620, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 620, 620, 620, 
	620, 620, 555, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 596, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 620, 620, 620, 
	596, 620, 596, 620, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 620, 620, 
	620, 620, 555, 620, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 659, 
	555, 660, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 620, 620, 
	620, 620, 620, 555, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 596, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 620, 620, 
	620, 596, 620, 596, 620, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 620, 
	620, 620, 620, 555, 620, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 661, 
	555, 555, 555, 555, 555, 555, 555, 620, 
	620, 620, 620, 620, 555, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 596, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 620, 
	620, 620, 596, 620, 596, 620, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	620, 620, 620, 620, 555, 620, 555, 555, 
	555, 555, 633, 555, 555, 555, 662, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	620, 620, 620, 620, 620, 555, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 596, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	620, 620, 620, 596, 620, 596, 620, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 620, 620, 620, 620, 555, 620, 555, 
	555, 555, 555, 555, 633, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 620, 620, 620, 620, 620, 555, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	596, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 620, 620, 620, 596, 620, 596, 620, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 620, 620, 620, 620, 555, 620, 
	555, 555, 555, 633, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 663, 555, 555, 555, 555, 555, 
	555, 555, 620, 620, 620, 620, 620, 555, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 596, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 620, 620, 620, 596, 620, 596, 
	620, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 620, 620, 620, 620, 555, 
	620, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 664, 555, 555, 
	555, 555, 555, 620, 620, 620, 620, 620, 
	555, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 596, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 620, 620, 620, 596, 620, 
	596, 620, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 620, 620, 620, 620, 
	555, 620, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 649, 555, 555, 555, 555, 
	555, 555, 555, 555, 620, 620, 620, 620, 
	620, 555, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 596, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 620, 620, 620, 596, 
	620, 596, 620, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 620, 620, 620, 
	620, 555, 620, 665, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 587, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 620, 620, 620, 
	620, 620, 555, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 596, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 620, 620, 620, 
	596, 620, 596, 620, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 620, 620, 
	620, 620, 555, 620, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 647, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 620, 620, 
	620, 620, 620, 555, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 596, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 620, 620, 
	620, 596, 620, 596, 620, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 620, 
	620, 620, 620, 555, 620, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 633, 555, 
	555, 555, 555, 555, 555, 555, 555, 620, 
	620, 620, 620, 620, 555, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 596, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 620, 
	620, 620, 596, 620, 596, 620, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	620, 620, 620, 620, 555, 620, 555, 555, 
	555, 555, 555, 633, 555, 555, 555, 555, 
	555, 555, 555, 633, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	620, 620, 620, 620, 620, 555, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 596, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	620, 620, 620, 596, 620, 596, 620, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 620, 620, 620, 620, 555, 620, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 666, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 620, 620, 620, 620, 620, 555, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	596, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 620, 620, 620, 596, 620, 596, 620, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 620, 620, 620, 620, 555, 620, 
	555, 555, 555, 667, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 620, 620, 620, 620, 620, 555, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 596, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 620, 620, 620, 596, 620, 596, 
	620, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 620, 620, 620, 620, 555, 
	620, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 668, 555, 555, 
	555, 555, 555, 620, 620, 620, 620, 620, 
	555, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 596, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 620, 620, 620, 596, 620, 
	596, 620, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 620, 620, 620, 620, 
	555, 620, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 649, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 620, 620, 620, 620, 
	620, 555, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 596, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 620, 620, 620, 596, 
	620, 596, 620, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 620, 620, 620, 
	620, 555, 620, 555, 555, 555, 555, 669, 
	555, 555, 555, 670, 555, 555, 555, 555, 
	555, 671, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 620, 620, 620, 
	620, 620, 555, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 596, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 620, 620, 620, 
	596, 620, 596, 620, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 620, 620, 
	620, 620, 555, 620, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 671, 555, 555, 620, 620, 
	620, 620, 620, 555, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 596, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 620, 620, 
	620, 596, 620, 596, 620, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 620, 
	620, 620, 620, 555, 620, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	633, 555, 555, 555, 555, 555, 555, 620, 
	620, 620, 620, 620, 555, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 596, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 620, 
	620, 620, 596, 620, 596, 620, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	620, 620, 620, 620, 555, 620, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 633, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	620, 620, 620, 620, 620, 555, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 596, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	620, 620, 620, 596, 620, 596, 620, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 620, 620, 620, 620, 555, 620, 555, 
	555, 555, 555, 672, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 620, 620, 620, 620, 620, 555, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	596, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 620, 620, 620, 596, 620, 596, 620, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 620, 620, 620, 620, 555, 620, 
	555, 555, 555, 673, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 674, 675, 555, 555, 555, 555, 
	555, 555, 620, 620, 620, 620, 620, 555, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 596, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 620, 620, 620, 596, 620, 596, 
	620, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 620, 620, 620, 620, 555, 
	620, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 633, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 620, 620, 620, 620, 620, 
	555, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 596, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 620, 620, 620, 596, 620, 
	596, 620, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 620, 620, 620, 620, 
	555, 620, 555, 555, 676, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 620, 620, 620, 620, 
	620, 555, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 596, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 620, 620, 620, 596, 
	620, 596, 620, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 620, 620, 620, 
	620, 555, 620, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 649, 
	555, 555, 555, 555, 555, 620, 620, 620, 
	620, 620, 555, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 596, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 620, 620, 620, 
	596, 620, 596, 620, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 620, 620, 
	620, 620, 555, 620, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 677, 555, 555, 
	678, 555, 555, 555, 555, 555, 620, 620, 
	620, 620, 620, 555, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 596, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 620, 620, 
	620, 596, 620, 596, 620, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 620, 
	620, 620, 620, 555, 620, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 633, 555, 620, 
	620, 620, 620, 620, 555, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 596, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 620, 
	620, 620, 596, 620, 596, 620, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	620, 620, 620, 620, 555, 620, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 644, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	620, 620, 620, 620, 620, 555, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 596, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	620, 620, 620, 596, 620, 596, 620, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 620, 620, 620, 620, 555, 620, 555, 
	555, 555, 555, 679, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 680, 555, 555, 555, 555, 
	555, 620, 620, 620, 620, 620, 555, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	596, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 620, 620, 620, 596, 620, 596, 620, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 620, 620, 620, 620, 555, 620, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 662, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 620, 620, 620, 620, 620, 555, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 596, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 620, 620, 620, 596, 620, 596, 
	620, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 620, 620, 620, 620, 555, 
	620, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	681, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 620, 620, 620, 620, 620, 
	555, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 596, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 620, 620, 620, 596, 620, 
	596, 620, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 620, 620, 620, 620, 
	555, 620, 555, 555, 555, 555, 587, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 620, 620, 620, 620, 
	620, 555, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 596, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 620, 620, 620, 596, 
	620, 596, 620, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 620, 620, 620, 
	620, 555, 620, 555, 555, 555, 555, 555, 
	555, 555, 682, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 676, 555, 555, 555, 
	555, 555, 555, 555, 555, 620, 620, 620, 
	620, 620, 555, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 596, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 620, 620, 620, 
	596, 620, 596, 620, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 620, 620, 
	620, 620, 555, 620, 555, 555, 555, 555, 
	644, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 620, 620, 
	620, 620, 620, 555, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 596, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 620, 620, 
	620, 596, 620, 596, 620, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 620, 
	620, 620, 620, 555, 620, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 683, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 620, 
	620, 620, 620, 620, 555, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 596, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 620, 
	620, 620, 596, 620, 596, 620, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	620, 620, 620, 620, 555, 620, 555, 555, 
	555, 684, 555, 555, 555, 555, 555, 555, 
	555, 685, 555, 555, 555, 555, 555, 555, 
	555, 686, 555, 555, 555, 555, 555, 555, 
	620, 620, 620, 620, 620, 555, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 596, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	620, 620, 620, 596, 620, 596, 620, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 620, 620, 620, 620, 555, 620, 555, 
	555, 555, 555, 662, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 620, 620, 620, 620, 620, 555, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	596, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 620, 620, 620, 596, 620, 596, 620, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 620, 620, 620, 620, 555, 620, 
	555, 555, 555, 555, 650, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 620, 620, 620, 620, 620, 555, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 596, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 620, 620, 620, 596, 620, 596, 
	620, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 620, 620, 620, 620, 555, 
	620, 555, 555, 555, 555, 555, 555, 555, 
	555, 670, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 620, 620, 620, 620, 620, 
	555, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 596, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 620, 620, 620, 596, 620, 
	596, 620, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 620, 620, 620, 620, 
	555, 620, 555, 555, 555, 555, 555, 555, 
	555, 687, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 620, 620, 620, 620, 
	620, 555, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 596, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 620, 620, 620, 596, 
	620, 596, 620, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 620, 620, 620, 
	620, 555, 620, 555, 555, 555, 555, 644, 
	555, 555, 555, 668, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 620, 620, 620, 
	620, 620, 555, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 596, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 620, 620, 620, 
	596, 620, 596, 620, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 620, 620, 
	620, 620, 555, 620, 555, 555, 555, 555, 
	555, 555, 555, 555, 688, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 620, 620, 
	620, 620, 620, 555, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 596, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 620, 620, 
	620, 596, 620, 596, 620, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 620, 
	620, 620, 620, 555, 620, 555, 555, 555, 
	555, 689, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 620, 
	620, 620, 620, 620, 555, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 596, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 620, 
	620, 620, 596, 620, 596, 620, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	620, 620, 620, 620, 555, 620, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	555, 638, 555, 555, 555, 555, 555, 555, 
	555, 555, 555, 555, 555, 555, 555, 555, 
	620, 620, 620, 620, 620, 555, 567, 599, 
	691, 692, 692, 692, 691, 692, 692, 692, 
	692, 693, 692, 693, 693, 693, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 691, 692, 692, 692, 692, 692, 
	693, 692, 692, 694, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 692, 692, 692, 692, 692, 692, 692, 
	692, 690, 690, 690, 690, 690, 690, 690, 
	690, 690, 690, 690, 690, 690, 690, 690, 
	690, 690, 690, 690, 690, 690, 690, 690, 
	690, 690, 690, 692, 695, 692, 692, 690, 
	692, 690, 690, 690, 690, 690, 690, 690, 
	690, 690, 690, 690, 690, 690, 690, 690, 
	690, 690, 690, 690, 690, 690, 690, 690, 
	690, 690, 690, 692, 692, 692, 692, 692, 
	690, 696, 696, 696, 696, 696, 696, 696, 
	696, 696, 696, 696, 696, 696, 696, 696, 
	696, 696, 696, 696, 696, 696, 696, 696, 
	696, 696, 696, 696, 696, 696, 696, 696, 
	696, 696, 100, 696, 696, 696, 696, 696, 
	696, 696, 696, 696, 696, 696, 696, 696, 
	696, 99, 99, 99, 99, 99, 99, 99, 
	99, 99, 99, 101, 696, 696, 696, 696, 
	100, 696, 99, 99, 99, 99, 99, 99, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	99, 99, 99, 99, 696, 696, 696, 696, 
	99, 696, 99, 99, 99, 99, 99, 99, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	99, 99, 99, 99, 696, 696, 696, 696, 
	696, 99, 693, 697, 693, 693, 693, 697, 
	697, 697, 697, 697, 697, 697, 697, 697, 
	697, 697, 697, 697, 697, 697, 697, 697, 
	697, 693, 697, 698, 699, 700, 701, 702, 
	696, 703, 705, 706, 706, 706, 705, 706, 
	706, 706, 706, 707, 708, 707, 707, 707, 
	706, 706, 706, 706, 706, 706, 706, 706, 
	706, 706, 706, 706, 705, 706, 706, 706, 
	706, 706, 707, 709, 706, 710, 706, 711, 
	712, 706, 706, 706, 713, 714, 706, 714, 
	706, 711, 706, 706, 706, 706, 706, 706, 
	706, 706, 706, 706, 706, 706, 715, 716, 
	717, 706, 706, 718, 718, 718, 718, 718, 
	718, 718, 718, 718, 718, 718, 718, 718, 
	718, 718, 718, 718, 718, 718, 718, 718, 
	718, 718, 718, 718, 718, 719, 720, 706, 
	711, 704, 711, 704, 704, 704, 704, 704, 
	704, 704, 704, 704, 704, 704, 704, 704, 
	704, 704, 704, 704, 704, 704, 704, 704, 
	704, 704, 704, 704, 704, 706, 721, 706, 
	714, 706, 704, 722, 722, 722, 722, 722, 
	722, 722, 722, 722, 722, 722, 722, 722, 
	722, 722, 722, 722, 722, 722, 722, 722, 
	722, 722, 722, 722, 722, 722, 722, 722, 
	722, 722, 722, 722, 723, 722, 722, 722, 
	722, 722, 722, 722, 722, 722, 722, 722, 
	722, 722, 722, 704, 704, 704, 704, 704, 
	704, 704, 704, 704, 704, 722, 722, 722, 
	722, 722, 723, 722, 704, 704, 704, 704, 
	704, 704, 704, 704, 704, 704, 704, 704, 
	704, 704, 704, 704, 704, 704, 704, 704, 
	704, 704, 704, 704, 704, 704, 722, 722, 
	722, 722, 704, 722, 704, 704, 704, 704, 
	704, 704, 704, 704, 704, 704, 704, 704, 
	704, 704, 704, 704, 704, 704, 704, 704, 
	704, 704, 704, 704, 704, 704, 722, 722, 
	722, 722, 722, 704, 725, 724, 726, 707, 
	727, 707, 707, 707, 727, 727, 727, 727, 
	727, 727, 727, 727, 727, 727, 727, 727, 
	727, 727, 727, 727, 727, 727, 707, 727, 
	728, 711, 729, 729, 711, 729, 729, 729, 
	729, 729, 729, 729, 729, 729, 729, 729, 
	729, 729, 729, 729, 729, 729, 729, 729, 
	729, 729, 729, 729, 729, 729, 729, 729, 
	729, 729, 729, 729, 729, 729, 729, 729, 
	729, 729, 729, 729, 729, 729, 729, 729, 
	729, 729, 729, 729, 729, 729, 729, 729, 
	729, 729, 729, 729, 729, 729, 729, 729, 
	729, 729, 711, 729, 730, 731, 732, 733, 
	711, 729, 711, 729, 711, 729, 711, 734, 
	729, 711, 729, 736, 711, 735, 735, 735, 
	735, 735, 735, 735, 735, 735, 735, 735, 
	735, 735, 735, 735, 735, 735, 735, 735, 
	735, 735, 735, 735, 735, 735, 735, 735, 
	735, 735, 735, 735, 735, 735, 735, 735, 
	735, 735, 735, 735, 735, 735, 735, 735, 
	735, 735, 735, 735, 735, 735, 735, 735, 
	735, 735, 735, 735, 735, 735, 735, 735, 
	735, 735, 735, 735, 711, 735, 711, 729, 
	711, 711, 729, 737, 737, 737, 737, 737, 
	737, 737, 737, 737, 737, 737, 737, 737, 
	737, 737, 737, 737, 737, 737, 737, 737, 
	737, 737, 737, 737, 737, 737, 737, 737, 
	737, 737, 737, 737, 723, 737, 737, 737, 
	737, 737, 737, 737, 737, 737, 737, 737, 
	737, 737, 737, 718, 718, 718, 718, 718, 
	718, 718, 718, 718, 718, 737, 737, 737, 
	737, 737, 723, 737, 718, 718, 718, 718, 
	718, 718, 718, 718, 718, 718, 718, 718, 
	718, 718, 718, 718, 718, 718, 718, 718, 
	718, 718, 718, 718, 718, 718, 737, 737, 
	737, 737, 718, 737, 718, 718, 718, 718, 
	718, 718, 718, 718, 718, 718, 718, 718, 
	718, 718, 718, 718, 718, 718, 718, 718, 
	718, 718, 718, 718, 718, 718, 737, 737, 
	737, 737, 737, 718, 736, 735, 708, 735, 
	711, 729, 739, 738, 738, 738, 739, 738, 
	738, 738, 738, 740, 741, 740, 740, 740, 
	738, 738, 738, 738, 738, 738, 738, 738, 
	738, 738, 738, 738, 739, 738, 738, 738, 
	738, 738, 740, 738, 738, 742, 738, 109, 
	743, 738, 744, 738, 745, 109, 140, 746, 
	142, 109, 738, 738, 738, 738, 738, 738, 
	738, 738, 738, 738, 747, 738, 748, 140, 
	749, 750, 738, 738, 738, 738, 738, 738, 
	738, 738, 738, 738, 738, 738, 738, 738, 
	738, 738, 738, 738, 738, 738, 738, 738, 
	738, 738, 738, 738, 738, 140, 751, 140, 
	109, 738, 738, 738, 738, 738, 738, 738, 
	738, 738, 738, 752, 738, 738, 738, 738, 
	738, 738, 738, 738, 753, 738, 738, 754, 
	738, 755, 738, 738, 738, 153, 154, 738, 
	109, 738, 756, 756, 756, 756, 756, 756, 
	756, 756, 756, 740, 756, 740, 740, 740, 
	756, 756, 756, 756, 756, 756, 756, 756, 
	756, 756, 756, 756, 756, 756, 756, 756, 
	756, 756, 740, 756, 756, 756, 756, 135, 
	136, 756, 137, 756, 138, 139, 140, 141, 
	142, 135, 756, 756, 756, 756, 756, 756, 
	756, 756, 756, 756, 143, 756, 144, 140, 
	145, 146, 756, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 147, 148, 140, 
	109, 104, 756, 104, 104, 104, 104, 104, 
	104, 104, 104, 149, 104, 104, 104, 104, 
	104, 104, 104, 104, 150, 104, 104, 151, 
	104, 152, 104, 104, 104, 153, 154, 756, 
	109, 756, 104, 757, 758, 758, 758, 757, 
	758, 758, 758, 758, 140, 759, 140, 140, 
	140, 758, 758, 758, 758, 758, 758, 758, 
	758, 758, 758, 758, 758, 757, 758, 758, 
	758, 758, 758, 140, 758, 758, 758, 758, 
	758, 758, 758, 758, 758, 758, 758, 758, 
	758, 758, 758, 758, 758, 758, 758, 758, 
	758, 758, 758, 758, 758, 758, 758, 758, 
	140, 758, 140, 759, 140, 140, 140, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 140, 103, 103, 103, 103, 103, 109, 
	103, 103, 103, 103, 103, 103, 103, 140, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 103, 140, 103, 
	140, 759, 140, 140, 140, 103, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 140, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 140, 103, 760, 140, 
	759, 140, 140, 140, 761, 761, 761, 761, 
	761, 761, 761, 761, 761, 761, 761, 761, 
	761, 761, 761, 761, 761, 761, 140, 761, 
	761, 761, 761, 761, 761, 761, 761, 761, 
	762, 761, 761, 761, 761, 761, 761, 761, 
	761, 761, 761, 761, 761, 761, 761, 761, 
	761, 761, 761, 140, 761, 140, 759, 140, 
	140, 140, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 140, 103, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 140, 140, 103, 763, 757, 140, 757, 
	765, 764, 767, 768, 767, 767, 767, 766, 
	766, 766, 766, 766, 766, 766, 766, 766, 
	766, 766, 766, 766, 766, 766, 766, 766, 
	766, 767, 766, 769, 757, 757, 757, 757, 
	757, 757, 757, 757, 757, 757, 757, 757, 
	757, 757, 757, 757, 757, 757, 757, 757, 
	757, 757, 757, 757, 757, 757, 757, 757, 
	757, 757, 757, 757, 757, 105, 757, 757, 
	757, 757, 757, 757, 757, 757, 757, 757, 
	757, 757, 757, 757, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 106, 757, 
	757, 757, 757, 105, 757, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 757, 
	757, 757, 757, 104, 757, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 757, 
	757, 757, 757, 757, 104, 770, 140, 759, 
	140, 140, 140, 757, 757, 757, 757, 757, 
	757, 757, 757, 757, 757, 757, 757, 757, 
	757, 757, 757, 757, 757, 140, 757, 757, 
	757, 757, 757, 757, 757, 757, 757, 757, 
	757, 757, 757, 757, 757, 757, 757, 757, 
	757, 757, 757, 757, 757, 757, 757, 757, 
	757, 757, 140, 757, 757, 757, 757, 757, 
	757, 757, 757, 757, 757, 757, 757, 757, 
	757, 757, 757, 757, 757, 757, 757, 757, 
	757, 757, 757, 757, 757, 757, 757, 757, 
	757, 757, 757, 757, 757, 757, 757, 757, 
	757, 757, 757, 757, 757, 757, 757, 757, 
	757, 757, 757, 757, 757, 757, 757, 757, 
	757, 757, 757, 757, 757, 757, 757, 757, 
	757, 109, 757, 771, 772, 773, 774, 775, 
	776, 140, 759, 140, 140, 140, 757, 757, 
	757, 757, 757, 757, 757, 757, 757, 757, 
	757, 757, 757, 757, 757, 757, 757, 757, 
	140, 757, 757, 757, 757, 757, 757, 757, 
	757, 757, 109, 757, 757, 757, 757, 757, 
	757, 757, 757, 757, 757, 757, 757, 757, 
	757, 757, 757, 757, 757, 140, 757, 140, 
	764, 109, 777, 109, 777, 778, 779, 778, 
	778, 778, 766, 766, 766, 766, 766, 766, 
	766, 766, 766, 766, 766, 766, 766, 766, 
	766, 766, 766, 766, 778, 766, 780, 777, 
	781, 781, 781, 781, 781, 781, 781, 781, 
	781, 112, 781, 112, 112, 112, 781, 781, 
	781, 781, 781, 781, 781, 781, 781, 781, 
	781, 781, 781, 781, 781, 781, 781, 781, 
	112, 781, 781, 781, 781, 113, 114, 781, 
	115, 781, 116, 117, 118, 119, 120, 113, 
	781, 781, 781, 781, 781, 781, 781, 781, 
	781, 781, 121, 781, 122, 118, 123, 124, 
	781, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 125, 126, 118, 127, 111, 
	781, 111, 111, 111, 111, 111, 111, 111, 
	111, 128, 111, 111, 111, 111, 111, 111, 
	111, 111, 129, 111, 111, 130, 111, 131, 
	111, 111, 111, 132, 133, 781, 127, 781, 
	111, 140, 777, 782, 777, 783, 777, 784, 
	777, 785, 179, 179, 179, 785, 179, 179, 
	179, 179, 786, 179, 786, 786, 786, 179, 
	179, 179, 179, 179, 179, 179, 179, 179, 
	179, 179, 179, 785, 179, 179, 179, 179, 
	179, 786, 179, 179, 179, 179, 179, 179, 
	179, 179, 179, 179, 179, 179, 179, 179, 
	179, 179, 179, 179, 179, 179, 179, 179, 
	179, 179, 179, 179, 179, 179, 179, 179, 
	179, 179, 181, 181, 181, 181, 181, 181, 
	181, 181, 181, 181, 181, 181, 181, 181, 
	181, 181, 181, 181, 181, 181, 181, 181, 
	181, 181, 181, 181, 179, 787, 179, 179, 
	181, 179, 181, 181, 181, 185, 181, 181, 
	181, 181, 181, 181, 181, 181, 181, 181, 
	181, 181, 181, 181, 181, 181, 181, 181, 
	181, 181, 181, 181, 179, 179, 179, 179, 
	179, 181, 178, 178, 178, 178, 178, 178, 
	178, 178, 178, 178, 178, 178, 178, 178, 
	178, 178, 178, 178, 178, 178, 178, 178, 
	178, 178, 178, 178, 178, 178, 178, 178, 
	178, 178, 178, 788, 178, 178, 178, 178, 
	178, 178, 178, 178, 178, 178, 178, 178, 
	178, 178, 181, 181, 181, 181, 181, 181, 
	181, 181, 181, 181, 179, 178, 178, 178, 
	178, 788, 178, 181, 181, 181, 181, 181, 
	181, 181, 181, 181, 181, 181, 181, 181, 
	181, 181, 181, 181, 181, 181, 181, 181, 
	181, 181, 181, 181, 181, 178, 178, 178, 
	178, 181, 178, 181, 181, 181, 181, 181, 
	181, 181, 181, 181, 181, 181, 181, 181, 
	181, 181, 181, 181, 181, 181, 181, 181, 
	181, 181, 181, 181, 181, 178, 178, 178, 
	178, 178, 181, 789, 789, 789, 789, 789, 
	789, 789, 789, 789, 182, 789, 182, 182, 
	182, 789, 789, 789, 789, 789, 789, 789, 
	789, 789, 789, 789, 789, 789, 789, 789, 
	789, 789, 789, 182, 789, 789, 789, 789, 
	789, 789, 789, 183, 789, 789, 789, 789, 
	789, 789, 789, 789, 789, 789, 789, 789, 
	789, 789, 789, 789, 789, 789, 789, 789, 
	789, 789, 789, 789, 181, 181, 181, 181, 
	181, 181, 181, 181, 181, 181, 181, 181, 
	181, 181, 181, 181, 181, 181, 181, 181, 
	181, 181, 181, 181, 181, 181, 789, 184, 
	789, 789, 181, 789, 181, 181, 181, 185, 
	181, 181, 181, 181, 181, 181, 181, 181, 
	181, 181, 181, 181, 181, 181, 181, 181, 
	181, 181, 181, 181, 181, 181, 789, 789, 
	789, 789, 789, 181, 790, 789, 789, 789, 
	789, 789, 789, 789, 789, 789, 789, 789, 
	789, 789, 789, 789, 789, 789, 789, 789, 
	789, 789, 789, 789, 789, 789, 789, 789, 
	789, 789, 789, 789, 789, 789, 788, 789, 
	789, 789, 789, 789, 789, 789, 789, 789, 
	789, 789, 789, 789, 789, 181, 181, 181, 
	181, 181, 181, 181, 181, 181, 181, 179, 
	789, 789, 789, 789, 788, 789, 181, 181, 
	181, 181, 181, 181, 181, 181, 181, 181, 
	181, 181, 181, 181, 181, 181, 181, 181, 
	181, 181, 181, 181, 181, 181, 181, 181, 
	789, 789, 789, 789, 181, 789, 181, 181, 
	181, 181, 181, 181, 181, 181, 181, 181, 
	181, 181, 181, 181, 791, 181, 181, 181, 
	181, 181, 181, 181, 181, 181, 181, 181, 
	789, 789, 789, 789, 789, 181, 186, 789, 
	793, 792, 792, 792, 793, 792, 792, 792, 
	792, 794, 792, 794, 794, 794, 792, 792, 
	792, 792, 792, 792, 792, 792, 792, 792, 
	792, 792, 793, 792, 792, 792, 792, 792, 
	794, 792, 792, 795, 792, 792, 792, 792, 
	792, 792, 792, 792, 792, 792, 792, 792, 
	792, 792, 792, 792, 792, 792, 792, 792, 
	792, 792, 792, 792, 792, 792, 792, 792, 
	792, 792, 792, 792, 792, 792, 792, 792, 
	792, 792, 792, 792, 792, 792, 792, 792, 
	792, 792, 792, 792, 792, 792, 792, 792, 
	792, 792, 792, 792, 796, 792, 792, 792, 
	792, 792, 792, 792, 797, 792, 792, 792, 
	792, 792, 792, 792, 792, 792, 792, 792, 
	792, 792, 792, 792, 792, 792, 792, 792, 
	792, 792, 792, 798, 792, 794, 799, 794, 
	794, 794, 799, 799, 799, 799, 799, 799, 
	799, 799, 799, 799, 799, 799, 799, 799, 
	799, 799, 799, 799, 794, 799, 800, 801, 
	802, 803, 805, 804, 806, 807, 804, 808, 
	810, 811, 811, 811, 810, 811, 811, 811, 
	811, 812, 813, 812, 812, 812, 811, 811, 
	811, 811, 811, 811, 811, 811, 811, 811, 
	811, 811, 810, 811, 811, 811, 811, 811, 
	812, 811, 811, 814, 811, 811, 811, 811, 
	811, 811, 811, 811, 811, 811, 811, 811, 
	811, 811, 811, 811, 811, 811, 811, 811, 
	811, 811, 811, 811, 811, 811, 811, 811, 
	811, 809, 809, 809, 809, 809, 809, 809, 
	809, 809, 809, 809, 809, 809, 809, 809, 
	809, 809, 809, 809, 809, 809, 809, 809, 
	809, 809, 809, 811, 815, 811, 811, 809, 
	811, 809, 809, 809, 809, 809, 809, 809, 
	809, 816, 809, 809, 809, 809, 809, 809, 
	809, 809, 817, 809, 809, 818, 809, 819, 
	809, 809, 809, 811, 811, 811, 811, 811, 
	809, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 809, 809, 809, 809, 809, 809, 809, 
	809, 809, 809, 820, 820, 820, 820, 820, 
	820, 820, 809, 809, 809, 809, 809, 809, 
	809, 809, 809, 809, 809, 809, 809, 809, 
	809, 809, 809, 809, 809, 809, 809, 809, 
	809, 809, 809, 809, 820, 820, 820, 820, 
	809, 820, 809, 809, 809, 809, 809, 809, 
	809, 809, 809, 809, 809, 809, 809, 809, 
	809, 809, 809, 809, 809, 809, 809, 809, 
	809, 809, 809, 809, 820, 820, 820, 820, 
	820, 809, 812, 821, 812, 812, 812, 821, 
	821, 821, 821, 821, 821, 821, 821, 821, 
	821, 821, 821, 821, 821, 821, 821, 821, 
	821, 812, 821, 822, 823, 824, 825, 826, 
	828, 827, 829, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 809, 809, 809, 809, 809, 
	809, 809, 809, 809, 809, 830, 830, 830, 
	830, 830, 830, 830, 809, 809, 809, 809, 
	809, 809, 809, 809, 809, 809, 809, 809, 
	809, 809, 809, 809, 809, 809, 809, 809, 
	809, 809, 809, 809, 809, 809, 830, 830, 
	830, 830, 809, 830, 809, 809, 809, 809, 
	809, 831, 809, 809, 809, 809, 809, 809, 
	809, 809, 809, 809, 809, 809, 809, 809, 
	809, 809, 809, 809, 809, 809, 830, 830, 
	830, 830, 830, 809, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 809, 809, 809, 809, 
	809, 809, 809, 809, 809, 809, 830, 830, 
	830, 830, 830, 830, 830, 809, 809, 809, 
	809, 809, 809, 809, 809, 809, 809, 809, 
	809, 809, 809, 809, 809, 809, 809, 809, 
	809, 809, 809, 809, 809, 809, 809, 830, 
	830, 830, 830, 809, 830, 809, 809, 809, 
	809, 832, 809, 809, 809, 809, 809, 809, 
	809, 809, 809, 809, 809, 809, 809, 809, 
	809, 809, 809, 809, 809, 809, 809, 830, 
	830, 830, 830, 830, 809, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 809, 809, 809, 
	809, 809, 809, 809, 809, 809, 809, 830, 
	830, 830, 830, 830, 830, 830, 809, 809, 
	809, 809, 809, 809, 809, 809, 809, 809, 
	809, 809, 809, 809, 809, 809, 809, 809, 
	809, 809, 809, 809, 809, 809, 809, 809, 
	830, 830, 830, 830, 809, 830, 809, 809, 
	809, 809, 809, 809, 809, 809, 809, 809, 
	809, 809, 809, 809, 809, 809, 809, 809, 
	833, 809, 809, 809, 809, 809, 809, 809, 
	830, 830, 830, 830, 830, 809, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 809, 809, 
	809, 809, 809, 809, 809, 809, 809, 809, 
	830, 830, 830, 830, 830, 830, 830, 809, 
	809, 809, 809, 809, 809, 809, 809, 809, 
	809, 809, 809, 809, 809, 809, 809, 809, 
	809, 809, 809, 809, 809, 809, 809, 809, 
	809, 830, 830, 830, 830, 809, 830, 809, 
	809, 834, 809, 809, 809, 809, 809, 809, 
	809, 809, 809, 809, 809, 809, 809, 809, 
	809, 809, 809, 809, 809, 809, 809, 809, 
	809, 830, 830, 830, 830, 830, 809, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 809, 
	809, 809, 809, 809, 809, 809, 809, 809, 
	809, 830, 830, 830, 830, 830, 830, 830, 
	809, 809, 809, 809, 809, 809, 809, 809, 
	809, 809, 809, 809, 809, 809, 809, 809, 
	809, 809, 809, 809, 809, 809, 809, 809, 
	809, 809, 830, 830, 830, 830, 809, 830, 
	809, 809, 809, 809, 809, 809, 809, 809, 
	809, 809, 809, 809, 809, 809, 809, 809, 
	809, 809, 809, 809, 835, 809, 809, 809, 
	809, 809, 830, 830, 830, 830, 830, 809, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	809, 809, 809, 809, 809, 809, 809, 809, 
	809, 809, 830, 830, 830, 830, 830, 830, 
	830, 809, 809, 809, 809, 809, 809, 809, 
	809, 809, 809, 809, 809, 809, 809, 809, 
	809, 809, 809, 809, 809, 809, 809, 809, 
	809, 809, 809, 830, 830, 830, 830, 809, 
	830, 809, 809, 809, 809, 831, 809, 809, 
	809, 809, 809, 809, 809, 809, 809, 809, 
	809, 809, 809, 809, 809, 809, 809, 809, 
	809, 809, 809, 830, 830, 830, 830, 830, 
	809, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 809, 809, 809, 809, 809, 809, 809, 
	809, 809, 809, 830, 830, 830, 830, 830, 
	830, 830, 809, 809, 809, 809, 809, 809, 
	809, 809, 809, 809, 809, 809, 809, 809, 
	809, 809, 809, 809, 809, 809, 809, 809, 
	809, 809, 809, 809, 830, 830, 830, 830, 
	809, 830, 809, 809, 809, 809, 809, 809, 
	809, 809, 809, 809, 809, 809, 809, 836, 
	809, 809, 809, 809, 809, 809, 809, 809, 
	809, 809, 809, 809, 830, 830, 830, 830, 
	830, 809, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 809, 809, 809, 809, 809, 809, 
	809, 809, 809, 809, 830, 830, 830, 830, 
	830, 830, 830, 809, 809, 809, 809, 809, 
	809, 809, 809, 809, 809, 809, 809, 809, 
	809, 809, 809, 809, 809, 809, 809, 809, 
	809, 809, 809, 809, 809, 830, 830, 830, 
	830, 809, 830, 809, 809, 809, 809, 809, 
	809, 809, 809, 809, 809, 809, 837, 809, 
	809, 809, 809, 809, 809, 809, 838, 809, 
	809, 809, 809, 809, 809, 830, 830, 830, 
	830, 830, 809, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 809, 809, 809, 809, 809, 
	809, 809, 809, 809, 809, 830, 830, 830, 
	830, 830, 830, 830, 809, 809, 809, 809, 
	809, 809, 809, 809, 809, 809, 809, 809, 
	809, 809, 809, 809, 809, 809, 809, 809, 
	809, 809, 809, 809, 809, 809, 830, 830, 
	830, 830, 809, 830, 809, 809, 809, 809, 
	839, 809, 809, 809, 809, 809, 809, 809, 
	809, 809, 809, 809, 809, 809, 809, 809, 
	809, 809, 809, 809, 809, 809, 830, 830, 
	830, 830, 830, 809, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 809, 809, 809, 809, 
	809, 809, 809, 809, 809, 809, 830, 830, 
	830, 830, 830, 830, 830, 809, 809, 809, 
	809, 809, 809, 809, 809, 809, 809, 809, 
	809, 809, 809, 809, 809, 809, 809, 809, 
	809, 809, 809, 809, 809, 809, 809, 830, 
	830, 830, 830, 809, 830, 809, 809, 809, 
	809, 809, 809, 809, 809, 809, 809, 809, 
	809, 809, 809, 809, 809, 809, 809, 840, 
	809, 809, 809, 809, 809, 809, 809, 830, 
	830, 830, 830, 830, 809, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 809, 809, 809, 
	809, 809, 809, 809, 809, 809, 809, 830, 
	830, 830, 830, 830, 830, 830, 809, 809, 
	809, 809, 809, 809, 809, 809, 809, 809, 
	809, 809, 809, 809, 809, 809, 809, 809, 
	809, 809, 809, 809, 809, 809, 809, 809, 
	830, 830, 830, 830, 809, 830, 809, 809, 
	809, 809, 809, 809, 809, 809, 809, 809, 
	809, 809, 809, 809, 809, 809, 809, 809, 
	831, 809, 809, 809, 809, 809, 809, 809, 
	830, 830, 830, 830, 830, 809, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 809, 809, 
	809, 809, 809, 809, 809, 809, 809, 809, 
	830, 830, 830, 830, 830, 830, 830, 809, 
	809, 809, 809, 809, 809, 809, 809, 809, 
	809, 809, 809, 809, 809, 809, 809, 809, 
	809, 809, 809, 809, 809, 809, 809, 809, 
	809, 830, 830, 830, 830, 809, 830, 809, 
	809, 809, 809, 809, 809, 809, 809, 841, 
	809, 809, 809, 809, 809, 809, 809, 809, 
	809, 809, 809, 809, 809, 809, 809, 809, 
	809, 830, 830, 830, 830, 830, 809, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 809, 
	809, 809, 809, 809, 809, 809, 809, 809, 
	809, 830, 830, 830, 830, 830, 830, 830, 
	809, 809, 809, 809, 809, 809, 809, 809, 
	809, 809, 809, 809, 809, 809, 809, 809, 
	809, 809, 809, 809, 809, 809, 809, 809, 
	809, 809, 830, 830, 830, 830, 809, 830, 
	809, 809, 809, 809, 809, 809, 809, 809, 
	809, 809, 809, 831, 809, 809, 809, 809, 
	809, 809, 809, 809, 809, 809, 809, 809, 
	809, 809, 830, 830, 830, 830, 830, 809, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	809, 809, 809, 809, 809, 809, 809, 809, 
	809, 809, 830, 830, 830, 830, 830, 830, 
	830, 809, 809, 809, 809, 809, 809, 809, 
	809, 809, 809, 809, 809, 809, 809, 809, 
	809, 809, 809, 809, 809, 809, 809, 809, 
	809, 809, 809, 830, 830, 830, 830, 809, 
	830, 809, 809, 809, 809, 809, 809, 809, 
	842, 809, 809, 809, 809, 809, 809, 809, 
	809, 809, 809, 809, 809, 809, 809, 809, 
	809, 809, 809, 830, 830, 830, 830, 830, 
	809, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 809, 809, 809, 809, 809, 809, 809, 
	809, 809, 809, 830, 830, 830, 830, 830, 
	830, 830, 809, 809, 809, 809, 809, 809, 
	809, 809, 809, 809, 809, 809, 809, 809, 
	809, 809, 809, 809, 809, 809, 809, 809, 
	809, 809, 809, 809, 830, 830, 830, 830, 
	809, 830, 809, 809, 809, 809, 809, 809, 
	809, 809, 843, 809, 809, 809, 809, 809, 
	809, 809, 809, 809, 809, 809, 809, 809, 
	809, 809, 809, 809, 830, 830, 830, 830, 
	830, 809, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 809, 809, 809, 809, 809, 809, 
	809, 809, 809, 809, 830, 830, 830, 830, 
	830, 830, 830, 809, 809, 809, 809, 809, 
	809, 809, 809, 809, 809, 809, 809, 809, 
	809, 809, 809, 809, 809, 809, 809, 809, 
	809, 809, 809, 809, 809, 830, 830, 830, 
	830, 809, 830, 809, 809, 809, 809, 809, 
	809, 809, 809, 809, 809, 809, 835, 809, 
	809, 809, 809, 809, 809, 809, 809, 809, 
	809, 809, 809, 809, 809, 830, 830, 830, 
	830, 830, 809, 845, 211, 211, 211, 845, 
	211, 211, 211, 211, 846, 847, 846, 846, 
	846, 211, 211, 211, 211, 211, 211, 211, 
	211, 211, 211, 211, 211, 845, 211, 211, 
	211, 211, 211, 846, 848, 211, 849, 211, 
	850, 851, 211, 852, 211, 853, 854, 211, 
	855, 856, 857, 211, 211, 211, 211, 211, 
	211, 211, 211, 211, 211, 858, 211, 859, 
	860, 861, 862, 211, 863, 864, 863, 863, 
	865, 863, 863, 863, 863, 863, 863, 863, 
	863, 863, 863, 863, 863, 863, 863, 863, 
	863, 863, 863, 863, 863, 863, 866, 867, 
	211, 868, 869, 211, 870, 871, 872, 873, 
	874, 875, 844, 844, 876, 844, 844, 844, 
	877, 878, 879, 844, 844, 880, 881, 882, 
	883, 844, 884, 844, 885, 844, 886, 887, 
	211, 868, 211, 844, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 889, 888, 889, 
	889, 889, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 889, 279, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 280, 888, 
	888, 281, 888, 279, 888, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 888, 
	890, 888, 888, 844, 888, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 888, 
	888, 888, 888, 888, 844, 892, 891, 891, 
	893, 891, 894, 896, 897, 895, 895, 895, 
	895, 895, 895, 895, 895, 895, 895, 895, 
	895, 895, 895, 895, 895, 895, 895, 895, 
	895, 895, 895, 895, 895, 895, 895, 895, 
	895, 895, 895, 895, 895, 895, 895, 895, 
	895, 895, 895, 895, 895, 895, 895, 895, 
	895, 895, 895, 895, 895, 895, 895, 895, 
	895, 895, 895, 895, 895, 895, 895, 895, 
	895, 895, 895, 895, 898, 895, 900, 899, 
	901, 902, 903, 846, 904, 846, 846, 846, 
	904, 904, 904, 904, 904, 904, 904, 904, 
	904, 904, 904, 904, 904, 904, 904, 904, 
	904, 904, 846, 904, 906, 905, 908, 909, 
	908, 908, 908, 907, 907, 907, 907, 907, 
	907, 907, 907, 907, 907, 907, 907, 907, 
	907, 907, 907, 907, 907, 908, 907, 211, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	211, 910, 911, 912, 913, 914, 917, 917, 
	917, 917, 917, 917, 917, 917, 917, 917, 
	917, 917, 917, 917, 917, 917, 917, 917, 
	917, 917, 917, 917, 917, 917, 917, 917, 
	916, 916, 916, 916, 916, 916, 917, 917, 
	917, 917, 917, 917, 917, 917, 917, 917, 
	917, 917, 917, 917, 917, 917, 917, 917, 
	917, 917, 917, 917, 917, 917, 917, 917, 
	916, 918, 209, 209, 209, 918, 209, 209, 
	209, 209, 209, 209, 209, 209, 209, 209, 
	209, 209, 209, 209, 209, 209, 209, 209, 
	209, 209, 209, 918, 209, 209, 209, 209, 
	209, 209, 209, 209, 209, 209, 209, 209, 
	209, 209, 209, 209, 209, 209, 209, 209, 
	209, 209, 209, 209, 209, 209, 209, 209, 
	209, 209, 209, 209, 209, 209, 209, 209, 
	209, 209, 210, 210, 210, 210, 210, 210, 
	210, 210, 210, 210, 210, 210, 210, 210, 
	210, 210, 210, 210, 210, 210, 210, 210, 
	210, 210, 210, 210, 209, 209, 209, 209, 
	209, 209, 210, 210, 210, 210, 210, 210, 
	210, 210, 210, 210, 210, 210, 210, 210, 
	210, 210, 210, 210, 210, 210, 210, 210, 
	210, 210, 210, 210, 209, 920, 919, 919, 
	919, 919, 919, 919, 919, 919, 919, 919, 
	919, 919, 919, 919, 919, 919, 919, 919, 
	919, 919, 919, 919, 211, 919, 921, 923, 
	922, 922, 922, 922, 922, 922, 922, 922, 
	922, 922, 922, 922, 922, 922, 922, 922, 
	922, 922, 211, 922, 211, 200, 212, 213, 
	212, 212, 212, 919, 919, 919, 919, 919, 
	919, 919, 919, 919, 919, 919, 919, 919, 
	919, 919, 919, 919, 919, 212, 919, 919, 
	214, 919, 919, 919, 919, 919, 919, 919, 
	919, 919, 919, 919, 919, 215, 215, 215, 
	215, 215, 215, 215, 215, 215, 215, 919, 
	919, 919, 211, 919, 919, 919, 919, 919, 
	919, 919, 919, 919, 919, 919, 919, 919, 
	919, 919, 919, 919, 919, 919, 919, 919, 
	919, 919, 919, 919, 919, 919, 919, 919, 
	919, 216, 919, 229, 230, 229, 229, 229, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 229, 228, 228, 231, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 232, 232, 232, 232, 232, 232, 
	232, 232, 232, 232, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 233, 228, 
	212, 213, 212, 212, 212, 919, 919, 919, 
	919, 919, 919, 919, 919, 919, 919, 919, 
	919, 919, 919, 919, 919, 919, 919, 212, 
	919, 919, 214, 919, 919, 919, 919, 919, 
	919, 919, 919, 919, 919, 919, 919, 215, 
	215, 215, 215, 215, 215, 215, 215, 215, 
	215, 919, 919, 919, 211, 211, 919, 919, 
	919, 919, 919, 919, 919, 919, 919, 919, 
	919, 919, 919, 919, 919, 919, 919, 919, 
	919, 919, 919, 919, 919, 919, 919, 919, 
	919, 919, 919, 216, 919, 925, 910, 211, 
	910, 910, 926, 926, 926, 910, 926, 926, 
	926, 926, 926, 926, 926, 926, 926, 926, 
	926, 926, 926, 926, 926, 926, 926, 926, 
	926, 926, 926, 910, 926, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 928, 929, 
	910, 930, 237, 931, 929, 910, 910, 932, 
	933, 910, 933, 910, 237, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 934, 
	910, 935, 936, 937, 910, 938, 927, 927, 
	927, 927, 927, 927, 927, 927, 927, 927, 
	927, 927, 927, 927, 927, 927, 927, 927, 
	927, 927, 927, 927, 927, 927, 927, 927, 
	939, 910, 910, 237, 927, 237, 927, 927, 
	927, 927, 927, 927, 927, 927, 927, 927, 
	927, 927, 927, 927, 927, 927, 927, 927, 
	927, 927, 927, 927, 927, 927, 927, 927, 
	910, 940, 910, 941, 910, 927, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 943, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 927, 927, 
	927, 927, 927, 927, 927, 927, 927, 927, 
	942, 942, 942, 944, 942, 943, 942, 927, 
	927, 927, 927, 927, 927, 927, 927, 927, 
	927, 927, 927, 927, 927, 927, 927, 927, 
	927, 927, 927, 927, 927, 927, 927, 927, 
	927, 942, 942, 942, 942, 927, 942, 927, 
	927, 927, 927, 927, 927, 927, 927, 927, 
	927, 927, 927, 927, 927, 927, 927, 927, 
	927, 927, 927, 927, 927, 927, 927, 927, 
	927, 942, 942, 942, 942, 942, 927, 946, 
	945, 947, 949, 950, 948, 948, 948, 948, 
	948, 948, 948, 948, 948, 948, 948, 948, 
	948, 948, 948, 948, 948, 948, 948, 948, 
	948, 948, 948, 948, 948, 948, 948, 948, 
	948, 948, 948, 948, 948, 948, 948, 948, 
	948, 948, 948, 948, 948, 948, 948, 948, 
	948, 948, 948, 948, 948, 948, 948, 948, 
	948, 948, 948, 948, 948, 948, 948, 948, 
	948, 948, 948, 951, 948, 953, 954, 952, 
	955, 956, 957, 958, 237, 942, 942, 959, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 237, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 236, 
	236, 236, 236, 236, 236, 236, 236, 236, 
	236, 942, 942, 942, 942, 942, 942, 942, 
	236, 236, 236, 236, 236, 236, 236, 236, 
	236, 236, 236, 236, 236, 236, 236, 236, 
	236, 236, 236, 236, 236, 236, 236, 236, 
	236, 236, 942, 942, 942, 942, 236, 942, 
	236, 236, 236, 236, 236, 236, 236, 236, 
	236, 236, 236, 236, 236, 236, 236, 236, 
	236, 236, 236, 236, 236, 236, 236, 236, 
	236, 236, 942, 942, 942, 942, 942, 236, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 942, 960, 942, 237, 942, 237, 
	942, 237, 961, 942, 237, 942, 237, 942, 
	237, 237, 942, 960, 942, 959, 942, 962, 
	963, 910, 964, 211, 910, 868, 211, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 211, 910, 
	211, 920, 910, 967, 966, 966, 966, 967, 
	966, 966, 966, 966, 968, 969, 968, 968, 
	968, 966, 966, 966, 966, 966, 966, 966, 
	966, 966, 966, 966, 966, 967, 966, 966, 
	966, 966, 966, 968, 966, 966, 966, 966, 
	966, 966, 966, 966, 966, 966, 966, 966, 
	966, 966, 966, 966, 966, 966, 966, 966, 
	966, 966, 966, 966, 966, 966, 966, 966, 
	966, 966, 966, 966, 970, 970, 970, 970, 
	970, 970, 970, 970, 970, 970, 970, 970, 
	970, 970, 970, 970, 970, 970, 970, 970, 
	970, 970, 970, 970, 970, 970, 966, 971, 
	966, 966, 970, 966, 970, 970, 970, 970, 
	970, 970, 970, 970, 970, 970, 970, 970, 
	970, 970, 970, 970, 970, 970, 970, 970, 
	970, 970, 970, 970, 970, 970, 966, 972, 
	972, 972, 972, 972, 972, 972, 972, 972, 
	972, 972, 972, 972, 972, 972, 972, 972, 
	972, 972, 972, 972, 972, 972, 972, 972, 
	972, 972, 972, 972, 972, 972, 972, 972, 
	972, 972, 972, 972, 972, 972, 972, 972, 
	972, 972, 972, 972, 972, 972, 972, 972, 
	972, 972, 972, 972, 972, 972, 972, 972, 
	972, 972, 972, 972, 972, 972, 972, 972, 
	972, 973, 973, 973, 973, 973, 973, 973, 
	973, 973, 973, 973, 973, 973, 973, 973, 
	973, 973, 973, 973, 973, 973, 973, 973, 
	973, 973, 973, 972, 972, 972, 972, 973, 
	972, 973, 973, 973, 973, 973, 973, 973, 
	973, 973, 973, 973, 973, 973, 973, 973, 
	973, 973, 973, 973, 973, 973, 973, 973, 
	973, 973, 973, 972, 972, 972, 972, 972, 
	973, 974, 974, 974, 974, 974, 974, 974, 
	974, 974, 974, 974, 974, 974, 974, 974, 
	974, 974, 974, 974, 974, 974, 974, 974, 
	974, 974, 974, 974, 974, 974, 974, 974, 
	974, 974, 974, 974, 974, 974, 974, 974, 
	974, 974, 974, 974, 974, 974, 974, 974, 
	974, 975, 975, 975, 975, 975, 975, 975, 
	975, 975, 975, 974, 974, 974, 974, 974, 
	974, 974, 975, 975, 975, 975, 975, 975, 
	975, 975, 975, 975, 975, 975, 975, 975, 
	975, 975, 975, 975, 975, 975, 975, 975, 
	975, 975, 975, 975, 974, 974, 974, 974, 
	975, 974, 975, 975, 975, 975, 975, 975, 
	975, 975, 975, 975, 975, 975, 975, 975, 
	975, 975, 975, 975, 975, 975, 975, 975, 
	975, 975, 975, 975, 974, 974, 974, 974, 
	974, 975, 978, 977, 977, 977, 978, 977, 
	977, 977, 977, 977, 977, 977, 977, 977, 
	977, 977, 977, 977, 977, 977, 977, 977, 
	977, 977, 977, 977, 978, 977, 977, 977, 
	977, 977, 977, 977, 977, 977, 977, 977, 
	977, 977, 977, 977, 977, 977, 977, 977, 
	977, 977, 979, 979, 979, 979, 979, 979, 
	979, 979, 977, 977, 977, 977, 977, 977, 
	977, 977, 977, 977, 977, 980, 977, 977, 
	977, 977, 977, 977, 977, 977, 977, 981, 
	977, 977, 977, 977, 977, 977, 977, 977, 
	977, 977, 977, 977, 977, 977, 977, 977, 
	977, 977, 977, 977, 977, 982, 977, 977, 
	977, 977, 977, 977, 977, 977, 977, 977, 
	977, 977, 977, 977, 977, 977, 977, 983, 
	977, 977, 984, 977, 985, 986, 988, 988, 
	988, 988, 988, 988, 988, 988, 987, 989, 
	989, 989, 989, 989, 989, 989, 989, 987, 
	987, 990, 990, 273, 273, 273, 990, 273, 
	273, 273, 273, 273, 273, 273, 273, 273, 
	273, 273, 273, 273, 273, 273, 273, 273, 
	273, 273, 273, 273, 990, 273, 273, 273, 
	273, 273, 273, 273, 273, 273, 273, 273, 
	273, 273, 273, 273, 273, 273, 273, 273, 
	273, 273, 273, 273, 273, 273, 273, 273, 
	273, 273, 273, 273, 273, 273, 273, 273, 
	273, 274, 273, 273, 273, 273, 273, 273, 
	273, 273, 273, 273, 273, 273, 273, 273, 
	273, 273, 273, 273, 273, 273, 273, 273, 
	273, 273, 273, 273, 273, 273, 991, 273, 
	992, 993, 994, 994, 273, 273, 273, 994, 
	273, 273, 273, 273, 273, 273, 273, 273, 
	273, 273, 273, 273, 273, 273, 273, 273, 
	273, 273, 273, 273, 273, 994, 273, 273, 
	273, 273, 273, 273, 273, 273, 273, 273, 
	273, 273, 273, 273, 273, 273, 273, 273, 
	273, 273, 273, 273, 273, 273, 273, 273, 
	273, 273, 273, 273, 273, 273, 273, 273, 
	273, 273, 274, 273, 273, 273, 273, 273, 
	273, 273, 273, 273, 273, 273, 273, 273, 
	273, 273, 273, 273, 273, 273, 273, 273, 
	273, 273, 273, 273, 273, 273, 273, 995, 
	273, 272, 994, 996, 997, 998, 998, 260, 
	260, 260, 998, 260, 260, 260, 260, 260, 
	260, 260, 260, 260, 260, 260, 260, 260, 
	260, 260, 260, 260, 260, 260, 260, 260, 
	998, 260, 260, 260, 260, 260, 260, 260, 
	260, 260, 260, 260, 260, 260, 260, 260, 
	260, 260, 260, 260, 260, 260, 260, 260, 
	260, 260, 260, 260, 260, 260, 260, 260, 
	260, 260, 260, 260, 260, 261, 260, 260, 
	260, 260, 260, 260, 260, 260, 260, 260, 
	260, 260, 260, 260, 260, 260, 260, 260, 
	260, 260, 260, 260, 260, 260, 260, 260, 
	260, 260, 999, 260, 994, 254, 254, 254, 
	994, 254, 254, 254, 254, 254, 254, 254, 
	254, 254, 254, 254, 254, 254, 254, 254, 
	254, 254, 254, 254, 254, 254, 994, 254, 
	254, 254, 254, 254, 254, 254, 254, 254, 
	254, 254, 254, 254, 254, 254, 254, 254, 
	254, 1000, 254, 990, 260, 260, 260, 990, 
	260, 260, 260, 260, 260, 260, 260, 260, 
	260, 260, 260, 260, 260, 260, 260, 260, 
	260, 260, 260, 260, 260, 990, 260, 260, 
	260, 260, 260, 260, 260, 260, 260, 260, 
	260, 260, 260, 260, 260, 260, 260, 260, 
	260, 260, 260, 260, 260, 260, 260, 260, 
	260, 260, 260, 260, 260, 260, 260, 260, 
	260, 260, 261, 260, 260, 260, 260, 260, 
	260, 260, 260, 260, 260, 260, 260, 260, 
	260, 260, 260, 260, 260, 260, 260, 260, 
	260, 260, 260, 260, 260, 260, 260, 262, 
	260, 990, 1001, 1001, 1001, 990, 1001, 1001, 
	1001, 1001, 1001, 1001, 1001, 1001, 1001, 1001, 
	1001, 1001, 1001, 1001, 1001, 1001, 1001, 1001, 
	1001, 1001, 1001, 990, 1001, 1001, 1001, 1001, 
	1001, 1001, 1001, 1001, 1001, 1001, 1001, 1001, 
	1001, 1001, 1001, 1001, 1001, 1001, 1001, 1001, 
	1001, 1001, 1001, 1001, 1001, 1001, 1001, 1001, 
	1001, 1001, 1001, 1001, 1001, 1001, 1001, 1001, 
	1001, 1001, 1001, 1001, 1001, 1001, 1001, 1001, 
	1001, 1001, 1001, 1001, 1001, 1001, 1001, 1001, 
	1001, 1001, 1001, 1001, 1001, 1001, 1001, 1001, 
	1001, 1001, 1001, 1001, 1001, 1002, 1001, 1003, 
	1004, 1004, 1001, 1001, 1001, 1004, 1001, 1001, 
	1001, 1001, 1001, 1001, 1001, 1001, 1001, 1001, 
	1001, 1001, 1001, 1001, 1001, 1001, 1001, 1001, 
	1001, 1001, 1001, 1004, 1001, 1001, 1001, 1001, 
	1001, 1001, 1001, 1001, 1001, 1001, 1001, 1001, 
	1001, 1001, 1001, 1001, 1001, 1001, 1001, 1001, 
	1001, 1001, 1001, 1001, 1001, 1001, 1001, 1001, 
	1001, 1001, 1001, 1001, 1001, 1001, 1001, 1001, 
	1001, 1001, 1001, 1001, 1001, 1001, 1001, 1001, 
	1001, 1001, 1001, 1001, 1001, 1001, 1001, 1001, 
	1001, 1001, 1001, 1001, 1001, 1001, 1001, 1001, 
	1001, 1001, 1001, 1001, 1001, 1005, 1001, 1004, 
	254, 254, 254, 1004, 254, 254, 254, 254, 
	254, 254, 254, 254, 254, 254, 254, 254, 
	254, 254, 254, 254, 254, 254, 254, 254, 
	254, 1004, 254, 254, 254, 254, 254, 254, 
	254, 254, 254, 254, 254, 254, 254, 254, 
	254, 254, 254, 254, 1000, 254, 1006, 1004, 
	1004, 260, 260, 260, 1004, 260, 260, 260, 
	260, 260, 260, 260, 260, 260, 260, 260, 
	260, 260, 260, 260, 260, 260, 260, 260, 
	260, 260, 1004, 260, 260, 260, 260, 260, 
	260, 260, 260, 260, 260, 260, 260, 260, 
	260, 260, 260, 260, 260, 260, 260, 260, 
	260, 260, 260, 260, 260, 260, 260, 260, 
	260, 260, 260, 260, 260, 260, 260, 261, 
	260, 260, 260, 260, 260, 260, 260, 260, 
	260, 260, 260, 260, 260, 260, 260, 260, 
	260, 260, 260, 260, 260, 260, 260, 260, 
	260, 260, 260, 260, 262, 260, 1008, 1008, 
	1008, 1008, 1008, 1008, 1008, 1008, 1008, 1008, 
	1007, 1007, 1007, 1007, 1007, 1007, 1007, 1008, 
	1008, 1008, 1008, 1008, 1008, 1007, 1007, 1007, 
	1007, 1007, 1007, 1007, 1007, 1007, 1007, 1007, 
	1007, 1007, 1007, 1007, 1007, 1007, 1007, 1007, 
	1007, 1007, 1007, 1007, 1007, 1007, 1007, 1008, 
	1008, 1008, 1008, 1008, 1008, 1007, 1007, 1007, 
	1007, 1007, 1007, 1007, 1007, 1007, 1007, 1007, 
	1007, 1007, 1007, 1007, 1007, 1007, 1007, 1007, 
	1007, 1009, 1007, 1010, 1010, 1010, 1010, 1010, 
	1010, 1010, 1010, 1010, 1010, 1007, 1007, 1007, 
	1007, 1007, 1007, 1007, 1010, 1010, 1010, 1010, 
	1010, 1010, 1007, 1007, 1007, 1007, 1007, 1007, 
	1007, 1007, 1007, 1007, 1007, 1007, 1007, 1007, 
	1007, 1007, 1007, 1007, 1007, 1007, 1007, 1007, 
	1007, 1007, 1007, 1007, 1010, 1010, 1010, 1010, 
	1010, 1010, 1007, 1011, 1011, 1011, 1011, 1011, 
	1011, 1011, 1011, 1011, 1011, 1007, 1007, 1007, 
	1007, 1007, 1007, 1007, 1011, 1011, 1011, 1011, 
	1011, 1011, 1007, 1007, 1007, 1007, 1007, 1007, 
	1007, 1007, 1007, 1007, 1007, 1007, 1007, 1007, 
	1007, 1007, 1007, 1007, 1007, 1007, 1007, 1007, 
	1007, 1007, 1007, 1007, 1011, 1011, 1011, 1011, 
	1011, 1011, 1007, 1012, 1012, 1012, 1012, 1012, 
	1012, 1012, 1012, 1012, 1012, 1007, 1007, 1007, 
	1007, 1007, 1007, 1007, 1012, 1012, 1012, 1012, 
	1012, 1012, 1007, 1007, 1007, 1007, 1007, 1007, 
	1007, 1007, 1007, 1007, 1007, 1007, 1007, 1007, 
	1007, 1007, 1007, 1007, 1007, 1007, 1007, 1007, 
	1007, 1007, 1007, 1007, 1012, 1012, 1012, 1012, 
	1012, 1012, 1007, 1013, 1016, 1015, 1015, 1015, 
	1016, 1015, 1015, 1015, 1015, 1017, 1015, 1015, 
	1015, 1015, 1015, 1015, 1015, 1015, 1015, 1015, 
	1015, 1015, 1015, 1015, 1015, 1015, 1016, 1015, 
	1015, 1015, 1015, 1015, 1017, 1015, 1015, 1015, 
	1015, 1015, 1015, 1015, 1015, 1015, 1015, 1015, 
	1015, 1015, 1015, 1015, 1018, 1018, 1018, 1018, 
	1018, 1018, 1018, 1018, 1018, 1018, 1015, 1015, 
	1015, 1015, 1015, 1015, 1015, 1018, 1018, 1018, 
	1018, 1018, 1018, 1015, 1015, 1015, 1015, 1015, 
	1015, 1015, 1015, 1015, 1015, 1015, 1015, 1015, 
	1015, 1015, 1015, 1015, 1015, 1015, 1015, 1015, 
	1015, 1015, 1015, 1015, 1015, 1018, 1018, 1018, 
	1018, 1018, 1018, 1015, 1015, 1015, 1015, 1015, 
	1015, 1015, 1015, 1015, 1015, 1015, 1015, 1015, 
	1015, 1015, 1015, 1015, 1015, 1015, 1015, 1015, 
	1015, 1019, 1015, 1016, 1015, 1015, 1015, 1016, 
	1015, 1015, 1015, 1015, 1014, 1015, 1015, 1015, 
	1015, 1015, 1015, 1015, 1015, 1015, 1015, 1015, 
	1015, 1015, 1015, 1015, 1015, 1016, 1015, 1015, 
	1015, 1015, 1015, 1014, 1015, 1015, 1015, 1015, 
	1015, 1015, 1015, 1015, 1015, 1015, 1015, 1015, 
	1015, 1015, 1015, 1020, 1020, 1020, 1020, 1020, 
	1020, 1020, 1020, 1020, 1020, 1015, 1015, 1015, 
	1015, 1015, 1015, 1015, 1020, 1020, 1020, 1020, 
	1020, 1020, 1015, 1015, 1015, 1015, 1015, 1015, 
	1015, 1015, 1015, 1015, 1015, 1015, 1015, 1015, 
	1015, 1015, 1015, 1015, 1015, 1015, 1015, 1015, 
	1015, 1015, 1015, 1015, 1020, 1020, 1020, 1020, 
	1020, 1020, 1015, 1015, 1015, 1015, 1015, 1015, 
	1015, 1015, 1015, 1015, 1015, 1015, 1015, 1015, 
	1015, 1015, 1015, 1015, 1015, 1015, 1015, 1015, 
	1021, 1015, 1014, 1016, 1020, 1020, 1020, 1016, 
	1020, 1020, 1020, 1020, 1014, 1020, 1020, 1020, 
	1020, 1020, 1020, 1020, 1020, 1020, 1020, 1020, 
	1020, 1020, 1020, 1020, 1020, 1016, 1020, 1020, 
	1020, 1020, 1020, 1014, 1020, 1020, 1020, 1020, 
	1020, 1020, 1020, 1020, 1020, 1020, 1020, 1020, 
	1020, 1020, 1020, 1020, 1020, 1020, 1020, 1020, 
	1020, 1020, 1020, 1020, 1020, 1020, 1020, 1020, 
	1020, 1020, 1020, 1020, 1020, 1020, 1020, 1020, 
	1020, 1020, 1020, 1020, 1020, 1020, 1020, 1020, 
	1020, 1020, 1020, 1020, 1020, 1020, 1020, 1020, 
	1020, 1020, 1020, 1020, 1020, 1020, 1020, 1020, 
	1020, 1020, 1020, 1020, 1020, 1020, 1020, 1020, 
	1020, 1020, 1020, 1020, 1020, 1020, 1020, 1020, 
	1020, 1020, 1020, 1020, 1020, 1020, 1020, 1020, 
	1020, 1020, 1020, 1020, 1020, 1020, 1020, 1020, 
	1014, 1020, 1022, 1016, 1023, 1023, 1023, 1016, 
	1023, 1023, 1023, 1023, 1017, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1016, 1023, 1023, 
	1023, 1023, 1023, 1017, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1024, 1024, 1024, 1024, 1024, 
	1024, 1024, 1024, 1024, 1024, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1024, 1024, 1024, 1024, 
	1024, 1024, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1024, 1024, 1024, 1024, 
	1024, 1024, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1014, 1023, 1016, 1023, 1023, 1023, 1016, 1023, 
	1023, 1023, 1023, 1014, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1016, 1023, 1023, 1023, 
	1023, 1023, 1014, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1020, 1020, 1020, 1020, 1020, 1020, 
	1020, 1020, 1020, 1020, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1020, 1020, 1020, 1020, 1020, 
	1020, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1020, 1020, 1020, 1020, 1020, 
	1020, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1016, 
	1023, 1016, 1023, 1023, 1023, 1016, 1023, 1023, 
	1023, 1023, 1025, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1016, 1023, 1023, 1023, 1023, 
	1023, 1025, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1026, 1026, 1026, 1026, 1026, 1026, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1026, 1026, 1026, 1026, 1026, 1026, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1027, 1023, 
	1016, 1023, 1023, 1023, 1016, 1023, 1023, 1023, 
	1023, 1025, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1016, 1023, 1023, 1023, 1023, 1023, 
	1025, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 
	1024, 1024, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1024, 1024, 1024, 1024, 1024, 1024, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1024, 1024, 1024, 1024, 1024, 1024, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1027, 1023, 1028, 
	1016, 1023, 1023, 1023, 1016, 1023, 1023, 1023, 
	1023, 1025, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1016, 1023, 1023, 1023, 1023, 1023, 
	1025, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1029, 1029, 1029, 1029, 1029, 1029, 1029, 1029, 
	1029, 1029, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1029, 1029, 1029, 1029, 1029, 1029, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1029, 1029, 1029, 1029, 1029, 1029, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1027, 1023, 1016, 
	1023, 1023, 1023, 1016, 1023, 1023, 1023, 1023, 
	1025, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1016, 1023, 1023, 1023, 1023, 1023, 1025, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1030, 
	1030, 1030, 1030, 1030, 1030, 1030, 1030, 1030, 
	1030, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1030, 1030, 1030, 1030, 1030, 1030, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1030, 1030, 1030, 1030, 1030, 1030, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1027, 1023, 1016, 1023, 
	1023, 1023, 1016, 1023, 1023, 1023, 1023, 1025, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1016, 1023, 1023, 1023, 1023, 1023, 1025, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1031, 1031, 
	1031, 1031, 1031, 1031, 1031, 1031, 1031, 1031, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1031, 
	1031, 1031, 1031, 1031, 1031, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1031, 
	1031, 1031, 1031, 1031, 1031, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1027, 1023, 1016, 1023, 1023, 
	1023, 1016, 1023, 1023, 1023, 1023, 1025, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1016, 
	1023, 1023, 1023, 1023, 1023, 1025, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1032, 1032, 1032, 
	1032, 1032, 1032, 1032, 1032, 1032, 1032, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1032, 1032, 
	1032, 1032, 1032, 1032, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1032, 1032, 
	1032, 1032, 1032, 1032, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1027, 1023, 1016, 1023, 1023, 1023, 
	1016, 1023, 1023, 1023, 1023, 1025, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1016, 1023, 
	1023, 1023, 1023, 1023, 1025, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1033, 1033, 1033, 1033, 
	1033, 1033, 1033, 1033, 1033, 1033, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1033, 1033, 1033, 
	1033, 1033, 1033, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1033, 1033, 1033, 
	1033, 1033, 1033, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1027, 1023, 1016, 1023, 1023, 1023, 1016, 
	1023, 1023, 1023, 1023, 1014, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1016, 1023, 1023, 
	1023, 1023, 1023, 1014, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1033, 1033, 1033, 1033, 1033, 
	1033, 1033, 1033, 1033, 1033, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1033, 1033, 1033, 1033, 
	1033, 1033, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1033, 1033, 1033, 1033, 
	1033, 1033, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1014, 1023, 1016, 1023, 1023, 1023, 1016, 1023, 
	1023, 1023, 1023, 1034, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1016, 1023, 1023, 1023, 
	1023, 1023, 1034, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1035, 1035, 1035, 1035, 1035, 1035, 
	1035, 1035, 1035, 1035, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1035, 1035, 1035, 1035, 1035, 
	1035, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1035, 1035, 1035, 1035, 1035, 
	1035, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1027, 
	1023, 1016, 1023, 1023, 1023, 1016, 1023, 1023, 
	1023, 1023, 1034, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1016, 1023, 1023, 1023, 1023, 
	1023, 1034, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1036, 1036, 1036, 1036, 1036, 1036, 1036, 
	1036, 1036, 1036, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1036, 1036, 1036, 1036, 1036, 1036, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1036, 1036, 1036, 1036, 1036, 1036, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1027, 1023, 
	1016, 1023, 1023, 1023, 1016, 1023, 1023, 1023, 
	1023, 1034, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1016, 1023, 1023, 1023, 1023, 1023, 
	1034, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1037, 1037, 1037, 1037, 1037, 1037, 1037, 1037, 
	1037, 1037, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1037, 1037, 1037, 1037, 1037, 1037, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1037, 1037, 1037, 1037, 1037, 1037, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1014, 1023, 1016, 
	1023, 1023, 1023, 1016, 1023, 1023, 1023, 1023, 
	1034, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1016, 1023, 1023, 1023, 1023, 1023, 1034, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1038, 
	1038, 1038, 1038, 1038, 1038, 1038, 1038, 1038, 
	1038, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1038, 1038, 1038, 1038, 1038, 1038, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1038, 1038, 1038, 1038, 1038, 1038, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1014, 1023, 1016, 1023, 
	1023, 1023, 1016, 1023, 1023, 1023, 1023, 1034, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1016, 1023, 1023, 1023, 1023, 1023, 1034, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1039, 1039, 
	1039, 1039, 1039, 1039, 1039, 1039, 1039, 1039, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1039, 
	1039, 1039, 1039, 1039, 1039, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1039, 
	1039, 1039, 1039, 1039, 1039, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1014, 1023, 1016, 1023, 1023, 
	1023, 1016, 1023, 1023, 1023, 1023, 1034, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1016, 
	1023, 1023, 1023, 1023, 1023, 1034, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1040, 1040, 1040, 
	1040, 1040, 1040, 1040, 1040, 1040, 1040, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1040, 1040, 
	1040, 1040, 1040, 1040, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1040, 1040, 
	1040, 1040, 1040, 1040, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1014, 1023, 1016, 1023, 1023, 1023, 
	1016, 1023, 1023, 1023, 1023, 1034, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1016, 1023, 
	1023, 1023, 1023, 1023, 1034, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1041, 1041, 1041, 1041, 
	1041, 1041, 1041, 1041, 1041, 1041, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1041, 1041, 1041, 
	1041, 1041, 1041, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1041, 1041, 1041, 
	1041, 1041, 1041, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1014, 1023, 1016, 1023, 1023, 1023, 1016, 
	1023, 1023, 1023, 1023, 1034, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1016, 1023, 1023, 
	1023, 1023, 1023, 1034, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1033, 1033, 1033, 1033, 1033, 
	1033, 1033, 1033, 1033, 1033, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1033, 1033, 1033, 1033, 
	1033, 1033, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1033, 1033, 1033, 1033, 
	1033, 1033, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1014, 1023, 1016, 1023, 1023, 1023, 1016, 1023, 
	1023, 1023, 1023, 1034, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1016, 1023, 1023, 1023, 
	1023, 1023, 1034, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1042, 1042, 1042, 1042, 1042, 1042, 
	1042, 1042, 1042, 1042, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1042, 1042, 1042, 1042, 1042, 
	1042, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1042, 1042, 1042, 1042, 1042, 
	1042, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1027, 
	1023, 1016, 1023, 1023, 1023, 1016, 1023, 1023, 
	1023, 1023, 1034, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1016, 1023, 1023, 1023, 1023, 
	1023, 1034, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1043, 1043, 1043, 1043, 1043, 1043, 1043, 
	1043, 1043, 1043, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1043, 1043, 1043, 1043, 1043, 1043, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1043, 1043, 1043, 1043, 1043, 1043, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1027, 1023, 
	1016, 1023, 1023, 1023, 1016, 1023, 1023, 1023, 
	1023, 1034, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1016, 1023, 1023, 1023, 1023, 1023, 
	1034, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1044, 1044, 1044, 1044, 1044, 1044, 1044, 1044, 
	1044, 1044, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1044, 1044, 1044, 1044, 1044, 1044, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1044, 1044, 1044, 1044, 1044, 1044, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1027, 1023, 1016, 
	1023, 1023, 1023, 1016, 1023, 1023, 1023, 1023, 
	1034, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1016, 1023, 1023, 1023, 1023, 1023, 1034, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1045, 
	1045, 1045, 1045, 1045, 1045, 1045, 1045, 1045, 
	1045, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1045, 1045, 1045, 1045, 1045, 1045, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1045, 1045, 1045, 1045, 1045, 1045, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1027, 1023, 1016, 1023, 
	1023, 1023, 1016, 1023, 1023, 1023, 1023, 1034, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1016, 1023, 1023, 1023, 1023, 1023, 1034, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1033, 1033, 
	1033, 1033, 1033, 1033, 1033, 1033, 1033, 1033, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1033, 
	1033, 1033, 1033, 1033, 1033, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1033, 
	1033, 1033, 1033, 1033, 1033, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1027, 1023, 1046, 1047, 1049, 
	1049, 1049, 1049, 1049, 1049, 1049, 1049, 1049, 
	1049, 1048, 1048, 1048, 1048, 1048, 1048, 1048, 
	1049, 1049, 1049, 1049, 1049, 1049, 1048, 1048, 
	1048, 1048, 1048, 1048, 1048, 1048, 1048, 1048, 
	1048, 1048, 1048, 1048, 1048, 1048, 1048, 1048, 
	1048, 1048, 1048, 1048, 1048, 1048, 1048, 1048, 
	1049, 1049, 1049, 1049, 1049, 1049, 1048, 1048, 
	200, 200, 200, 200, 200, 200, 200, 200, 
	200, 200, 200, 200, 200, 200, 200, 200, 
	200, 200, 200, 200, 200, 200, 200, 200, 
	200, 200, 200, 200, 200, 200, 200, 200, 
	200, 279, 200, 200, 200, 200, 200, 200, 
	200, 200, 200, 200, 200, 200, 200, 200, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 280, 200, 200, 281, 200, 279, 
	200, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 200, 200, 200, 200, 278, 
	200, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 200, 200, 200, 200, 200, 
	278, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 279, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 280, 910, 910, 281, 910, 
	279, 910, 278, 278, 278, 278, 1050, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 910, 910, 910, 910, 
	278, 910, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 910, 910, 910, 910, 
	910, 278, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 279, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 280, 910, 910, 281, 
	910, 279, 910, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	1051, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 910, 910, 910, 
	910, 278, 910, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 910, 910, 910, 
	910, 910, 278, 1052, 1053, 910, 905, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	889, 888, 889, 889, 889, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 889, 
	279, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 280, 888, 888, 281, 888, 279, 888, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 888, 890, 888, 888, 1054, 888, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 888, 888, 888, 888, 888, 844, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 889, 888, 889, 889, 889, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	889, 279, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 280, 888, 888, 281, 888, 279, 
	888, 844, 844, 844, 844, 1055, 1056, 844, 
	844, 844, 844, 844, 1057, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 888, 890, 888, 888, 844, 
	888, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 888, 888, 888, 888, 888, 
	844, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 889, 888, 889, 889, 889, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 889, 279, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 280, 888, 888, 281, 888, 
	279, 888, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 1058, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 888, 890, 888, 888, 
	844, 888, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 888, 888, 888, 888, 
	888, 844, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 889, 888, 889, 889, 889, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 889, 279, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 280, 888, 888, 281, 
	888, 279, 888, 844, 844, 1059, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 888, 890, 888, 
	888, 844, 888, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 888, 888, 888, 
	888, 888, 844, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 889, 888, 889, 889, 
	889, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 889, 279, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 280, 888, 888, 
	281, 888, 279, 888, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 1060, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 888, 890, 
	888, 888, 844, 888, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 888, 888, 
	888, 888, 888, 844, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 889, 888, 889, 
	889, 889, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 889, 279, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 280, 888, 
	888, 281, 888, 279, 888, 844, 844, 844, 
	1061, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 888, 
	890, 888, 888, 844, 888, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 888, 
	888, 888, 888, 888, 844, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 889, 888, 
	889, 889, 889, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 889, 279, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 280, 
	888, 888, 281, 888, 279, 888, 844, 844, 
	844, 844, 844, 844, 844, 844, 1062, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	888, 890, 888, 888, 844, 888, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	888, 888, 888, 888, 888, 844, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 889, 
	888, 889, 889, 889, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 889, 279, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	280, 888, 888, 281, 888, 279, 888, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 1063, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 888, 890, 888, 888, 844, 888, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 888, 888, 888, 888, 888, 844, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	889, 888, 889, 889, 889, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 889, 
	279, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 280, 888, 888, 281, 888, 279, 888, 
	844, 844, 844, 844, 844, 844, 1064, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 888, 890, 888, 888, 844, 888, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 888, 888, 888, 888, 888, 844, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 889, 888, 889, 889, 889, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	889, 279, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 280, 888, 888, 281, 888, 279, 
	888, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 888, 890, 888, 888, 1065, 
	888, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 888, 888, 888, 888, 888, 
	844, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 889, 888, 889, 889, 889, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 889, 279, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 280, 888, 888, 281, 888, 
	279, 888, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 888, 890, 888, 888, 
	1066, 888, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 888, 888, 888, 888, 
	888, 844, 200, 200, 200, 200, 200, 200, 
	200, 200, 200, 200, 200, 200, 200, 200, 
	200, 200, 200, 200, 200, 200, 200, 200, 
	200, 200, 200, 200, 200, 200, 200, 200, 
	200, 200, 200, 279, 200, 200, 200, 200, 
	200, 200, 200, 200, 200, 200, 200, 200, 
	200, 200, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 280, 200, 200, 281, 
	200, 279, 200, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 200, 200, 200, 
	200, 844, 200, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 200, 200, 200, 
	200, 200, 844, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 889, 888, 889, 889, 
	889, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 889, 279, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 280, 888, 888, 
	281, 888, 279, 888, 844, 844, 844, 844, 
	844, 844, 844, 844, 1067, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 888, 890, 
	888, 888, 844, 888, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 888, 888, 
	888, 888, 888, 844, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 889, 888, 889, 
	889, 889, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 889, 279, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 280, 888, 
	888, 281, 888, 279, 888, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	1068, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 888, 
	890, 888, 888, 844, 888, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 888, 
	888, 888, 888, 888, 844, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 889, 888, 
	889, 889, 889, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 889, 279, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 280, 
	888, 888, 281, 888, 279, 888, 844, 844, 
	844, 844, 1064, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	888, 890, 888, 888, 844, 888, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	888, 888, 888, 888, 888, 844, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 889, 
	888, 889, 889, 889, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 889, 279, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	280, 888, 888, 281, 888, 279, 888, 844, 
	844, 844, 844, 844, 844, 844, 844, 1069, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 888, 890, 888, 888, 844, 888, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 888, 888, 888, 888, 888, 844, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	889, 888, 889, 889, 889, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 889, 
	279, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 280, 888, 888, 281, 888, 279, 888, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 1068, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 888, 890, 888, 888, 844, 888, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 888, 888, 888, 888, 888, 844, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 889, 888, 889, 889, 889, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	889, 279, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 280, 888, 888, 281, 888, 279, 
	888, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 888, 890, 888, 888, 844, 
	888, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 1070, 844, 1071, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 888, 888, 888, 888, 888, 
	844, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 889, 888, 889, 889, 889, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 889, 279, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 280, 888, 888, 281, 888, 
	279, 888, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 888, 890, 888, 888, 
	844, 888, 844, 844, 844, 844, 844, 844, 
	844, 844, 1072, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 888, 888, 888, 888, 
	888, 844, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 889, 888, 889, 889, 889, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 889, 279, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 280, 888, 888, 281, 
	888, 279, 888, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 888, 890, 888, 
	888, 844, 888, 1073, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 888, 888, 888, 
	888, 888, 844, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 889, 888, 889, 889, 
	889, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 889, 279, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 280, 888, 888, 
	281, 888, 279, 888, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 888, 890, 
	888, 888, 844, 888, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 1066, 844, 
	844, 844, 844, 844, 844, 844, 888, 888, 
	888, 888, 888, 844, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 889, 888, 889, 
	889, 889, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 889, 279, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 280, 888, 
	888, 281, 888, 279, 888, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 888, 
	890, 888, 888, 844, 888, 844, 844, 844, 
	1066, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 888, 
	888, 888, 888, 888, 844, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 889, 888, 
	889, 889, 889, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 889, 279, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 280, 
	888, 888, 281, 888, 279, 888, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	888, 890, 888, 888, 844, 888, 844, 844, 
	844, 844, 1074, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 1075, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	888, 888, 888, 888, 888, 844, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 889, 
	888, 889, 889, 889, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 889, 279, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	280, 888, 888, 281, 888, 279, 888, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 888, 890, 888, 888, 844, 888, 844, 
	844, 844, 844, 844, 844, 1076, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 888, 888, 888, 888, 888, 844, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	889, 888, 889, 889, 889, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 889, 
	279, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 280, 888, 888, 281, 888, 279, 888, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 888, 890, 888, 888, 844, 888, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	1077, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 888, 888, 888, 888, 888, 844, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 889, 888, 889, 889, 889, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	889, 279, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 280, 888, 888, 281, 888, 279, 
	888, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 888, 890, 888, 888, 844, 
	888, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 1066, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 888, 888, 888, 888, 888, 
	844, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 889, 888, 889, 889, 889, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 889, 279, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 280, 888, 888, 281, 888, 
	279, 888, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 888, 890, 888, 888, 
	844, 888, 844, 844, 844, 844, 1078, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 888, 888, 888, 888, 
	888, 844, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 889, 888, 889, 889, 889, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 889, 279, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 280, 888, 888, 281, 
	888, 279, 888, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 888, 890, 888, 
	888, 844, 888, 1079, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 888, 888, 888, 
	888, 888, 844, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 889, 888, 889, 889, 
	889, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 889, 279, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 280, 888, 888, 
	281, 888, 279, 888, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 888, 890, 
	888, 888, 844, 888, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 1066, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 888, 888, 
	888, 888, 888, 844, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 889, 888, 889, 
	889, 889, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 889, 279, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 280, 888, 
	888, 281, 888, 279, 888, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 888, 
	890, 888, 888, 844, 888, 1080, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	1081, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 888, 
	888, 888, 888, 888, 844, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 889, 888, 
	889, 889, 889, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 889, 279, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 280, 
	888, 888, 281, 888, 279, 888, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	888, 890, 888, 888, 844, 888, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	1082, 844, 844, 844, 844, 844, 844, 844, 
	888, 888, 888, 888, 888, 844, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 889, 
	888, 889, 889, 889, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 889, 279, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	280, 888, 888, 281, 888, 279, 888, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 888, 890, 888, 888, 844, 888, 844, 
	844, 844, 844, 1066, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 888, 888, 888, 888, 888, 844, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	889, 888, 889, 889, 889, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 889, 
	279, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 280, 888, 888, 281, 888, 279, 888, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 888, 890, 888, 888, 844, 888, 
	1083, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 888, 888, 888, 888, 888, 844, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 889, 888, 889, 889, 889, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	889, 279, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 280, 888, 888, 281, 888, 279, 
	888, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 888, 890, 888, 888, 844, 
	888, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 1073, 844, 844, 844, 844, 
	844, 844, 844, 888, 888, 888, 888, 888, 
	844, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 889, 888, 889, 889, 889, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 889, 279, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 280, 888, 888, 281, 888, 
	279, 888, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 888, 890, 888, 888, 
	844, 888, 844, 844, 844, 844, 1084, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	1066, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 888, 888, 888, 888, 
	888, 844, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 889, 888, 889, 889, 889, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 889, 279, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 280, 888, 888, 281, 
	888, 279, 888, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 888, 890, 888, 
	888, 844, 888, 844, 844, 844, 844, 844, 
	1066, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 888, 888, 888, 
	888, 888, 844, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 889, 888, 889, 889, 
	889, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 889, 279, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 280, 888, 888, 
	281, 888, 279, 888, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 888, 890, 
	888, 888, 844, 888, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 1085, 
	844, 1086, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 888, 888, 
	888, 888, 888, 844, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 889, 888, 889, 
	889, 889, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 889, 279, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 280, 888, 
	888, 281, 888, 279, 888, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 888, 
	890, 888, 888, 844, 888, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 1087, 
	844, 844, 844, 844, 844, 844, 844, 888, 
	888, 888, 888, 888, 844, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 889, 888, 
	889, 889, 889, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 889, 279, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 280, 
	888, 888, 281, 888, 279, 888, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	888, 890, 888, 888, 844, 888, 844, 844, 
	844, 844, 1066, 844, 844, 844, 1084, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	888, 888, 888, 888, 888, 844, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 889, 
	888, 889, 889, 889, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 889, 279, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	280, 888, 888, 281, 888, 279, 888, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 888, 890, 888, 888, 844, 888, 844, 
	844, 844, 1066, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 1088, 844, 844, 844, 844, 844, 844, 
	844, 888, 888, 888, 888, 888, 844, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	889, 888, 889, 889, 889, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 889, 
	279, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 280, 888, 888, 281, 888, 279, 888, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 888, 890, 888, 888, 844, 888, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 1089, 844, 844, 844, 
	844, 844, 888, 888, 888, 888, 888, 844, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 889, 888, 889, 889, 889, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	889, 279, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 280, 888, 888, 281, 888, 279, 
	888, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 888, 890, 888, 888, 844, 
	888, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 1082, 844, 844, 844, 844, 844, 
	844, 844, 844, 888, 888, 888, 888, 888, 
	844, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 889, 888, 889, 889, 889, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 889, 279, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 280, 888, 888, 281, 888, 
	279, 888, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 888, 890, 888, 888, 
	844, 888, 1090, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	879, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 888, 888, 888, 888, 
	888, 844, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 889, 888, 889, 889, 889, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 889, 279, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 280, 888, 888, 281, 
	888, 279, 888, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 888, 890, 888, 
	888, 844, 888, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 1080, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 888, 888, 888, 
	888, 888, 844, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 889, 888, 889, 889, 
	889, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 889, 279, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 280, 888, 888, 
	281, 888, 279, 888, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 888, 890, 
	888, 888, 844, 888, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 1066, 844, 844, 
	844, 844, 844, 844, 844, 844, 888, 888, 
	888, 888, 888, 844, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 889, 888, 889, 
	889, 889, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 889, 279, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 280, 888, 
	888, 281, 888, 279, 888, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 888, 
	890, 888, 888, 844, 888, 844, 844, 844, 
	844, 844, 1091, 844, 844, 844, 844, 844, 
	844, 844, 1066, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 888, 
	888, 888, 888, 888, 844, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 889, 888, 
	889, 889, 889, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 889, 279, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 280, 
	888, 888, 281, 888, 279, 888, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	888, 890, 888, 888, 844, 888, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 1092, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	888, 888, 888, 888, 888, 844, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 889, 
	888, 889, 889, 889, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 889, 279, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	280, 888, 888, 281, 888, 279, 888, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 888, 890, 888, 888, 844, 888, 844, 
	844, 844, 1093, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 888, 888, 888, 888, 888, 844, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	889, 888, 889, 889, 889, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 889, 
	279, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 280, 888, 888, 281, 888, 279, 888, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 888, 890, 888, 888, 844, 888, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 1094, 844, 844, 844, 
	844, 844, 888, 888, 888, 888, 888, 844, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 889, 888, 889, 889, 889, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	889, 279, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 280, 888, 888, 281, 888, 279, 
	888, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 888, 890, 888, 888, 844, 
	888, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 1082, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 888, 888, 888, 888, 888, 
	844, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 889, 888, 889, 889, 889, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 889, 279, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 280, 888, 888, 281, 888, 
	279, 888, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 888, 890, 888, 888, 
	844, 888, 844, 844, 844, 844, 1095, 844, 
	844, 844, 1096, 844, 844, 844, 844, 844, 
	1097, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 888, 888, 888, 888, 
	888, 844, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 889, 888, 889, 889, 889, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 889, 279, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 280, 888, 888, 281, 
	888, 279, 888, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 888, 890, 888, 
	888, 844, 888, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 1097, 844, 844, 888, 888, 888, 
	888, 888, 844, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 889, 888, 889, 889, 
	889, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 889, 279, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 280, 888, 888, 
	281, 888, 279, 888, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 888, 890, 
	888, 888, 844, 888, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 1066, 
	844, 844, 844, 844, 844, 844, 888, 888, 
	888, 888, 888, 844, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 889, 888, 889, 
	889, 889, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 889, 279, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 280, 888, 
	888, 281, 888, 279, 888, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 888, 
	890, 888, 888, 844, 888, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	1066, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 888, 
	888, 888, 888, 888, 844, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 889, 888, 
	889, 889, 889, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 889, 279, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 280, 
	888, 888, 281, 888, 279, 888, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	888, 890, 888, 888, 844, 888, 844, 844, 
	844, 844, 1098, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	888, 888, 888, 888, 888, 844, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 889, 
	888, 889, 889, 889, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 889, 279, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	280, 888, 888, 281, 888, 279, 888, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 888, 890, 888, 888, 844, 888, 844, 
	844, 844, 1099, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 1100, 1101, 844, 844, 844, 844, 844, 
	844, 888, 888, 888, 888, 888, 844, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	889, 888, 889, 889, 889, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 889, 
	279, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 280, 888, 888, 281, 888, 279, 888, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 888, 890, 888, 888, 844, 888, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 1066, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 888, 888, 888, 888, 888, 844, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 889, 888, 889, 889, 889, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	889, 279, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 280, 888, 888, 281, 888, 279, 
	888, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 888, 890, 888, 888, 844, 
	888, 844, 844, 1102, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 888, 888, 888, 888, 888, 
	844, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 889, 888, 889, 889, 889, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 889, 279, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 280, 888, 888, 281, 888, 
	279, 888, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 888, 890, 888, 888, 
	844, 888, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 1103, 844, 
	844, 844, 844, 844, 888, 888, 888, 888, 
	888, 844, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 889, 888, 889, 889, 889, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 889, 279, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 280, 888, 888, 281, 
	888, 279, 888, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 888, 890, 888, 
	888, 844, 888, 844, 844, 844, 844, 1104, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 888, 888, 888, 
	888, 888, 844, 1105, 1105, 1105, 1105, 1105, 
	1105, 1105, 1105, 1105, 1105, 1105, 1105, 1105, 
	1105, 1105, 1105, 1105, 1105, 1105, 1105, 1105, 
	1105, 1105, 1105, 1105, 1105, 1105, 1105, 1105, 
	1105, 1105, 1105, 1105, 1107, 1105, 1105, 1105, 
	1105, 1105, 1105, 1105, 1105, 1105, 1105, 1105, 
	1105, 1105, 1105, 1106, 1106, 1106, 1106, 1106, 
	1106, 1106, 1106, 1106, 1106, 1108, 1105, 1105, 
	1109, 1105, 1107, 1105, 1106, 1106, 1106, 1106, 
	1106, 1106, 1106, 1106, 1106, 1106, 1106, 1106, 
	1106, 1106, 1106, 1106, 1106, 1106, 1106, 1106, 
	1106, 1106, 1106, 1106, 1106, 1106, 1105, 1105, 
	1105, 1105, 1106, 1105, 1106, 1106, 1106, 1106, 
	1106, 1106, 1106, 1106, 1106, 1106, 1106, 1106, 
	1106, 1106, 1106, 1106, 1106, 1106, 1106, 1106, 
	1106, 1106, 1106, 1106, 1106, 1106, 1105, 1105, 
	1105, 1105, 1105, 1106, 896, 1110, 895, 895, 
	895, 895, 895, 895, 895, 895, 895, 895, 
	895, 895, 895, 895, 895, 895, 895, 895, 
	895, 895, 895, 895, 895, 895, 895, 895, 
	895, 895, 895, 895, 895, 895, 895, 895, 
	895, 895, 895, 895, 895, 895, 895, 895, 
	895, 895, 895, 895, 895, 895, 895, 895, 
	895, 895, 895, 895, 895, 895, 895, 895, 
	895, 895, 895, 895, 895, 898, 895, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	889, 888, 889, 889, 889, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 889, 
	279, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 280, 888, 888, 281, 888, 279, 888, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 888, 890, 888, 888, 844, 888, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 1111, 844, 844, 1112, 844, 844, 844, 
	844, 844, 888, 888, 888, 888, 888, 844, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 889, 888, 889, 889, 889, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	889, 279, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 280, 888, 888, 281, 888, 279, 
	888, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 888, 890, 888, 888, 844, 
	888, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 1066, 844, 888, 888, 888, 888, 888, 
	844, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 889, 888, 889, 889, 889, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 889, 279, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 280, 888, 888, 281, 888, 
	279, 888, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 888, 890, 888, 888, 
	844, 888, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 1077, 844, 844, 844, 844, 
	844, 844, 844, 844, 888, 888, 888, 888, 
	888, 844, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 889, 888, 889, 889, 889, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 889, 279, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 280, 888, 888, 281, 
	888, 279, 888, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 888, 890, 888, 
	888, 844, 888, 844, 844, 844, 844, 1113, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 1114, 
	844, 844, 844, 844, 844, 888, 888, 888, 
	888, 888, 844, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 889, 888, 889, 889, 
	889, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 889, 279, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 280, 888, 888, 
	281, 888, 279, 888, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 888, 890, 
	888, 888, 844, 888, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 1084, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 888, 888, 
	888, 888, 888, 844, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 889, 888, 889, 
	889, 889, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 889, 279, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 280, 888, 
	888, 281, 888, 279, 888, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 888, 
	890, 888, 888, 844, 888, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 1115, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 888, 
	888, 888, 888, 888, 844, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 889, 888, 
	889, 889, 889, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 889, 279, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 280, 
	888, 888, 281, 888, 279, 888, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	888, 890, 888, 888, 844, 888, 844, 844, 
	844, 844, 879, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	888, 888, 888, 888, 888, 844, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 889, 
	888, 889, 889, 889, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 889, 279, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	280, 888, 888, 281, 888, 279, 888, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 888, 890, 888, 888, 844, 888, 844, 
	844, 844, 844, 844, 844, 844, 1116, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	1117, 844, 844, 844, 844, 844, 844, 844, 
	844, 888, 888, 888, 888, 888, 844, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	889, 888, 889, 889, 889, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 889, 
	279, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 280, 888, 888, 281, 888, 279, 888, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 888, 890, 888, 888, 844, 888, 
	844, 844, 844, 844, 1077, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 888, 888, 888, 888, 888, 844, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 889, 888, 889, 889, 889, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	889, 279, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 280, 888, 888, 281, 888, 279, 
	888, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 888, 890, 888, 888, 844, 
	888, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 1082, 844, 844, 
	844, 844, 844, 888, 888, 888, 888, 888, 
	844, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 889, 888, 889, 889, 889, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 889, 279, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 280, 888, 888, 281, 888, 
	279, 888, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 888, 890, 888, 888, 
	844, 888, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 1118, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 888, 888, 888, 888, 
	888, 844, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 889, 888, 889, 889, 889, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 889, 279, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 280, 888, 888, 281, 
	888, 279, 888, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 888, 890, 888, 
	888, 844, 888, 844, 844, 844, 1119, 844, 
	844, 844, 844, 844, 844, 844, 1120, 844, 
	844, 844, 844, 844, 844, 844, 1121, 844, 
	844, 844, 844, 844, 844, 888, 888, 888, 
	888, 888, 844, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 889, 888, 889, 889, 
	889, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 889, 279, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 280, 888, 888, 
	281, 888, 279, 888, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 888, 890, 
	888, 888, 844, 888, 844, 844, 844, 844, 
	1084, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 888, 888, 
	888, 888, 888, 844, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 889, 888, 889, 
	889, 889, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 889, 279, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 280, 888, 
	888, 281, 888, 279, 888, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 888, 
	890, 888, 888, 844, 888, 844, 844, 844, 
	844, 1122, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 888, 
	888, 888, 888, 888, 844, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 889, 888, 
	889, 889, 889, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 889, 279, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 280, 
	888, 888, 281, 888, 279, 888, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	888, 890, 888, 888, 844, 888, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	1123, 844, 844, 844, 844, 844, 844, 844, 
	888, 888, 888, 888, 888, 844, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 889, 
	888, 889, 889, 889, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 889, 279, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	280, 888, 888, 281, 888, 279, 888, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 888, 890, 888, 888, 844, 888, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 1091, 844, 844, 844, 844, 844, 844, 
	844, 888, 888, 888, 888, 888, 844, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	889, 888, 889, 889, 889, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 889, 
	279, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 280, 888, 888, 281, 888, 279, 888, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 888, 890, 888, 888, 844, 888, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	1124, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 888, 888, 888, 888, 888, 844, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 889, 888, 889, 889, 889, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	889, 279, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 280, 888, 888, 281, 888, 279, 
	888, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 888, 890, 888, 888, 844, 
	888, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 1091, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 888, 888, 888, 888, 888, 
	844, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 889, 888, 889, 889, 889, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 889, 279, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 280, 888, 888, 281, 888, 
	279, 888, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 888, 890, 888, 888, 
	844, 888, 844, 844, 844, 844, 844, 844, 
	844, 1125, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 888, 888, 888, 888, 
	888, 844, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 889, 888, 889, 889, 889, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 889, 279, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 280, 888, 888, 281, 
	888, 279, 888, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 888, 890, 888, 
	888, 844, 888, 844, 844, 844, 844, 1077, 
	844, 844, 844, 1126, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 888, 888, 888, 
	888, 888, 844, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 889, 888, 889, 889, 
	889, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 889, 279, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 280, 888, 888, 
	281, 888, 279, 888, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 888, 890, 
	888, 888, 844, 888, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 1127, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 888, 888, 
	888, 888, 888, 844, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 889, 888, 889, 
	889, 889, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 889, 279, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 280, 888, 
	888, 281, 888, 279, 888, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 888, 
	890, 888, 888, 844, 888, 844, 844, 844, 
	844, 1091, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 888, 
	888, 888, 888, 888, 844, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 889, 888, 
	889, 889, 889, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 889, 279, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 280, 
	888, 888, 281, 888, 279, 888, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	888, 890, 888, 888, 844, 888, 844, 844, 
	844, 844, 844, 844, 844, 844, 1128, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	888, 888, 888, 888, 888, 844, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 889, 
	888, 889, 889, 889, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 889, 279, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	280, 888, 888, 281, 888, 279, 888, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 888, 890, 888, 888, 844, 888, 844, 
	844, 844, 844, 1129, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 888, 888, 888, 888, 888, 844, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	889, 888, 889, 889, 889, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 889, 
	279, 888, 888, 888, 888, 888, 888, 888, 
	888, 888, 888, 888, 888, 888, 888, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 280, 888, 888, 281, 888, 279, 888, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 888, 890, 888, 888, 844, 888, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 844, 1071, 844, 844, 844, 844, 
	844, 844, 844, 844, 844, 844, 844, 844, 
	844, 844, 888, 888, 888, 888, 888, 844, 
	1130, 211, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	910, 910, 910, 910, 910, 910, 910, 910, 
	920, 910, 1132, 1131, 1131, 1131, 1132, 1131, 
	1131, 1131, 1131, 1133, 1134, 1133, 1133, 1133, 
	1131, 1131, 1131, 1131, 1131, 1131, 1131, 1131, 
	1131, 1131, 1131, 1131, 1132, 1131, 1131, 1131, 
	1131, 1131, 1133, 1131, 1131, 1135, 1131, 1131, 
	1131, 1131, 1131, 1131, 1131, 1131, 1131, 1131, 
	1131, 1131, 1131, 1131, 1131, 1131, 1131, 1131, 
	1131, 1131, 1131, 1131, 1131, 1131, 1131, 1131, 
	1131, 1131, 1131, 1131, 1131, 1131, 1131, 1131, 
	1131, 1131, 1131, 1131, 1131, 1131, 1131, 1131, 
	1131, 1131, 1131, 1131, 1131, 1131, 1131, 1131, 
	1131, 1131, 1131, 1131, 1131, 1131, 1136, 1131, 
	1133, 1137, 1133, 1133, 1133, 1137, 1137, 1137, 
	1137, 1137, 1137, 1137, 1137, 1137, 1137, 1137, 
	1137, 1137, 1137, 1137, 1137, 1137, 1137, 1133, 
	1137, 1138, 1139, 1140, 1141, 1142, 1144, 1143, 
	1145, 1147, 1148, 1148, 1148, 1147, 1148, 1148, 
	1148, 1148, 1149, 1150, 1149, 1149, 1149, 1148, 
	1148, 1148, 1148, 1148, 1148, 1148, 1148, 1148, 
	1148, 1148, 1148, 1147, 1148, 1148, 1148, 1148, 
	1148, 1149, 1148, 1151, 1152, 1148, 1148, 1148, 
	1151, 1148, 1148, 1148, 1148, 1148, 1148, 1148, 
	1148, 1148, 1148, 1148, 1148, 1148, 1148, 1148, 
	1148, 1148, 1148, 1148, 1148, 1148, 1148, 1148, 
	1148, 1148, 1146, 1146, 1146, 1146, 1146, 1146, 
	1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146, 
	1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146, 
	1146, 1146, 1146, 1146, 1148, 1153, 1148, 1148, 
	1146, 1148, 1146, 1146, 1146, 1146, 1146, 1146, 
	1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146, 
	1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146, 
	1146, 1146, 1146, 1146, 1148, 1148, 1148, 1148, 
	1148, 1146, 1154, 1154, 1154, 1154, 1154, 1154, 
	1154, 1154, 1154, 1154, 1154, 1154, 1154, 1154, 
	1154, 1154, 1154, 1154, 1154, 1154, 1154, 1154, 
	1154, 1154, 1154, 1154, 1154, 1154, 1154, 1154, 
	1154, 1154, 1154, 287, 1154, 1154, 1154, 1154, 
	1154, 1154, 1154, 1154, 1154, 1154, 1154, 1154, 
	1154, 1154, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 288, 1154, 1154, 1154, 
	1154, 287, 1154, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 1154, 1154, 1154, 
	1154, 286, 1154, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 1154, 1154, 1154, 
	1154, 1154, 286, 1149, 1155, 1149, 1149, 1149, 
	1155, 1155, 1155, 1155, 1155, 1155, 1155, 1155, 
	1155, 1155, 1155, 1155, 1155, 1155, 1155, 1155, 
	1155, 1155, 1149, 1155, 1156, 1157, 1158, 1159, 
	1160, 1161, 1154, 1162, 1164, 1165, 1165, 1165, 
	1164, 1165, 1165, 1165, 1165, 1166, 1167, 1166, 
	1166, 1166, 1165, 1165, 1165, 1165, 1165, 1165, 
	1165, 1165, 1165, 1165, 1165, 1165, 1164, 1165, 
	1165, 1165, 1165, 1165, 1166, 1168, 1169, 1170, 
	1171, 1172, 1173, 1169, 1174, 1175, 1176, 1172, 
	1177, 1178, 1179, 1172, 1180, 1181, 1181, 1181, 
	1181, 1181, 1181, 1181, 1181, 1181, 1182, 1183, 
	1184, 1185, 1186, 1187, 1188, 1189, 1190, 1189, 
	1189, 1191, 1189, 1189, 1189, 1189, 1189, 1189, 
	1189, 1189, 1189, 1189, 1189, 1189, 1189, 1189, 
	1189, 1189, 1189, 1189, 1189, 1189, 1189, 1192, 
	1193, 1194, 1172, 1195, 1169, 1196, 1197, 1198, 
	1199, 1200, 1201, 1163, 1163, 1202, 1163, 1163, 
	1163, 1203, 1204, 1205, 1163, 1163, 1206, 1207, 
	1208, 1209, 1163, 1210, 1163, 1211, 1163, 1212, 
	1213, 1214, 1215, 1165, 1163, 296, 296, 296, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	296, 296, 296, 296, 296, 296, 1216, 296, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	296, 296, 296, 296, 296, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 296, 
	296, 296, 296, 296, 1216, 296, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	296, 296, 296, 296, 1163, 296, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	296, 296, 296, 296, 296, 1163, 1218, 1217, 
	1219, 1166, 1220, 1166, 1166, 1166, 1220, 1220, 
	1220, 1220, 1220, 1220, 1220, 1220, 1220, 1220, 
	1220, 1220, 1220, 1220, 1220, 1220, 1220, 1220, 
	1166, 1220, 1221, 1223, 1222, 1222, 1222, 1222, 
	1222, 1222, 1222, 1222, 1222, 1222, 1222, 1222, 
	1222, 1222, 1222, 1222, 1222, 1222, 1222, 1222, 
	1222, 1222, 1222, 1222, 1222, 1222, 1222, 1222, 
	1222, 1222, 1222, 1222, 1222, 1222, 1222, 1222, 
	1222, 1222, 1222, 1222, 1222, 1222, 1222, 1222, 
	1222, 1222, 1222, 1222, 1222, 1222, 1222, 1222, 
	1222, 1222, 1222, 1222, 1222, 1222, 1222, 1222, 
	1222, 1222, 1222, 1222, 1223, 1222, 1224, 1225, 
	1226, 1227, 1228, 1228, 1228, 1228, 1228, 1228, 
	1228, 1228, 1228, 1228, 1228, 1228, 1228, 1228, 
	1228, 1228, 1228, 1228, 1228, 1228, 1228, 1228, 
	1228, 1228, 1228, 1228, 1228, 1228, 1228, 1228, 
	1228, 1228, 1228, 291, 291, 1228, 291, 1228, 
	291, 291, 1228, 1228, 291, 291, 291, 1229, 
	291, 291, 1230, 1230, 1230, 1230, 1230, 1230, 
	1230, 1230, 1230, 1230, 291, 291, 291, 291, 
	291, 291, 291, 308, 308, 308, 308, 308, 
	308, 308, 308, 308, 308, 308, 308, 308, 
	308, 308, 308, 308, 308, 308, 308, 308, 
	308, 308, 308, 308, 308, 1228, 291, 1228, 
	1228, 308, 291, 308, 308, 308, 308, 308, 
	308, 308, 308, 308, 308, 308, 308, 308, 
	308, 308, 308, 308, 308, 308, 308, 308, 
	308, 308, 308, 308, 308, 1228, 1228, 1228, 
	291, 1228, 308, 1231, 1231, 1231, 1231, 1231, 
	1231, 1231, 1231, 1231, 1231, 1231, 1231, 1231, 
	1231, 1231, 1231, 1231, 1231, 1231, 1231, 1231, 
	1231, 1231, 1231, 1231, 1231, 1231, 1231, 1231, 
	1231, 1231, 1231, 1231, 1231, 1231, 1231, 1231, 
	1231, 1231, 1231, 1231, 1231, 1231, 1231, 1231, 
	1231, 1231, 1231, 308, 308, 308, 308, 308, 
	308, 308, 308, 308, 308, 1231, 1231, 1231, 
	1231, 1231, 1231, 1231, 308, 308, 308, 308, 
	308, 308, 308, 308, 308, 308, 308, 308, 
	308, 308, 308, 308, 308, 308, 308, 308, 
	308, 308, 308, 308, 308, 308, 1231, 1231, 
	1231, 1231, 308, 1231, 308, 308, 308, 308, 
	308, 308, 308, 308, 308, 308, 308, 308, 
	308, 308, 308, 308, 308, 308, 308, 308, 
	308, 308, 308, 308, 308, 308, 1231, 1231, 
	1231, 1231, 1231, 308, 1230, 1230, 1230, 1230, 
	1230, 1230, 1230, 1230, 1230, 1230, 1231, 1232, 
	296, 1172, 1233, 1233, 1233, 1233, 1233, 1233, 
	1233, 1234, 1233, 1233, 1233, 1233, 1233, 1233, 
	1233, 1233, 1233, 1233, 1233, 1233, 1233, 1233, 
	1232, 1233, 1235, 1236, 1172, 1237, 1237, 1237, 
	1237, 1237, 1237, 1237, 1237, 1237, 1237, 1237, 
	1237, 1237, 1237, 1237, 1237, 1237, 1237, 1232, 
	1237, 1232, 1238, 1233, 1240, 1239, 295, 295, 
	295, 295, 295, 295, 295, 295, 295, 295, 
	1239, 1177, 1241, 295, 295, 295, 295, 295, 
	295, 295, 295, 295, 295, 1242, 1242, 1242, 
	1242, 1242, 1242, 1242, 1242, 1242, 1242, 1242, 
	1243, 1242, 1242, 1242, 1242, 1242, 1242, 1242, 
	1242, 1242, 1242, 1242, 1242, 1242, 1242, 1242, 
	1242, 1242, 1242, 1242, 1242, 1242, 1242, 1242, 
	1242, 1242, 1244, 1242, 1242, 1242, 1242, 1242, 
	1243, 1242, 294, 294, 294, 294, 294, 294, 
	294, 294, 294, 294, 1242, 1242, 1242, 1242, 
	1242, 1242, 1242, 1242, 1242, 1242, 1242, 1242, 
	1242, 1242, 1242, 1242, 1242, 1242, 1242, 1242, 
	1242, 1242, 1242, 1242, 1242, 1242, 1242, 1242, 
	1242, 1242, 1242, 1242, 1242, 1242, 1242, 1242, 
	1242, 293, 1242, 1246, 1245, 1247, 1247, 1247, 
	1247, 1247, 1247, 1247, 1247, 1247, 1247, 1245, 
	1245, 1245, 1245, 1245, 1245, 1245, 1245, 1248, 
	1245, 1249, 1250, 1245, 1245, 1245, 1245, 1245, 
	1245, 1245, 1245, 1245, 1251, 1245, 1245, 1245, 
	1245, 1245, 1245, 1245, 1245, 1252, 1245, 1245, 
	1245, 1245, 1245, 1245, 1253, 1245, 1245, 1248, 
	1245, 1249, 1250, 1245, 1245, 1245, 1254, 1245, 
	1245, 1245, 1245, 1245, 1251, 1245, 1245, 1255, 
	1245, 1245, 1245, 1245, 1245, 1252, 1245, 297, 
	297, 297, 297, 297, 297, 297, 297, 297, 
	297, 1256, 1256, 1256, 1256, 1256, 1256, 1256, 
	1256, 1256, 1256, 1256, 1257, 1256, 1256, 1256, 
	1256, 1256, 1256, 1256, 1256, 1256, 1256, 1256, 
	1256, 1256, 1256, 1256, 1256, 1256, 1256, 1256, 
	1256, 1256, 1256, 1256, 1256, 1256, 1258, 1256, 
	1256, 1256, 1256, 1256, 1257, 1256, 1256, 1256, 
	1259, 1256, 1256, 1256, 1256, 1256, 1256, 1256, 
	1256, 1260, 1256, 1261, 296, 1261, 296, 296, 
	298, 298, 298, 298, 298, 298, 298, 298, 
	298, 298, 296, 298, 298, 298, 298, 298, 
	298, 298, 298, 298, 298, 1262, 1262, 1262, 
	1262, 1262, 1262, 1262, 1262, 1262, 1262, 1262, 
	1262, 1262, 1262, 1262, 1262, 1262, 1262, 1262, 
	1262, 1262, 1262, 1262, 1262, 1262, 1262, 1262, 
	1262, 1262, 1262, 1262, 1262, 1262, 1262, 1262, 
	1262, 1262, 1261, 1262, 1262, 1262, 1262, 1262, 
	1262, 1262, 1262, 1262, 1263, 1262, 1265, 1264, 
	1266, 1268, 1267, 1267, 1267, 1269, 1267, 1270, 
	1271, 1247, 1247, 1247, 1247, 1247, 1247, 1247, 
	1247, 1247, 1247, 1245, 1245, 1245, 1245, 1245, 
	1245, 1245, 1245, 1245, 1245, 1245, 1245, 1245, 
	1245, 1245, 1245, 1245, 1245, 1245, 1245, 1245, 
	1245, 1245, 1245, 1245, 1245, 1245, 1245, 1245, 
	1245, 1245, 1245, 1245, 1245, 1245, 1245, 1245, 
	1253, 1245, 1245, 1245, 1245, 1245, 1245, 1245, 
	1245, 1245, 1254, 1245, 1245, 1245, 1245, 1245, 
	1245, 1245, 1245, 1255, 1245, 1272, 1272, 1272, 
	1272, 1272, 1272, 1272, 1272, 1272, 1272, 1245, 
	1245, 1245, 1245, 1245, 1245, 1245, 1245, 1245, 
	1245, 1245, 1245, 1245, 1245, 1245, 1245, 1245, 
	1245, 1245, 1245, 1245, 1245, 1245, 1245, 1245, 
	1245, 1245, 1245, 1245, 1245, 1245, 1245, 1245, 
	1245, 1245, 1245, 1245, 1273, 1245, 1245, 1245, 
	1245, 1245, 1245, 1245, 1245, 1245, 1254, 1245, 
	1245, 1245, 1245, 1245, 1245, 1245, 1245, 1255, 
	1245, 1275, 1275, 1275, 1275, 1275, 1275, 1275, 
	1275, 1275, 1275, 1274, 1274, 1274, 1274, 1274, 
	1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274, 
	1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274, 
	1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274, 
	1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274, 
	1276, 1274, 1274, 1274, 1274, 1274, 1274, 1274, 
	1274, 1274, 1277, 1274, 1274, 1274, 1274, 1274, 
	1274, 1274, 1274, 1278, 1274, 1275, 1275, 1275, 
	1275, 1275, 1275, 1275, 1275, 1275, 1275, 1274, 
	1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274, 
	1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274, 
	1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274, 
	1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274, 
	1274, 1274, 1274, 1274, 1279, 1274, 1274, 1274, 
	1274, 1274, 1274, 1274, 1274, 1274, 1277, 1274, 
	1274, 1274, 1274, 1274, 1274, 1274, 1274, 1278, 
	1274, 1277, 1274, 1274, 1274, 1274, 1274, 1274, 
	1274, 1274, 1278, 1274, 1281, 1280, 1282, 1284, 
	1283, 1283, 1283, 1285, 1283, 1287, 1286, 1288, 
	1289, 1291, 1291, 1290, 1290, 1290, 1290, 1290, 
	1290, 1290, 1290, 1290, 1290, 1290, 1290, 1290, 
	1290, 1290, 1290, 1290, 1290, 1290, 1290, 1290, 
	1290, 1290, 1290, 1290, 1290, 1290, 1290, 1290, 
	1290, 1290, 1290, 1290, 1290, 1290, 1290, 1290, 
	1290, 1290, 1290, 1290, 1290, 1290, 1290, 1290, 
	1292, 1290, 1290, 1290, 1290, 1290, 1290, 1290, 
	1290, 1290, 1293, 1290, 1290, 1290, 1290, 1290, 
	1290, 1290, 1290, 1294, 1290, 1295, 1295, 1274, 
	1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274, 
	1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274, 
	1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274, 
	1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274, 
	1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274, 
	1274, 1274, 1274, 1274, 1296, 1274, 1274, 1274, 
	1274, 1274, 1274, 1274, 1274, 1274, 1277, 1274, 
	1274, 1274, 1274, 1274, 1274, 1274, 1274, 1278, 
	1274, 1295, 1295, 1274, 1274, 1274, 1274, 1274, 
	1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274, 
	1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274, 
	1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274, 
	1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274, 
	1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274, 
	1279, 1274, 1274, 1274, 1274, 1274, 1274, 1274, 
	1274, 1274, 1277, 1274, 1274, 1274, 1274, 1274, 
	1274, 1274, 1274, 1278, 1274, 1298, 1298, 1298, 
	1298, 1298, 1298, 1298, 1298, 1298, 1298, 1297, 
	1297, 1297, 1297, 1297, 1297, 1297, 1297, 1297, 
	1297, 1297, 1297, 1297, 1297, 1297, 1297, 1297, 
	1297, 1297, 1297, 1297, 1297, 1297, 1297, 1297, 
	1297, 1297, 1297, 1297, 1297, 1297, 1297, 1297, 
	1297, 1297, 1297, 1297, 1299, 1297, 1297, 1297, 
	1297, 1297, 1297, 1297, 1297, 1297, 1300, 1297, 
	1297, 1297, 1297, 1297, 1297, 1297, 1297, 1301, 
	1297, 1303, 1303, 1303, 1303, 1303, 1303, 1303, 
	1303, 1303, 1303, 1302, 1302, 1302, 1302, 1302, 
	1302, 1302, 1302, 1302, 1302, 1302, 1302, 1302, 
	1302, 1302, 1302, 1302, 1302, 1302, 1302, 1302, 
	1302, 1302, 1302, 1302, 1302, 1302, 1302, 1302, 
	1302, 1302, 1302, 1302, 1302, 1302, 1302, 1302, 
	1304, 1302, 1302, 1302, 1302, 1302, 1302, 1302, 
	1302, 1302, 1305, 1302, 1302, 1302, 1302, 1302, 
	1302, 1302, 1302, 1306, 1302, 1308, 1308, 1308, 
	1308, 1308, 1308, 1308, 1308, 1308, 1308, 1307, 
	1307, 1307, 1307, 1307, 1307, 1307, 1308, 1308, 
	1308, 1308, 1308, 1308, 1307, 1307, 1307, 1307, 
	1307, 1307, 1307, 1307, 1307, 1307, 1307, 1307, 
	1307, 1307, 1307, 1307, 1307, 1307, 1307, 1307, 
	1307, 1307, 1307, 1307, 1309, 1307, 1308, 1308, 
	1308, 1308, 1308, 1308, 1307, 1307, 1310, 1307, 
	1307, 1307, 1307, 1307, 1307, 1307, 1307, 1311, 
	1307, 1312, 1312, 1312, 1312, 1312, 1312, 1312, 
	1312, 1312, 1312, 1274, 1274, 1274, 1274, 1274, 
	1274, 1274, 1312, 1312, 1312, 1312, 1312, 1312, 
	1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274, 
	1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274, 
	1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274, 
	1313, 1274, 1312, 1312, 1312, 1312, 1312, 1312, 
	1274, 1274, 1277, 1274, 1274, 1274, 1274, 1274, 
	1274, 1274, 1274, 1278, 1274, 1312, 1312, 1312, 
	1312, 1312, 1312, 1312, 1312, 1312, 1312, 1274, 
	1274, 1274, 1274, 1274, 1274, 1274, 1312, 1312, 
	1312, 1312, 1312, 1312, 1274, 1274, 1274, 1274, 
	1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274, 
	1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274, 
	1274, 1274, 1274, 1274, 1279, 1274, 1312, 1312, 
	1312, 1312, 1312, 1312, 1274, 1274, 1277, 1274, 
	1274, 1274, 1274, 1274, 1274, 1274, 1274, 1278, 
	1274, 1315, 1314, 1316, 1316, 1316, 1316, 1316, 
	1316, 1316, 1316, 1316, 1316, 1314, 1314, 1314, 
	1314, 1314, 1314, 1314, 1314, 1314, 1314, 1314, 
	1317, 1314, 1314, 1314, 1314, 1314, 1314, 1314, 
	1314, 1314, 1314, 1314, 1314, 1314, 1314, 1314, 
	1314, 1314, 1314, 1314, 1314, 1314, 1314, 1314, 
	1314, 1314, 1318, 1314, 1314, 1314, 1314, 1314, 
	1317, 1314, 1314, 1314, 1319, 1314, 1314, 1314, 
	1314, 1314, 1314, 1314, 1314, 1320, 1314, 1321, 
	1321, 1321, 1321, 1321, 1321, 1321, 1321, 1321, 
	1321, 1314, 1314, 1314, 1314, 1314, 1314, 1314, 
	1314, 1314, 1314, 1314, 1314, 1314, 1314, 1314, 
	1314, 1314, 1314, 1314, 1314, 1314, 1314, 1314, 
	1314, 1314, 1314, 1314, 1314, 1314, 1314, 1314, 
	1314, 1314, 1314, 1314, 1314, 1314, 1322, 1314, 
	1314, 1314, 1314, 1314, 1314, 1314, 1314, 1314, 
	1319, 1314, 1314, 1314, 1314, 1314, 1314, 1314, 
	1314, 1320, 1314, 1323, 1274, 1324, 1324, 1324, 
	1324, 1324, 1324, 1324, 1324, 1324, 1324, 1274, 
	1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274, 
	1274, 1274, 1325, 1274, 1274, 1274, 1274, 1274, 
	1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274, 
	1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274, 
	1274, 1274, 1274, 1274, 1326, 1274, 1274, 1274, 
	1274, 1274, 1325, 1274, 1274, 1274, 1277, 1274, 
	1274, 1274, 1274, 1274, 1274, 1274, 1274, 1278, 
	1274, 1324, 1324, 1324, 1324, 1324, 1324, 1324, 
	1324, 1324, 1324, 1274, 1274, 1274, 1274, 1274, 
	1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274, 
	1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274, 
	1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274, 
	1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274, 
	1279, 1274, 1274, 1274, 1274, 1274, 1274, 1274, 
	1274, 1274, 1277, 1274, 1274, 1274, 1274, 1274, 
	1274, 1274, 1274, 1278, 1274, 1234, 1241, 1172, 
	1327, 1233, 1223, 1233, 1328, 1329, 1241, 1241, 
	1241, 1241, 1241, 1241, 1241, 1241, 1241, 1241, 
	1241, 1241, 1241, 1241, 1241, 1241, 1241, 1241, 
	1241, 1241, 1241, 1241, 1241, 1241, 1241, 1241, 
	1241, 1241, 1241, 1241, 1241, 1241, 1241, 1241, 
	1241, 1241, 1241, 1241, 1241, 1241, 1241, 1241, 
	1241, 1241, 1241, 1241, 1241, 1241, 1241, 1241, 
	1241, 1241, 1241, 1241, 1241, 1241, 1241, 1241, 
	1241, 1241, 1241, 1241, 1241, 1223, 1241, 1223, 
	1233, 1223, 1172, 1233, 1228, 1228, 1228, 1228, 
	1228, 1228, 1228, 1228, 1228, 1228, 1228, 1228, 
	1228, 1228, 1228, 1228, 1228, 1228, 1228, 1228, 
	1228, 1228, 1228, 1228, 1228, 1228, 1228, 1228, 
	1228, 1228, 1228, 1228, 1228, 1228, 1228, 1228, 
	1228, 1228, 1228, 1228, 1228, 1228, 1228, 1228, 
	1228, 1228, 1228, 1228, 308, 308, 308, 308, 
	308, 308, 308, 308, 308, 308, 1228, 1228, 
	1228, 1228, 1228, 1228, 1330, 308, 308, 308, 
	308, 308, 308, 308, 308, 308, 308, 308, 
	308, 308, 308, 308, 308, 308, 308, 308, 
	308, 308, 308, 308, 308, 308, 308, 1228, 
	1228, 1228, 1228, 308, 1228, 308, 308, 308, 
	308, 308, 308, 308, 308, 308, 308, 308, 
	308, 308, 308, 308, 308, 308, 308, 308, 
	308, 308, 308, 308, 308, 308, 308, 1228, 
	1228, 1228, 1228, 1228, 308, 296, 296, 296, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	296, 296, 296, 296, 296, 296, 1216, 296, 
	296, 296, 296, 296, 296, 296, 296, 296, 
	296, 296, 296, 296, 296, 1189, 1189, 1189, 
	1189, 1189, 1189, 1189, 1189, 1189, 1189, 1331, 
	296, 296, 296, 296, 1216, 296, 1189, 1189, 
	1189, 1189, 1189, 1189, 1189, 1189, 1189, 1189, 
	1189, 1189, 1189, 1189, 1189, 1189, 1189, 1189, 
	1189, 1189, 1189, 1189, 1189, 1189, 1189, 1189, 
	296, 296, 296, 296, 1189, 296, 1189, 1189, 
	1189, 1189, 1189, 1189, 1189, 1189, 1189, 1189, 
	1189, 1189, 1189, 1189, 1189, 1189, 1189, 1189, 
	1189, 1189, 1189, 1189, 1189, 1189, 1189, 1189, 
	296, 296, 296, 296, 296, 1189, 1332, 1333, 
	1333, 1333, 1333, 1333, 1333, 1333, 1333, 1333, 
	1333, 1333, 1333, 1333, 1333, 1333, 1333, 1333, 
	1333, 1333, 1333, 1333, 1333, 1333, 1333, 1333, 
	1333, 1333, 1333, 1333, 1333, 1333, 1333, 1333, 
	1216, 1333, 1333, 1333, 1333, 1333, 1333, 1333, 
	1333, 1333, 1333, 1333, 1333, 1333, 1333, 1189, 
	1189, 1189, 1189, 1189, 1189, 1189, 1189, 1189, 
	1189, 1331, 1333, 1333, 1333, 1333, 1216, 1333, 
	1189, 1189, 1189, 1189, 1334, 1189, 1189, 1189, 
	1189, 1189, 1189, 1189, 1189, 1189, 1189, 1189, 
	1189, 1189, 1189, 1189, 1189, 1189, 1189, 1189, 
	1189, 1189, 1333, 1333, 1333, 1333, 1189, 1333, 
	1189, 1189, 1189, 1189, 1189, 1189, 1189, 1189, 
	1189, 1189, 1189, 1189, 1189, 1189, 1189, 1189, 
	1189, 1189, 1189, 1189, 1189, 1189, 1189, 1189, 
	1189, 1189, 1333, 1333, 1333, 1333, 1333, 1189, 
	1333, 1333, 1333, 1333, 1333, 1333, 1333, 1333, 
	1333, 1333, 1333, 1333, 1333, 1333, 1333, 1333, 
	1333, 1333, 1333, 1333, 1333, 1333, 1333, 1333, 
	1333, 1333, 1333, 1333, 1333, 1333, 1333, 1333, 
	1333, 1216, 1333, 1333, 1333, 1333, 1333, 1333, 
	1333, 1333, 1333, 1333, 1333, 1333, 1333, 1333, 
	1189, 1189, 1189, 1189, 1189, 1189, 1189, 1189, 
	1189, 1189, 1331, 1333, 1333, 1333, 1333, 1216, 
	1333, 1189, 1189, 1189, 1189, 1189, 1189, 1335, 
	1189, 1189, 1189, 1189, 1189, 1189, 1189, 1189, 
	1189, 1189, 1189, 1189, 1189, 1189, 1189, 1189, 
	1189, 1189, 1189, 1333, 1333, 1333, 1333, 1189, 
	1333, 1189, 1189, 1189, 1189, 1189, 1189, 1189, 
	1189, 1189, 1189, 1189, 1189, 1189, 1189, 1189, 
	1189, 1189, 1189, 1189, 1189, 1189, 1189, 1189, 
	1189, 1189, 1189, 1333, 1333, 1333, 1333, 1333, 
	1189, 1333, 1333, 1333, 1333, 1333, 1333, 1333, 
	1333, 1333, 1333, 1333, 1333, 1333, 1333, 1333, 
	1333, 1333, 1333, 1333, 1333, 1333, 1333, 1333, 
	1333, 1333, 1333, 1333, 1333, 1333, 1333, 1333, 
	1333, 1333, 1216, 1333, 1333, 1333, 1333, 1333, 
	1333, 1333, 1333, 1333, 1333, 1333, 1333, 1333, 
	1333, 1189, 1189, 1189, 1189, 1189, 1189, 1189, 
	1189, 1189, 1189, 1331, 1333, 1333, 1333, 1333, 
	1216, 1333, 1189, 1189, 1189, 1189, 1189, 1189, 
	1189, 1189, 1336, 1189, 1189, 1189, 1189, 1189, 
	1189, 1189, 1189, 1189, 1189, 1189, 1189, 1189, 
	1189, 1189, 1189, 1189, 1333, 1333, 1333, 1333, 
	1189, 1333, 1189, 1189, 1189, 1189, 1189, 1189, 
	1189, 1189, 1189, 1189, 1189, 1189, 1189, 1189, 
	1189, 1189, 1189, 1189, 1189, 1189, 1189, 1189, 
	1189, 1189, 1189, 1189, 1333, 1333, 1333, 1333, 
	1333, 1189, 1333, 1333, 1333, 1333, 1333, 1333, 
	1333, 1333, 1333, 1333, 1333, 1333, 1333, 1333, 
	1333, 1333, 1333, 1333, 1333, 1333, 1333, 1333, 
	1333, 1333, 1333, 1333, 1333, 1333, 1333, 1333, 
	1333, 1333, 1333, 1216, 1333, 1333, 1333, 1333, 
	1333, 1333, 1333, 1333, 1333, 1333, 1333, 1333, 
	1333, 1333, 1189, 1189, 1189, 1189, 1189, 1189, 
	1189, 1189, 1189, 1189, 1331, 1333, 1333, 1333, 
	1333, 1216, 1333, 1189, 1189, 1189, 1189, 1189, 
	1189, 1189, 1189, 1189, 1189, 1189, 1189, 1189, 
	1337, 1189, 1189, 1189, 1189, 1189, 1189, 1189, 
	1189, 1189, 1189, 1189, 1189, 1333, 1333, 1333, 
	1333, 1189, 1333, 1189, 1189, 1189, 1189, 1189, 
	1189, 1189, 1189, 1189, 1189, 1189, 1189, 1189, 
	1189, 1189, 1189, 1189, 1189, 1189, 1189, 1189, 
	1189, 1189, 1189, 1189, 1189, 1333, 1333, 1333, 
	1333, 1333, 1189, 1333, 1333, 1333, 1333, 1333, 
	1333, 1333, 1333, 1333, 1333, 1333, 1333, 1333, 
	1333, 1333, 1333, 1333, 1333, 1333, 1333, 1333, 
	1333, 1333, 1333, 1333, 1333, 1333, 1333, 1333, 
	1333, 1333, 1333, 1333, 1216, 1333, 1333, 1333, 
	1333, 1333, 1333, 1333, 1333, 1333, 1333, 1333, 
	1333, 1333, 1333, 1189, 1189, 1189, 1189, 1189, 
	1189, 1189, 1189, 1189, 1189, 1331, 1333, 1333, 
	1333, 1333, 1216, 1333, 1189, 1189, 1189, 1189, 
	1189, 1189, 1189, 1189, 1189, 1189, 1189, 1189, 
	1189, 1338, 1189, 1189, 1189, 1189, 1189, 1189, 
	1189, 1189, 1189, 1189, 1189, 1189, 1333, 1333, 
	1333, 1333, 1189, 1333, 1189, 1189, 1189, 1189, 
	1189, 1189, 1189, 1189, 1189, 1189, 1189, 1189, 
	1189, 1189, 1189, 1189, 1189, 1189, 1189, 1189, 
	1189, 1189, 1189, 1189, 1189, 1189, 1333, 1333, 
	1333, 1333, 1333, 1189, 1333, 1333, 1333, 1333, 
	1333, 1333, 1333, 1333, 1333, 1333, 1333, 1333, 
	1333, 1333, 1333, 1333, 1333, 1333, 1333, 1333, 
	1333, 1333, 1333, 1333, 1333, 1333, 1333, 1333, 
	1333, 1333, 1333, 1333, 1333, 1216, 1333, 1333, 
	1333, 1333, 1333, 1333, 1333, 1333, 1333, 1333, 
	1333, 1333, 1333, 1333, 1189, 1189, 1189, 1189, 
	1189, 1189, 1189, 1189, 1189, 1189, 1331, 1333, 
	1333, 1333, 1333, 1216, 1333, 1189, 1189, 1189, 
	1337, 1189, 1189, 1189, 1189, 1189, 1189, 1189, 
	1189, 1189, 1189, 1189, 1189, 1189, 1189, 1189, 
	1189, 1189, 1189, 1189, 1189, 1189, 1189, 1333, 
	1333, 1333, 1333, 1189, 1333, 1189, 1189, 1189, 
	1189, 1189, 1189, 1189, 1189, 1189, 1189, 1189, 
	1189, 1189, 1189, 1189, 1189, 1189, 1189, 1189, 
	1189, 1189, 1189, 1189, 1189, 1189, 1189, 1333, 
	1333, 1333, 1333, 1333, 1189, 1339, 1341, 1340, 
	1342, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1216, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1343, 1343, 1343, 1343, 1343, 
	1216, 1343, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1343, 1343, 1343, 1343, 
	1344, 1343, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1343, 1343, 1343, 1343, 
	1343, 1163, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1216, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1343, 1343, 1343, 1343, 
	1343, 1216, 1343, 1163, 1163, 1163, 1163, 1345, 
	1346, 1163, 1163, 1163, 1163, 1163, 1347, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1343, 1343, 1343, 
	1343, 1163, 1343, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1343, 1343, 1343, 
	1343, 1343, 1163, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1216, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1343, 1343, 1343, 
	1343, 1343, 1216, 1343, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1348, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1343, 1343, 
	1343, 1343, 1163, 1343, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1343, 1343, 
	1343, 1343, 1343, 1163, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1216, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1343, 1343, 
	1343, 1343, 1343, 1216, 1343, 1163, 1163, 1349, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1343, 
	1343, 1343, 1343, 1163, 1343, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1343, 
	1343, 1343, 1343, 1343, 1163, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1216, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1343, 
	1343, 1343, 1343, 1343, 1216, 1343, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1350, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1343, 1343, 1343, 1343, 1163, 1343, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1343, 1343, 1343, 1343, 1343, 1163, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1216, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1343, 1343, 1343, 1343, 1343, 1216, 1343, 1163, 
	1163, 1163, 1351, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1343, 1343, 1343, 1343, 1163, 1343, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1343, 1343, 1343, 1343, 1343, 1163, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1216, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1343, 1343, 1343, 1343, 1343, 1216, 1343, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1352, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1343, 1343, 1343, 1343, 1163, 1343, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1343, 1343, 1343, 1343, 1343, 1163, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1216, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1343, 1343, 1343, 1343, 1343, 1216, 
	1343, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1353, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1343, 1343, 1343, 1343, 1163, 
	1343, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1343, 1343, 1343, 1343, 1343, 
	1163, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1216, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1343, 1343, 1343, 1343, 1343, 
	1216, 1343, 1163, 1163, 1163, 1163, 1163, 1163, 
	1354, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1343, 1343, 1343, 1343, 
	1163, 1343, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1343, 1343, 1343, 1343, 
	1343, 1163, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1216, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1343, 1343, 1343, 1343, 
	1343, 1216, 1343, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1343, 1343, 1343, 
	1343, 1355, 1343, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1343, 1343, 1343, 
	1343, 1343, 1163, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1216, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1343, 1343, 1343, 
	1343, 1343, 1216, 1343, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1343, 1343, 
	1343, 1343, 1356, 1343, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1343, 1343, 
	1343, 1343, 1343, 1163, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1216, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1343, 1343, 
	1343, 1343, 1343, 1216, 1343, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1357, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1343, 
	1343, 1343, 1343, 1163, 1343, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1343, 
	1343, 1343, 1343, 1343, 1163, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1216, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1343, 
	1343, 1343, 1343, 1343, 1216, 1343, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1358, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1343, 1343, 1343, 1343, 1163, 1343, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1343, 1343, 1343, 1343, 1343, 1163, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1216, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1343, 1343, 1343, 1343, 1343, 1216, 1343, 1163, 
	1163, 1163, 1163, 1359, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1343, 1343, 1343, 1343, 1163, 1343, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1343, 1343, 1343, 1343, 1343, 1163, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1216, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1343, 1343, 1343, 1343, 1343, 1216, 1343, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1343, 1343, 1343, 1343, 1360, 1343, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1343, 1343, 1343, 1343, 1343, 1163, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1216, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1343, 1343, 1343, 1343, 1343, 1216, 
	1343, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1343, 1343, 1343, 1343, 1361, 
	1343, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1343, 1343, 1343, 1343, 1343, 
	1163, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1216, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1343, 1343, 1343, 1343, 1343, 
	1216, 1343, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1362, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1343, 1343, 1343, 1343, 
	1163, 1343, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1343, 1343, 1343, 1343, 
	1343, 1163, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1216, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1343, 1343, 1343, 1343, 
	1343, 1216, 1343, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1358, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1343, 1343, 1343, 
	1343, 1163, 1343, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1343, 1343, 1343, 
	1343, 1343, 1163, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1216, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1343, 1343, 1343, 
	1343, 1343, 1216, 1343, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1343, 1343, 
	1343, 1343, 1163, 1343, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1363, 
	1163, 1364, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1343, 1343, 
	1343, 1343, 1343, 1163, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1216, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1343, 1343, 
	1343, 1343, 1343, 1216, 1343, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1343, 
	1343, 1343, 1343, 1163, 1343, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1365, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1343, 
	1343, 1343, 1343, 1343, 1163, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1216, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1343, 
	1343, 1343, 1343, 1343, 1216, 1343, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1343, 1343, 1343, 1343, 1163, 1343, 1366, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1343, 1343, 1343, 1343, 1343, 1163, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1216, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1343, 1343, 1343, 1343, 1343, 1216, 1343, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1343, 1343, 1343, 1343, 1163, 1343, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1367, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1343, 1343, 1343, 1343, 1343, 1163, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1216, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1343, 1343, 1343, 1343, 1343, 1216, 1343, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1343, 1343, 1343, 1343, 1163, 1343, 
	1163, 1163, 1163, 1368, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1343, 1343, 1343, 1343, 1343, 1163, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1216, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1343, 1343, 1343, 1343, 1343, 1216, 
	1343, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1343, 1343, 1343, 1343, 1163, 
	1343, 1163, 1163, 1163, 1163, 1369, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1370, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1343, 1343, 1343, 1343, 1343, 
	1163, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1216, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1343, 1343, 1343, 1343, 1343, 
	1216, 1343, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1343, 1343, 1343, 1343, 
	1163, 1343, 1163, 1163, 1163, 1163, 1163, 1163, 
	1371, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1343, 1343, 1343, 1343, 
	1343, 1163, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1216, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1343, 1343, 1343, 1343, 
	1343, 1216, 1343, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1343, 1343, 1343, 
	1343, 1163, 1343, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1372, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1343, 1343, 1343, 
	1343, 1343, 1163, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1216, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1343, 1343, 1343, 
	1343, 1343, 1216, 1343, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1343, 1343, 
	1343, 1343, 1163, 1343, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1368, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1343, 1343, 
	1343, 1343, 1343, 1163, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1216, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1343, 1343, 
	1343, 1343, 1343, 1216, 1343, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1343, 
	1343, 1343, 1343, 1163, 1343, 1163, 1163, 1163, 
	1163, 1373, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1343, 
	1343, 1343, 1343, 1343, 1163, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1216, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1343, 
	1343, 1343, 1343, 1343, 1216, 1343, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1343, 1343, 1343, 1343, 1163, 1343, 1374, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1343, 1343, 1343, 1343, 1343, 1163, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1216, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1343, 1343, 1343, 1343, 1343, 1216, 1343, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1343, 1343, 1343, 1343, 1163, 1343, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1375, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1343, 1343, 1343, 1343, 1343, 1163, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1216, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1343, 1343, 1343, 1343, 1343, 1216, 1343, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1343, 1343, 1343, 1343, 1163, 1343, 
	1376, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1377, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1343, 1343, 1343, 1343, 1343, 1163, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1216, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1343, 1343, 1343, 1343, 1343, 1216, 
	1343, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1343, 1343, 1343, 1343, 1163, 
	1343, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1378, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1343, 1343, 1343, 1343, 1343, 
	1163, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1216, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1343, 1343, 1343, 1343, 1343, 
	1216, 1343, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1343, 1343, 1343, 1343, 
	1163, 1343, 1163, 1163, 1163, 1163, 1368, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1343, 1343, 1343, 1343, 
	1343, 1163, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1216, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1343, 1343, 1343, 1343, 
	1343, 1216, 1343, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1343, 1343, 1343, 
	1343, 1163, 1343, 1379, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1343, 1343, 1343, 
	1343, 1343, 1163, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1216, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1343, 1343, 1343, 
	1343, 1343, 1216, 1343, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1343, 1343, 
	1343, 1343, 1163, 1343, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1380, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1343, 1343, 
	1343, 1343, 1343, 1163, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1216, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1343, 1343, 
	1343, 1343, 1343, 1216, 1343, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1343, 
	1343, 1343, 1343, 1163, 1343, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1381, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1343, 
	1343, 1343, 1343, 1343, 1163, 1382, 1382, 1382, 
	1382, 1382, 1382, 1382, 1382, 1382, 310, 311, 
	310, 310, 310, 1382, 1382, 1382, 1382, 1382, 
	1382, 1382, 1382, 1382, 1382, 1382, 1382, 1382, 
	1382, 1382, 1382, 1382, 1382, 310, 1216, 1382, 
	312, 1382, 1382, 1382, 1382, 1382, 1382, 1382, 
	1382, 1382, 1382, 1382, 1382, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1382, 
	1382, 313, 1382, 1382, 1216, 1382, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1382, 314, 1382, 1382, 1163, 1382, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1382, 1382, 1382, 1382, 1382, 1163, 327, 328, 
	327, 327, 327, 326, 326, 326, 326, 326, 
	326, 326, 326, 326, 326, 326, 326, 326, 
	326, 326, 326, 326, 326, 327, 326, 326, 
	329, 326, 326, 326, 326, 326, 326, 326, 
	326, 326, 326, 326, 326, 326, 326, 326, 
	326, 326, 326, 326, 326, 326, 326, 326, 
	326, 332, 326, 326, 326, 326, 326, 326, 
	326, 326, 326, 326, 326, 326, 326, 326, 
	326, 326, 326, 326, 326, 326, 326, 326, 
	326, 326, 326, 326, 326, 326, 326, 326, 
	326, 331, 326, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1216, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1343, 1343, 1343, 
	1343, 1343, 1216, 1343, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1343, 1343, 
	1343, 1343, 1163, 1343, 1163, 1163, 1163, 1163, 
	1384, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1385, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1343, 1343, 
	1343, 1343, 1343, 1163, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1216, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1343, 1343, 
	1343, 1343, 1343, 1216, 1343, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1343, 
	1343, 1343, 1343, 1163, 1343, 1163, 1163, 1163, 
	1163, 1163, 1386, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1343, 
	1343, 1343, 1343, 1343, 1163, 1387, 1387, 1387, 
	1387, 1387, 1387, 1387, 1387, 1387, 1387, 1387, 
	1387, 1387, 1387, 1387, 1387, 1387, 1387, 1387, 
	1387, 1387, 1387, 1387, 1387, 1387, 1387, 1387, 
	1387, 1387, 1387, 1387, 1387, 1387, 1216, 1387, 
	1387, 1387, 1387, 1387, 1387, 1387, 1387, 1387, 
	1387, 1387, 1387, 1387, 1387, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1387, 
	1387, 1387, 1387, 1387, 1216, 1387, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1387, 1387, 1387, 1387, 1163, 1387, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1388, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1387, 1387, 1387, 1387, 1387, 1163, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1216, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1343, 1343, 1343, 1343, 1343, 1216, 1343, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1343, 1343, 1343, 1343, 1163, 1343, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1389, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1343, 1343, 1343, 1343, 1343, 1163, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1216, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1343, 1343, 1343, 1343, 1343, 1216, 1343, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1343, 1343, 1343, 1343, 1163, 1343, 
	1163, 1163, 1163, 1163, 1390, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1343, 1343, 1343, 1343, 1343, 1163, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1216, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1343, 1343, 1343, 1343, 1343, 1216, 
	1343, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1343, 1343, 1343, 1343, 1163, 
	1343, 1163, 1163, 1163, 1391, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1343, 1343, 1343, 1343, 1343, 
	1163, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1216, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1343, 1343, 1343, 1343, 1343, 
	1392, 1343, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1343, 1343, 1343, 1343, 
	1163, 1343, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1343, 1343, 1343, 1343, 
	1343, 1163, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1216, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1343, 1343, 1343, 1343, 
	1343, 1216, 1343, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1343, 1343, 1343, 
	1343, 1163, 1343, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1393, 1163, 
	1394, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1343, 1343, 1343, 
	1343, 1343, 1163, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1216, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1343, 1343, 1343, 
	1343, 1343, 1216, 1343, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1343, 1343, 
	1343, 1343, 1163, 1343, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1395, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1343, 1343, 
	1343, 1343, 1343, 1163, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1216, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1343, 1343, 
	1343, 1343, 1343, 1216, 1343, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1343, 
	1343, 1343, 1343, 1163, 1343, 1163, 1163, 1163, 
	1163, 1368, 1163, 1163, 1163, 1396, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1343, 
	1343, 1343, 1343, 1343, 1163, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1216, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1343, 
	1343, 1343, 1343, 1343, 1216, 1343, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1343, 1343, 1343, 1343, 1163, 1343, 1163, 1163, 
	1163, 1163, 1163, 1368, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1343, 1343, 1343, 1343, 1343, 1163, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1216, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1343, 1343, 1343, 1343, 1343, 1216, 1343, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1343, 1343, 1343, 1343, 1163, 1343, 1163, 
	1163, 1163, 1361, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1397, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1343, 1343, 1343, 1343, 1343, 1163, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1216, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1343, 1343, 1343, 1343, 1343, 1216, 1343, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1343, 1343, 1343, 1343, 1163, 1343, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1398, 1163, 1163, 1163, 
	1163, 1163, 1343, 1343, 1343, 1343, 1343, 1163, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1216, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1343, 1343, 1343, 1343, 1343, 1216, 
	1343, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1343, 1343, 1343, 1343, 1163, 
	1343, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1378, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1343, 1343, 1343, 1343, 1343, 
	1163, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1216, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1343, 1343, 1343, 1343, 1343, 
	1216, 1343, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1343, 1343, 1343, 1343, 
	1163, 1343, 1399, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1205, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1343, 1343, 1343, 1343, 
	1343, 1163, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1216, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1343, 1343, 1343, 1343, 
	1343, 1216, 1343, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1343, 1343, 1343, 
	1343, 1163, 1343, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1400, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1343, 1343, 1343, 
	1343, 1343, 1163, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1216, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1343, 1343, 1343, 
	1343, 1343, 1216, 1343, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1343, 1343, 
	1343, 1343, 1163, 1343, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1401, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1343, 1343, 
	1343, 1343, 1343, 1163, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1216, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1343, 1343, 
	1343, 1343, 1343, 1216, 1343, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1343, 
	1343, 1343, 1343, 1163, 1343, 1163, 1163, 1163, 
	1163, 1361, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1343, 
	1343, 1343, 1343, 1343, 1163, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1216, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1343, 
	1343, 1343, 1343, 1343, 1216, 1343, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1343, 1343, 1343, 1343, 1163, 1343, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1368, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1343, 1343, 1343, 1343, 1343, 1163, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1216, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1343, 1343, 1343, 1343, 1343, 1216, 1343, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1343, 1343, 1343, 1343, 1163, 1343, 1163, 
	1163, 1163, 1163, 1163, 1402, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1368, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1343, 1343, 1343, 1343, 1343, 1163, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1216, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1343, 1343, 1343, 1343, 1343, 1216, 1343, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1343, 1343, 1343, 1343, 1163, 1343, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1403, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1343, 1343, 1343, 1343, 1343, 1163, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1216, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1343, 1343, 1343, 1343, 1343, 1216, 
	1343, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1343, 1343, 1343, 1343, 1163, 
	1343, 1163, 1163, 1163, 1404, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1343, 1343, 1343, 1343, 1343, 
	1163, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1216, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1343, 1343, 1343, 1343, 1343, 
	1216, 1343, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1343, 1343, 1343, 1343, 
	1163, 1343, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1405, 1163, 
	1163, 1163, 1163, 1163, 1343, 1343, 1343, 1343, 
	1343, 1163, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1216, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1343, 1343, 1343, 1343, 
	1343, 1216, 1343, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1343, 1343, 1343, 
	1343, 1163, 1343, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1378, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1343, 1343, 1343, 
	1343, 1343, 1163, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1216, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1343, 1343, 1343, 
	1343, 1343, 1216, 1343, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1343, 1343, 
	1343, 1343, 1163, 1343, 1163, 1163, 1163, 1163, 
	1406, 1163, 1163, 1163, 1407, 1163, 1163, 1163, 
	1163, 1163, 1408, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1343, 1343, 
	1343, 1343, 1343, 1163, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1216, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1343, 1343, 
	1343, 1343, 1343, 1216, 1343, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1343, 
	1343, 1343, 1343, 1163, 1343, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1409, 1163, 1163, 1343, 
	1343, 1343, 1343, 1343, 1163, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1216, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1343, 
	1343, 1343, 1343, 1343, 1216, 1343, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1343, 1343, 1343, 1343, 1163, 1343, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1375, 1163, 1163, 1163, 1163, 1163, 1163, 
	1343, 1343, 1343, 1343, 1343, 1163, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1216, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1343, 1343, 1343, 1343, 1343, 1216, 1343, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1343, 1343, 1343, 1343, 1163, 1343, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1361, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1343, 1343, 1343, 1343, 1343, 1163, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1216, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1343, 1343, 1343, 1343, 1343, 1216, 1343, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1343, 1343, 1343, 1343, 1163, 1343, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1410, 1163, 1163, 1163, 1163, 
	1163, 1163, 1343, 1343, 1343, 1343, 1343, 1163, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1216, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1343, 1343, 1343, 1343, 1343, 1216, 
	1343, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1343, 1343, 1343, 1343, 1163, 
	1343, 1163, 1163, 1163, 1163, 1411, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1343, 1343, 1343, 1343, 1343, 
	1163, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1216, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1343, 1343, 1343, 1343, 1343, 
	1216, 1343, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1343, 1343, 1343, 1343, 
	1163, 1343, 1163, 1163, 1163, 1412, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1413, 1414, 1163, 1163, 
	1163, 1163, 1163, 1163, 1343, 1343, 1343, 1343, 
	1343, 1163, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1216, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1343, 1343, 1343, 1343, 
	1343, 1216, 1343, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1343, 1343, 1343, 
	1343, 1163, 1343, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1361, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1343, 1343, 1343, 
	1343, 1343, 1163, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1216, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1343, 1343, 1343, 
	1343, 1343, 1216, 1343, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1343, 1343, 
	1343, 1343, 1163, 1343, 1163, 1163, 1415, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1343, 1343, 
	1343, 1343, 1343, 1163, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1216, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1343, 1343, 
	1343, 1343, 1343, 1216, 1343, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1343, 
	1343, 1343, 1343, 1163, 1343, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1416, 1163, 1163, 1163, 1163, 1163, 1343, 
	1343, 1343, 1343, 1343, 1163, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1216, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1343, 
	1343, 1343, 1343, 1343, 1216, 1343, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1343, 1343, 1343, 1343, 1163, 1343, 1163, 1163, 
	1163, 1163, 1402, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1343, 1343, 1343, 1343, 1343, 1163, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1216, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1343, 1343, 1343, 1343, 1343, 1216, 1343, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1343, 1343, 1343, 1343, 1163, 1343, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1417, 1163, 1163, 1418, 1163, 1163, 1163, 1163, 
	1163, 1343, 1343, 1343, 1343, 1343, 1163, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1216, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1343, 1343, 1343, 1343, 1343, 1216, 1343, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1343, 1343, 1343, 1343, 1163, 1343, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1361, 1163, 1343, 1343, 1343, 1343, 1343, 1163, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1216, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1343, 1343, 1343, 1343, 1343, 1216, 
	1343, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1343, 1343, 1343, 1343, 1163, 
	1343, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1419, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1343, 1343, 1343, 1343, 1343, 
	1163, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1216, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1343, 1343, 1343, 1343, 1343, 
	1216, 1343, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1343, 1343, 1343, 1343, 
	1163, 1343, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1375, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1343, 1343, 1343, 1343, 
	1343, 1163, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1216, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1343, 1343, 1343, 1343, 
	1343, 1216, 1343, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1343, 1343, 1343, 
	1343, 1163, 1343, 1163, 1163, 1163, 1163, 1420, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1421, 
	1163, 1163, 1163, 1163, 1163, 1343, 1343, 1343, 
	1343, 1343, 1163, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1216, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1343, 1343, 1343, 
	1343, 1343, 1216, 1343, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1343, 1343, 
	1343, 1343, 1163, 1343, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1422, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1343, 1343, 
	1343, 1343, 1343, 1163, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1216, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1343, 1343, 
	1343, 1343, 1343, 1216, 1343, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1343, 
	1343, 1343, 1343, 1163, 1343, 1163, 1163, 1163, 
	1163, 1163, 1361, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1343, 
	1343, 1343, 1343, 1343, 1163, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1216, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1343, 
	1343, 1343, 1343, 1343, 1216, 1343, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1343, 1343, 1343, 1343, 1163, 1343, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1423, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1343, 1343, 1343, 1343, 1343, 1163, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1216, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1343, 1343, 1343, 1343, 1343, 1216, 1343, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1343, 1343, 1343, 1343, 1163, 1343, 1163, 
	1163, 1163, 1163, 1424, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1343, 1343, 1343, 1343, 1343, 1163, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1216, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1343, 1343, 1343, 1343, 1343, 1216, 1343, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1343, 1343, 1343, 1343, 1163, 1343, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1410, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1343, 1343, 1343, 1343, 1343, 1163, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1216, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1343, 1343, 1343, 1343, 1343, 1216, 
	1343, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1343, 1343, 1343, 1343, 1163, 
	1343, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1425, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1426, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1343, 1343, 1343, 1343, 1343, 
	1163, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1216, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1343, 1343, 1343, 1343, 1343, 
	1216, 1343, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1343, 1343, 1343, 1343, 
	1163, 1343, 1163, 1163, 1163, 1163, 1372, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1343, 1343, 1343, 1343, 
	1343, 1163, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1216, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1343, 1343, 1343, 1343, 
	1343, 1216, 1343, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1343, 1343, 1343, 
	1343, 1163, 1343, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1401, 
	1163, 1163, 1163, 1163, 1163, 1343, 1343, 1343, 
	1343, 1343, 1163, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1216, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1343, 1343, 1343, 
	1343, 1343, 1216, 1343, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1343, 1343, 
	1343, 1343, 1163, 1343, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1427, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1343, 1343, 
	1343, 1343, 1343, 1163, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1216, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1343, 1343, 
	1343, 1343, 1343, 1216, 1343, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1343, 
	1343, 1343, 1343, 1163, 1343, 1163, 1163, 1163, 
	1428, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1429, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1430, 1163, 1163, 1163, 1163, 1163, 1163, 1343, 
	1343, 1343, 1343, 1343, 1163, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1216, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1343, 
	1343, 1343, 1343, 1343, 1216, 1343, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1343, 1343, 1343, 1343, 1163, 1343, 1163, 1163, 
	1163, 1163, 1431, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1343, 1343, 1343, 1343, 1343, 1163, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1216, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1343, 1343, 1343, 1343, 1343, 1216, 1343, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1343, 1343, 1343, 1343, 1163, 1343, 1163, 
	1163, 1163, 1163, 1163, 1367, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1343, 1343, 1343, 1343, 1343, 1163, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1216, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1343, 1343, 1343, 1343, 1343, 1216, 1343, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1343, 1343, 1343, 1343, 1163, 1343, 
	1163, 1163, 1163, 1163, 1432, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1343, 1343, 1343, 1343, 1343, 1163, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1216, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1343, 1343, 1343, 1343, 1343, 1216, 
	1343, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1343, 1343, 1343, 1343, 1163, 
	1343, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1433, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1343, 1343, 1343, 1343, 1343, 
	1163, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1216, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1343, 1343, 1343, 1343, 1343, 
	1216, 1343, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1343, 1343, 1343, 1343, 
	1163, 1343, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1402, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1343, 1343, 1343, 1343, 
	1343, 1163, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1216, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1343, 1343, 1343, 1343, 
	1343, 1216, 1343, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1343, 1343, 1343, 
	1343, 1163, 1343, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1434, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1343, 1343, 1343, 
	1343, 1343, 1163, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1216, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1343, 1343, 1343, 
	1343, 1343, 1216, 1343, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1343, 1343, 
	1343, 1343, 1163, 1343, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1402, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1343, 1343, 
	1343, 1343, 1343, 1163, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1216, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1343, 1343, 
	1343, 1343, 1343, 1216, 1343, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1343, 
	1343, 1343, 1343, 1163, 1343, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1435, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1343, 
	1343, 1343, 1343, 1343, 1163, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1216, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1343, 
	1343, 1343, 1343, 1343, 1216, 1343, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1343, 1343, 1343, 1343, 1163, 1343, 1163, 1163, 
	1163, 1163, 1372, 1163, 1163, 1163, 1436, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1343, 1343, 1343, 1343, 1343, 1163, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1216, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1343, 1343, 1343, 1343, 1343, 1216, 1343, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1343, 1343, 1343, 1343, 1163, 1343, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1437, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1343, 1343, 1343, 1343, 1343, 1163, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1216, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1343, 1343, 1343, 1343, 1343, 1216, 1343, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1343, 1343, 1343, 1343, 1163, 1343, 
	1163, 1163, 1163, 1163, 1402, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1343, 1343, 1343, 1343, 1343, 1163, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1216, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1343, 1343, 1343, 1343, 1343, 1216, 
	1343, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1343, 1343, 1343, 1343, 1163, 
	1343, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1438, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1343, 1343, 1343, 1343, 1343, 
	1163, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1216, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1343, 1343, 1343, 1343, 1343, 
	1216, 1343, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1343, 1343, 1343, 1343, 
	1163, 1343, 1163, 1163, 1163, 1163, 1439, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1343, 1343, 1343, 1343, 
	1343, 1163, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1216, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1343, 1343, 1343, 1343, 
	1343, 1216, 1343, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1343, 1343, 1343, 
	1343, 1163, 1343, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1440, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1343, 1343, 1343, 
	1343, 1343, 1163, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1216, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1343, 1343, 1343, 
	1343, 1343, 1216, 1343, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1343, 1343, 
	1343, 1343, 1163, 1343, 1163, 1163, 1163, 1410, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1163, 1163, 
	1163, 1163, 1163, 1163, 1163, 1163, 1343, 1343, 
	1343, 1343, 1343, 1163, 1441, 1232, 1222, 1222, 
	1222, 1222, 1222, 1222, 1222, 1222, 1222, 1222, 
	1222, 1222, 1222, 1222, 1222, 1222, 1222, 1222, 
	1222, 1222, 1222, 1222, 1222, 1222, 1222, 1222, 
	1222, 1222, 1222, 1222, 1222, 1222, 1222, 1222, 
	1222, 1222, 1222, 1222, 1222, 1222, 1222, 1222, 
	1222, 1222, 1222, 1222, 1222, 1222, 1222, 1222, 
	1222, 1222, 1222, 1222, 1222, 1222, 1222, 1222, 
	1222, 1222, 1222, 1222, 1172, 1222, 1442, 1444, 
	1443, 1444, 1444, 1444, 1443, 1443, 1443, 1443, 
	1443, 1443, 1443, 1443, 1443, 1443, 1443, 1443, 
	1443, 1443, 1443, 1443, 1443, 1443, 1444, 1443, 
	1443, 1443, 1443, 1443, 1445, 1443, 1443, 1443, 
	1443, 1443, 1443, 1443, 338, 1443, 336, 1446, 
	336, 336, 336, 1446, 1446, 1446, 1446, 1446, 
	1446, 1446, 1446, 1446, 1446, 1446, 1446, 1446, 
	1446, 1446, 1446, 1446, 1446, 336, 1446, 1446, 
	1446, 1446, 1446, 337, 1446, 1446, 1446, 1446, 
	1446, 1446, 1446, 338, 1446, 339, 1446, 1448, 
	1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 
	1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 
	1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 
	1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 
	1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 
	1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 
	1447, 1447, 1449, 1447, 1448, 1447, 1448, 1447, 
	1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 
	1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 
	1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 
	1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 
	1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 
	1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 
	1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 
	1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 
	1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 
	1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 
	1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 
	1447, 1451, 1447, 1448, 1447, 1447, 1447, 1447, 
	1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 
	1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 
	1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 
	1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 
	1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 
	1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 
	1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 
	1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 
	1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 
	1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 
	1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 
	1447, 1447, 1447, 1447, 1447, 1447, 1447, 1452, 
	1447, 1448, 1447, 1447, 1447, 1447, 1447, 1447, 
	1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 
	1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 
	1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 
	1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 
	1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 
	1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 
	1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 
	1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 
	1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 
	1447, 1447, 1447, 1447, 1447, 1447, 1447, 1447, 
	1447, 1447, 1447, 1453, 1447, 1455, 1453, 0
]

class << self
	attr_accessor :_lex_trans_targs
	private :_lex_trans_targs, :_lex_trans_targs=
end
self._lex_trans_targs = [
	181, 2, 3, 4, 187, 6, 7, 8, 
	9, 10, 181, 181, 190, 193, 190, 12, 
	194, 14, 190, 201, 202, 205, 206, 212, 
	207, 208, 209, 19, 210, 211, 214, 216, 
	217, 218, 219, 220, 25, 18, 203, 204, 
	27, 243, 244, 246, 248, 246, 30, 249, 
	32, 246, 256, 257, 260, 261, 267, 262, 
	263, 264, 37, 265, 266, 269, 271, 272, 
	273, 274, 275, 43, 36, 258, 259, 45, 
	298, 299, 306, 308, 306, 48, 309, 50, 
	311, 314, 311, 52, 315, 54, 321, 320, 
	0, 56, 322, 323, 58, 324, 325, 325, 
	325, 325, 438, 61, 62, 63, 438, 466, 
	64, 65, 466, 466, 470, 470, 69, 64, 
	70, 468, 469, 471, 472, 470, 466, 473, 
	474, 476, 66, 67, 477, 478, 68, 470, 
	71, 72, 77, 84, 480, 481, 70, 468, 
	469, 471, 472, 470, 466, 473, 474, 476, 
	66, 67, 477, 478, 68, 71, 72, 77, 
	84, 480, 481, 479, 73, 74, 75, 76, 
	78, 79, 82, 80, 81, 83, 85, 86, 
	466, 88, 89, 90, 92, 95, 93, 94, 
	96, 98, 497, 497, 497, 498, 100, 500, 
	101, 501, 102, 498, 100, 500, 101, 501, 
	535, 103, 535, 104, 105, 103, 535, 104, 
	535, 535, 535, 108, 109, 110, 111, 546, 
	535, 535, 551, 535, 114, 115, 116, 535, 
	119, 114, 115, 116, 535, 119, 117, 117, 
	115, 116, 557, 118, 117, 117, 115, 116, 
	557, 118, 115, 535, 573, 535, 121, 574, 
	580, 124, 127, 129, 131, 132, 133, 127, 
	128, 585, 128, 585, 130, 535, 599, 600, 
	603, 604, 610, 605, 606, 607, 138, 608, 
	609, 612, 614, 615, 616, 617, 618, 144, 
	137, 601, 602, 146, 654, 655, 148, 537, 
	106, 539, 150, 151, 657, 759, 153, 154, 
	155, 759, 767, 767, 767, 158, 788, 787, 
	767, 790, 792, 767, 163, 164, 165, 796, 
	767, 167, 168, 807, 777, 829, 171, 172, 
	173, 177, 178, 171, 172, 173, 177, 178, 
	174, 174, 172, 173, 175, 176, 174, 174, 
	172, 173, 175, 176, 876, 172, 767, 945, 
	179, 180, 945, 945, 181, 181, 182, 183, 
	184, 186, 188, 189, 181, 181, 181, 185, 
	181, 185, 181, 1, 181, 181, 181, 5, 
	190, 190, 191, 190, 192, 195, 190, 190, 
	11, 13, 190, 190, 190, 196, 197, 198, 
	15, 21, 26, 221, 28, 190, 190, 190, 
	199, 200, 190, 16, 190, 190, 190, 17, 
	190, 190, 190, 20, 213, 215, 22, 190, 
	190, 23, 24, 190, 222, 226, 223, 224, 
	225, 190, 190, 227, 228, 231, 233, 242, 
	229, 230, 190, 232, 234, 236, 235, 190, 
	237, 238, 239, 240, 241, 190, 190, 190, 
	245, 246, 246, 246, 247, 250, 246, 29, 
	31, 246, 246, 246, 251, 252, 253, 33, 
	39, 44, 276, 46, 246, 246, 246, 254, 
	255, 246, 34, 246, 246, 246, 35, 246, 
	246, 246, 38, 268, 270, 40, 246, 246, 
	41, 42, 246, 277, 281, 278, 279, 280, 
	246, 246, 282, 283, 286, 288, 297, 284, 
	285, 246, 287, 289, 291, 290, 246, 292, 
	293, 294, 295, 296, 246, 246, 246, 300, 
	301, 301, 302, 301, 303, 301, 301, 301, 
	304, 304, 304, 305, 304, 304, 304, 306, 
	306, 306, 307, 306, 47, 49, 306, 306, 
	310, 310, 310, 311, 311, 312, 311, 313, 
	311, 311, 51, 53, 311, 311, 316, 316, 
	317, 316, 316, 318, 319, 318, 55, 57, 
	320, 320, 320, 326, 325, 325, 327, 328, 
	329, 330, 332, 335, 336, 337, 338, 325, 
	339, 340, 342, 344, 345, 346, 350, 352, 
	353, 354, 370, 375, 382, 387, 394, 401, 
	404, 405, 409, 403, 413, 421, 425, 427, 
	432, 434, 437, 325, 325, 325, 325, 325, 
	325, 331, 325, 331, 325, 333, 59, 334, 
	325, 60, 325, 325, 341, 343, 325, 347, 
	348, 349, 345, 351, 325, 355, 356, 365, 
	368, 357, 358, 359, 360, 361, 362, 363, 
	364, 326, 366, 367, 369, 371, 374, 372, 
	373, 376, 379, 377, 378, 380, 381, 383, 
	385, 384, 386, 388, 389, 325, 390, 391, 
	392, 393, 325, 395, 398, 396, 397, 399, 
	400, 402, 406, 407, 408, 410, 412, 411, 
	414, 415, 416, 418, 417, 419, 420, 422, 
	423, 424, 426, 428, 429, 430, 431, 433, 
	435, 436, 439, 438, 438, 440, 441, 443, 
	438, 438, 438, 442, 438, 442, 444, 438, 
	446, 445, 445, 449, 450, 451, 452, 445, 
	454, 455, 456, 457, 459, 461, 462, 463, 
	464, 465, 445, 447, 445, 448, 445, 445, 
	445, 445, 445, 453, 445, 453, 458, 445, 
	460, 445, 466, 466, 467, 482, 483, 469, 
	485, 486, 473, 487, 488, 489, 490, 491, 
	493, 494, 495, 496, 466, 466, 466, 466, 
	466, 466, 470, 475, 466, 466, 466, 466, 
	466, 466, 466, 466, 466, 484, 466, 484, 
	466, 466, 466, 466, 492, 466, 87, 91, 
	97, 497, 499, 502, 99, 497, 497, 498, 
	503, 503, 504, 505, 507, 509, 510, 503, 
	503, 506, 503, 506, 503, 508, 503, 503, 
	503, 512, 511, 511, 513, 514, 515, 517, 
	519, 520, 525, 532, 511, 511, 511, 511, 
	516, 511, 516, 511, 518, 511, 511, 512, 
	521, 522, 523, 524, 526, 527, 530, 528, 
	529, 531, 533, 534, 536, 535, 544, 545, 
	547, 548, 550, 552, 553, 554, 556, 558, 
	559, 561, 562, 584, 587, 588, 589, 657, 
	658, 659, 660, 661, 555, 663, 680, 685, 
	692, 697, 699, 705, 708, 709, 713, 707, 
	717, 728, 732, 735, 743, 747, 750, 751, 
	535, 103, 104, 535, 106, 538, 535, 535, 
	540, 542, 543, 535, 541, 535, 535, 535, 
	535, 535, 107, 535, 535, 535, 535, 535, 
	549, 535, 549, 535, 535, 112, 535, 535, 
	113, 535, 535, 555, 535, 560, 535, 563, 
	572, 535, 120, 575, 576, 577, 535, 578, 
	122, 581, 123, 125, 582, 583, 535, 564, 
	566, 535, 565, 535, 535, 567, 570, 571, 
	535, 568, 569, 535, 535, 535, 535, 535, 
	535, 579, 126, 586, 535, 535, 590, 535, 
	535, 535, 591, 593, 535, 592, 535, 592, 
	535, 594, 595, 596, 134, 140, 145, 619, 
	147, 535, 535, 535, 597, 598, 535, 135, 
	535, 535, 535, 136, 535, 535, 535, 139, 
	611, 613, 141, 535, 535, 142, 143, 535, 
	620, 624, 621, 622, 623, 535, 535, 625, 
	626, 629, 640, 653, 627, 628, 535, 630, 
	631, 632, 634, 633, 535, 635, 636, 637, 
	638, 639, 641, 648, 642, 643, 644, 645, 
	646, 647, 649, 650, 651, 652, 535, 535, 
	535, 656, 149, 152, 535, 662, 664, 665, 
	675, 678, 666, 667, 668, 669, 670, 671, 
	672, 673, 674, 676, 677, 679, 681, 684, 
	682, 683, 686, 689, 687, 688, 690, 691, 
	693, 695, 694, 696, 698, 700, 702, 701, 
	703, 704, 706, 674, 710, 711, 712, 714, 
	716, 715, 718, 719, 720, 725, 721, 722, 
	723, 535, 536, 537, 106, 724, 542, 726, 
	727, 729, 730, 731, 733, 734, 736, 737, 
	738, 741, 739, 740, 742, 744, 745, 746, 
	748, 749, 535, 752, 752, 753, 754, 755, 
	757, 752, 752, 752, 756, 752, 756, 752, 
	758, 752, 760, 759, 759, 761, 762, 759, 
	763, 765, 759, 759, 759, 759, 764, 759, 
	764, 766, 759, 768, 767, 767, 771, 772, 
	773, 767, 774, 776, 779, 780, 781, 782, 
	783, 767, 784, 785, 789, 817, 821, 767, 
	822, 824, 826, 767, 827, 828, 830, 834, 
	836, 837, 767, 839, 857, 862, 869, 877, 
	884, 891, 896, 897, 901, 895, 906, 916, 
	922, 925, 934, 938, 942, 943, 944, 779, 
	769, 767, 770, 767, 767, 767, 767, 767, 
	767, 775, 767, 775, 767, 156, 778, 767, 
	767, 767, 767, 767, 767, 767, 767, 767, 
	786, 767, 767, 157, 159, 767, 160, 798, 
	809, 812, 791, 813, 814, 799, 803, 805, 
	767, 791, 160, 793, 795, 161, 767, 793, 
	767, 794, 767, 767, 162, 797, 767, 767, 
	800, 802, 767, 800, 801, 803, 805, 802, 
	767, 804, 767, 767, 806, 808, 767, 166, 
	767, 767, 767, 810, 802, 803, 805, 810, 
	811, 767, 800, 802, 803, 805, 767, 800, 
	802, 803, 805, 767, 815, 802, 803, 805, 
	815, 816, 767, 160, 817, 791, 818, 803, 
	805, 819, 802, 160, 819, 791, 820, 823, 
	825, 767, 169, 170, 767, 767, 831, 832, 
	833, 828, 835, 767, 767, 838, 767, 767, 
	840, 841, 850, 855, 842, 843, 844, 845, 
	846, 847, 848, 849, 768, 851, 852, 853, 
	854, 768, 856, 858, 861, 859, 860, 768, 
	768, 863, 866, 864, 865, 867, 868, 768, 
	870, 872, 871, 873, 874, 875, 767, 767, 
	878, 768, 879, 767, 880, 881, 882, 883, 
	769, 885, 888, 886, 887, 889, 890, 892, 
	893, 894, 768, 898, 899, 900, 902, 904, 
	905, 903, 768, 907, 908, 909, 912, 910, 
	911, 913, 914, 915, 917, 919, 918, 920, 
	921, 923, 924, 926, 927, 929, 932, 928, 
	930, 931, 933, 935, 936, 937, 939, 940, 
	941, 767, 767, 945, 946, 947, 945, 949, 
	948, 950, 948, 951, 952, 953, 948, 948
]

class << self
	attr_accessor :_lex_trans_actions
	private :_lex_trans_actions, :_lex_trans_actions=
end
self._lex_trans_actions = [
	1, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 2, 3, 4, 0, 5, 0, 
	0, 0, 6, 0, 7, 0, 8, 0, 
	7, 0, 0, 0, 0, 8, 7, 0, 
	8, 0, 7, 7, 0, 0, 0, 0, 
	0, 0, 0, 9, 0, 10, 0, 0, 
	0, 11, 0, 7, 0, 8, 0, 7, 
	0, 0, 0, 0, 8, 7, 0, 8, 
	0, 7, 7, 0, 0, 0, 0, 0, 
	0, 0, 12, 0, 13, 0, 0, 0, 
	14, 0, 15, 0, 0, 0, 0, 16, 
	0, 0, 0, 0, 0, 0, 17, 18, 
	19, 20, 21, 0, 0, 0, 22, 23, 
	0, 0, 24, 25, 26, 27, 28, 29, 
	29, 30, 31, 29, 32, 31, 33, 31, 
	29, 29, 30, 29, 34, 29, 29, 35, 
	29, 29, 29, 29, 29, 29, 0, 36, 
	37, 0, 38, 37, 39, 37, 0, 0, 
	36, 0, 40, 0, 0, 0, 0, 0, 
	0, 0, 0, 27, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	41, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 42, 43, 44, 45, 0, 0, 
	0, 45, 28, 46, 29, 29, 29, 46, 
	47, 0, 48, 0, 28, 29, 49, 29, 
	50, 51, 52, 0, 0, 0, 0, 0, 
	53, 54, 0, 55, 0, 28, 0, 56, 
	0, 29, 57, 29, 58, 29, 59, 60, 
	61, 60, 62, 60, 0, 63, 64, 63, 
	65, 63, 66, 67, 0, 68, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 69, 
	69, 70, 0, 28, 0, 71, 0, 7, 
	0, 8, 0, 7, 0, 0, 0, 0, 
	8, 7, 0, 8, 0, 7, 7, 0, 
	0, 0, 0, 0, 0, 0, 0, 72, 
	0, 0, 0, 0, 72, 73, 0, 0, 
	0, 74, 75, 76, 77, 0, 7, 7, 
	78, 79, 79, 80, 0, 0, 0, 0, 
	81, 0, 0, 0, 0, 0, 0, 28, 
	0, 0, 0, 29, 57, 29, 29, 29, 
	59, 60, 61, 60, 60, 60, 0, 63, 
	64, 63, 63, 63, 82, 66, 83, 84, 
	0, 85, 86, 87, 90, 91, 0, 28, 
	0, 7, 0, 7, 92, 93, 94, 59, 
	95, 0, 96, 0, 97, 98, 99, 0, 
	100, 101, 0, 102, 7, 7, 103, 104, 
	0, 0, 105, 106, 107, 108, 108, 108, 
	108, 108, 108, 108, 108, 109, 110, 111, 
	0, 0, 112, 0, 113, 114, 115, 0, 
	116, 117, 118, 0, 7, 0, 0, 119, 
	120, 0, 28, 121, 0, 0, 0, 0, 
	0, 122, 123, 0, 0, 0, 0, 0, 
	0, 0, 124, 0, 0, 0, 0, 125, 
	0, 0, 0, 0, 0, 126, 127, 128, 
	0, 129, 130, 131, 7, 7, 132, 0, 
	0, 133, 134, 135, 108, 108, 108, 108, 
	108, 108, 108, 108, 136, 137, 138, 0, 
	0, 139, 0, 140, 141, 142, 0, 143, 
	144, 145, 0, 7, 0, 0, 146, 147, 
	0, 28, 148, 0, 0, 0, 0, 0, 
	149, 150, 0, 0, 0, 0, 0, 0, 
	0, 151, 0, 0, 0, 0, 152, 0, 
	0, 0, 0, 0, 153, 154, 155, 0, 
	156, 157, 0, 158, 0, 159, 160, 161, 
	162, 163, 164, 0, 165, 166, 167, 168, 
	169, 170, 7, 171, 0, 0, 172, 173, 
	174, 175, 176, 177, 178, 0, 179, 7, 
	180, 181, 0, 0, 182, 183, 184, 185, 
	0, 186, 187, 188, 0, 189, 0, 0, 
	190, 191, 192, 193, 194, 195, 0, 28, 
	0, 0, 7, 7, 0, 0, 0, 196, 
	0, 0, 0, 0, 197, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 198, 199, 200, 201, 202, 
	203, 59, 204, 0, 205, 0, 0, 0, 
	206, 0, 207, 208, 0, 0, 209, 0, 
	0, 0, 210, 0, 211, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 210, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 212, 0, 0, 
	0, 0, 213, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 7, 214, 215, 0, 0, 0, 
	216, 217, 218, 59, 219, 0, 28, 220, 
	0, 221, 222, 0, 28, 0, 0, 223, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 224, 0, 225, 0, 226, 227, 
	228, 229, 230, 59, 231, 0, 0, 232, 
	0, 233, 234, 235, 236, 28, 0, 27, 
	0, 0, 27, 0, 0, 0, 0, 0, 
	0, 7, 7, 7, 237, 238, 239, 240, 
	241, 242, 243, 0, 244, 245, 246, 247, 
	248, 249, 250, 251, 252, 59, 253, 0, 
	254, 255, 256, 257, 258, 259, 0, 0, 
	0, 260, 7, 7, 0, 261, 262, 263, 
	264, 265, 0, 0, 0, 0, 0, 266, 
	267, 59, 268, 0, 269, 28, 270, 271, 
	272, 273, 274, 275, 0, 28, 0, 0, 
	0, 0, 0, 0, 276, 277, 278, 279, 
	59, 280, 0, 281, 28, 282, 283, 284, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 285, 286, 0, 8, 
	0, 0, 7, 287, 0, 0, 287, 287, 
	0, 0, 7, 7, 0, 288, 0, 288, 
	288, 288, 0, 0, 288, 285, 285, 285, 
	285, 285, 285, 285, 285, 285, 285, 285, 
	285, 285, 285, 285, 285, 285, 0, 288, 
	289, 290, 290, 291, 292, 0, 293, 294, 
	0, 72, 0, 295, 0, 296, 297, 298, 
	299, 300, 29, 301, 302, 303, 304, 305, 
	59, 306, 0, 307, 308, 0, 309, 310, 
	0, 311, 312, 287, 313, 0, 314, 0, 
	0, 315, 0, 0, 0, 0, 316, 0, 
	0, 0, 0, 0, 0, 0, 317, 0, 
	0, 318, 0, 319, 320, 0, 0, 0, 
	321, 0, 0, 322, 323, 324, 325, 326, 
	327, 0, 0, 0, 328, 329, 0, 330, 
	331, 332, 0, 7, 333, 334, 335, 0, 
	336, 108, 108, 108, 108, 108, 108, 108, 
	108, 337, 338, 339, 0, 0, 340, 0, 
	341, 342, 343, 0, 344, 345, 346, 0, 
	7, 0, 0, 347, 348, 0, 28, 349, 
	0, 0, 0, 0, 0, 350, 351, 0, 
	0, 0, 0, 0, 0, 0, 352, 0, 
	0, 0, 0, 0, 353, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 354, 355, 
	356, 0, 0, 0, 357, 28, 285, 285, 
	285, 285, 285, 285, 285, 285, 285, 285, 
	285, 285, 72, 285, 285, 285, 285, 285, 
	285, 285, 285, 285, 285, 285, 285, 285, 
	285, 285, 285, 285, 285, 285, 285, 285, 
	285, 285, 285, 358, 285, 285, 285, 285, 
	285, 285, 285, 285, 285, 285, 285, 285, 
	359, 360, 361, 362, 363, 363, 359, 285, 
	285, 285, 285, 285, 285, 285, 285, 285, 
	285, 285, 285, 285, 285, 285, 285, 285, 
	285, 285, 364, 365, 366, 0, 28, 0, 
	0, 367, 368, 369, 59, 370, 0, 371, 
	28, 372, 7, 373, 374, 0, 28, 375, 
	0, 0, 376, 377, 378, 379, 59, 380, 
	0, 28, 381, 382, 383, 384, 0, 28, 
	0, 385, 0, 7, 386, 0, 0, 0, 
	0, 387, 0, 0, 388, 388, 0, 389, 
	0, 0, 0, 390, 7, 391, 391, 391, 
	0, 0, 392, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 393, 
	394, 395, 0, 396, 397, 398, 399, 400, 
	401, 59, 402, 0, 403, 0, 0, 404, 
	405, 406, 407, 408, 409, 410, 411, 412, 
	0, 413, 414, 0, 0, 415, 416, 417, 
	0, 0, 418, 0, 0, 417, 419, 419, 
	420, 421, 0, 422, 423, 0, 424, 425, 
	426, 0, 427, 428, 0, 0, 429, 430, 
	417, 417, 431, 0, 0, 432, 432, 0, 
	433, 0, 434, 435, 7, 0, 436, 0, 
	437, 438, 439, 440, 440, 441, 441, 0, 
	0, 442, 443, 443, 444, 444, 445, 446, 
	446, 447, 447, 448, 449, 449, 450, 450, 
	0, 0, 451, 452, 453, 454, 455, 456, 
	456, 453, 455, 457, 388, 458, 0, 0, 
	0, 459, 0, 0, 460, 461, 391, 391, 
	391, 462, 391, 463, 464, 28, 465, 466, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 467, 0, 0, 0, 
	0, 462, 0, 0, 0, 0, 0, 468, 
	469, 0, 0, 0, 0, 0, 0, 470, 
	0, 0, 0, 0, 0, 469, 471, 472, 
	0, 473, 0, 474, 0, 0, 0, 0, 
	475, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 476, 0, 0, 0, 0, 0, 
	0, 0, 475, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 477, 478, 479, 7, 85, 480, 0, 
	481, 0, 482, 0, 0, 0, 483, 484
]

class << self
	attr_accessor :_lex_to_state_actions
	private :_lex_to_state_actions, :_lex_to_state_actions=
end
self._lex_to_state_actions = [
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 88, 0, 0, 
	0, 0, 0, 0, 0, 0, 88, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 88, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 88, 0, 0, 
	88, 0, 88, 0, 0, 0, 88, 88, 
	0, 0, 0, 0, 88, 0, 88, 0, 
	88, 0, 0, 0, 0, 88, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 88, 0, 
	0, 0, 0, 0, 0, 88, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 88, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 88, 0, 0, 0, 0, 0, 88, 
	0, 0, 0, 0, 0, 0, 0, 88, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 88, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	88, 0, 0, 0, 0, 0, 0, 88, 
	0, 0, 0, 0, 0, 0, 0, 88, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 88, 0, 0, 88, 0, 0, 0, 
	0, 0
]

class << self
	attr_accessor :_lex_from_state_actions
	private :_lex_from_state_actions, :_lex_from_state_actions=
end
self._lex_from_state_actions = [
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 89, 0, 0, 
	0, 0, 0, 0, 0, 0, 89, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 89, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 89, 0, 0, 
	89, 0, 89, 0, 0, 0, 89, 89, 
	0, 0, 0, 0, 89, 0, 89, 0, 
	89, 0, 0, 0, 0, 89, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 89, 0, 
	0, 0, 0, 0, 0, 89, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 89, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 89, 0, 0, 0, 0, 0, 89, 
	0, 0, 0, 0, 0, 0, 0, 89, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 89, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	89, 0, 0, 0, 0, 0, 0, 89, 
	0, 0, 0, 0, 0, 0, 0, 89, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 89, 0, 0, 89, 0, 0, 0, 
	0, 0
]

class << self
	attr_accessor :_lex_eof_trans
	private :_lex_eof_trans, :_lex_eof_trans=
end
self._lex_eof_trans = [
	0, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 13, 13, 13, 13, 19, 
	19, 19, 19, 19, 19, 19, 19, 19, 
	19, 19, 19, 19, 19, 44, 44, 44, 
	44, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 75, 
	75, 75, 75, 81, 81, 81, 81, 0, 
	0, 0, 0, 95, 97, 99, 99, 99, 
	104, 104, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 169, 
	169, 169, 169, 169, 169, 169, 169, 169, 
	169, 169, 169, 179, 181, 181, 181, 193, 
	193, 193, 201, 203, 203, 203, 203, 203, 
	209, 201, 201, 201, 201, 201, 201, 201, 
	236, 236, 236, 236, 236, 236, 236, 236, 
	236, 236, 236, 236, 236, 236, 254, 254, 
	254, 254, 254, 254, 254, 254, 254, 254, 
	254, 254, 254, 254, 201, 236, 236, 236, 
	236, 286, 286, 286, 291, 293, 293, 293, 
	297, 297, 300, 300, 300, 300, 305, 305, 
	305, 291, 297, 297, 297, 297, 297, 297, 
	297, 297, 297, 336, 336, 0, 349, 350, 
	351, 353, 355, 357, 355, 355, 0, 367, 
	368, 372, 372, 373, 382, 383, 384, 384, 
	384, 387, 387, 389, 390, 391, 391, 391, 
	393, 394, 395, 395, 391, 387, 387, 400, 
	401, 401, 401, 401, 401, 404, 404, 404, 
	404, 410, 411, 411, 411, 411, 419, 411, 
	411, 411, 411, 424, 411, 411, 411, 411, 
	411, 411, 430, 431, 432, 432, 0, 439, 
	443, 443, 444, 453, 454, 455, 455, 455, 
	458, 458, 460, 461, 462, 462, 462, 464, 
	465, 466, 466, 462, 458, 458, 471, 472, 
	472, 472, 472, 472, 475, 475, 475, 475, 
	481, 482, 482, 482, 482, 490, 482, 482, 
	482, 482, 495, 482, 482, 482, 482, 482, 
	482, 501, 502, 503, 503, 0, 510, 511, 
	0, 517, 0, 524, 528, 528, 0, 0, 
	537, 538, 542, 542, 0, 547, 0, 550, 
	0, 553, 553, 554, 555, 0, 596, 598, 
	599, 600, 601, 603, 605, 609, 609, 600, 
	600, 600, 600, 611, 600, 600, 605, 600, 
	600, 596, 615, 615, 615, 615, 615, 615, 
	605, 605, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 654, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 621, 621, 621, 
	621, 621, 621, 621, 621, 600, 0, 697, 
	698, 699, 701, 697, 704, 0, 723, 725, 
	727, 728, 729, 730, 731, 733, 730, 730, 
	730, 730, 730, 736, 730, 730, 738, 736, 
	736, 730, 0, 757, 758, 104, 104, 761, 
	762, 104, 758, 758, 765, 767, 770, 758, 
	771, 758, 772, 773, 775, 777, 758, 765, 
	778, 778, 767, 778, 782, 778, 778, 778, 
	778, 0, 179, 790, 791, 790, 790, 0, 
	800, 801, 803, 805, 807, 805, 809, 0, 
	821, 822, 823, 824, 826, 828, 830, 831, 
	831, 831, 831, 831, 831, 831, 831, 831, 
	831, 831, 831, 831, 831, 831, 831, 0, 
	889, 892, 895, 896, 900, 902, 903, 904, 
	905, 906, 908, 911, 912, 914, 916, 919, 
	920, 922, 923, 201, 920, 925, 920, 911, 
	911, 911, 911, 943, 946, 948, 949, 953, 
	956, 957, 958, 959, 943, 943, 943, 943, 
	943, 943, 943, 943, 943, 943, 943, 943, 
	911, 965, 911, 911, 911, 966, 973, 973, 
	975, 977, 986, 987, 988, 988, 988, 991, 
	991, 993, 994, 995, 995, 995, 997, 998, 
	999, 999, 995, 991, 991, 1004, 1005, 1005, 
	1005, 1005, 1005, 1008, 1008, 1008, 1008, 1014, 
	1015, 1015, 1015, 1015, 1023, 1015, 1015, 1015, 
	1015, 1029, 1015, 1015, 1015, 1015, 1015, 1015, 
	1015, 1015, 1015, 1015, 1015, 1015, 1015, 1015, 
	1015, 1015, 1015, 1015, 1015, 1047, 1048, 1049, 
	1049, 201, 911, 911, 1053, 911, 906, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 201, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 1106, 896, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 889, 889, 
	889, 889, 889, 889, 889, 889, 1131, 911, 
	0, 1138, 1139, 1140, 1142, 1144, 1146, 0, 
	1155, 1156, 1157, 1158, 1160, 1155, 1163, 0, 
	297, 1218, 1220, 1221, 1222, 1223, 1225, 1227, 
	1229, 1232, 1232, 297, 1234, 1236, 1237, 1238, 
	1234, 1240, 1242, 1243, 1243, 1246, 1257, 297, 
	1263, 1265, 1267, 1268, 1271, 1272, 1246, 1246, 
	1275, 1275, 1275, 1281, 1283, 1284, 1287, 1289, 
	1290, 1291, 1275, 1275, 1298, 1303, 1308, 1275, 
	1275, 1315, 1315, 1275, 1275, 1242, 1234, 1234, 
	1242, 1234, 1234, 1229, 297, 1333, 1334, 1334, 
	1334, 1334, 1334, 1334, 1340, 1229, 1343, 1344, 
	1344, 1344, 1344, 1344, 1344, 1344, 1344, 1344, 
	1344, 1344, 1344, 1344, 1344, 1344, 1344, 1344, 
	1344, 1344, 1344, 1344, 1344, 1344, 1344, 1344, 
	1344, 1344, 1344, 1344, 1344, 1344, 1344, 1344, 
	1344, 1344, 1344, 1383, 1384, 1344, 1344, 1388, 
	1344, 1344, 1344, 1344, 1344, 1344, 1344, 1344, 
	1344, 1344, 1344, 1344, 1344, 1344, 1344, 1344, 
	1344, 1344, 1344, 1344, 1344, 1344, 1344, 1344, 
	1344, 1344, 1344, 1344, 1344, 1344, 1344, 1344, 
	1344, 1344, 1344, 1344, 1344, 1344, 1344, 1344, 
	1344, 1344, 1344, 1344, 1344, 1344, 1344, 1344, 
	1344, 1344, 1344, 1344, 1344, 1344, 1344, 1344, 
	1344, 1344, 1344, 1344, 1344, 1344, 1442, 1223, 
	1443, 0, 1447, 1447, 0, 1451, 1451, 1451, 
	1451, 1455
]

class << self
	attr_accessor :lex_start
end
self.lex_start = 181;
class << self
	attr_accessor :lex_error
end
self.lex_error = 0;

class << self
	attr_accessor :lex_en_interp_words
end
self.lex_en_interp_words = 190;
class << self
	attr_accessor :lex_en_interp_string
end
self.lex_en_interp_string = 246;
class << self
	attr_accessor :lex_en_plain_words
end
self.lex_en_plain_words = 301;
class << self
	attr_accessor :lex_en_plain_string
end
self.lex_en_plain_string = 304;
class << self
	attr_accessor :lex_en_interp_backslash_delimited
end
self.lex_en_interp_backslash_delimited = 306;
class << self
	attr_accessor :lex_en_plain_backslash_delimited
end
self.lex_en_plain_backslash_delimited = 310;
class << self
	attr_accessor :lex_en_interp_backslash_delimited_words
end
self.lex_en_interp_backslash_delimited_words = 311;
class << self
	attr_accessor :lex_en_plain_backslash_delimited_words
end
self.lex_en_plain_backslash_delimited_words = 316;
class << self
	attr_accessor :lex_en_regexp_modifiers
end
self.lex_en_regexp_modifiers = 318;
class << self
	attr_accessor :lex_en_expr_variable
end
self.lex_en_expr_variable = 320;
class << self
	attr_accessor :lex_en_expr_fname
end
self.lex_en_expr_fname = 325;
class << self
	attr_accessor :lex_en_expr_endfn
end
self.lex_en_expr_endfn = 438;
class << self
	attr_accessor :lex_en_expr_dot
end
self.lex_en_expr_dot = 445;
class << self
	attr_accessor :lex_en_expr_arg
end
self.lex_en_expr_arg = 466;
class << self
	attr_accessor :lex_en_expr_cmdarg
end
self.lex_en_expr_cmdarg = 497;
class << self
	attr_accessor :lex_en_expr_endarg
end
self.lex_en_expr_endarg = 503;
class << self
	attr_accessor :lex_en_expr_mid
end
self.lex_en_expr_mid = 511;
class << self
	attr_accessor :lex_en_expr_beg
end
self.lex_en_expr_beg = 535;
class << self
	attr_accessor :lex_en_expr_labelarg
end
self.lex_en_expr_labelarg = 752;
class << self
	attr_accessor :lex_en_expr_value
end
self.lex_en_expr_value = 759;
class << self
	attr_accessor :lex_en_expr_end
end
self.lex_en_expr_end = 767;
class << self
	attr_accessor :lex_en_leading_dot
end
self.lex_en_leading_dot = 945;
class << self
	attr_accessor :lex_en_line_comment
end
self.lex_en_line_comment = 948;
class << self
	attr_accessor :lex_en_line_begin
end
self.lex_en_line_begin = 181;


# line 82 "lib/parser/lexer.rl"
  # %

  ESCAPES = {
    ?a.ord => "\a", ?b.ord  => "\b", ?e.ord => "\e", ?f.ord => "\f",
    ?n.ord => "\n", ?r.ord  => "\r", ?s.ord => "\s", ?t.ord => "\t",
    ?v.ord => "\v", ?\\.ord => "\\"
  }.freeze

  REGEXP_META_CHARACTERS = Regexp.union(*"\\$()*+.<>?[]^{|}".chars).freeze

  attr_reader   :source_buffer

  attr_accessor :diagnostics
  attr_accessor :static_env
  attr_accessor :force_utf32

  attr_accessor :cond, :cmdarg, :in_kwarg

  attr_accessor :tokens, :comments

  def initialize(version)
    @version    = version
    @static_env = nil

    @tokens     = nil
    @comments   = nil

    reset
  end

  def reset(reset_state=true)
    # Ragel state:
    if reset_state
      # Unit tests set state prior to resetting lexer.
      @cs     = self.class.lex_en_line_begin

      @cond   = StackState.new('cond')
      @cmdarg = StackState.new('cmdarg')
      @cond_stack   = []
      @cmdarg_stack = []
    end

    @force_utf32   = false # Set to true by some tests

    @source_pts    = nil # @source as a codepoint array

    @p             = 0   # stream position (saved manually in #advance)
    @ts            = nil # token start
    @te            = nil # token end
    @act           = 0   # next action

    @stack         = []  # state stack
    @top           = 0   # state stack top pointer

    # Lexer state:
    @token_queue   = []
    @literal_stack = []

    @eq_begin_s    = nil # location of last encountered =begin
    @sharp_s       = nil # location of last encountered #

    @newline_s     = nil # location of last encountered newline

    @num_base      = nil # last numeric base
    @num_digits_s  = nil # starting position of numeric digits
    @num_suffix_s  = nil # starting position of numeric suffix
    @num_xfrm      = nil # numeric suffix-induced transformation

    @escape_s      = nil # starting position of current sequence
    @escape        = nil # last escaped sequence, as string

    @herebody_s    = nil # starting position of current heredoc line

    # Ruby 1.9 ->() lambdas emit a distinct token if do/{ is
    # encountered after a matching closing parenthesis.
    @paren_nest    = 0
    @lambda_stack  = []

    # After encountering the closing line of <<~SQUIGGLY_HEREDOC,
    # we store the indentation level and give it out to the parser
    # on request. It is not possible to infer indentation level just
    # from the AST because escape sequences such as `\ ` or `\t` are
    # expanded inside the lexer, but count as non-whitespace for
    # indentation purposes.
    @dedent_level  = nil

    # If the lexer is in `command state' (aka expr_value)
    # at the entry to #advance, it will transition to expr_cmdarg
    # instead of expr_arg at certain points.
    @command_state = false

    # True at the end of "def foo a:"
    @in_kwarg      = false

    # State before =begin / =end block comment
    @cs_before_block_comment = self.class.lex_en_line_begin
  end

  def source_buffer=(source_buffer)
    @source_buffer = source_buffer

    if @source_buffer
      source = @source_buffer.source

      if source.encoding == Encoding::UTF_8
        @source_pts = source.unpack('U*')
      else
        @source_pts = source.unpack('C*')
      end

      if @source_pts[0] == 0xfeff
        # Skip byte order mark.
        @p = 1
      end
    else
      @source_pts = nil
    end
  end

  def encoding
    @source_buffer.source.encoding
  end

  LEX_STATES = {
    :line_begin    => lex_en_line_begin,
    :expr_dot      => lex_en_expr_dot,
    :expr_fname    => lex_en_expr_fname,
    :expr_value    => lex_en_expr_value,
    :expr_beg      => lex_en_expr_beg,
    :expr_mid      => lex_en_expr_mid,
    :expr_arg      => lex_en_expr_arg,
    :expr_cmdarg   => lex_en_expr_cmdarg,
    :expr_end      => lex_en_expr_end,
    :expr_endarg   => lex_en_expr_endarg,
    :expr_endfn    => lex_en_expr_endfn,
    :expr_labelarg => lex_en_expr_labelarg,

    :interp_string => lex_en_interp_string,
    :interp_words  => lex_en_interp_words,
    :plain_string  => lex_en_plain_string,
    :plain_words   => lex_en_plain_string,
  }

  def state
    LEX_STATES.invert.fetch(@cs, @cs)
  end

  def state=(state)
    @cs = LEX_STATES.fetch(state)
  end

  def push_cmdarg
    @cmdarg_stack.push(@cmdarg)
    @cmdarg = StackState.new("cmdarg.#{@cmdarg_stack.count}")
  end

  def pop_cmdarg
    @cmdarg = @cmdarg_stack.pop
  end

  def push_cond
    @cond_stack.push(@cond)
    @cond = StackState.new("cond.#{@cond_stack.count}")
  end

  def pop_cond
    @cond = @cond_stack.pop
  end

  def dedent_level
    # We erase @dedent_level as a precaution to avoid accidentally
    # using a stale value.
    dedent_level, @dedent_level = @dedent_level, nil
    dedent_level
  end

  # Return next token: [type, value].
  def advance
    if @token_queue.any?
      return @token_queue.shift
    end

    # Ugly, but dependent on Ragel output. Consider refactoring it somehow.
    klass = self.class
    _lex_trans_keys         = klass.send :_lex_trans_keys
    _lex_key_spans          = klass.send :_lex_key_spans
    _lex_index_offsets      = klass.send :_lex_index_offsets
    _lex_indicies           = klass.send :_lex_indicies
    _lex_trans_targs        = klass.send :_lex_trans_targs
    _lex_trans_actions      = klass.send :_lex_trans_actions
    _lex_to_state_actions   = klass.send :_lex_to_state_actions
    _lex_from_state_actions = klass.send :_lex_from_state_actions
    _lex_eof_trans          = klass.send :_lex_eof_trans

    pe = @source_pts.size + 2
    p, eof = @p, pe

    @command_state = (@cs == klass.lex_en_expr_value ||
                      @cs == klass.lex_en_line_begin)

    
# line 10834 "lib/parser/lexer.rb"
begin
	testEof = false
	_slen, _trans, _keys, _inds, _acts, _nacts = nil
	_goto_level = 0
	_resume = 10
	_eof_trans = 15
	_again = 20
	_test_eof = 30
	_out = 40
	while true
	if _goto_level <= 0
	if p == pe
		_goto_level = _test_eof
		next
	end
	if  @cs == 0
		_goto_level = _out
		next
	end
	end
	if _goto_level <= _resume
	case _lex_from_state_actions[ @cs] 
	when 89 then
# line 1 "NONE"
		begin
 @ts = p
		end
# line 10862 "lib/parser/lexer.rb"
	end
	_keys =  @cs << 1
	_inds = _lex_index_offsets[ @cs]
	_slen = _lex_key_spans[ @cs]
	_wide = ( (@source_pts[p] || 0))
	_trans = if (   _slen > 0 && 
			_lex_trans_keys[_keys] <= _wide && 
			_wide <= _lex_trans_keys[_keys + 1] 
		    ) then
			_lex_indicies[ _inds + _wide - _lex_trans_keys[_keys] ] 
		 else 
			_lex_indicies[ _inds + _slen ]
		 end
	end
	if _goto_level <= _eof_trans
	 @cs = _lex_trans_targs[_trans]
	if _lex_trans_actions[_trans] != 0
	case _lex_trans_actions[_trans]
	when 28 then
# line 491 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
	when 108 then
# line 799 "lib/parser/lexer.rl"
		begin

    @escape_s = p
    @escape   = nil
  		end
	when 29 then
# line 839 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
	when 59 then
# line 1183 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
	when 63 then
# line 1186 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
	when 292 then
# line 1227 "lib/parser/lexer.rl"
		begin
 tm = p 		end
	when 36 then
# line 1496 "lib/parser/lexer.rl"
		begin
 tm = p 		end
	when 38 then
# line 1512 "lib/parser/lexer.rl"
		begin
 tm = p 		end
	when 40 then
# line 1540 "lib/parser/lexer.rl"
		begin
 tm = p 		end
	when 69 then
# line 1730 "lib/parser/lexer.rl"
		begin
 heredoc_e      = p 		end
	when 334 then
# line 1810 "lib/parser/lexer.rl"
		begin
 @escape = nil 		end
	when 363 then
# line 1879 "lib/parser/lexer.rl"
		begin
 tm = p 		end
	when 290 then
# line 1934 "lib/parser/lexer.rl"
		begin
 ident_tok = tok; ident_ts = @ts; ident_te = @te; 		end
	when 449 then
# line 2115 "lib/parser/lexer.rl"
		begin
 @num_base = 16; @num_digits_s = p 		end
	when 443 then
# line 2116 "lib/parser/lexer.rl"
		begin
 @num_base = 10; @num_digits_s = p 		end
	when 446 then
# line 2117 "lib/parser/lexer.rl"
		begin
 @num_base = 8;  @num_digits_s = p 		end
	when 440 then
# line 2118 "lib/parser/lexer.rl"
		begin
 @num_base = 2;  @num_digits_s = p 		end
	when 455 then
# line 2119 "lib/parser/lexer.rl"
		begin
 @num_base = 10; @num_digits_s = @ts 		end
	when 417 then
# line 2120 "lib/parser/lexer.rl"
		begin
 @num_base = 8;  @num_digits_s = @ts 		end
	when 432 then
# line 2121 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
	when 425 then
# line 2178 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
	when 422 then
# line 2179 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
	when 85 then
# line 2337 "lib/parser/lexer.rl"
		begin
 tm = p 		end
	when 7 then
# line 1 "NONE"
		begin
 @te = p+1
		end
	when 105 then
# line 1065 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DBEG, '#{'.freeze)

    if current_literal.heredoc?
      current_literal.saved_herebody_s = @herebody_s
      @herebody_s = nil
    end

    current_literal.start_interp_brace
     @cs = 759;
    	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 5 then
# line 1002 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DVAR, nil, @ts, @ts + 1)

    p = @ts
    	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 320
		_goto_level = _again
		next
	end

   end
		end
	when 101 then
# line 927 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 100 then
# line 848 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 752;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 106 then
# line 1002 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DVAR, nil, @ts, @ts + 1)

    p = @ts
    	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 320
		_goto_level = _again
		next
	end

   end
		end
	when 103 then
# line 989 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    literal.extend_space @ts, @te
   end
		end
	when 104 then
# line 848 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 752;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 6 then
# line 872 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.heredoc? && escaped_char == "\n".freeze
        if current_literal.squiggly_heredoc?
          # Squiggly heredocs like
          #   <<~-HERE
          #     1\
          #     2
          #   HERE
          # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
          # This information is emitted as is, without escaping,
          # later this escape sequence (\\n) gets handled manually in the Lexer::Dedenter
          current_literal.extend_string(tok, @ts, @te)
        else
          # Plain heredocs also parse \\n as a line continuation,
          # but they don't need to know that there was originally a newline in the
          # code, so we escape it and emit as "  1  2\n"
          current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
        end
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 4 then
# line 848 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 752;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 133 then
# line 1065 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DBEG, '#{'.freeze)

    if current_literal.heredoc?
      current_literal.saved_herebody_s = @herebody_s
      @herebody_s = nil
    end

    current_literal.start_interp_brace
     @cs = 759;
    	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 10 then
# line 1002 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DVAR, nil, @ts, @ts + 1)

    p = @ts
    	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 320
		_goto_level = _again
		next
	end

   end
		end
	when 130 then
# line 927 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 129 then
# line 848 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 752;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 134 then
# line 1002 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DVAR, nil, @ts, @ts + 1)

    p = @ts
    	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 320
		_goto_level = _again
		next
	end

   end
		end
	when 132 then
# line 848 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 752;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 11 then
# line 872 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.heredoc? && escaped_char == "\n".freeze
        if current_literal.squiggly_heredoc?
          # Squiggly heredocs like
          #   <<~-HERE
          #     1\
          #     2
          #   HERE
          # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
          # This information is emitted as is, without escaping,
          # later this escape sequence (\\n) gets handled manually in the Lexer::Dedenter
          current_literal.extend_string(tok, @ts, @te)
        else
          # Plain heredocs also parse \\n as a line continuation,
          # but they don't need to know that there was originally a newline in the
          # code, so we escape it and emit as "  1  2\n"
          current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
        end
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 9 then
# line 848 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 752;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 157 then
# line 927 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 156 then
# line 848 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 752;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 159 then
# line 989 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    literal.extend_space @ts, @te
   end
		end
	when 160 then
# line 848 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 752;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 163 then
# line 927 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 162 then
# line 848 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 752;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 165 then
# line 848 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 752;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 172 then
# line 1065 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DBEG, '#{'.freeze)

    if current_literal.heredoc?
      current_literal.saved_herebody_s = @herebody_s
      @herebody_s = nil
    end

    current_literal.start_interp_brace
     @cs = 759;
    	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 13 then
# line 1002 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DVAR, nil, @ts, @ts + 1)

    p = @ts
    	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 320
		_goto_level = _again
		next
	end

   end
		end
	when 169 then
# line 927 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 168 then
# line 848 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 752;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 173 then
# line 1002 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DVAR, nil, @ts, @ts + 1)

    p = @ts
    	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 320
		_goto_level = _again
		next
	end

   end
		end
	when 171 then
# line 848 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 752;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 12 then
# line 848 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 752;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 175 then
# line 927 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 174 then
# line 848 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 752;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 182 then
# line 1065 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DBEG, '#{'.freeze)

    if current_literal.heredoc?
      current_literal.saved_herebody_s = @herebody_s
      @herebody_s = nil
    end

    current_literal.start_interp_brace
     @cs = 759;
    	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 15 then
# line 1002 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DVAR, nil, @ts, @ts + 1)

    p = @ts
    	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 320
		_goto_level = _again
		next
	end

   end
		end
	when 178 then
# line 927 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 177 then
# line 848 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 752;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 183 then
# line 1002 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DVAR, nil, @ts, @ts + 1)

    p = @ts
    	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 320
		_goto_level = _again
		next
	end

   end
		end
	when 180 then
# line 989 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    literal.extend_space @ts, @te
   end
		end
	when 181 then
# line 848 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 752;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 14 then
# line 848 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 752;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 185 then
# line 927 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 184 then
# line 848 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 752;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 187 then
# line 989 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    literal.extend_space @ts, @te
   end
		end
	when 188 then
# line 1157 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit(:tREGEXP_OPT, tok(@ts, @te - 1), @ts, @te - 1)
        p = p - 1;
        	begin
		 @cs = 767
		_goto_level = _again
		next
	end

       end
		end
	when 189 then
# line 1144 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        unknown_options = tok.scan(/[^imxouesn]/)
        if unknown_options.any?
          diagnostic :error, :regexp_options,
                     { :options => unknown_options.join }
        end

        emit(:tREGEXP_OPT)
         @cs = 767;
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 16 then
# line 1286 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        if    tok =~ /^\$([1-9][0-9]*)$/
          emit(:tNTH_REF, tok(@ts + 1).to_i)
        elsif tok =~ /^\$([&`'+])$/
          emit(:tBACK_REF)
        else
          emit(:tGVAR)
        end

         @cs = (stack_pop); 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 190 then
# line 1286 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if    tok =~ /^\$([1-9][0-9]*)$/
          emit(:tNTH_REF, tok(@ts + 1).to_i)
        elsif tok =~ /^\$([&`'+])$/
          emit(:tBACK_REF)
        else
          emit(:tGVAR)
        end

         @cs = (stack_pop); 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 192 then
# line 1299 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if tok =~ /^@@[0-9]/
          diagnostic :error, :cvar_name, { :name => tok }
        end

        emit(:tCVAR)
         @cs = (stack_pop); 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 191 then
# line 1309 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if tok =~ /^@[0-9]/
          diagnostic :error, :ivar_name, { :name => tok }
        end

        emit(:tIVAR)
         @cs = (stack_pop); 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 213 then
# line 1330 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit_table(KEYWORDS_BEGIN);
            @cs = 438; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 199 then
# line 1338 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit(:tIDENTIFIER)
            @cs = 438; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 18 then
# line 1342 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = @ts - 1
            @cs = 767; 	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 320
		_goto_level = _again
		next
	end
  end
		end
	when 196 then
# line 1351 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit_table(PUNCTUATION)
            @cs = 438; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 208 then
# line 1355 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; p = p - 1; 	begin
		 @cs = 767
		_goto_level = _again
		next
	end
  end
		end
	when 20 then
# line 1361 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        if version?(23)
          type, delimiter = tok[0..-2], tok[-1].chr
          	begin
		 @cs = (push_literal(type, delimiter, @ts))
		_goto_level = _again
		next
	end

        else
          p = @ts - 1
          	begin
		 @cs = 767
		_goto_level = _again
		next
	end

        end
       end
		end
	when 195 then
# line 1374 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; 	begin
		 @cs = 767
		_goto_level = _again
		next
	end
  end
		end
	when 194 then
# line 517 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 212 then
# line 1330 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(KEYWORDS_BEGIN);
            @cs = 438; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 209 then
# line 1334 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tCONSTANT)
            @cs = 438; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 211 then
# line 1338 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tIDENTIFIER)
            @cs = 438; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 206 then
# line 1342 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1
            @cs = 767; 	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 320
		_goto_level = _again
		next
	end
  end
		end
	when 202 then
# line 1351 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(PUNCTUATION)
            @cs = 438; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 207 then
# line 1358 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 535
		_goto_level = _again
		next
	end
  end
		end
	when 200 then
# line 1371 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 205 then
# line 1374 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 767
		_goto_level = _again
		next
	end
  end
		end
	when 19 then
# line 1351 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin  emit_table(PUNCTUATION)
            @cs = 438; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 17 then
# line 1374 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin  p = p - 1; 	begin
		 @cs = 767
		_goto_level = _again
		next
	end
  end
		end
	when 198 then
# line 1 "NONE"
		begin
	case  @act
	when 39 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS_BEGIN);
            @cs = 438; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 40 then
	begin begin p = (( @te))-1; end
 emit(:tCONSTANT)
            @cs = 438; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 41 then
	begin begin p = (( @te))-1; end
 emit(:tIDENTIFIER)
            @cs = 438; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
end 
			end
	when 22 then
# line 1386 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit(:tLABEL, tok(@ts, @te - 2), @ts, @te - 1)
           p = p - 1;  @cs = 752; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 215 then
# line 1392 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; 	begin
		 @cs = 767
		_goto_level = _again
		next
	end
  end
		end
	when 214 then
# line 517 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 217 then
# line 1389 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 216 then
# line 1392 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 767
		_goto_level = _again
		next
	end
  end
		end
	when 21 then
# line 1392 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin  p = p - 1; 	begin
		 @cs = 767
		_goto_level = _again
		next
	end
  end
		end
	when 223 then
# line 1418 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit_table(PUNCTUATION)
            @cs = 466; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 222 then
# line 1424 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; 	begin
		 @cs = 767
		_goto_level = _again
		next
	end
  end
		end
	when 221 then
# line 517 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 233 then
# line 1403 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tCONSTANT)
            @cs = (arg_or_cmdarg); 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 224 then
# line 1407 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tIDENTIFIER)
            @cs = (arg_or_cmdarg); 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 229 then
# line 1418 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(PUNCTUATION)
            @cs = 466; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 227 then
# line 1421 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 232 then
# line 1424 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 767
		_goto_level = _again
		next
	end
  end
		end
	when 256 then
# line 1482 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        # Unlike expr_beg as invoked in the next rule, do not warn
        p = @ts - 1
        	begin
		 @cs = 767
		_goto_level = _again
		next
	end

       end
		end
	when 239 then
# line 1500 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        if tok(tm, tm + 1) == '/'.freeze
          # Ambiguous regexp literal.
          diagnostic :warning, :ambiguous_literal, nil, range(tm, tm + 1)
        end

        p = tm - 1
        	begin
		 @cs = 535
		_goto_level = _again
		next
	end

       end
		end
	when 245 then
# line 1524 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; p = p - 1; 	begin
		 @cs = 535
		_goto_level = _again
		next
	end
  end
		end
	when 24 then
# line 1532 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = @ts - 1; 	begin
		 @cs = 535
		_goto_level = _again
		next
	end
  end
		end
	when 247 then
# line 1541 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = tm - 1; 	begin
		 @cs = 767
		_goto_level = _again
		next
	end
  end
		end
	when 39 then
# line 1552 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        p = @ts - 1
        	begin
		 @cs = 767
		_goto_level = _again
		next
	end

       end
		end
	when 234 then
# line 1566 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; 	begin
		 @cs = 535
		_goto_level = _again
		next
	end
  end
		end
	when 235 then
# line 517 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 246 then
# line 1491 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 535
		_goto_level = _again
		next
	end
  end
		end
	when 242 then
# line 1513 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        diagnostic :warning, :ambiguous_prefix, { :prefix => tok(tm, @te) },
                   range(tm, @te)

        p = tm - 1
        	begin
		 @cs = 535
		_goto_level = _again
		next
	end

       end
		end
	when 244 then
# line 1529 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 535
		_goto_level = _again
		next
	end
  end
		end
	when 238 then
# line 1552 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        p = @ts - 1
        	begin
		 @cs = 767
		_goto_level = _again
		next
	end

       end
		end
	when 237 then
# line 1557 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 255 then
# line 1566 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 535
		_goto_level = _again
		next
	end
  end
		end
	when 25 then
# line 1557 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
		end
	when 41 then
# line 1566 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin  p = p - 1; 	begin
		 @cs = 535
		_goto_level = _again
		next
	end
  end
		end
	when 23 then
# line 1 "NONE"
		begin
	case  @act
	when 67 then
	begin begin p = (( @te))-1; end

        if tok(tm, tm + 1) == '/'.freeze
          # Ambiguous regexp literal.
          diagnostic :warning, :ambiguous_literal, nil, range(tm, tm + 1)
        end

        p = tm - 1
        	begin
		 @cs = 535
		_goto_level = _again
		next
	end

      end
	when 68 then
	begin begin p = (( @te))-1; end

        diagnostic :warning, :ambiguous_prefix, { :prefix => tok(tm, @te) },
                   range(tm, @te)

        p = tm - 1
        	begin
		 @cs = 535
		_goto_level = _again
		next
	end

      end
	when 73 then
	begin begin p = (( @te))-1; end

        p = @ts - 1
        	begin
		 @cs = 767
		_goto_level = _again
		next
	end

      end
	else
	begin begin p = (( @te))-1; end
end
end 
			end
	when 43 then
# line 1602 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = @ts - 1
           	begin
		 @cs = 466
		_goto_level = _again
		next
	end
  end
		end
	when 260 then
# line 517 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 261 then
# line 1602 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1
           	begin
		 @cs = 466
		_goto_level = _again
		next
	end
  end
		end
	when 44 then
# line 1602 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin  p = @ts - 1
           	begin
		 @cs = 466
		_goto_level = _again
		next
	end
  end
		end
	when 42 then
# line 1 "NONE"
		begin
	case  @act
	when 80 then
	begin begin p = (( @te))-1; end

        if @cond.active?
          emit(:kDO_COND, 'do'.freeze, @te - 2, @te)
        else
          emit(:kDO, 'do'.freeze, @te - 2, @te)
        end
         @cs = 759; 	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 81 then
	begin begin p = (( @te))-1; end
 p = @ts - 1
           	begin
		 @cs = 466
		_goto_level = _again
		next
	end
 end
end 
			end
	when 271 then
# line 1636 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit_do(true)
            @cs = 759; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 264 then
# line 1642 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; 	begin
		 @cs = 767
		_goto_level = _again
		next
	end
  end
		end
	when 265 then
# line 517 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 266 then
# line 1639 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 269 then
# line 1642 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 767
		_goto_level = _again
		next
	end
  end
		end
	when 275 then
# line 1666 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; 	begin
		 @cs = 535
		_goto_level = _again
		next
	end
  end
		end
	when 274 then
# line 517 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 283 then
# line 1658 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1; 	begin
		 @cs = 535
		_goto_level = _again
		next
	end
  end
		end
	when 277 then
# line 1660 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 281 then
# line 1666 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 535
		_goto_level = _again
		next
	end
  end
		end
	when 276 then
# line 1 "NONE"
		begin
	case  @act
	when 88 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
            @cs = 535; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 89 then
	begin begin p = (( @te))-1; end
 p = @ts - 1; 	begin
		 @cs = 535
		_goto_level = _again
		next
	end
 end
end 
			end
	when 56 then
# line 1681 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit(:tUNARY_NUM, tok(@ts, @ts + 1), @ts, @ts + 1)
        p = p - 1;  @cs = 767; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 314 then
# line 1698 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        type = delimiter = tok[0].chr
        p = p - 1; 	begin
		 @cs = (push_literal(type, delimiter, @ts))
		_goto_level = _again
		next
	end

       end
		end
	when 308 then
# line 1705 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        type, delimiter = @source_buffer.slice(@ts).chr, tok[-1].chr
        	begin
		 @cs = (push_literal(type, delimiter, @ts))
		_goto_level = _again
		next
	end

       end
		end
	when 54 then
# line 1712 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        type, delimiter = tok[0..-2], tok[-1].chr
        	begin
		 @cs = (push_literal(type, delimiter, @ts))
		_goto_level = _again
		next
	end

       end
		end
	when 327 then
# line 1768 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        p = p - 1; p = p - 1;
        emit(:tSYMBEG, tok(@ts, @ts + 1), @ts, @ts + 1)
        	begin
		 @cs = 325
		_goto_level = _again
		next
	end

       end
		end
	when 315 then
# line 1776 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        type, delimiter = tok, tok[-1].chr
        	begin
		 @cs = (push_literal(type, delimiter, @ts))
		_goto_level = _again
		next
	end

       end
		end
	when 326 then
# line 1784 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit(:tSYMBOL, tok(@ts + 1, @ts + 2))
         @cs = 767; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 68 then
# line 1798 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit(:tSYMBOL, tok(@ts + 1), @ts)
         @cs = 767; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 331 then
# line 1825 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        escape = { " "  => '\s', "\r" => '\r', "\n" => '\n', "\t" => '\t',
                   "\v" => '\v', "\f" => '\f' }[@source_buffer.slice(@ts + 1)]
        diagnostic :warning, :invalid_escape_use, { :escape => escape }, range

        p = @ts - 1
        	begin
		 @cs = 767
		_goto_level = _again
		next
	end

       end
		end
	when 330 then
# line 1835 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        diagnostic :fatal, :incomplete_escape, nil, range(@ts, @ts + 1)
       end
		end
	when 316 then
# line 1874 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit_table(PUNCTUATION_BEGIN)
           	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 51 then
# line 1894 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        p = p - 1;

        if version?(18)
          ident = tok(@ts, @te - 2)

          emit((@source_buffer.slice(@ts) =~ /[A-Z]/) ? :tCONSTANT : :tIDENTIFIER,
               ident, @ts, @te - 2)
          p = p - 1; # continue as a symbol

          if !@static_env.nil? && @static_env.declared?(ident)
             @cs = 767;
          else
             @cs = (arg_or_cmdarg);
          end
        else
          emit(:tLABEL, tok(@ts, @te - 2), @ts, @te - 1)
           @cs = 752;
        end

        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 48 then
# line 1936 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit(:tIDENTIFIER, ident_tok, ident_ts, ident_te)
        p = ident_te - 1

        if !@static_env.nil? && @static_env.declared?(ident_tok) && @version < 25
           @cs = 438;
        else
           @cs = 497;
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 302 then
# line 1955 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        p = @ts - 1
        @cs_before_block_comment = @cs
        	begin
		 @cs = 181
		_goto_level = _again
		next
	end

       end
		end
	when 55 then
# line 1971 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = @ts - 1; 	begin
		 @cs = 767
		_goto_level = _again
		next
	end
  end
		end
	when 286 then
# line 517 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 313 then
# line 1681 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tUNARY_NUM, tok(@ts, @ts + 1), @ts, @ts + 1)
        p = p - 1;  @cs = 767; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 312 then
# line 1688 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tSTAR, '*'.freeze)
           	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 309 then
# line 1712 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        type, delimiter = tok[0..-2], tok[-1].chr
        	begin
		 @cs = (push_literal(type, delimiter, @ts))
		_goto_level = _again
		next
	end

       end
		end
	when 307 then
# line 1718 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        diagnostic :fatal, :string_eof, nil, range(@ts, @ts + 1)
       end
		end
	when 317 then
# line 1798 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tSYMBOL, tok(@ts + 1), @ts)
         @cs = 767; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 329 then
# line 1835 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        diagnostic :fatal, :incomplete_escape, nil, range(@ts, @ts + 1)
       end
		end
	when 335 then
# line 1841 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        p = @ts - 1
        	begin
		 @cs = 767
		_goto_level = _again
		next
	end

       end
		end
	when 310 then
# line 1874 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(PUNCTUATION_BEGIN)
           	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 289 then
# line 1271 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    emit(:tIDENTIFIER)

    if !@static_env.nil? && @static_env.declared?(tok)
       @cs = 438; 	begin
		p += 1
		_goto_level = _out
		next
	end

    else
       @cs = (arg_or_cmdarg); 	begin
		p += 1
		_goto_level = _out
		next
	end

    end
   end
		end
	when 299 then
# line 1952 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 301 then
# line 1955 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        p = @ts - 1
        @cs_before_block_comment = @cs
        	begin
		 @cs = 181
		_goto_level = _again
		next
	end

       end
		end
	when 304 then
# line 1971 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1; 	begin
		 @cs = 767
		_goto_level = _again
		next
	end
  end
		end
	when 53 then
# line 1718 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
        diagnostic :fatal, :string_eof, nil, range(@ts, @ts + 1)
       end
		end
	when 71 then
# line 1812 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 767; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 47 then
# line 1271 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
    emit(:tIDENTIFIER)

    if !@static_env.nil? && @static_env.declared?(tok)
       @cs = 438; 	begin
		p += 1
		_goto_level = _out
		next
	end

    else
       @cs = (arg_or_cmdarg); 	begin
		p += 1
		_goto_level = _out
		next
	end

    end
   end
		end
	when 52 then
# line 1952 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
		end
	when 67 then
# line 1971 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin  p = @ts - 1; 	begin
		 @cs = 767
		_goto_level = _again
		next
	end
  end
		end
	when 50 then
# line 1 "NONE"
		begin
	case  @act
	when 94 then
	begin begin p = (( @te))-1; end

        emit(:tUNARY_NUM, tok(@ts, @ts + 1), @ts, @ts + 1)
        p = p - 1;  @cs = 767; 	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 113 then
	begin begin p = (( @te))-1; end
 emit_table(PUNCTUATION_BEGIN)
           	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 114 then
	begin begin p = (( @te))-1; end
 emit(:kRESCUE, 'rescue'.freeze, @ts, tm)
           p = tm - 1
            @cs = 511; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 115 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS_BEGIN)
            @cs = 759; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 117 then
	begin begin p = (( @te))-1; end
 p = @ts - 1
           	begin
		 @cs = 767
		_goto_level = _again
		next
	end
 end
	when 118 then
	begin begin p = (( @te))-1; end

    emit(:tIDENTIFIER)

    if !@static_env.nil? && @static_env.declared?(tok)
       @cs = 438; 	begin
		p += 1
		_goto_level = _out
		next
	end

    else
       @cs = (arg_or_cmdarg); 	begin
		p += 1
		_goto_level = _out
		next
	end

    end
  end
	when 122 then
	begin begin p = (( @te))-1; end
 p = @ts - 1; 	begin
		 @cs = 767
		_goto_level = _again
		next
	end
 end
end 
			end
	when 365 then
# line 1991 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; 	begin
		 @cs = 535
		_goto_level = _again
		next
	end
  end
		end
	when 366 then
# line 517 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 367 then
# line 1979 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 371 then
# line 1991 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 535
		_goto_level = _again
		next
	end
  end
		end
	when 74 then
# line 2001 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = @ts - 1
           	begin
		 @cs = 767
		_goto_level = _again
		next
	end
  end
		end
	when 375 then
# line 2006 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        	begin
		 @cs = (push_literal(tok, tok, @ts))
		_goto_level = _again
		next
	end

       end
		end
	when 374 then
# line 2016 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; 	begin
		 @cs = 535
		_goto_level = _again
		next
	end
  end
		end
	when 373 then
# line 517 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 377 then
# line 2010 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 376 then
# line 2016 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 535
		_goto_level = _again
		next
	end
  end
		end
	when 73 then
# line 2016 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin  p = p - 1; 	begin
		 @cs = 535
		_goto_level = _again
		next
	end
  end
		end
	when 411 then
# line 2027 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit(:tLAMBDA, '->'.freeze, @ts, @ts + 2)

        @lambda_stack.push @paren_nest
         @cs = 438; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 83 then
# line 2064 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit(:kCLASS, 'class'.freeze, @ts, @ts + 5)
           emit(:tLSHFT, '<<'.freeze,    @te - 2, @te)
            @cs = 759; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 385 then
# line 2199 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        type, delimiter = tok, tok[-1].chr
        	begin
		 @cs = (push_literal(type, delimiter, @ts, nil, false, false, true))
		_goto_level = _again
		next
	end

       end
		end
	when 76 then
# line 2217 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = @ts - 1; 	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 320
		_goto_level = _again
		next
	end
  end
		end
	when 407 then
# line 2224 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit_table(PUNCTUATION)
            @cs = 445; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 459 then
# line 2248 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit_table(PUNCTUATION)
        	begin
		 @cs = 759
		_goto_level = _again
		next
	end

       end
		end
	when 400 then
# line 2257 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit_table(PUNCTUATION);
         @cs = 759; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 392 then
# line 2267 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit_table(PUNCTUATION)

        if @version < 24
          @cond.lexpop
          @cmdarg.lexpop
        else
          @cond.pop
          @cmdarg.pop
        end

        if tok == '}'.freeze || tok == ']'.freeze
          if @version >= 25
             @cs = 767;
          else
             @cs = 503;
          end
        else # )
          # fnext expr_endfn; ?
        end

        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 405 then
# line 2292 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit(:tOP_ASGN, tok(@ts, @te - 1))
            @cs = 535; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 390 then
# line 2296 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit(:tEH, '?'.freeze)
            @cs = 759; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 387 then
# line 2304 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit_table(PUNCTUATION)
            @cs = 535; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 389 then
# line 2317 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit(:tSEMI, ';'.freeze)
            @cs = 759; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 464 then
# line 2320 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        diagnostic :error, :bare_backslash, nil, range(@ts, @ts + 1)
        p = p - 1;
       end
		end
	when 384 then
# line 2326 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        diagnostic :fatal, :unexpected, { :character => tok.inspect[1..-2] }
       end
		end
	when 383 then
# line 517 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 474 then
# line 2060 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(KEYWORDS)
            @cs = 325; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 472 then
# line 2064 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:kCLASS, 'class'.freeze, @ts, @ts + 5)
           emit(:tLSHFT, '<<'.freeze,    @te - 2, @te)
            @cs = 759; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 471 then
# line 2075 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(KEYWORDS)
            @cs = 759; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 414 then
# line 2149 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        diagnostic :error, :no_dot_digit_literal
       end
		end
	when 461 then
# line 2209 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tCONSTANT)
            @cs = (arg_or_cmdarg); 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 404 then
# line 2217 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1; 	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 320
		_goto_level = _again
		next
	end
  end
		end
	when 412 then
# line 2224 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(PUNCTUATION)
            @cs = 445; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 466 then
# line 1271 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    emit(:tIDENTIFIER)

    if !@static_env.nil? && @static_env.declared?(tok)
       @cs = 438; 	begin
		p += 1
		_goto_level = _out
		next
	end

    else
       @cs = (arg_or_cmdarg); 	begin
		p += 1
		_goto_level = _out
		next
	end

    end
   end
		end
	when 410 then
# line 2248 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit_table(PUNCTUATION)
        	begin
		 @cs = 759
		_goto_level = _again
		next
	end

       end
		end
	when 406 then
# line 2257 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit_table(PUNCTUATION);
         @cs = 759; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 399 then
# line 2263 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(PUNCTUATION)
            @cs = 535; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 413 then
# line 2304 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(PUNCTUATION)
            @cs = 535; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 397 then
# line 2311 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 403 then
# line 2326 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        diagnostic :fatal, :unexpected, { :character => tok.inspect[1..-2] }
       end
		end
	when 81 then
# line 2122 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 77 then
# line 2149 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
        diagnostic :error, :no_dot_digit_literal
       end
		end
	when 80 then
# line 2181 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
        digits = tok(@ts, @num_suffix_s)

        if version?(18, 19, 20)
          emit(:tFLOAT, Float(digits), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 75 then
# line 2326 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
        diagnostic :fatal, :unexpected, { :character => tok.inspect[1..-2] }
       end
		end
	when 78 then
# line 1 "NONE"
		begin
	case  @act
	when 135 then
	begin begin p = (( @te))-1; end

        if @lambda_stack.last == @paren_nest
          @lambda_stack.pop

          if tok == '{'.freeze
            emit(:tLAMBEG, '{'.freeze)
          else # 'do'
            emit(:kDO_LAMBDA, 'do'.freeze)
          end
        else
          if tok == '{'.freeze
            emit(:tLCURLY, '{'.freeze)
          else # 'do'
            emit_do
          end
        end

         @cs = 759; 	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 136 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
            @cs = 325; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 137 then
	begin begin p = (( @te))-1; end
 emit(:kCLASS, 'class'.freeze, @ts, @ts + 5)
           emit(:tLSHFT, '<<'.freeze,    @te - 2, @te)
            @cs = 759; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 138 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
            @cs = 535; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 139 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
            @cs = 759; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 140 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
            @cs = 511; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 141 then
	begin begin p = (( @te))-1; end

        emit_table(KEYWORDS)

        if version?(18) && tok == 'not'.freeze
           @cs = 535; 	begin
		p += 1
		_goto_level = _out
		next
	end

        else
           @cs = 466; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
      end
	when 142 then
	begin begin p = (( @te))-1; end

        if version?(18)
          emit(:tIDENTIFIER)

          unless !@static_env.nil? && @static_env.declared?(tok)
             @cs = (arg_or_cmdarg);
          end
        else
          emit(:k__ENCODING__, '__ENCODING__'.freeze)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 143 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
           	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 144 then
	begin begin p = (( @te))-1; end

        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 146 then
	begin begin p = (( @te))-1; end

        if version?(18, 19, 20)
          diagnostic :error,
                     :trailing_in_number, { :character => tok(@te - 1, @te) },
                     range(@te - 1, @te)
        else
          emit(:tINTEGER, tok(@ts, @te - 1).to_i, @ts, @te - 1)
          p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
      end
	when 147 then
	begin begin p = (( @te))-1; end

        if version?(18, 19, 20)
          diagnostic :error,
                     :trailing_in_number, { :character => tok(@te - 1, @te) },
                     range(@te - 1, @te)
        else
          emit(:tFLOAT, tok(@ts, @te - 1).to_f, @ts, @te - 1)
          p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
      end
	when 148 then
	begin begin p = (( @te))-1; end

        digits = tok(@ts, @num_suffix_s)

        if version?(18, 19, 20)
          emit(:tFLOAT, Float(digits), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 150 then
	begin begin p = (( @te))-1; end
 emit(:tCONSTANT)
            @cs = (arg_or_cmdarg); 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 154 then
	begin begin p = (( @te))-1; end

    emit(:tIDENTIFIER)

    if !@static_env.nil? && @static_env.declared?(tok)
       @cs = 438; 	begin
		p += 1
		_goto_level = _out
		next
	end

    else
       @cs = (arg_or_cmdarg); 	begin
		p += 1
		_goto_level = _out
		next
	end

    end
  end
	when 155 then
	begin begin p = (( @te))-1; end

        if tm == @te
          # Suffix was consumed, e.g. foo!
          emit(:tFID)
        else
          # Suffix was not consumed, e.g. foo!=
          emit(:tIDENTIFIER, tok(@ts, tm), @ts, tm)
          p = tm - 1
        end
         @cs = 466; 	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 157 then
	begin begin p = (( @te))-1; end

        emit_table(PUNCTUATION);
         @cs = 759; 	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 158 then
	begin begin p = (( @te))-1; end
 emit_table(PUNCTUATION)
            @cs = 535; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
end 
			end
	when 87 then
# line 2338 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = tm - 1; 	begin
		 @cs = 767
		_goto_level = _again
		next
	end
  end
		end
	when 479 then
# line 2341 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit(:tNL, nil, @newline_s, @newline_s + 1)
           p = p - 1;  @cs = 181; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 480 then
# line 2341 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tNL, nil, @newline_s, @newline_s + 1)
           p = p - 1;  @cs = 181; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 84 then
# line 2341 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin  emit(:tNL, nil, @newline_s, @newline_s + 1)
           p = p - 1;  @cs = 181; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 483 then
# line 2351 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit_comment(@eq_begin_s, @te)
        	begin
		 @cs = (@cs_before_block_comment)
		_goto_level = _again
		next
	end

       end
		end
	when 482 then
# line 2359 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        diagnostic :fatal, :embedded_document, nil,
                   range(@eq_begin_s, @eq_begin_s + '=begin'.length)
       end
		end
	when 98 then
# line 2369 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  @eq_begin_s = @ts
           	begin
		 @cs = 948
		_goto_level = _again
		next
	end
  end
		end
	when 2 then
# line 2373 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = pe - 3  end
		end
	when 90 then
# line 2376 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; 	begin
		 @cs = 759
		_goto_level = _again
		next
	end
  end
		end
	when 91 then
# line 517 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 92 then
# line 2366 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 97 then
# line 2369 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  @eq_begin_s = @ts
           	begin
		 @cs = 948
		_goto_level = _again
		next
	end
  end
		end
	when 96 then
# line 2376 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 759
		_goto_level = _again
		next
	end
  end
		end
	when 1 then
# line 2376 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin  p = p - 1; 	begin
		 @cs = 759
		_goto_level = _again
		next
	end
  end
		end
	when 66 then
# line 491 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 1186 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
	when 102 then
# line 491 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 927 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 131 then
# line 491 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 927 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 158 then
# line 491 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 927 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 164 then
# line 491 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 927 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 170 then
# line 491 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 927 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 176 then
# line 491 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 927 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 179 then
# line 491 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 927 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 186 then
# line 491 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 927 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 257 then
# line 491 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 1482 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        # Unlike expr_beg as invoked in the next rule, do not warn
        p = @ts - 1
        	begin
		 @cs = 767
		_goto_level = _again
		next
	end

       end
		end
	when 248 then
# line 491 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 1541 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = tm - 1; 	begin
		 @cs = 767
		_goto_level = _again
		next
	end
  end
		end
	when 240 then
# line 491 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 1552 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        p = @ts - 1
        	begin
		 @cs = 767
		_goto_level = _again
		next
	end

       end
		end
	when 332 then
# line 491 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 1825 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        escape = { " "  => '\s', "\r" => '\r', "\n" => '\n', "\t" => '\t',
                   "\v" => '\v', "\f" => '\f' }[@source_buffer.slice(@ts + 1)]
        diagnostic :warning, :invalid_escape_use, { :escape => escape }, range

        p = @ts - 1
        	begin
		 @cs = 767
		_goto_level = _again
		next
	end

       end
		end
	when 303 then
# line 491 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 1955 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        p = @ts - 1
        @cs_before_block_comment = @cs
        	begin
		 @cs = 181
		_goto_level = _again
		next
	end

       end
		end
	when 484 then
# line 491 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 2351 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit_comment(@eq_begin_s, @te)
        	begin
		 @cs = (@cs_before_block_comment)
		_goto_level = _again
		next
	end

       end
		end
	when 481 then
# line 491 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 2356 "lib/parser/lexer.rl"
		begin
 @te = p+1
		end
	when 99 then
# line 491 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 2369 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  @eq_begin_s = @ts
           	begin
		 @cs = 948
		_goto_level = _again
		next
	end
  end
		end
	when 3 then
# line 491 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 2373 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = pe - 3  end
		end
	when 435 then
# line 625 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tRATIONAL,  Rational(chars)) } 		end
# line 2122 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 433 then
# line 626 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tIMAGINARY, Complex(0, chars)) } 		end
# line 2122 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 438 then
# line 627 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tIMAGINARY, Complex(0, Rational(chars))) } 		end
# line 2122 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 436 then
# line 628 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars, @ts, @te - 2); p -= 2 } 		end
# line 2122 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 434 then
# line 629 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars, @ts, @te - 2); p -= 2 } 		end
# line 2122 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 437 then
# line 630 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars, @ts, @te - 6); p -= 6 } 		end
# line 2122 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 426 then
# line 634 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tIMAGINARY, Complex(0, Float(chars))) } 		end
# line 2181 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@ts, @num_suffix_s)

        if version?(18, 19, 20)
          emit(:tFLOAT, Float(digits), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 427 then
# line 635 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tFLOAT,     Float(chars), @ts, @te - 2); p -= 2 } 		end
# line 2181 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@ts, @num_suffix_s)

        if version?(18, 19, 20)
          emit(:tFLOAT, Float(digits), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 428 then
# line 639 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tRATIONAL,  Rational(chars)) } 		end
# line 2181 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@ts, @num_suffix_s)

        if version?(18, 19, 20)
          emit(:tFLOAT, Float(digits), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 430 then
# line 640 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tIMAGINARY, Complex(0, Rational(chars))) } 		end
# line 2181 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@ts, @num_suffix_s)

        if version?(18, 19, 20)
          emit(:tFLOAT, Float(digits), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 429 then
# line 641 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tFLOAT,     Float(chars), @ts, @te - 6); p -= 6 } 		end
# line 2181 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@ts, @num_suffix_s)

        if version?(18, 19, 20)
          emit(:tFLOAT, Float(digits), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 125 then
# line 656 "lib/parser/lexer.rl"
		begin

    @escape = ""

    codepoints  = tok(@escape_s + 2, p - 1)
    codepoint_s = @escape_s + 2

    if @version < 24
      if codepoints.start_with?(" ") || codepoints.start_with?("\t")
        diagnostic :fatal, :invalid_unicode_escape, nil,
          range(@escape_s + 2, @escape_s + 3)
      end

      if spaces_p = codepoints.index(/[ \t]{2}/)
        diagnostic :fatal, :invalid_unicode_escape, nil,
          range(codepoint_s + spaces_p + 1, codepoint_s + spaces_p + 2)
      end

      if codepoints.end_with?(" ") || codepoints.end_with?("\t")
        diagnostic :fatal, :invalid_unicode_escape, nil, range(p - 1, p)
      end
    end

    codepoints.scan(/([0-9a-fA-F]+)|([ \t]+)/).each do |(codepoint_str, spaces)|
      if spaces
        codepoint_s += spaces.length
      else
        codepoint = codepoint_str.to_i(16)

        if codepoint >= 0x110000
          diagnostic :error, :unicode_point_too_large, nil,
                     range(codepoint_s, codepoint_s + codepoint_str.length)
          break
        end

        @escape     += codepoint.chr(Encoding::UTF_8)
        codepoint_s += codepoint_str.length
      end
    end
  		end
# line 872 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.heredoc? && escaped_char == "\n".freeze
        if current_literal.squiggly_heredoc?
          # Squiggly heredocs like
          #   <<~-HERE
          #     1\
          #     2
          #   HERE
          # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
          # This information is emitted as is, without escaping,
          # later this escape sequence (\\n) gets handled manually in the Lexer::Dedenter
          current_literal.extend_string(tok, @ts, @te)
        else
          # Plain heredocs also parse \\n as a line continuation,
          # but they don't need to know that there was originally a newline in the
          # code, so we escape it and emit as "  1  2\n"
          current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
        end
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 152 then
# line 656 "lib/parser/lexer.rl"
		begin

    @escape = ""

    codepoints  = tok(@escape_s + 2, p - 1)
    codepoint_s = @escape_s + 2

    if @version < 24
      if codepoints.start_with?(" ") || codepoints.start_with?("\t")
        diagnostic :fatal, :invalid_unicode_escape, nil,
          range(@escape_s + 2, @escape_s + 3)
      end

      if spaces_p = codepoints.index(/[ \t]{2}/)
        diagnostic :fatal, :invalid_unicode_escape, nil,
          range(codepoint_s + spaces_p + 1, codepoint_s + spaces_p + 2)
      end

      if codepoints.end_with?(" ") || codepoints.end_with?("\t")
        diagnostic :fatal, :invalid_unicode_escape, nil, range(p - 1, p)
      end
    end

    codepoints.scan(/([0-9a-fA-F]+)|([ \t]+)/).each do |(codepoint_str, spaces)|
      if spaces
        codepoint_s += spaces.length
      else
        codepoint = codepoint_str.to_i(16)

        if codepoint >= 0x110000
          diagnostic :error, :unicode_point_too_large, nil,
                     range(codepoint_s, codepoint_s + codepoint_str.length)
          break
        end

        @escape     += codepoint.chr(Encoding::UTF_8)
        codepoint_s += codepoint_str.length
      end
    end
  		end
# line 872 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.heredoc? && escaped_char == "\n".freeze
        if current_literal.squiggly_heredoc?
          # Squiggly heredocs like
          #   <<~-HERE
          #     1\
          #     2
          #   HERE
          # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
          # This information is emitted as is, without escaping,
          # later this escape sequence (\\n) gets handled manually in the Lexer::Dedenter
          current_literal.extend_string(tok, @ts, @te)
        else
          # Plain heredocs also parse \\n as a line continuation,
          # but they don't need to know that there was originally a newline in the
          # code, so we escape it and emit as "  1  2\n"
          current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
        end
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 353 then
# line 656 "lib/parser/lexer.rl"
		begin

    @escape = ""

    codepoints  = tok(@escape_s + 2, p - 1)
    codepoint_s = @escape_s + 2

    if @version < 24
      if codepoints.start_with?(" ") || codepoints.start_with?("\t")
        diagnostic :fatal, :invalid_unicode_escape, nil,
          range(@escape_s + 2, @escape_s + 3)
      end

      if spaces_p = codepoints.index(/[ \t]{2}/)
        diagnostic :fatal, :invalid_unicode_escape, nil,
          range(codepoint_s + spaces_p + 1, codepoint_s + spaces_p + 2)
      end

      if codepoints.end_with?(" ") || codepoints.end_with?("\t")
        diagnostic :fatal, :invalid_unicode_escape, nil, range(p - 1, p)
      end
    end

    codepoints.scan(/([0-9a-fA-F]+)|([ \t]+)/).each do |(codepoint_str, spaces)|
      if spaces
        codepoint_s += spaces.length
      else
        codepoint = codepoint_str.to_i(16)

        if codepoint >= 0x110000
          diagnostic :error, :unicode_point_too_large, nil,
                     range(codepoint_s, codepoint_s + codepoint_str.length)
          break
        end

        @escape     += codepoint.chr(Encoding::UTF_8)
        codepoint_s += codepoint_str.length
      end
    end
  		end
# line 1812 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 767; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 109 then
# line 696 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]
    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 872 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.heredoc? && escaped_char == "\n".freeze
        if current_literal.squiggly_heredoc?
          # Squiggly heredocs like
          #   <<~-HERE
          #     1\
          #     2
          #   HERE
          # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
          # This information is emitted as is, without escaping,
          # later this escape sequence (\\n) gets handled manually in the Lexer::Dedenter
          current_literal.extend_string(tok, @ts, @te)
        else
          # Plain heredocs also parse \\n as a line continuation,
          # but they don't need to know that there was originally a newline in the
          # code, so we escape it and emit as "  1  2\n"
          current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
        end
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 136 then
# line 696 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]
    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 872 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.heredoc? && escaped_char == "\n".freeze
        if current_literal.squiggly_heredoc?
          # Squiggly heredocs like
          #   <<~-HERE
          #     1\
          #     2
          #   HERE
          # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
          # This information is emitted as is, without escaping,
          # later this escape sequence (\\n) gets handled manually in the Lexer::Dedenter
          current_literal.extend_string(tok, @ts, @te)
        else
          # Plain heredocs also parse \\n as a line continuation,
          # but they don't need to know that there was originally a newline in the
          # code, so we escape it and emit as "  1  2\n"
          current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
        end
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 337 then
# line 696 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]
    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 1812 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 767; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 112 then
# line 703 "lib/parser/lexer.rl"
		begin

    diagnostic :fatal, :invalid_escape
  		end
# line 872 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.heredoc? && escaped_char == "\n".freeze
        if current_literal.squiggly_heredoc?
          # Squiggly heredocs like
          #   <<~-HERE
          #     1\
          #     2
          #   HERE
          # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
          # This information is emitted as is, without escaping,
          # later this escape sequence (\\n) gets handled manually in the Lexer::Dedenter
          current_literal.extend_string(tok, @ts, @te)
        else
          # Plain heredocs also parse \\n as a line continuation,
          # but they don't need to know that there was originally a newline in the
          # code, so we escape it and emit as "  1  2\n"
          current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
        end
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 139 then
# line 703 "lib/parser/lexer.rl"
		begin

    diagnostic :fatal, :invalid_escape
  		end
# line 872 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.heredoc? && escaped_char == "\n".freeze
        if current_literal.squiggly_heredoc?
          # Squiggly heredocs like
          #   <<~-HERE
          #     1\
          #     2
          #   HERE
          # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
          # This information is emitted as is, without escaping,
          # later this escape sequence (\\n) gets handled manually in the Lexer::Dedenter
          current_literal.extend_string(tok, @ts, @te)
        else
          # Plain heredocs also parse \\n as a line continuation,
          # but they don't need to know that there was originally a newline in the
          # code, so we escape it and emit as "  1  2\n"
          current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
        end
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 340 then
# line 703 "lib/parser/lexer.rl"
		begin

    diagnostic :fatal, :invalid_escape
  		end
# line 1812 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 767; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 114 then
# line 722 "lib/parser/lexer.rl"
		begin
 @escape = "\x7f" 		end
# line 872 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.heredoc? && escaped_char == "\n".freeze
        if current_literal.squiggly_heredoc?
          # Squiggly heredocs like
          #   <<~-HERE
          #     1\
          #     2
          #   HERE
          # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
          # This information is emitted as is, without escaping,
          # later this escape sequence (\\n) gets handled manually in the Lexer::Dedenter
          current_literal.extend_string(tok, @ts, @te)
        else
          # Plain heredocs also parse \\n as a line continuation,
          # but they don't need to know that there was originally a newline in the
          # code, so we escape it and emit as "  1  2\n"
          current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
        end
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 141 then
# line 722 "lib/parser/lexer.rl"
		begin
 @escape = "\x7f" 		end
# line 872 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.heredoc? && escaped_char == "\n".freeze
        if current_literal.squiggly_heredoc?
          # Squiggly heredocs like
          #   <<~-HERE
          #     1\
          #     2
          #   HERE
          # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
          # This information is emitted as is, without escaping,
          # later this escape sequence (\\n) gets handled manually in the Lexer::Dedenter
          current_literal.extend_string(tok, @ts, @te)
        else
          # Plain heredocs also parse \\n as a line continuation,
          # but they don't need to know that there was originally a newline in the
          # code, so we escape it and emit as "  1  2\n"
          current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
        end
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 342 then
# line 722 "lib/parser/lexer.rl"
		begin
 @escape = "\x7f" 		end
# line 1812 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 767; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 111 then
# line 729 "lib/parser/lexer.rl"
		begin
 @escape = encode_escape(tok(@escape_s, p).to_i(8) % 0x100) 		end
# line 872 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.heredoc? && escaped_char == "\n".freeze
        if current_literal.squiggly_heredoc?
          # Squiggly heredocs like
          #   <<~-HERE
          #     1\
          #     2
          #   HERE
          # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
          # This information is emitted as is, without escaping,
          # later this escape sequence (\\n) gets handled manually in the Lexer::Dedenter
          current_literal.extend_string(tok, @ts, @te)
        else
          # Plain heredocs also parse \\n as a line continuation,
          # but they don't need to know that there was originally a newline in the
          # code, so we escape it and emit as "  1  2\n"
          current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
        end
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 138 then
# line 729 "lib/parser/lexer.rl"
		begin
 @escape = encode_escape(tok(@escape_s, p).to_i(8) % 0x100) 		end
# line 872 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.heredoc? && escaped_char == "\n".freeze
        if current_literal.squiggly_heredoc?
          # Squiggly heredocs like
          #   <<~-HERE
          #     1\
          #     2
          #   HERE
          # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
          # This information is emitted as is, without escaping,
          # later this escape sequence (\\n) gets handled manually in the Lexer::Dedenter
          current_literal.extend_string(tok, @ts, @te)
        else
          # Plain heredocs also parse \\n as a line continuation,
          # but they don't need to know that there was originally a newline in the
          # code, so we escape it and emit as "  1  2\n"
          current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
        end
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 339 then
# line 729 "lib/parser/lexer.rl"
		begin
 @escape = encode_escape(tok(@escape_s, p).to_i(8) % 0x100) 		end
# line 1812 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 767; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 128 then
# line 733 "lib/parser/lexer.rl"
		begin
 @escape = encode_escape(tok(@escape_s + 1, p).to_i(16)) 		end
# line 872 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.heredoc? && escaped_char == "\n".freeze
        if current_literal.squiggly_heredoc?
          # Squiggly heredocs like
          #   <<~-HERE
          #     1\
          #     2
          #   HERE
          # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
          # This information is emitted as is, without escaping,
          # later this escape sequence (\\n) gets handled manually in the Lexer::Dedenter
          current_literal.extend_string(tok, @ts, @te)
        else
          # Plain heredocs also parse \\n as a line continuation,
          # but they don't need to know that there was originally a newline in the
          # code, so we escape it and emit as "  1  2\n"
          current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
        end
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 155 then
# line 733 "lib/parser/lexer.rl"
		begin
 @escape = encode_escape(tok(@escape_s + 1, p).to_i(16)) 		end
# line 872 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.heredoc? && escaped_char == "\n".freeze
        if current_literal.squiggly_heredoc?
          # Squiggly heredocs like
          #   <<~-HERE
          #     1\
          #     2
          #   HERE
          # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
          # This information is emitted as is, without escaping,
          # later this escape sequence (\\n) gets handled manually in the Lexer::Dedenter
          current_literal.extend_string(tok, @ts, @te)
        else
          # Plain heredocs also parse \\n as a line continuation,
          # but they don't need to know that there was originally a newline in the
          # code, so we escape it and emit as "  1  2\n"
          current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
        end
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 356 then
# line 733 "lib/parser/lexer.rl"
		begin
 @escape = encode_escape(tok(@escape_s + 1, p).to_i(16)) 		end
# line 1812 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 767; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 127 then
# line 737 "lib/parser/lexer.rl"
		begin

        diagnostic :fatal, :invalid_hex_escape, nil, range(@escape_s - 1, p + 2)
      		end
# line 872 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.heredoc? && escaped_char == "\n".freeze
        if current_literal.squiggly_heredoc?
          # Squiggly heredocs like
          #   <<~-HERE
          #     1\
          #     2
          #   HERE
          # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
          # This information is emitted as is, without escaping,
          # later this escape sequence (\\n) gets handled manually in the Lexer::Dedenter
          current_literal.extend_string(tok, @ts, @te)
        else
          # Plain heredocs also parse \\n as a line continuation,
          # but they don't need to know that there was originally a newline in the
          # code, so we escape it and emit as "  1  2\n"
          current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
        end
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 154 then
# line 737 "lib/parser/lexer.rl"
		begin

        diagnostic :fatal, :invalid_hex_escape, nil, range(@escape_s - 1, p + 2)
      		end
# line 872 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.heredoc? && escaped_char == "\n".freeze
        if current_literal.squiggly_heredoc?
          # Squiggly heredocs like
          #   <<~-HERE
          #     1\
          #     2
          #   HERE
          # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
          # This information is emitted as is, without escaping,
          # later this escape sequence (\\n) gets handled manually in the Lexer::Dedenter
          current_literal.extend_string(tok, @ts, @te)
        else
          # Plain heredocs also parse \\n as a line continuation,
          # but they don't need to know that there was originally a newline in the
          # code, so we escape it and emit as "  1  2\n"
          current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
        end
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 355 then
# line 737 "lib/parser/lexer.rl"
		begin

        diagnostic :fatal, :invalid_hex_escape, nil, range(@escape_s - 1, p + 2)
      		end
# line 1812 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 767; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 122 then
# line 743 "lib/parser/lexer.rl"
		begin
 @escape = tok(@escape_s + 1, p).to_i(16).chr(Encoding::UTF_8) 		end
# line 872 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.heredoc? && escaped_char == "\n".freeze
        if current_literal.squiggly_heredoc?
          # Squiggly heredocs like
          #   <<~-HERE
          #     1\
          #     2
          #   HERE
          # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
          # This information is emitted as is, without escaping,
          # later this escape sequence (\\n) gets handled manually in the Lexer::Dedenter
          current_literal.extend_string(tok, @ts, @te)
        else
          # Plain heredocs also parse \\n as a line continuation,
          # but they don't need to know that there was originally a newline in the
          # code, so we escape it and emit as "  1  2\n"
          current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
        end
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 149 then
# line 743 "lib/parser/lexer.rl"
		begin
 @escape = tok(@escape_s + 1, p).to_i(16).chr(Encoding::UTF_8) 		end
# line 872 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.heredoc? && escaped_char == "\n".freeze
        if current_literal.squiggly_heredoc?
          # Squiggly heredocs like
          #   <<~-HERE
          #     1\
          #     2
          #   HERE
          # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
          # This information is emitted as is, without escaping,
          # later this escape sequence (\\n) gets handled manually in the Lexer::Dedenter
          current_literal.extend_string(tok, @ts, @te)
        else
          # Plain heredocs also parse \\n as a line continuation,
          # but they don't need to know that there was originally a newline in the
          # code, so we escape it and emit as "  1  2\n"
          current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
        end
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 350 then
# line 743 "lib/parser/lexer.rl"
		begin
 @escape = tok(@escape_s + 1, p).to_i(16).chr(Encoding::UTF_8) 		end
# line 1812 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 767; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 121 then
# line 747 "lib/parser/lexer.rl"
		begin

        diagnostic :fatal, :invalid_unicode_escape, nil, range(@escape_s - 1, p)
      		end
# line 872 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.heredoc? && escaped_char == "\n".freeze
        if current_literal.squiggly_heredoc?
          # Squiggly heredocs like
          #   <<~-HERE
          #     1\
          #     2
          #   HERE
          # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
          # This information is emitted as is, without escaping,
          # later this escape sequence (\\n) gets handled manually in the Lexer::Dedenter
          current_literal.extend_string(tok, @ts, @te)
        else
          # Plain heredocs also parse \\n as a line continuation,
          # but they don't need to know that there was originally a newline in the
          # code, so we escape it and emit as "  1  2\n"
          current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
        end
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 148 then
# line 747 "lib/parser/lexer.rl"
		begin

        diagnostic :fatal, :invalid_unicode_escape, nil, range(@escape_s - 1, p)
      		end
# line 872 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.heredoc? && escaped_char == "\n".freeze
        if current_literal.squiggly_heredoc?
          # Squiggly heredocs like
          #   <<~-HERE
          #     1\
          #     2
          #   HERE
          # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
          # This information is emitted as is, without escaping,
          # later this escape sequence (\\n) gets handled manually in the Lexer::Dedenter
          current_literal.extend_string(tok, @ts, @te)
        else
          # Plain heredocs also parse \\n as a line continuation,
          # but they don't need to know that there was originally a newline in the
          # code, so we escape it and emit as "  1  2\n"
          current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
        end
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 349 then
# line 747 "lib/parser/lexer.rl"
		begin

        diagnostic :fatal, :invalid_unicode_escape, nil, range(@escape_s - 1, p)
      		end
# line 1812 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 767; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 126 then
# line 753 "lib/parser/lexer.rl"
		begin

        diagnostic :fatal, :invalid_unicode_escape, nil, range(@escape_s - 1, p)
      		end
# line 872 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.heredoc? && escaped_char == "\n".freeze
        if current_literal.squiggly_heredoc?
          # Squiggly heredocs like
          #   <<~-HERE
          #     1\
          #     2
          #   HERE
          # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
          # This information is emitted as is, without escaping,
          # later this escape sequence (\\n) gets handled manually in the Lexer::Dedenter
          current_literal.extend_string(tok, @ts, @te)
        else
          # Plain heredocs also parse \\n as a line continuation,
          # but they don't need to know that there was originally a newline in the
          # code, so we escape it and emit as "  1  2\n"
          current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
        end
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 153 then
# line 753 "lib/parser/lexer.rl"
		begin

        diagnostic :fatal, :invalid_unicode_escape, nil, range(@escape_s - 1, p)
      		end
# line 872 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.heredoc? && escaped_char == "\n".freeze
        if current_literal.squiggly_heredoc?
          # Squiggly heredocs like
          #   <<~-HERE
          #     1\
          #     2
          #   HERE
          # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
          # This information is emitted as is, without escaping,
          # later this escape sequence (\\n) gets handled manually in the Lexer::Dedenter
          current_literal.extend_string(tok, @ts, @te)
        else
          # Plain heredocs also parse \\n as a line continuation,
          # but they don't need to know that there was originally a newline in the
          # code, so we escape it and emit as "  1  2\n"
          current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
        end
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 354 then
# line 753 "lib/parser/lexer.rl"
		begin

        diagnostic :fatal, :invalid_unicode_escape, nil, range(@escape_s - 1, p)
      		end
# line 1812 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 767; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 123 then
# line 767 "lib/parser/lexer.rl"
		begin

          diagnostic :fatal, :unterminated_unicode, nil, range(p - 1, p)
        		end
# line 872 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.heredoc? && escaped_char == "\n".freeze
        if current_literal.squiggly_heredoc?
          # Squiggly heredocs like
          #   <<~-HERE
          #     1\
          #     2
          #   HERE
          # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
          # This information is emitted as is, without escaping,
          # later this escape sequence (\\n) gets handled manually in the Lexer::Dedenter
          current_literal.extend_string(tok, @ts, @te)
        else
          # Plain heredocs also parse \\n as a line continuation,
          # but they don't need to know that there was originally a newline in the
          # code, so we escape it and emit as "  1  2\n"
          current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
        end
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 150 then
# line 767 "lib/parser/lexer.rl"
		begin

          diagnostic :fatal, :unterminated_unicode, nil, range(p - 1, p)
        		end
# line 872 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.heredoc? && escaped_char == "\n".freeze
        if current_literal.squiggly_heredoc?
          # Squiggly heredocs like
          #   <<~-HERE
          #     1\
          #     2
          #   HERE
          # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
          # This information is emitted as is, without escaping,
          # later this escape sequence (\\n) gets handled manually in the Lexer::Dedenter
          current_literal.extend_string(tok, @ts, @te)
        else
          # Plain heredocs also parse \\n as a line continuation,
          # but they don't need to know that there was originally a newline in the
          # code, so we escape it and emit as "  1  2\n"
          current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
        end
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 351 then
# line 767 "lib/parser/lexer.rl"
		begin

          diagnostic :fatal, :unterminated_unicode, nil, range(p - 1, p)
        		end
# line 1812 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 767; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 110 then
# line 793 "lib/parser/lexer.rl"
		begin

      diagnostic :fatal, :escape_eof, nil, range(p - 1, p)
    		end
# line 872 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.heredoc? && escaped_char == "\n".freeze
        if current_literal.squiggly_heredoc?
          # Squiggly heredocs like
          #   <<~-HERE
          #     1\
          #     2
          #   HERE
          # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
          # This information is emitted as is, without escaping,
          # later this escape sequence (\\n) gets handled manually in the Lexer::Dedenter
          current_literal.extend_string(tok, @ts, @te)
        else
          # Plain heredocs also parse \\n as a line continuation,
          # but they don't need to know that there was originally a newline in the
          # code, so we escape it and emit as "  1  2\n"
          current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
        end
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 137 then
# line 793 "lib/parser/lexer.rl"
		begin

      diagnostic :fatal, :escape_eof, nil, range(p - 1, p)
    		end
# line 872 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.heredoc? && escaped_char == "\n".freeze
        if current_literal.squiggly_heredoc?
          # Squiggly heredocs like
          #   <<~-HERE
          #     1\
          #     2
          #   HERE
          # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
          # This information is emitted as is, without escaping,
          # later this escape sequence (\\n) gets handled manually in the Lexer::Dedenter
          current_literal.extend_string(tok, @ts, @te)
        else
          # Plain heredocs also parse \\n as a line continuation,
          # but they don't need to know that there was originally a newline in the
          # code, so we escape it and emit as "  1  2\n"
          current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
        end
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 338 then
# line 793 "lib/parser/lexer.rl"
		begin

      diagnostic :fatal, :escape_eof, nil, range(p - 1, p)
    		end
# line 1812 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 767; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 161 then
# line 799 "lib/parser/lexer.rl"
		begin

    @escape_s = p
    @escape   = nil
  		end
# line 872 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.heredoc? && escaped_char == "\n".freeze
        if current_literal.squiggly_heredoc?
          # Squiggly heredocs like
          #   <<~-HERE
          #     1\
          #     2
          #   HERE
          # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
          # This information is emitted as is, without escaping,
          # later this escape sequence (\\n) gets handled manually in the Lexer::Dedenter
          current_literal.extend_string(tok, @ts, @te)
        else
          # Plain heredocs also parse \\n as a line continuation,
          # but they don't need to know that there was originally a newline in the
          # code, so we escape it and emit as "  1  2\n"
          current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
        end
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 166 then
# line 799 "lib/parser/lexer.rl"
		begin

    @escape_s = p
    @escape   = nil
  		end
# line 872 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.heredoc? && escaped_char == "\n".freeze
        if current_literal.squiggly_heredoc?
          # Squiggly heredocs like
          #   <<~-HERE
          #     1\
          #     2
          #   HERE
          # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
          # This information is emitted as is, without escaping,
          # later this escape sequence (\\n) gets handled manually in the Lexer::Dedenter
          current_literal.extend_string(tok, @ts, @te)
        else
          # Plain heredocs also parse \\n as a line continuation,
          # but they don't need to know that there was originally a newline in the
          # code, so we escape it and emit as "  1  2\n"
          current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
        end
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 57 then
# line 839 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 491 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
	when 30 then
# line 839 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1496 "lib/parser/lexer.rl"
		begin
 tm = p 		end
	when 32 then
# line 839 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1512 "lib/parser/lexer.rl"
		begin
 tm = p 		end
	when 34 then
# line 839 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1540 "lib/parser/lexer.rl"
		begin
 tm = p 		end
	when 201 then
# line 839 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1371 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 220 then
# line 839 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1389 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 228 then
# line 839 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1421 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 33 then
# line 839 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1552 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        p = @ts - 1
        	begin
		 @cs = 767
		_goto_level = _again
		next
	end

       end
		end
	when 259 then
# line 839 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1557 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 251 then
# line 839 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1563 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 767
		_goto_level = _again
		next
	end
  end
		end
	when 270 then
# line 839 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1639 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 282 then
# line 839 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1660 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 278 then
# line 839 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1663 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 767
		_goto_level = _again
		next
	end
  end
		end
	when 58 then
# line 839 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1681 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit(:tUNARY_NUM, tok(@ts, @ts + 1), @ts, @ts + 1)
        p = p - 1;  @cs = 767; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 49 then
# line 839 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1936 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit(:tIDENTIFIER, ident_tok, ident_ts, ident_te)
        p = ident_te - 1

        if !@static_env.nil? && @static_env.declared?(ident_tok) && @version < 25
           @cs = 438;
        else
           @cs = 497;
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 300 then
# line 839 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1952 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 372 then
# line 839 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1979 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 368 then
# line 839 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1982 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
      if @in_kwarg
        p = p - 1; 	begin
		 @cs = 767
		_goto_level = _again
		next
	end

      else
        	begin
		 @cs = 181
		_goto_level = _again
		next
	end

      end
     end
		end
	when 381 then
# line 839 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 2010 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 378 then
# line 839 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 2013 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  	begin
		 @cs = 181
		_goto_level = _again
		next
	end
  end
		end
	when 465 then
# line 839 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 2311 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 398 then
# line 839 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 2314 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  	begin
		 @cs = 945
		_goto_level = _again
		next
	end
  end
		end
	when 93 then
# line 839 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 2366 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 250 then
# line 1027 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    current_literal = literal
    if current_literal
      current_literal.start_interp_brace
    end
  		end
# line 1465 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if @lambda_stack.last == @paren_nest
          @lambda_stack.pop
          emit(:tLAMBEG, '{'.freeze, @te - 1, @te)
        else
          emit(:tLCURLY, '{'.freeze, @te - 1, @te)
        end
         @cs = 759; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 272 then
# line 1027 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    current_literal = literal
    if current_literal
      current_literal.start_interp_brace
    end
  		end
# line 1625 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if @lambda_stack.last == @paren_nest
          @lambda_stack.pop
          emit(:tLAMBEG, '{'.freeze)
        else
          emit(:tLBRACE_ARG, '{'.freeze)
        end
         @cs = 759; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 364 then
# line 1027 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    current_literal = literal
    if current_literal
      current_literal.start_interp_brace
    end
  		end
# line 1852 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if @lambda_stack.last == @paren_nest
          @lambda_stack.pop
          emit(:tLAMBEG, '{'.freeze)
        else
          emit(:tLBRACE, '{'.freeze)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 477 then
# line 1027 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    current_literal = literal
    if current_literal
      current_literal.start_interp_brace
    end
  		end
# line 2035 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if @lambda_stack.last == @paren_nest
          @lambda_stack.pop

          if tok == '{'.freeze
            emit(:tLAMBEG, '{'.freeze)
          else # 'do'
            emit(:kDO_LAMBDA, 'do'.freeze)
          end
        else
          if tok == '{'.freeze
            emit(:tLCURLY, '{'.freeze)
          else # 'do'
            emit_do
          end
        end

         @cs = 759; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 478 then
# line 1036 "lib/parser/lexer.rl"
		begin

    current_literal = literal
    if current_literal
      if current_literal.end_interp_brace_and_try_closing
        if version?(18, 19)
          emit(:tRCURLY, '}'.freeze, p - 1, p)
          if @version < 24
            @cond.lexpop
            @cmdarg.lexpop
          else
            @cond.pop
            @cmdarg.pop
          end
        else
          emit(:tSTRING_DEND, '}'.freeze, p - 1, p)
        end

        if current_literal.saved_herebody_s
          @herebody_s = current_literal.saved_herebody_s
        end


        p = p - 1;
         @cs = (next_state_for_literal(current_literal));
        	begin
		p += 1
		_goto_level = _out
		next
	end

      end
    end
  		end
# line 2267 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit_table(PUNCTUATION)

        if @version < 24
          @cond.lexpop
          @cmdarg.lexpop
        else
          @cond.pop
          @cmdarg.pop
        end

        if tok == '}'.freeze || tok == ']'.freeze
          if @version >= 25
             @cs = 767;
          else
             @cs = 503;
          end
        else # )
          # fnext expr_endfn; ?
        end

        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 60 then
# line 1183 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1186 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
	when 64 then
# line 1186 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 491 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
	when 204 then
# line 1186 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1371 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 219 then
# line 1186 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1389 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 231 then
# line 1186 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1421 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 253 then
# line 1186 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1560 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  	begin
		 @cs = 767
		_goto_level = _again
		next
	end
  end
		end
	when 268 then
# line 1186 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1639 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 280 then
# line 1186 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1660 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 306 then
# line 1186 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1952 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 370 then
# line 1186 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1979 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 380 then
# line 1186 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 2010 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 402 then
# line 1186 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 2311 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 95 then
# line 1186 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 2366 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 225 then
# line 1227 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 1411 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tFID, tok(@ts, tm), @ts, tm)
            @cs = (arg_or_cmdarg); p = tm - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 318 then
# line 1227 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 1790 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tSYMBOL, tok(@ts + 1, tm), @ts, tm)
        p = tm - 1
         @cs = 767; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 291 then
# line 1227 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 1925 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1
           	begin
		 @cs = 767
		_goto_level = _again
		next
	end
  end
		end
	when 395 then
# line 1227 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 1 "NONE"
		begin
	case  @act
	when 135 then
	begin begin p = (( @te))-1; end

        if @lambda_stack.last == @paren_nest
          @lambda_stack.pop

          if tok == '{'.freeze
            emit(:tLAMBEG, '{'.freeze)
          else # 'do'
            emit(:kDO_LAMBDA, 'do'.freeze)
          end
        else
          if tok == '{'.freeze
            emit(:tLCURLY, '{'.freeze)
          else # 'do'
            emit_do
          end
        end

         @cs = 759; 	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 136 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
            @cs = 325; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 137 then
	begin begin p = (( @te))-1; end
 emit(:kCLASS, 'class'.freeze, @ts, @ts + 5)
           emit(:tLSHFT, '<<'.freeze,    @te - 2, @te)
            @cs = 759; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 138 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
            @cs = 535; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 139 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
            @cs = 759; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 140 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
            @cs = 511; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 141 then
	begin begin p = (( @te))-1; end

        emit_table(KEYWORDS)

        if version?(18) && tok == 'not'.freeze
           @cs = 535; 	begin
		p += 1
		_goto_level = _out
		next
	end

        else
           @cs = 466; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
      end
	when 142 then
	begin begin p = (( @te))-1; end

        if version?(18)
          emit(:tIDENTIFIER)

          unless !@static_env.nil? && @static_env.declared?(tok)
             @cs = (arg_or_cmdarg);
          end
        else
          emit(:k__ENCODING__, '__ENCODING__'.freeze)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 143 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
           	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 144 then
	begin begin p = (( @te))-1; end

        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 146 then
	begin begin p = (( @te))-1; end

        if version?(18, 19, 20)
          diagnostic :error,
                     :trailing_in_number, { :character => tok(@te - 1, @te) },
                     range(@te - 1, @te)
        else
          emit(:tINTEGER, tok(@ts, @te - 1).to_i, @ts, @te - 1)
          p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
      end
	when 147 then
	begin begin p = (( @te))-1; end

        if version?(18, 19, 20)
          diagnostic :error,
                     :trailing_in_number, { :character => tok(@te - 1, @te) },
                     range(@te - 1, @te)
        else
          emit(:tFLOAT, tok(@ts, @te - 1).to_f, @ts, @te - 1)
          p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
      end
	when 148 then
	begin begin p = (( @te))-1; end

        digits = tok(@ts, @num_suffix_s)

        if version?(18, 19, 20)
          emit(:tFLOAT, Float(digits), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 150 then
	begin begin p = (( @te))-1; end
 emit(:tCONSTANT)
            @cs = (arg_or_cmdarg); 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 154 then
	begin begin p = (( @te))-1; end

    emit(:tIDENTIFIER)

    if !@static_env.nil? && @static_env.declared?(tok)
       @cs = 438; 	begin
		p += 1
		_goto_level = _out
		next
	end

    else
       @cs = (arg_or_cmdarg); 	begin
		p += 1
		_goto_level = _out
		next
	end

    end
  end
	when 155 then
	begin begin p = (( @te))-1; end

        if tm == @te
          # Suffix was consumed, e.g. foo!
          emit(:tFID)
        else
          # Suffix was not consumed, e.g. foo!=
          emit(:tIDENTIFIER, tok(@ts, tm), @ts, tm)
          p = tm - 1
        end
         @cs = 466; 	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 157 then
	begin begin p = (( @te))-1; end

        emit_table(PUNCTUATION);
         @cs = 759; 	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 158 then
	begin begin p = (( @te))-1; end
 emit_table(PUNCTUATION)
            @cs = 535; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
end 
			end
	when 226 then
# line 1228 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 1411 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tFID, tok(@ts, tm), @ts, tm)
            @cs = (arg_or_cmdarg); p = tm - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 319 then
# line 1228 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 1790 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tSYMBOL, tok(@ts + 1, tm), @ts, tm)
        p = tm - 1
         @cs = 767; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 293 then
# line 1228 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 1925 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1
           	begin
		 @cs = 767
		_goto_level = _again
		next
	end
  end
		end
	when 396 then
# line 1228 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 2231 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if tm == @te
          # Suffix was consumed, e.g. foo!
          emit(:tFID)
        else
          # Suffix was not consumed, e.g. foo!=
          emit(:tIDENTIFIER, tok(@ts, tm), @ts, tm)
          p = tm - 1
        end
         @cs = 466; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 320 then
# line 1233 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 1790 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tSYMBOL, tok(@ts + 1, tm), @ts, tm)
        p = tm - 1
         @cs = 767; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 294 then
# line 1233 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 1925 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1
           	begin
		 @cs = 767
		_goto_level = _again
		next
	end
  end
		end
	when 321 then
# line 1234 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 1790 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tSYMBOL, tok(@ts + 1, tm), @ts, tm)
        p = tm - 1
         @cs = 767; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 295 then
# line 1234 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 1925 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1
           	begin
		 @cs = 767
		_goto_level = _again
		next
	end
  end
		end
	when 325 then
# line 1235 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 1790 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tSYMBOL, tok(@ts + 1, tm), @ts, tm)
        p = tm - 1
         @cs = 767; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 298 then
# line 1235 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 1925 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1
           	begin
		 @cs = 767
		_goto_level = _again
		next
	end
  end
		end
	when 324 then
# line 1236 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 1790 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tSYMBOL, tok(@ts + 1, tm), @ts, tm)
        p = tm - 1
         @cs = 767; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 297 then
# line 1236 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 1 "NONE"
		begin
	case  @act
	when 94 then
	begin begin p = (( @te))-1; end

        emit(:tUNARY_NUM, tok(@ts, @ts + 1), @ts, @ts + 1)
        p = p - 1;  @cs = 767; 	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 113 then
	begin begin p = (( @te))-1; end
 emit_table(PUNCTUATION_BEGIN)
           	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 114 then
	begin begin p = (( @te))-1; end
 emit(:kRESCUE, 'rescue'.freeze, @ts, tm)
           p = tm - 1
            @cs = 511; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 115 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS_BEGIN)
            @cs = 759; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 117 then
	begin begin p = (( @te))-1; end
 p = @ts - 1
           	begin
		 @cs = 767
		_goto_level = _again
		next
	end
 end
	when 118 then
	begin begin p = (( @te))-1; end

    emit(:tIDENTIFIER)

    if !@static_env.nil? && @static_env.declared?(tok)
       @cs = 438; 	begin
		p += 1
		_goto_level = _out
		next
	end

    else
       @cs = (arg_or_cmdarg); 	begin
		p += 1
		_goto_level = _out
		next
	end

    end
  end
	when 122 then
	begin begin p = (( @te))-1; end
 p = @ts - 1; 	begin
		 @cs = 767
		_goto_level = _again
		next
	end
 end
end 
			end
	when 322 then
# line 1237 "lib/parser/lexer.rl"
		begin
 tm = p - 3 		end
# line 1790 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tSYMBOL, tok(@ts + 1, tm), @ts, tm)
        p = tm - 1
         @cs = 767; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 296 then
# line 1237 "lib/parser/lexer.rl"
		begin
 tm = p - 3 		end
# line 1925 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1
           	begin
		 @cs = 767
		_goto_level = _again
		next
	end
  end
		end
	when 323 then
# line 1242 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 1790 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tSYMBOL, tok(@ts + 1, tm), @ts, tm)
        p = tm - 1
         @cs = 767; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 460 then
# line 1247 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 2213 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tCONSTANT, tok(@ts, tm), @ts, tm)
           p = tm - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 249 then
# line 1253 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)
  		end
# line 1459 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tLBRACK, '['.freeze, @te - 1, @te)
            @cs = 535; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 357 then
# line 1253 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)
  		end
# line 1864 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tLBRACK, '['.freeze)
           	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 463 then
# line 1253 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)
  		end
# line 2300 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tLBRACK2, '['.freeze)
            @cs = 535; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 241 then
# line 1260 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    @paren_nest += 1
  		end
# line 1440 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if version?(18)
          emit(:tLPAREN2, '('.freeze, @te - 1, @te)
           @cs = 759; 	begin
		p += 1
		_goto_level = _out
		next
	end

        else
          emit(:tLPAREN_ARG, '('.freeze, @te - 1, @te)
           @cs = 535; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
       end
		end
	when 254 then
# line 1260 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    @paren_nest += 1
  		end
# line 1453 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tLPAREN2, '('.freeze)
            @cs = 535; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 262 then
# line 1260 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    @paren_nest += 1
  		end
# line 1579 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tLPAREN_ARG, '('.freeze, @te - 1, @te)
        if version?(18)
           @cs = 759; 	begin
		p += 1
		_goto_level = _out
		next
	end

        else
           @cs = 535; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
       end
		end
	when 311 then
# line 1260 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    @paren_nest += 1
  		end
# line 1869 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tLPAREN, '('.freeze)
           	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 408 then
# line 1260 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    @paren_nest += 1
  		end
# line 2263 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(PUNCTUATION)
            @cs = 535; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 409 then
# line 1266 "lib/parser/lexer.rl"
		begin

    @paren_nest -= 1
  		end
# line 2267 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit_table(PUNCTUATION)

        if @version < 24
          @cond.lexpop
          @cmdarg.lexpop
        else
          @cond.pop
          @cmdarg.pop
        end

        if tok == '}'.freeze || tok == ']'.freeze
          if @version >= 25
             @cs = 767;
          else
             @cs = 503;
          end
        else # )
          # fnext expr_endfn; ?
        end

        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 70 then
# line 1730 "lib/parser/lexer.rl"
		begin
 heredoc_e      = p 		end
# line 491 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
	when 328 then
# line 1731 "lib/parser/lexer.rl"
		begin
 new_herebody_s = p 		end
# line 1732 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        tok(@ts, heredoc_e) =~ /^<<(-?)(~?)(["'`]?)(.*)\3$/m

        indent      = !$1.empty? || !$2.empty?
        dedent_body = !$2.empty?
        type        =  $3.empty? ? '<<"'.freeze : ('<<'.freeze + $3)
        delimiter   =  $4

        if @version >= 24
          if delimiter.count("\n") > 0
            if delimiter.end_with?("\n")
              diagnostic :warning, :heredoc_id_ends_with_nl, nil, range(@ts, @ts + 1)
              delimiter = delimiter.rstrip
            else
              diagnostic :fatal, :heredoc_id_has_newline, nil, range(@ts, @ts + 1)
            end
          end
        end

        if dedent_body && version?(18, 19, 20, 21, 22)
          emit(:tLSHFT, '<<'.freeze, @ts, @ts + 2)
          p = @ts + 1
           @cs = 535; 	begin
		p += 1
		_goto_level = _out
		next
	end

        else
           @cs = (push_literal(type, delimiter, @ts, heredoc_e, indent, dedent_body));

          @herebody_s ||= new_herebody_s
          p = @herebody_s - 1
        end
       end
		end
	when 333 then
# line 1810 "lib/parser/lexer.rl"
		begin
 @escape = nil 		end
# line 1812 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 767; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 360 then
# line 1879 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 1880 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:kRESCUE, 'rescue'.freeze, @ts, tm)
           p = tm - 1
            @cs = 511; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 450 then
# line 2115 "lib/parser/lexer.rl"
		begin
 @num_base = 16; @num_digits_s = p 		end
# line 2121 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
	when 444 then
# line 2116 "lib/parser/lexer.rl"
		begin
 @num_base = 10; @num_digits_s = p 		end
# line 2121 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
	when 447 then
# line 2117 "lib/parser/lexer.rl"
		begin
 @num_base = 8;  @num_digits_s = p 		end
# line 2121 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
	when 441 then
# line 2118 "lib/parser/lexer.rl"
		begin
 @num_base = 2;  @num_digits_s = p 		end
# line 2121 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
	when 456 then
# line 2119 "lib/parser/lexer.rl"
		begin
 @num_base = 10; @num_digits_s = @ts 		end
# line 2121 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
	when 419 then
# line 2120 "lib/parser/lexer.rl"
		begin
 @num_base = 8;  @num_digits_s = @ts 		end
# line 2121 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
	when 457 then
# line 2121 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 624 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
	when 86 then
# line 2337 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 2338 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = tm - 1; 	begin
		 @cs = 767
		_goto_level = _again
		next
	end
  end
		end
	when 8 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 491 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
	when 423 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2179 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
	when 210 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1330 "lib/parser/lexer.rl"
		begin
 @act = 39;		end
	when 197 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1334 "lib/parser/lexer.rl"
		begin
 @act = 40;		end
	when 193 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1338 "lib/parser/lexer.rl"
		begin
 @act = 41;		end
	when 26 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1500 "lib/parser/lexer.rl"
		begin
 @act = 67;		end
	when 243 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1513 "lib/parser/lexer.rl"
		begin
 @act = 68;		end
	when 27 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1552 "lib/parser/lexer.rl"
		begin
 @act = 73;		end
	when 236 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1557 "lib/parser/lexer.rl"
		begin
 @act = 74;		end
	when 263 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1589 "lib/parser/lexer.rl"
		begin
 @act = 80;		end
	when 45 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1602 "lib/parser/lexer.rl"
		begin
 @act = 81;		end
	when 284 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1654 "lib/parser/lexer.rl"
		begin
 @act = 88;		end
	when 273 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1658 "lib/parser/lexer.rl"
		begin
 @act = 89;		end
	when 287 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1874 "lib/parser/lexer.rl"
		begin
 @act = 113;		end
	when 359 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1880 "lib/parser/lexer.rl"
		begin
 @act = 114;		end
	when 358 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1886 "lib/parser/lexer.rl"
		begin
 @act = 115;		end
	when 72 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1925 "lib/parser/lexer.rl"
		begin
 @act = 117;		end
	when 285 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1271 "lib/parser/lexer.rl"
		begin
 @act = 118;		end
	when 288 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1971 "lib/parser/lexer.rl"
		begin
 @act = 122;		end
	when 473 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2035 "lib/parser/lexer.rl"
		begin
 @act = 135;		end
	when 468 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2060 "lib/parser/lexer.rl"
		begin
 @act = 136;		end
	when 476 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2070 "lib/parser/lexer.rl"
		begin
 @act = 138;		end
	when 469 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2075 "lib/parser/lexer.rl"
		begin
 @act = 139;		end
	when 470 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2079 "lib/parser/lexer.rl"
		begin
 @act = 140;		end
	when 475 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2083 "lib/parser/lexer.rl"
		begin
 @act = 141;		end
	when 467 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2094 "lib/parser/lexer.rl"
		begin
 @act = 142;		end
	when 462 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2108 "lib/parser/lexer.rl"
		begin
 @act = 143;		end
	when 388 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2122 "lib/parser/lexer.rl"
		begin
 @act = 144;		end
	when 421 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2166 "lib/parser/lexer.rl"
		begin
 @act = 147;		end
	when 79 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2181 "lib/parser/lexer.rl"
		begin
 @act = 148;		end
	when 391 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2209 "lib/parser/lexer.rl"
		begin
 @act = 150;		end
	when 382 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1271 "lib/parser/lexer.rl"
		begin
 @act = 154;		end
	when 394 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2231 "lib/parser/lexer.rl"
		begin
 @act = 155;		end
	when 386 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2257 "lib/parser/lexer.rl"
		begin
 @act = 157;		end
	when 393 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2263 "lib/parser/lexer.rl"
		begin
 @act = 158;		end
	when 167 then
# line 491 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 927 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
# line 799 "lib/parser/lexer.rl"
		begin

    @escape_s = p
    @escape   = nil
  		end
	when 115 then
# line 696 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]
    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 707 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 872 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.heredoc? && escaped_char == "\n".freeze
        if current_literal.squiggly_heredoc?
          # Squiggly heredocs like
          #   <<~-HERE
          #     1\
          #     2
          #   HERE
          # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
          # This information is emitted as is, without escaping,
          # later this escape sequence (\\n) gets handled manually in the Lexer::Dedenter
          current_literal.extend_string(tok, @ts, @te)
        else
          # Plain heredocs also parse \\n as a line continuation,
          # but they don't need to know that there was originally a newline in the
          # code, so we escape it and emit as "  1  2\n"
          current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
        end
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 142 then
# line 696 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]
    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 707 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 872 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.heredoc? && escaped_char == "\n".freeze
        if current_literal.squiggly_heredoc?
          # Squiggly heredocs like
          #   <<~-HERE
          #     1\
          #     2
          #   HERE
          # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
          # This information is emitted as is, without escaping,
          # later this escape sequence (\\n) gets handled manually in the Lexer::Dedenter
          current_literal.extend_string(tok, @ts, @te)
        else
          # Plain heredocs also parse \\n as a line continuation,
          # but they don't need to know that there was originally a newline in the
          # code, so we escape it and emit as "  1  2\n"
          current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
        end
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 343 then
# line 696 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]
    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 707 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 1812 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 767; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 120 then
# line 696 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]
    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 711 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 872 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.heredoc? && escaped_char == "\n".freeze
        if current_literal.squiggly_heredoc?
          # Squiggly heredocs like
          #   <<~-HERE
          #     1\
          #     2
          #   HERE
          # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
          # This information is emitted as is, without escaping,
          # later this escape sequence (\\n) gets handled manually in the Lexer::Dedenter
          current_literal.extend_string(tok, @ts, @te)
        else
          # Plain heredocs also parse \\n as a line continuation,
          # but they don't need to know that there was originally a newline in the
          # code, so we escape it and emit as "  1  2\n"
          current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
        end
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 147 then
# line 696 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]
    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 711 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 872 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.heredoc? && escaped_char == "\n".freeze
        if current_literal.squiggly_heredoc?
          # Squiggly heredocs like
          #   <<~-HERE
          #     1\
          #     2
          #   HERE
          # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
          # This information is emitted as is, without escaping,
          # later this escape sequence (\\n) gets handled manually in the Lexer::Dedenter
          current_literal.extend_string(tok, @ts, @te)
        else
          # Plain heredocs also parse \\n as a line continuation,
          # but they don't need to know that there was originally a newline in the
          # code, so we escape it and emit as "  1  2\n"
          current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
        end
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 348 then
# line 696 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]
    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 711 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 1812 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 767; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 119 then
# line 717 "lib/parser/lexer.rl"
		begin
 @escape = @source_buffer.slice(p - 1).chr 		end
# line 711 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 872 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.heredoc? && escaped_char == "\n".freeze
        if current_literal.squiggly_heredoc?
          # Squiggly heredocs like
          #   <<~-HERE
          #     1\
          #     2
          #   HERE
          # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
          # This information is emitted as is, without escaping,
          # later this escape sequence (\\n) gets handled manually in the Lexer::Dedenter
          current_literal.extend_string(tok, @ts, @te)
        else
          # Plain heredocs also parse \\n as a line continuation,
          # but they don't need to know that there was originally a newline in the
          # code, so we escape it and emit as "  1  2\n"
          current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
        end
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 146 then
# line 717 "lib/parser/lexer.rl"
		begin
 @escape = @source_buffer.slice(p - 1).chr 		end
# line 711 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 872 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.heredoc? && escaped_char == "\n".freeze
        if current_literal.squiggly_heredoc?
          # Squiggly heredocs like
          #   <<~-HERE
          #     1\
          #     2
          #   HERE
          # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
          # This information is emitted as is, without escaping,
          # later this escape sequence (\\n) gets handled manually in the Lexer::Dedenter
          current_literal.extend_string(tok, @ts, @te)
        else
          # Plain heredocs also parse \\n as a line continuation,
          # but they don't need to know that there was originally a newline in the
          # code, so we escape it and emit as "  1  2\n"
          current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
        end
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 347 then
# line 717 "lib/parser/lexer.rl"
		begin
 @escape = @source_buffer.slice(p - 1).chr 		end
# line 711 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 1812 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 767; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 117 then
# line 722 "lib/parser/lexer.rl"
		begin
 @escape = "\x7f" 		end
# line 711 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 872 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.heredoc? && escaped_char == "\n".freeze
        if current_literal.squiggly_heredoc?
          # Squiggly heredocs like
          #   <<~-HERE
          #     1\
          #     2
          #   HERE
          # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
          # This information is emitted as is, without escaping,
          # later this escape sequence (\\n) gets handled manually in the Lexer::Dedenter
          current_literal.extend_string(tok, @ts, @te)
        else
          # Plain heredocs also parse \\n as a line continuation,
          # but they don't need to know that there was originally a newline in the
          # code, so we escape it and emit as "  1  2\n"
          current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
        end
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 144 then
# line 722 "lib/parser/lexer.rl"
		begin
 @escape = "\x7f" 		end
# line 711 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 872 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.heredoc? && escaped_char == "\n".freeze
        if current_literal.squiggly_heredoc?
          # Squiggly heredocs like
          #   <<~-HERE
          #     1\
          #     2
          #   HERE
          # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
          # This information is emitted as is, without escaping,
          # later this escape sequence (\\n) gets handled manually in the Lexer::Dedenter
          current_literal.extend_string(tok, @ts, @te)
        else
          # Plain heredocs also parse \\n as a line continuation,
          # but they don't need to know that there was originally a newline in the
          # code, so we escape it and emit as "  1  2\n"
          current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
        end
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 345 then
# line 722 "lib/parser/lexer.rl"
		begin
 @escape = "\x7f" 		end
# line 711 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 1812 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 767; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 113 then
# line 723 "lib/parser/lexer.rl"
		begin
 @escape = @source_buffer.slice(p - 1).chr 		end
# line 707 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 872 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.heredoc? && escaped_char == "\n".freeze
        if current_literal.squiggly_heredoc?
          # Squiggly heredocs like
          #   <<~-HERE
          #     1\
          #     2
          #   HERE
          # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
          # This information is emitted as is, without escaping,
          # later this escape sequence (\\n) gets handled manually in the Lexer::Dedenter
          current_literal.extend_string(tok, @ts, @te)
        else
          # Plain heredocs also parse \\n as a line continuation,
          # but they don't need to know that there was originally a newline in the
          # code, so we escape it and emit as "  1  2\n"
          current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
        end
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 140 then
# line 723 "lib/parser/lexer.rl"
		begin
 @escape = @source_buffer.slice(p - 1).chr 		end
# line 707 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 872 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.heredoc? && escaped_char == "\n".freeze
        if current_literal.squiggly_heredoc?
          # Squiggly heredocs like
          #   <<~-HERE
          #     1\
          #     2
          #   HERE
          # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
          # This information is emitted as is, without escaping,
          # later this escape sequence (\\n) gets handled manually in the Lexer::Dedenter
          current_literal.extend_string(tok, @ts, @te)
        else
          # Plain heredocs also parse \\n as a line continuation,
          # but they don't need to know that there was originally a newline in the
          # code, so we escape it and emit as "  1  2\n"
          current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
        end
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 341 then
# line 723 "lib/parser/lexer.rl"
		begin
 @escape = @source_buffer.slice(p - 1).chr 		end
# line 707 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 1812 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 767; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 124 then
# line 753 "lib/parser/lexer.rl"
		begin

        diagnostic :fatal, :invalid_unicode_escape, nil, range(@escape_s - 1, p)
      		end
# line 767 "lib/parser/lexer.rl"
		begin

          diagnostic :fatal, :unterminated_unicode, nil, range(p - 1, p)
        		end
# line 872 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.heredoc? && escaped_char == "\n".freeze
        if current_literal.squiggly_heredoc?
          # Squiggly heredocs like
          #   <<~-HERE
          #     1\
          #     2
          #   HERE
          # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
          # This information is emitted as is, without escaping,
          # later this escape sequence (\\n) gets handled manually in the Lexer::Dedenter
          current_literal.extend_string(tok, @ts, @te)
        else
          # Plain heredocs also parse \\n as a line continuation,
          # but they don't need to know that there was originally a newline in the
          # code, so we escape it and emit as "  1  2\n"
          current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
        end
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 151 then
# line 753 "lib/parser/lexer.rl"
		begin

        diagnostic :fatal, :invalid_unicode_escape, nil, range(@escape_s - 1, p)
      		end
# line 767 "lib/parser/lexer.rl"
		begin

          diagnostic :fatal, :unterminated_unicode, nil, range(p - 1, p)
        		end
# line 872 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.heredoc? && escaped_char == "\n".freeze
        if current_literal.squiggly_heredoc?
          # Squiggly heredocs like
          #   <<~-HERE
          #     1\
          #     2
          #   HERE
          # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
          # This information is emitted as is, without escaping,
          # later this escape sequence (\\n) gets handled manually in the Lexer::Dedenter
          current_literal.extend_string(tok, @ts, @te)
        else
          # Plain heredocs also parse \\n as a line continuation,
          # but they don't need to know that there was originally a newline in the
          # code, so we escape it and emit as "  1  2\n"
          current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
        end
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 352 then
# line 753 "lib/parser/lexer.rl"
		begin

        diagnostic :fatal, :invalid_unicode_escape, nil, range(@escape_s - 1, p)
      		end
# line 767 "lib/parser/lexer.rl"
		begin

          diagnostic :fatal, :unterminated_unicode, nil, range(p - 1, p)
        		end
# line 1812 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 767; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 107 then
# line 799 "lib/parser/lexer.rl"
		begin

    @escape_s = p
    @escape   = nil
  		end
# line 793 "lib/parser/lexer.rl"
		begin

      diagnostic :fatal, :escape_eof, nil, range(p - 1, p)
    		end
# line 872 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.heredoc? && escaped_char == "\n".freeze
        if current_literal.squiggly_heredoc?
          # Squiggly heredocs like
          #   <<~-HERE
          #     1\
          #     2
          #   HERE
          # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
          # This information is emitted as is, without escaping,
          # later this escape sequence (\\n) gets handled manually in the Lexer::Dedenter
          current_literal.extend_string(tok, @ts, @te)
        else
          # Plain heredocs also parse \\n as a line continuation,
          # but they don't need to know that there was originally a newline in the
          # code, so we escape it and emit as "  1  2\n"
          current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
        end
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 135 then
# line 799 "lib/parser/lexer.rl"
		begin

    @escape_s = p
    @escape   = nil
  		end
# line 793 "lib/parser/lexer.rl"
		begin

      diagnostic :fatal, :escape_eof, nil, range(p - 1, p)
    		end
# line 872 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.heredoc? && escaped_char == "\n".freeze
        if current_literal.squiggly_heredoc?
          # Squiggly heredocs like
          #   <<~-HERE
          #     1\
          #     2
          #   HERE
          # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
          # This information is emitted as is, without escaping,
          # later this escape sequence (\\n) gets handled manually in the Lexer::Dedenter
          current_literal.extend_string(tok, @ts, @te)
        else
          # Plain heredocs also parse \\n as a line continuation,
          # but they don't need to know that there was originally a newline in the
          # code, so we escape it and emit as "  1  2\n"
          current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
        end
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 336 then
# line 799 "lib/parser/lexer.rl"
		begin

    @escape_s = p
    @escape   = nil
  		end
# line 793 "lib/parser/lexer.rl"
		begin

      diagnostic :fatal, :escape_eof, nil, range(p - 1, p)
    		end
# line 1812 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 767; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 61 then
# line 1183 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1186 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 491 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
	when 203 then
# line 1183 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1186 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1371 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 218 then
# line 1183 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1186 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1389 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 230 then
# line 1183 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1186 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1421 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 252 then
# line 1183 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1186 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1560 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  	begin
		 @cs = 767
		_goto_level = _again
		next
	end
  end
		end
	when 267 then
# line 1183 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1186 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1639 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 279 then
# line 1183 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1186 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1660 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 305 then
# line 1183 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1186 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1952 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 369 then
# line 1183 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1186 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1979 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 379 then
# line 1183 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1186 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 2010 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 401 then
# line 1183 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1186 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 2311 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 94 then
# line 1183 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1186 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 2366 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 452 then
# line 2119 "lib/parser/lexer.rl"
		begin
 @num_base = 10; @num_digits_s = @ts 		end
# line 2121 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 624 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
	when 416 then
# line 2120 "lib/parser/lexer.rl"
		begin
 @num_base = 8;  @num_digits_s = @ts 		end
# line 2121 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 624 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
	when 431 then
# line 2121 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 624 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
# line 2122 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 424 then
# line 2178 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 633 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tFLOAT,     Float(chars)) } 		end
# line 2181 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@ts, @num_suffix_s)

        if version?(18, 19, 20)
          emit(:tFLOAT, Float(digits), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 420 then
# line 2179 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 633 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tFLOAT,     Float(chars)) } 		end
# line 2181 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@ts, @num_suffix_s)

        if version?(18, 19, 20)
          emit(:tFLOAT, Float(digits), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 258 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 491 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 1557 "lib/parser/lexer.rl"
		begin
 @act = 74;		end
	when 35 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 839 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1552 "lib/parser/lexer.rl"
		begin
 @act = 73;		end
	when 46 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 839 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1602 "lib/parser/lexer.rl"
		begin
 @act = 81;		end
	when 65 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1186 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1681 "lib/parser/lexer.rl"
		begin
 @act = 94;		end
	when 82 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1186 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 2064 "lib/parser/lexer.rl"
		begin
 @act = 137;		end
	when 37 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1512 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 1513 "lib/parser/lexer.rl"
		begin
 @act = 68;		end
	when 362 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1879 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 1925 "lib/parser/lexer.rl"
		begin
 @act = 117;		end
	when 361 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1879 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 1271 "lib/parser/lexer.rl"
		begin
 @act = 118;		end
	when 453 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2119 "lib/parser/lexer.rl"
		begin
 @num_base = 10; @num_digits_s = @ts 		end
# line 2122 "lib/parser/lexer.rl"
		begin
 @act = 144;		end
	when 118 then
# line 696 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]
    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 707 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 711 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 872 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.heredoc? && escaped_char == "\n".freeze
        if current_literal.squiggly_heredoc?
          # Squiggly heredocs like
          #   <<~-HERE
          #     1\
          #     2
          #   HERE
          # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
          # This information is emitted as is, without escaping,
          # later this escape sequence (\\n) gets handled manually in the Lexer::Dedenter
          current_literal.extend_string(tok, @ts, @te)
        else
          # Plain heredocs also parse \\n as a line continuation,
          # but they don't need to know that there was originally a newline in the
          # code, so we escape it and emit as "  1  2\n"
          current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
        end
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 145 then
# line 696 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]
    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 707 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 711 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 872 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.heredoc? && escaped_char == "\n".freeze
        if current_literal.squiggly_heredoc?
          # Squiggly heredocs like
          #   <<~-HERE
          #     1\
          #     2
          #   HERE
          # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
          # This information is emitted as is, without escaping,
          # later this escape sequence (\\n) gets handled manually in the Lexer::Dedenter
          current_literal.extend_string(tok, @ts, @te)
        else
          # Plain heredocs also parse \\n as a line continuation,
          # but they don't need to know that there was originally a newline in the
          # code, so we escape it and emit as "  1  2\n"
          current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
        end
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 346 then
# line 696 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]
    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 707 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 711 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 1812 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 767; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 116 then
# line 723 "lib/parser/lexer.rl"
		begin
 @escape = @source_buffer.slice(p - 1).chr 		end
# line 707 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 711 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 872 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.heredoc? && escaped_char == "\n".freeze
        if current_literal.squiggly_heredoc?
          # Squiggly heredocs like
          #   <<~-HERE
          #     1\
          #     2
          #   HERE
          # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
          # This information is emitted as is, without escaping,
          # later this escape sequence (\\n) gets handled manually in the Lexer::Dedenter
          current_literal.extend_string(tok, @ts, @te)
        else
          # Plain heredocs also parse \\n as a line continuation,
          # but they don't need to know that there was originally a newline in the
          # code, so we escape it and emit as "  1  2\n"
          current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
        end
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 143 then
# line 723 "lib/parser/lexer.rl"
		begin
 @escape = @source_buffer.slice(p - 1).chr 		end
# line 707 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 711 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 872 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.heredoc? && escaped_char == "\n".freeze
        if current_literal.squiggly_heredoc?
          # Squiggly heredocs like
          #   <<~-HERE
          #     1\
          #     2
          #   HERE
          # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
          # This information is emitted as is, without escaping,
          # later this escape sequence (\\n) gets handled manually in the Lexer::Dedenter
          current_literal.extend_string(tok, @ts, @te)
        else
          # Plain heredocs also parse \\n as a line continuation,
          # but they don't need to know that there was originally a newline in the
          # code, so we escape it and emit as "  1  2\n"
          current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
        end
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 344 then
# line 723 "lib/parser/lexer.rl"
		begin
 @escape = @source_buffer.slice(p - 1).chr 		end
# line 707 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 711 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 1812 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 767; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 448 then
# line 2115 "lib/parser/lexer.rl"
		begin
 @num_base = 16; @num_digits_s = p 		end
# line 2121 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 624 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
# line 2122 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 442 then
# line 2116 "lib/parser/lexer.rl"
		begin
 @num_base = 10; @num_digits_s = p 		end
# line 2121 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 624 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
# line 2122 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 445 then
# line 2117 "lib/parser/lexer.rl"
		begin
 @num_base = 8;  @num_digits_s = p 		end
# line 2121 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 624 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
# line 2122 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 439 then
# line 2118 "lib/parser/lexer.rl"
		begin
 @num_base = 2;  @num_digits_s = p 		end
# line 2121 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 624 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
# line 2122 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 451 then
# line 2119 "lib/parser/lexer.rl"
		begin
 @num_base = 10; @num_digits_s = @ts 		end
# line 2121 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 624 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
# line 2122 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 415 then
# line 2120 "lib/parser/lexer.rl"
		begin
 @num_base = 8;  @num_digits_s = @ts 		end
# line 2121 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 624 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
# line 2122 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 31 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 839 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1512 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 1513 "lib/parser/lexer.rl"
		begin
 @act = 68;		end
	when 62 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1183 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1186 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1681 "lib/parser/lexer.rl"
		begin
 @act = 94;		end
	when 458 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2121 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 624 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
# line 2154 "lib/parser/lexer.rl"
		begin
 @act = 146;		end
	when 454 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2119 "lib/parser/lexer.rl"
		begin
 @num_base = 10; @num_digits_s = @ts 		end
# line 2121 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 624 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
# line 2154 "lib/parser/lexer.rl"
		begin
 @act = 146;		end
	when 418 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2120 "lib/parser/lexer.rl"
		begin
 @num_base = 8;  @num_digits_s = @ts 		end
# line 2121 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 624 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
# line 2154 "lib/parser/lexer.rl"
		begin
 @act = 146;		end
# line 22832 "lib/parser/lexer.rb"
	end
	end
	end
	if _goto_level <= _again
	case _lex_to_state_actions[ @cs] 
	when 88 then
# line 1 "NONE"
		begin
 @ts = nil;		end
# line 22842 "lib/parser/lexer.rb"
	end

	if  @cs == 0
		_goto_level = _out
		next
	end
	p += 1
	if p != pe
		_goto_level = _resume
		next
	end
	end
	if _goto_level <= _test_eof
	if p == eof
	if _lex_eof_trans[ @cs] > 0
		_trans = _lex_eof_trans[ @cs] - 1;
		_goto_level = _eof_trans
		next;
	end
	end

	end
	if _goto_level <= _out
		break
	end
end
	end

# line 283 "lib/parser/lexer.rl"
    # %

    @p = p

    if @token_queue.any?
      @token_queue.shift
    elsif @cs == klass.lex_error
      [ false, [ '$error'.freeze, range(p - 1, p) ] ]
    else
      eof = @source_pts.size
      [ false, [ '$eof'.freeze,   range(eof, eof) ] ]
    end
  end

  protected

  def eof_codepoint?(point)
    [0x04, 0x1a, 0x00].include? point
  end

  def version?(*versions)
    versions.include?(@version)
  end

  def stack_pop
    @top -= 1
    @stack[@top]
  end

  def encode_escape(ord)
    ord.chr.force_encoding(@source_buffer.source.encoding)
  end

  def tok(s = @ts, e = @te)
    @source_buffer.slice(s...e)
  end

  def range(s = @ts, e = @te)
    Parser::Source::Range.new(@source_buffer, s, e)
  end

  def emit(type, value = tok, s = @ts, e = @te)
    token = [ type, [ value, range(s, e) ] ]

    @token_queue.push(token)

    @tokens.push(token) if @tokens

    token
  end

  def emit_table(table, s = @ts, e = @te)
    value = tok(s, e)

    emit(table[value], value, s, e)
  end

  def emit_do(do_block=false)
    if @cond.active?
      emit(:kDO_COND, 'do'.freeze)
    elsif @cmdarg.active? || do_block
      emit(:kDO_BLOCK, 'do'.freeze)
    else
      emit(:kDO, 'do'.freeze)
    end
  end

  def arg_or_cmdarg
    if @command_state
      self.class.lex_en_expr_cmdarg
    else
      self.class.lex_en_expr_arg
    end
  end

  def emit_comment(s = @ts, e = @te)
    if @comments
      @comments.push(Parser::Source::Comment.new(range(s, e)))
    end

    if @tokens
      @tokens.push([ :tCOMMENT, [ tok(s, e), range(s, e) ] ])
    end

    nil
  end

  def diagnostic(type, reason, arguments=nil, location=range, highlights=[])
    @diagnostics.process(
        Parser::Diagnostic.new(type, reason, arguments, location, highlights))
  end

  #
  # === LITERAL STACK ===
  #

  def push_literal(*args)
    new_literal = Literal.new(self, *args)
    @literal_stack.push(new_literal)
    next_state_for_literal(new_literal)
  end

  def next_state_for_literal(literal)
    if literal.words? && literal.backslash_delimited?
      if literal.interpolate?
        self.class.lex_en_interp_backslash_delimited_words
      else
        self.class.lex_en_plain_backslash_delimited_words
      end
    elsif literal.words? && !literal.backslash_delimited?
      if literal.interpolate?
        self.class.lex_en_interp_words
      else
        self.class.lex_en_plain_words
      end
    elsif !literal.words? && literal.backslash_delimited?
      if literal.interpolate?
        self.class.lex_en_interp_backslash_delimited
      else
        self.class.lex_en_plain_backslash_delimited
      end
    else
      if literal.interpolate?
        self.class.lex_en_interp_string
      else
        self.class.lex_en_plain_string
      end
    end
  end

  def literal
    @literal_stack.last
  end

  def pop_literal
    old_literal = @literal_stack.pop

    @dedent_level = old_literal.dedent_level

    if old_literal.type == :tREGEXP_BEG
      # Fetch modifiers.
      self.class.lex_en_regexp_modifiers
    else
      self.class.lex_en_expr_end
    end
  end

  # Mapping of strings to parser tokens.

  PUNCTUATION = {
    '='   => :tEQL,     '&'   => :tAMPER2,  '|'   => :tPIPE,
    '!'   => :tBANG,    '^'   => :tCARET,   '+'   => :tPLUS,
    '-'   => :tMINUS,   '*'   => :tSTAR2,   '/'   => :tDIVIDE,
    '%'   => :tPERCENT, '~'   => :tTILDE,   ','   => :tCOMMA,
    ';'   => :tSEMI,    '.'   => :tDOT,     '..'  => :tDOT2,
    '...' => :tDOT3,    '['   => :tLBRACK2, ']'   => :tRBRACK,
    '('   => :tLPAREN2, ')'   => :tRPAREN,  '?'   => :tEH,
    ':'   => :tCOLON,   '&&'  => :tANDOP,   '||'  => :tOROP,
    '-@'  => :tUMINUS,  '+@'  => :tUPLUS,   '~@'  => :tTILDE,
    '**'  => :tPOW,     '->'  => :tLAMBDA,  '=~'  => :tMATCH,
    '!~'  => :tNMATCH,  '=='  => :tEQ,      '!='  => :tNEQ,
    '>'   => :tGT,      '>>'  => :tRSHFT,   '>='  => :tGEQ,
    '<'   => :tLT,      '<<'  => :tLSHFT,   '<='  => :tLEQ,
    '=>'  => :tASSOC,   '::'  => :tCOLON2,  '===' => :tEQQ,
    '<=>' => :tCMP,     '[]'  => :tAREF,    '[]=' => :tASET,
    '{'   => :tLCURLY,  '}'   => :tRCURLY,  '`'   => :tBACK_REF2,
    '!@'  => :tBANG,    '&.'  => :tANDDOT,
  }

  PUNCTUATION_BEGIN = {
    '&'   => :tAMPER,   '*'   => :tSTAR,    '**'  => :tDSTAR,
    '+'   => :tUPLUS,   '-'   => :tUMINUS,  '::'  => :tCOLON3,
    '('   => :tLPAREN,  '{'   => :tLBRACE,  '['   => :tLBRACK,
  }

  KEYWORDS = {
    'if'     => :kIF_MOD,      'unless'   => :kUNLESS_MOD,
    'while'  => :kWHILE_MOD,   'until'    => :kUNTIL_MOD,
    'rescue' => :kRESCUE_MOD,  'defined?' => :kDEFINED,
    'BEGIN'  => :klBEGIN,      'END'      => :klEND,
  }

  KEYWORDS_BEGIN = {
    'if'     => :kIF,          'unless'   => :kUNLESS,
    'while'  => :kWHILE,       'until'    => :kUNTIL,
    'rescue' => :kRESCUE,      'defined?' => :kDEFINED,
    'BEGIN'  => :klBEGIN,      'END'      => :klEND,
  }

  %w(class module def undef begin end then elsif else ensure case when
     for break next redo retry in do return yield super self nil true
     false and or not alias __FILE__ __LINE__ __ENCODING__).each do |keyword|
    KEYWORDS_BEGIN[keyword] = KEYWORDS[keyword] = :"k#{keyword.upcase}"
  end

  
# line 2381 "lib/parser/lexer.rl"

  # %
end
