/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.util;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class ImageUtil {
    private ImageUtil() {
    }

    public static BufferedImage bufferImage(Image image) {
        BufferedImage bufferedImage = null;
        int imageWidth = image.getWidth(null);
        int imageHeight = image.getHeight(null);
        if (imageWidth > 0 && imageHeight > 0) {
            bufferedImage = new BufferedImage(imageWidth, imageHeight, 1);
            Graphics g = bufferedImage.getGraphics();
            g.drawImage(image, 0, 0, null);
        }
        return bufferedImage;
    }

    public static Image loadImage(String name) {
        InputStream stream = ImageUtil.class.getClassLoader().getResourceAsStream(name);
        if (stream != null) {
            byte[] buffer = new byte[32000];
            BufferedInputStream bufferedStream = new BufferedInputStream(stream);
            try {
                int read = bufferedStream.read(buffer);
                if (read > 0) {
                    Image image;
                    Image image2 = image = Toolkit.getDefaultToolkit().createImage(buffer);
                    return image2;
                }
                try {
                    System.out.println("Error reading " + name + ' ' + read + " bytes read");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            finally {
                try {
                    bufferedStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else {
            System.out.println("Resource not found " + name);
        }
        return null;
    }
}

