/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.ui.memory.floatingpoint;

import java.lang.reflect.Method;
import java.math.BigInteger;
import org.eclipse.cdt.debug.core.model.provisional.IMemoryRenderingViewportProvider;
import org.eclipse.cdt.debug.ui.memory.floatingpoint.CopyAction;
import org.eclipse.cdt.debug.ui.memory.floatingpoint.FPAbstractPane;
import org.eclipse.cdt.debug.ui.memory.floatingpoint.FPIMemorySelection;
import org.eclipse.cdt.debug.ui.memory.floatingpoint.FPRenderingMessages;
import org.eclipse.cdt.debug.ui.memory.floatingpoint.FPRenderingPlugin;
import org.eclipse.cdt.debug.ui.memory.floatingpoint.FPutilities;
import org.eclipse.cdt.debug.ui.memory.floatingpoint.Rendering;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.memory.IMemoryBlockConnection;
import org.eclipse.debug.internal.ui.memory.provisional.MemoryViewPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelChangedListener;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelProxy;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelProxyFactory;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.ui.memory.AbstractMemoryRendering;
import org.eclipse.debug.ui.memory.IMemoryRendering;
import org.eclipse.debug.ui.memory.IMemoryRenderingContainer;
import org.eclipse.debug.ui.memory.IMemoryRenderingSite;
import org.eclipse.debug.ui.memory.IRepositionableMemoryRendering;
import org.eclipse.debug.ui.memory.IResettableMemoryRendering;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.progress.UIJob;

public class FPRendering
extends AbstractMemoryRendering
implements IRepositionableMemoryRendering,
IResettableMemoryRendering,
IMemoryRenderingViewportProvider,
IModelChangedListener {
    protected Rendering fRendering;
    protected Action actionDisplayBigEndian;
    protected Action actionDisplayLittleEndian;
    protected Action actionDisplayFloatingPoint;
    private IWorkbenchAdapter fWorkbenchAdapter;
    private IMemoryBlockConnection fConnection;
    private static final int MAX_MENU_COLUMN_COUNT = 8;
    Action actionFloatingPoint32 = null;
    Action actionFloatingPoint64 = null;
    Action actionDisplay4Digits = null;
    Action actionDisplay8Digits = null;
    Action actionDisplay16Digits = null;
    static int paddingCounter = 0;
    BigInteger fBigBaseAddress;
    private BigInteger fStartAddress;
    private BigInteger fEndAddress;
    private int fAddressableSize;
    private int fAddressSize;
    IModelProxy fModel;
    private static final String ID_GO_TO_ADDRESS_COMMAND = "org.eclipse.debug.ui.command.gotoaddress";
    private AbstractHandler fGoToAddressHandler;
    private Color colorBackground;
    private Color colorChanged;
    private Color[] colorsChanged = null;
    private Color colorEdit;
    private Color colorSelection;
    private Color colorText;
    private Color colorTextAlternate;

    public FPRendering(String id) {
        super(id);
        JFaceResources.getFontRegistry().addListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("org.eclipse.debug.ui.MemoryViewTableFont")) {
                    FPRendering.this.fRendering.handleFontPreferenceChange(JFaceResources.getFont((String)"org.eclipse.debug.ui.MemoryViewTableFont"));
                }
            }
        });
        this.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                IMemoryRendering sourceRendering = (IMemoryRendering)event.getSource();
                if (!sourceRendering.getMemoryBlock().equals(FPRendering.this.getMemoryBlock())) {
                    return;
                }
                Object address = event.getNewValue();
                if (event.getProperty().equals("selectedAddress") && address instanceof BigInteger) {
                    FPRendering.this.fRendering.ensureVisible((BigInteger)address);
                }
            }
        });
        FPRenderingPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                FPRendering.this.disposeColors();
                FPRendering.this.allocateColors();
                FPRendering.this.applyPreferences();
            }
        });
        DebugUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("org.eclipse.debug.ui.memory.paddedStr") && FPRendering.this.fRendering != null) {
                    FPRendering.this.setRenderingPadding((String)event.getNewValue());
                    FPRendering.this.fRendering.redrawPanes();
                }
            }
        });
    }

    void setRenderingPadding(String padding) {
        if (padding == null || padding.length() == 0) {
            padding = "  ";
        }
        this.fRendering.setPaddingString(padding);
    }

    protected void logError(String message, Exception e) {
        Status status = new Status(4, this.getRenderingId(), 5013, message, (Throwable)e);
        FPRenderingPlugin.getDefault().getLog().log((IStatus)status);
    }

    public void modelChanged(IModelDelta delta, IModelProxy proxy) {
        int flags = delta.getFlags();
        if ((flags & 0x800) != 0) {
            this.fRendering.handleSuspend(false);
        }
        this.fRendering.handleChange();
    }

    public void dispose() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (FPRendering.this.fModel != null) {
                    FPRendering.this.fModel.removeModelChangedListener((IModelChangedListener)FPRendering.this);
                    FPRendering.this.fModel.dispose();
                }
            }
        });
        if (this.fRendering != null) {
            this.fRendering.dispose();
        }
        this.disposeColors();
        super.dispose();
    }

    public void init(final IMemoryRenderingContainer container, final IMemoryBlock block) {
        BigInteger endAddress;
        super.init(container, block);
        final IModelProxyFactory factory = (IModelProxyFactory)DebugPlugin.getAdapter((Object)block, IModelProxyFactory.class);
        if (factory != null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    IMemoryRenderingSite site = container.getMemoryRenderingSite();
                    MemoryViewPresentationContext context = new MemoryViewPresentationContext(site, container, (IMemoryRendering)FPRendering.this);
                    FPRendering.this.fModel = factory.createModelProxy((Object)block, (IPresentationContext)context);
                    if (FPRendering.this.fModel != null) {
                        FPRendering.this.fModel.installed(null);
                        FPRendering.this.fModel.addModelChangedListener((IModelChangedListener)FPRendering.this);
                    }
                }
            });
        }
        try {
            this.fBigBaseAddress = ((IMemoryBlockExtension)block).getBigBaseAddress();
        }
        catch (DebugException de) {
            this.logError(FPRenderingMessages.getString("FPRendering.FAILURE_RETRIEVE_BASE_ADDRESS"), (Exception)((Object)de));
        }
        try {
            this.fAddressableSize = ((IMemoryBlockExtension)block).getAddressableSize();
        }
        catch (DebugException de) {
            this.fAddressableSize = 1;
        }
        try {
            this.fStartAddress = ((IMemoryBlockExtension)block).getMemoryBlockStartAddress();
        }
        catch (DebugException de) {
            this.fStartAddress = null;
            this.logError(FPRenderingMessages.getString("FPRendering.FAILURE_RETRIEVE_START_ADDRESS"), (Exception)((Object)de));
        }
        try {
            this.fAddressSize = ((IMemoryBlockExtension)block).getAddressSize();
        }
        catch (DebugException e) {
            this.fAddressSize = 0;
        }
        try {
            endAddress = ((IMemoryBlockExtension)block).getMemoryBlockEndAddress();
            if (endAddress != null) {
                this.fEndAddress = endAddress;
            }
        }
        catch (DebugException e) {
            this.fEndAddress = null;
        }
        if (this.fEndAddress == null) {
            int addressSize;
            try {
                addressSize = ((IMemoryBlockExtension)block).getAddressSize();
            }
            catch (DebugException e) {
                addressSize = 4;
            }
            endAddress = BigInteger.valueOf(2L);
            endAddress = endAddress.pow(addressSize * 8);
            this.fEndAddress = endAddress = endAddress.subtract(BigInteger.ONE);
        }
        if (this.fEndAddress == null) {
            this.fEndAddress = BigInteger.valueOf(Integer.MAX_VALUE);
        }
    }

    public BigInteger getBigBaseAddress() {
        return this.fBigBaseAddress;
    }

    public BigInteger getMemoryBlockStartAddress() {
        return this.fStartAddress;
    }

    public BigInteger getMemoryBlockEndAddress() {
        return this.fEndAddress;
    }

    public int getAddressableSize() {
        return this.fAddressableSize;
    }

    public int getAddressSize() {
        return this.fAddressSize;
    }

    public Control createControl(Composite parent) {
        this.allocateColors();
        this.fRendering = new Rendering(parent, this);
        this.applyPreferences();
        this.createMenus();
        if (this.actionFloatingPoint32.isChecked()) {
            this.actionDisplay16Digits.setEnabled(false);
        } else {
            this.actionDisplay16Digits.setEnabled(true);
        }
        return this.fRendering;
    }

    public void activated() {
        super.activated();
        IWorkbench workbench = PlatformUI.getWorkbench();
        ICommandService commandSupport = (ICommandService)workbench.getAdapter(ICommandService.class);
        if (commandSupport != null) {
            Command gotoCommand = commandSupport.getCommand(ID_GO_TO_ADDRESS_COMMAND);
            if (this.fGoToAddressHandler == null) {
                this.fGoToAddressHandler = new AbstractHandler(){

                    public Object execute(ExecutionEvent event) throws ExecutionException {
                        return null;
                    }
                };
            }
            gotoCommand.setHandler((IHandler)this.fGoToAddressHandler);
        }
    }

    public void deactivated() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        ICommandService commandSupport = (ICommandService)workbench.getAdapter(ICommandService.class);
        if (commandSupport != null) {
            Command command = commandSupport.getCommand(ID_GO_TO_ADDRESS_COMMAND);
            command.setHandler(null);
        }
        super.deactivated();
    }

    public void setSelection(BigInteger start, BigInteger end) {
        this.fRendering.getSelection().setStart(start, start);
        this.fRendering.getSelection().setEnd(end, end);
    }

    public void gotoAddress(BigInteger address) {
        this.fRendering.gotoAddress(address);
    }

    public void updateRenderingLabels() {
        UIJob job = new UIJob("updateLabels"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                String fLabel = FPRendering.this.getLabel();
                FPRendering.this.firePropertyChangedEvent(new PropertyChangeEvent((Object)FPRendering.this, "org.eclipse.jface.text", null, (Object)fLabel));
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    public void allocateColors() {
        IPreferenceStore store = FPRenderingPlugin.getDefault().getPreferenceStore();
        this.colorBackground = new Color((Device)Display.getDefault(), PreferenceConverter.getColor((IPreferenceStore)store, (String)"memoryColorBackground"));
        this.colorChanged = new Color((Device)Display.getDefault(), PreferenceConverter.getColor((IPreferenceStore)store, (String)"memoryColorChanged"));
        this.colorEdit = new Color((Device)Display.getDefault(), PreferenceConverter.getColor((IPreferenceStore)store, (String)"memoryColorEdit"));
        this.colorSelection = new Color((Device)Display.getDefault(), PreferenceConverter.getColor((IPreferenceStore)store, (String)"memoryColorSelection"));
        this.colorText = new Color((Device)Display.getDefault(), PreferenceConverter.getColor((IPreferenceStore)store, (String)"memoryColorText"));
        Color textColor = this.getColorText();
        int red = textColor.getRed();
        int green = textColor.getGreen();
        int blue = textColor.getBlue();
        float scale = store.getInt("memoryColorScaleTextAlternate");
        red = (int)Math.min((float)red + (float)((255 - red) / 10) * scale, 255.0f);
        green = (int)Math.min((float)green + (float)((255 - green) / 10) * scale, 255.0f);
        blue = (int)Math.min((float)blue + (float)((255 - blue) / 10) * scale, 255.0f);
        this.colorTextAlternate = new Color((Device)Display.getDefault(), new RGB(red, green, blue));
    }

    public void disposeColors() {
        if (this.colorBackground != null) {
            this.colorBackground.dispose();
        }
        this.colorBackground = null;
        if (this.colorChanged != null) {
            this.colorChanged.dispose();
        }
        this.colorChanged = null;
        if (this.colorEdit != null) {
            this.colorEdit.dispose();
        }
        this.colorEdit = null;
        if (this.colorSelection != null) {
            this.colorSelection.dispose();
        }
        this.colorSelection = null;
        if (this.colorText != null) {
            this.colorText.dispose();
        }
        this.colorText = null;
        if (this.colorTextAlternate != null) {
            this.colorTextAlternate.dispose();
        }
        this.colorTextAlternate = null;
        this.disposeChangedColors();
    }

    public void applyPreferences() {
        if (this.fRendering != null && !this.fRendering.isDisposed()) {
            IPreferenceStore store = FPRenderingPlugin.getDefault().getPreferenceStore();
            this.fRendering.setHistoryDepth(store.getInt("memoryHistoryTrailsCount"));
            this.fRendering.setBackground(this.getColorBackground());
            FPAbstractPane[] panes = this.fRendering.getRenderingPanes();
            int index = 0;
            while (index < panes.length) {
                panes[index].setBackground(this.getColorBackground());
                ++index;
            }
            this.setRenderingPadding(FPRenderingPlugin.getDefault().getPreferenceStore().getString("org.eclipse.debug.ui.memory.paddedStr"));
            this.fRendering.redrawPanes();
        }
    }

    public Color getColorBackground() {
        IPreferenceStore store = FPRenderingPlugin.getDefault().getPreferenceStore();
        if (store.getBoolean("memUseGlobalBackground")) {
            return Display.getDefault().getSystemColor(25);
        }
        return this.colorBackground;
    }

    public Color getColorChanged() {
        return this.colorChanged;
    }

    private void disposeChangedColors() {
        if (this.colorsChanged != null) {
            int index = 0;
            while (index < this.colorsChanged.length) {
                this.colorsChanged[index].dispose();
                ++index;
            }
        }
        this.colorsChanged = null;
    }

    public Color[] getColorsChanged() {
        if (this.colorsChanged != null && this.colorsChanged.length != this.fRendering.getHistoryDepth()) {
            this.disposeChangedColors();
        }
        if (this.colorsChanged == null) {
            this.colorsChanged = new Color[this.fRendering.getHistoryDepth()];
            this.colorsChanged[0] = this.colorChanged;
            int shades = this.fRendering.getHistoryDepth() + 4;
            int red = (255 - this.colorChanged.getRed()) / shades;
            int green = (255 - this.colorChanged.getGreen()) / shades;
            int blue = (255 - this.colorChanged.getBlue()) / shades;
            int index = 1;
            while (index < this.fRendering.getHistoryDepth()) {
                this.colorsChanged[index] = new Color(this.colorChanged.getDevice(), this.colorChanged.getRed() + (shades - index) * red, this.colorChanged.getGreen() + (shades - index) * green, this.colorChanged.getBlue() + (shades - index) * blue);
                ++index;
            }
        }
        return this.colorsChanged;
    }

    public Color getColorEdit() {
        return this.colorEdit;
    }

    public Color getColorSelection() {
        IPreferenceStore store = FPRenderingPlugin.getDefault().getPreferenceStore();
        if (store.getBoolean("memUseGlobalSelection")) {
            return Display.getDefault().getSystemColor(26);
        }
        return this.colorSelection;
    }

    public Color getColorText() {
        IPreferenceStore store = FPRenderingPlugin.getDefault().getPreferenceStore();
        if (store.getBoolean("memUseGlobalText")) {
            return Display.getDefault().getSystemColor(24);
        }
        return this.colorText;
    }

    public Color getColorTextAlternate() {
        return this.colorTextAlternate;
    }

    public void createMenus() {
        FPAbstractPane[] renderingControls = this.fRendering.getRenderingPanes();
        int index = 0;
        while (index < renderingControls.length) {
            super.createPopupMenu((Control)renderingControls[index]);
            ++index;
        }
        super.createPopupMenu((Control)this.fRendering);
        final CopyAction copyAction = new CopyAction(this.fRendering);
        final Action copyAddressAction = new Action(FPRenderingMessages.getString("FPRendering.COPY_ADDRESS")){

            public void run() {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        (this).FPRendering.this.fRendering.copyAddressToClipboard();
                    }
                });
            }
        };
        final Action gotoBaseAddressAction = new Action(FPRenderingMessages.getString("FPRendering.RESET_TO_BASE_ADDRESS")){

            public void run() {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        (this).FPRendering.this.fRendering.gotoAddress((this).FPRendering.this.fRendering.fBaseAddress);
                    }
                });
            }
        };
        final Action refreshAction = new Action(FPRenderingMessages.getString("FPRendering.REFRESH")){

            public void run() {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Method m = (this).FPRendering.this.fRendering.getMemoryBlock().getClass().getMethod("clearCache", new Class[0]);
                            if (m != null) {
                                m.invoke((Object)(this).FPRendering.this.fRendering.getMemoryBlock(), new Object[0]);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        (this).FPRendering.this.fRendering.refresh();
                    }
                });
            }
        };
        this.actionDisplayLittleEndian = new Action(FPRenderingMessages.getString("FPRendering.ENDIAN_LITTLE"), 8){

            public void run() {
                FPRendering.this.fRendering.setDisplayLittleEndian(true);
                FPRendering.this.setRMCvalue("org.eclipse.cdt.debug.ui.memory.floatingpoint.endian", FPutilities.Endian.LITTLE.getValue());
            }
        };
        this.actionDisplayBigEndian = new Action(FPRenderingMessages.getString("FPRendering.ENDIAN_BIG"), 8){

            public void run() {
                FPRendering.this.fRendering.setDisplayLittleEndian(false);
                FPRendering.this.setRMCvalue("org.eclipse.cdt.debug.ui.memory.floatingpoint.endian", FPutilities.Endian.BIG.getValue());
            }
        };
        int endian = this.getRMCvalue("org.eclipse.cdt.debug.ui.memory.floatingpoint.endian");
        endian = endian != -1 ? endian : (this.fRendering.isDisplayLittleEndian() ? FPutilities.Endian.LITTLE.getValue() : FPutilities.Endian.BIG.getValue());
        boolean le = endian == FPutilities.Endian.LITTLE.getValue();
        this.fRendering.setDisplayLittleEndian(le);
        this.actionDisplayLittleEndian.setChecked(le);
        this.actionDisplayBigEndian.setChecked(!le);
        boolean dtFloat = this.getRMCvalue("org.eclipse.cdt.debug.ui.memory.floatingpoint.dataType") == FPutilities.FPDataType.FLOAT.getValue();
        this.fRendering.setFPDataType(dtFloat ? FPutilities.FPDataType.FLOAT : FPutilities.FPDataType.DOUBLE);
        this.actionFloatingPoint32 = new Action(FPRenderingMessages.getString("FPRendering.FLOATING_POINT_32"), 8){

            public void run() {
                FPRendering.this.fRendering.setDisplayedPrecision(FPRendering.this.getRMCvalue("org.eclipse.cdt.debug.ui.memory.floatingpoint.floatDispPrec"));
                FPRendering.this.fRendering.setFPDataType(FPutilities.FPDataType.FLOAT);
                FPRendering.this.setRMCvalue("org.eclipse.cdt.debug.ui.memory.floatingpoint.dataType", FPutilities.FPDataType.FLOAT.getValue());
                FPRendering.this.setSelections();
            }
        };
        this.actionFloatingPoint64 = new Action(FPRenderingMessages.getString("FPRendering.FLOATING_POINT_64"), 8){

            public void run() {
                FPRendering.this.fRendering.setDisplayedPrecision(FPRendering.this.getRMCvalue("org.eclipse.cdt.debug.ui.memory.floatingpoint.doubleDispPrec"));
                FPRendering.this.fRendering.setFPDataType(FPutilities.FPDataType.DOUBLE);
                FPRendering.this.setRMCvalue("org.eclipse.cdt.debug.ui.memory.floatingpoint.dataType", FPutilities.FPDataType.DOUBLE.getValue());
                FPRendering.this.setSelections();
            }
        };
        int savedPrecision = this.getDisplayedPrecision();
        this.actionDisplay4Digits = new Action(FPRenderingMessages.getString("FPRendering.DISPLAYED_PRECISION_4"), 8){

            public void run() {
                FPRendering.this.fRendering.setDisplayedPrecision(4);
                FPRendering.this.setDisplayedPrecision(4);
            }
        };
        if (savedPrecision == 4) {
            this.fRendering.setDisplayedPrecision(4);
            this.actionDisplay4Digits.setChecked(savedPrecision == 4);
        }
        this.actionDisplay8Digits = new Action(FPRenderingMessages.getString("FPRendering.DISPLAYED_PRECISION_8"), 8){

            public void run() {
                FPRendering.this.fRendering.setDisplayedPrecision(8);
                FPRendering.this.setDisplayedPrecision(8);
            }
        };
        if (savedPrecision == 8) {
            this.fRendering.setDisplayedPrecision(8);
            this.actionDisplay8Digits.setChecked(savedPrecision == 8);
        }
        this.actionDisplay16Digits = new Action(FPRenderingMessages.getString("FPRendering.DISPLAYED_PRECISION_16"), 8){

            public void run() {
                FPRendering.this.fRendering.setDisplayedPrecision(16);
                FPRendering.this.setDisplayedPrecision(16);
            }
        };
        if (savedPrecision == 16) {
            this.fRendering.setDisplayedPrecision(16);
            this.actionDisplay16Digits.setChecked(savedPrecision == 16);
        }
        this.setSelections();
        int savedColumnCount = this.getRMCvalue("org.eclipse.cdt.debug.ui.memory.floatingpoint.columns");
        final Action displayColumnCountAuto = new Action(FPRenderingMessages.getString("FPRendering.COLUMN_COUNT_AUTO"), 8){

            public void run() {
                FPRendering.this.fRendering.setColumnsSetting(0);
                FPRendering.this.setRMCvalue("org.eclipse.cdt.debug.ui.memory.floatingpoint.columns", 0);
            }
        };
        boolean autoMode = savedColumnCount == 0;
        displayColumnCountAuto.setChecked(autoMode);
        final Action[] displayColumnCounts = new Action[8];
        int index2 = 0;
        int j = 1;
        while (index2 < 8) {
            final int finali = j;
            displayColumnCounts[index2] = new Action(FPRenderingMessages.getString("FPRendering.COLUMN_COUNT_" + finali), 8){

                public void run() {
                    FPRendering.this.fRendering.setColumnsSetting(finali);
                    FPRendering.this.setRMCvalue("org.eclipse.cdt.debug.ui.memory.floatingpoint.columns", finali);
                }
            };
            displayColumnCounts[index2].setChecked(this.fRendering.getColumnsSetting() == finali);
            ++index2;
            j *= 2;
        }
        int countValue = this.getRMCvalue("org.eclipse.cdt.debug.ui.memory.floatingpoint.columns");
        int index3 = 0;
        while (index3 < 8) {
            displayColumnCounts[index3].setChecked(countValue != 0 && countValue == 1 << index3);
            ++index3;
        }
        this.fRendering.setColumnsSetting(this.getRMCvalue("org.eclipse.cdt.debug.ui.memory.floatingpoint.columns"));
        final Action displayColumnCountCustomValue = new Action("", 8){

            public void run() {
            }
        };
        final Action displayColumnCountCustom = new Action(FPRenderingMessages.getString("FPRendering.COLUMN_COUNT_CUSTOM"), 8){

            public void run() {
                int newColumnCount;
                block11: {
                    InputDialog inputDialog = new InputDialog(FPRendering.this.fRendering.getShell(), "Set Column Count", "Please enter column count", "", new IInputValidator(){

                        public String isValid(String input) {
                            int index;
                            block4: {
                                try {
                                    index = Integer.parseInt(input);
                                    if (index > 0) break block4;
                                    return "Please enter a positive integer";
                                }
                                catch (NumberFormatException x) {
                                    return "Please enter a positive integer";
                                }
                            }
                            if (index > 200) {
                                return "Please enter a positive integer not greater than 200";
                            }
                            return null;
                        }
                    });
                    if (inputDialog.open() != 0) {
                        this.setChecked(false);
                        int currentColumnSetting = FPRendering.this.fRendering.getColumnsSetting();
                        if (currentColumnSetting == 0) {
                            displayColumnCountAuto.setChecked(true);
                        } else {
                            boolean currentCountIsCustom = true;
                            int index = 0;
                            int j = 1;
                            while (index < 8 && currentCountIsCustom) {
                                boolean bl = currentCountIsCustom = j != FPRendering.this.fRendering.getColumnsSetting();
                                if (j == FPRendering.this.fRendering.getColumnsSetting()) {
                                    displayColumnCounts[index].setChecked(true);
                                }
                                ++index;
                                j *= 2;
                            }
                            if (currentCountIsCustom) {
                                displayColumnCountCustomValue.setChecked(true);
                            }
                        }
                        return;
                    }
                    newColumnCount = -1;
                    try {
                        newColumnCount = Integer.parseInt(inputDialog.getValue());
                    }
                    catch (NumberFormatException x) {
                        if ($assertionsDisabled) break block11;
                        throw new AssertionError();
                    }
                }
                boolean customIsOneOfStandardListChoices = false;
                int index = 0;
                int j = 1;
                while (index < 8) {
                    if (newColumnCount == j) {
                        customIsOneOfStandardListChoices = true;
                        FPRendering.this.fRendering.setColumnsSetting(newColumnCount);
                        FPRendering.this.setRMCvalue("org.eclipse.cdt.debug.ui.memory.floatingpoint.columns", newColumnCount);
                        this.setChecked(false);
                        displayColumnCountCustomValue.setChecked(false);
                        displayColumnCounts[index].setChecked(true);
                        break;
                    }
                    ++index;
                    j *= 2;
                }
                if (!customIsOneOfStandardListChoices) {
                    FPRendering.this.fRendering.setColumnsSetting(newColumnCount);
                    FPRendering.this.setRMCvalue("org.eclipse.cdt.debug.ui.memory.floatingpoint.columns", newColumnCount);
                    this.setChecked(false);
                    displayColumnCountCustomValue.setChecked(true);
                    displayColumnCountCustomValue.setText(Integer.valueOf(FPRendering.this.fRendering.getColumnsSetting()).toString());
                }
            }
        };
        boolean customColumnCountSet = true;
        countValue = this.getRMCvalue("org.eclipse.cdt.debug.ui.memory.floatingpoint.columns");
        if (countValue != 0) {
            int index4 = 0;
            while (index4 < 8) {
                if (countValue == 1 << index4) {
                    customColumnCountSet = false;
                    break;
                }
                ++index4;
            }
            if (customColumnCountSet) {
                this.fRendering.setColumnsSetting(countValue);
                displayColumnCountCustomValue.setChecked(true);
                displayColumnCountCustomValue.setText(Integer.valueOf(this.fRendering.getColumnsSetting()).toString());
            }
        }
        this.getPopupMenuManager().addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IContributionItem)new Separator());
                MenuManager sub = new MenuManager(FPRenderingMessages.getString("FPRendering.PANES"));
                sub = new MenuManager(FPRenderingMessages.getString("FPRendering.ENDIAN"));
                sub.add((IAction)FPRendering.this.actionDisplayBigEndian);
                sub.add((IAction)FPRendering.this.actionDisplayLittleEndian);
                manager.add((IContributionItem)sub);
                sub = new MenuManager(FPRenderingMessages.getString("FPRendering.NUMBER_TYPE"));
                sub.add((IAction)FPRendering.this.actionFloatingPoint32);
                sub.add((IAction)FPRendering.this.actionFloatingPoint64);
                manager.add((IContributionItem)sub);
                sub = new MenuManager(FPRenderingMessages.getString("FPRendering.PRECISION"));
                sub.add((IAction)FPRendering.this.actionDisplay4Digits);
                sub.add((IAction)FPRendering.this.actionDisplay8Digits);
                sub.add((IAction)FPRendering.this.actionDisplay16Digits);
                manager.add((IContributionItem)sub);
                sub = new MenuManager(FPRenderingMessages.getString("FPRendering.COLUMN_COUNT"));
                sub.add((IAction)displayColumnCountAuto);
                int index = 0;
                while (index < displayColumnCounts.length) {
                    sub.add((IAction)displayColumnCounts[index]);
                    ++index;
                }
                boolean currentCountIsCustom = FPRendering.this.fRendering.getColumnsSetting() != 0;
                int index2 = 0;
                int j = 1;
                while (index2 < 8 && currentCountIsCustom) {
                    currentCountIsCustom = j != FPRendering.this.fRendering.getColumnsSetting();
                    ++index2;
                    j *= 2;
                }
                if (currentCountIsCustom) {
                    sub.add((IAction)displayColumnCountCustomValue);
                }
                sub.add((IAction)displayColumnCountCustom);
                manager.add((IContributionItem)sub);
                int updateMode = FPRendering.this.getRMCvalue("org.eclipse.cdt.debug.ui.memory.floatingpoint.updateMode");
                Action updateAlwaysAction = new Action(FPRenderingMessages.getString("FPRendering.UPDATE_ALWAYS"), 8){

                    public void run() {
                        (this).FPRendering.this.fRendering.setUpdateMode(1);
                        FPRendering.this.setRMCvalue("org.eclipse.cdt.debug.ui.memory.floatingpoint.updateMode", 1);
                    }
                };
                updateAlwaysAction.setChecked(updateMode == 1);
                Action updateOnBreakpointAction = new Action(FPRenderingMessages.getString("FPRendering.UPDATE_ON_BREAKPOINT"), 8){

                    public void run() {
                        (this).FPRendering.this.fRendering.setUpdateMode(2);
                        FPRendering.this.setRMCvalue("org.eclipse.cdt.debug.ui.memory.floatingpoint.updateMode", 2);
                    }
                };
                updateOnBreakpointAction.setChecked(updateMode == 2);
                Action updateManualAction = new Action(FPRenderingMessages.getString("FPRendering.UPDATE_MANUAL"), 8){

                    public void run() {
                        (this).FPRendering.this.fRendering.setUpdateMode(3);
                        FPRendering.this.setRMCvalue("org.eclipse.cdt.debug.ui.memory.floatingpoint.updateMode", 3);
                    }
                };
                updateManualAction.setChecked(updateMode == 3);
                sub = new MenuManager(FPRenderingMessages.getString("FPRendering.UPDATEMODE"));
                sub.add((IAction)updateAlwaysAction);
                sub.add((IAction)updateOnBreakpointAction);
                sub.add((IAction)updateManualAction);
                manager.add((IContributionItem)sub);
                manager.add((IContributionItem)new Separator());
                BigInteger start = FPRendering.this.fRendering.getSelection().getStart();
                BigInteger end = FPRendering.this.fRendering.getSelection().getEnd();
                copyAction.setEnabled(start != null && end != null);
                manager.add((IAction)copyAction);
                manager.add((IAction)copyAddressAction);
                manager.add((IAction)gotoBaseAddressAction);
                manager.add((IAction)refreshAction);
                manager.add((IContributionItem)new Separator());
                manager.add((IContributionItem)new Separator("additions"));
            }
        });
    }

    public void setSelections() {
        if (this.actionDisplay4Digits == null || this.actionDisplay8Digits == null || this.actionDisplay16Digits == null) {
            return;
        }
        boolean dtFloat = this.fRendering.getFPDataType() == FPutilities.FPDataType.FLOAT;
        this.actionDisplay16Digits.setEnabled(!dtFloat);
        this.actionFloatingPoint32.setChecked(dtFloat);
        this.actionFloatingPoint64.setChecked(!dtFloat);
        int displayedPrecision = this.getRMCvalue(dtFloat ? "org.eclipse.cdt.debug.ui.memory.floatingpoint.floatDispPrec" : "org.eclipse.cdt.debug.ui.memory.floatingpoint.doubleDispPrec");
        this.actionDisplay4Digits.setChecked(displayedPrecision == 4);
        this.actionDisplay8Digits.setChecked(displayedPrecision == 8);
        this.actionDisplay16Digits.setChecked(displayedPrecision == 16);
    }

    public Control getControl() {
        return this.fRendering;
    }

    public BigInteger getSelectedAddress() {
        FPIMemorySelection selection = this.fRendering.getSelection();
        if (selection == null || selection.getStart() == null) {
            return this.fRendering.getCaretAddress();
        }
        return selection.getStartLow();
    }

    public MemoryByte[] getSelectedAsBytes() {
        try {
            BigInteger startAddr = this.fRendering.getCaretAddress();
            int byteCount = this.fRendering.getCharsPerColumn();
            FPIMemorySelection selection = this.fRendering.getSelection();
            if (selection != null && selection.getStart() != null) {
                startAddr = this.getSelectedAddress();
                if (selection.getHigh() != null) {
                    byteCount = selection.getHigh().subtract(selection.getLow()).intValue() * this.fRendering.getAddressableSize();
                }
            }
            return this.fRendering.getViewportCache().getBytes(startAddr, byteCount);
        }
        catch (DebugException de) {
            return new MemoryByte[0];
        }
    }

    public void goToAddress(final BigInteger address) throws DebugException {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                FPRendering.this.fRendering.gotoAddress(address);
            }
        });
    }

    protected void setTargetMemoryLittleEndian(boolean littleEndian) {
        this.actionDisplayBigEndian.setChecked(!littleEndian);
        this.actionDisplayLittleEndian.setChecked(littleEndian);
        this.fRendering.setDisplayLittleEndian(littleEndian);
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IWorkbenchAdapter.class) {
            if (this.fWorkbenchAdapter == null) {
                this.fWorkbenchAdapter = new IWorkbenchAdapter(){

                    public Object[] getChildren(Object o) {
                        return new Object[0];
                    }

                    public ImageDescriptor getImageDescriptor(Object object) {
                        return null;
                    }

                    public String getLabel(Object o) {
                        return FPRenderingMessages.getString("FPRendering.RENDERING_NAME");
                    }

                    public Object getParent(Object o) {
                        return null;
                    }
                };
            }
            return this.fWorkbenchAdapter;
        }
        if (adapter == IMemoryBlockConnection.class) {
            if (this.fConnection == null) {
                this.fConnection = new IMemoryBlockConnection(){

                    public void update() {
                        Display display = FPRenderingPlugin.getDefault().getWorkbench().getDisplay();
                        display.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    if ((this).FPRendering.this.fBigBaseAddress != (this).FPRendering.this.fRendering.getMemoryBlock().getBigBaseAddress()) {
                                        (this).FPRendering.this.fBigBaseAddress = (this).FPRendering.this.fRendering.getMemoryBlock().getBigBaseAddress();
                                        (this).FPRendering.this.fRendering.gotoAddress((this).FPRendering.this.fBigBaseAddress);
                                    }
                                    (this).FPRendering.this.fRendering.refresh();
                                }
                                catch (DebugException debugException) {
                                    // empty catch block
                                }
                            }
                        });
                    }
                };
            }
            return this.fConnection;
        }
        return super.getAdapter(adapter);
    }

    public void resetRendering() throws DebugException {
        this.fRendering.gotoAddress(this.fRendering.fBaseAddress);
    }

    public BigInteger getViewportAddress() {
        return this.fRendering.getViewportStartAddress();
    }

    void setDisplayedPrecision(int precision) {
        if (this.fRendering.getFPDataType() == FPutilities.FPDataType.FLOAT) {
            this.setRMCvalue("org.eclipse.cdt.debug.ui.memory.floatingpoint.floatDispPrec", precision);
        } else {
            this.setRMCvalue("org.eclipse.cdt.debug.ui.memory.floatingpoint.doubleDispPrec", precision);
        }
    }

    private int getDisplayedPrecision() {
        IPreferenceStore store = FPRenderingPlugin.getDefault().getPreferenceStore();
        FPutilities.FPDataType dataType = this.fRendering.getFPDataType();
        if (store != null) {
            return store.getInt(dataType == FPutilities.FPDataType.FLOAT ? "org.eclipse.cdt.debug.ui.memory.floatingpoint.floatDispPrec" : "org.eclipse.cdt.debug.ui.memory.floatingpoint.doubleDispPrec");
        }
        return dataType == FPutilities.FPDataType.FLOAT ? FPutilities.FPDataType.FLOAT.getDisplayedPrecision() : FPutilities.FPDataType.DOUBLE.getDisplayedPrecision();
    }

    void setRMCvalue(String key, int value) {
        IPreferenceStore store = FPRenderingPlugin.getDefault().getPreferenceStore();
        if (store != null) {
            store.setValue(key, value);
        }
    }

    int getRMCvalue(String key) {
        IPreferenceStore store = FPRenderingPlugin.getDefault().getPreferenceStore();
        return store != null ? store.getInt(key) : 0;
    }
}

