/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.internal.ui.text.CHelpBookDescriptor;
import org.eclipse.cdt.ui.ICHelpBook;
import org.eclipse.cdt.ui.ICHelpProvider;
import org.eclipse.cdt.ui.text.ICHelpInvocationContext;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class CHelpProviderDescriptor {
    private static final String CLASS = "class";
    private static final String ELEMENT_PROVIDER = "provider";
    private static final String ATTRIBUTE_ID = "id";
    private static Map<String, ICHelpProvider> fProvidersMap = null;
    private ICHelpProvider fHelpProvider = null;
    private IConfigurationElement fConfigElement;
    private CHelpBookDescriptor[] fHelpBookDescriptors = null;
    private IProject fProject;

    public CHelpProviderDescriptor(IProject project, IConfigurationElement element) {
        this(project, element, null);
    }

    public CHelpProviderDescriptor(IProject project, IConfigurationElement configElement, Element parentElement) {
        this.fConfigElement = configElement;
        this.fProject = project;
        if (parentElement == null) {
            return;
        }
        Element projectElement = this.getDescriptorElement(parentElement);
        if (projectElement == null) {
            return;
        }
        this.getCHelpBookDescriptors(projectElement);
    }

    private Element getDescriptorElement(Element parentElement) {
        String id = this.getConfigurationElement().getAttribute(ATTRIBUTE_ID);
        if (id == null || id.isEmpty()) {
            return null;
        }
        NodeList nodes = parentElement.getElementsByTagName(ELEMENT_PROVIDER);
        int i = 0;
        while (i < nodes.getLength()) {
            Element descriptorEl = (Element)nodes.item(i);
            if (id.equals(descriptorEl.getAttribute(ATTRIBUTE_ID))) {
                return descriptorEl;
            }
            ++i;
        }
        return null;
    }

    private static Map<String, ICHelpProvider> getProvidersMap() {
        if (fProvidersMap == null) {
            fProvidersMap = new HashMap<String, ICHelpProvider>();
        }
        return fProvidersMap;
    }

    private static ICHelpProvider getCHelpProvider(IConfigurationElement element) {
        String id = element.getAttribute(ATTRIBUTE_ID);
        if (id == null || id.isEmpty()) {
            return null;
        }
        Map<String, ICHelpProvider> providersMap = CHelpProviderDescriptor.getProvidersMap();
        try {
            ICHelpProvider provider = providersMap.get(id);
            if (provider == null) {
                provider = (ICHelpProvider)element.createExecutableExtension(CLASS);
                providersMap.put(id, provider);
                final ICHelpProvider c = provider;
                ISafeRunnable runnable = new ISafeRunnable(){

                    public void run() throws Exception {
                        c.initialize();
                    }

                    public void handleException(Throwable exception) {
                    }
                };
                SafeRunner.run((ISafeRunnable)runnable);
            }
            return provider;
        }
        catch (Exception e) {
            return null;
        }
    }

    public IConfigurationElement getConfigurationElement() {
        return this.fConfigElement;
    }

    public ICHelpProvider getCHelpProvider() {
        if (this.fHelpProvider == null) {
            this.fHelpProvider = CHelpProviderDescriptor.getCHelpProvider(this.fConfigElement);
        }
        return this.fHelpProvider;
    }

    public CHelpBookDescriptor[] getCHelpBookDescriptors(Element projectElement) {
        if (this.fHelpBookDescriptors == null || projectElement != null) {
            ICHelpBook[] books;
            ICHelpProvider provider = this.getCHelpProvider();
            if (provider != null && this.fProject != null && (books = provider.getCHelpBooks()) != null) {
                ArrayList<CHelpBookDescriptor> descriptorList = new ArrayList<CHelpBookDescriptor>();
                int i = 0;
                while (i < books.length) {
                    CHelpBookDescriptor des = new CHelpBookDescriptor(books[i], projectElement);
                    if (des.matches(this.fProject)) {
                        descriptorList.add(des);
                    }
                    ++i;
                }
                this.fHelpBookDescriptors = descriptorList.toArray(new CHelpBookDescriptor[descriptorList.size()]);
            }
            if (this.fHelpBookDescriptors == null) {
                this.fHelpBookDescriptors = new CHelpBookDescriptor[0];
            }
        }
        return this.fHelpBookDescriptors;
    }

    public CHelpBookDescriptor[] getCHelpBookDescriptors() {
        return this.getCHelpBookDescriptors(null);
    }

    ICHelpBook[] getEnabledMatchedCHelpBooks(ICHelpInvocationContext context) {
        CHelpBookDescriptor[] bookDescriptors = this.getCHelpBookDescriptors();
        if (bookDescriptors.length == 0) {
            return null;
        }
        ArrayList<ICHelpBook> bookList = new ArrayList<ICHelpBook>();
        int i = 0;
        while (i < bookDescriptors.length) {
            if (bookDescriptors[i].isEnabled() && bookDescriptors[i].matches(context)) {
                bookList.add(bookDescriptors[i].getCHelpBook());
            }
            ++i;
        }
        return bookList.toArray(new ICHelpBook[bookList.size()]);
    }

    public void serialize(Document doc, Element parentElement) {
        String id = this.getConfigurationElement().getAttribute(ATTRIBUTE_ID);
        if (id == null || id.isEmpty()) {
            return;
        }
        CHelpBookDescriptor[] bookDescriptors = this.getCHelpBookDescriptors();
        Element providerElement = doc.createElement(ELEMENT_PROVIDER);
        providerElement.setAttribute(ATTRIBUTE_ID, id);
        parentElement.appendChild(providerElement);
        int i = 0;
        while (i < bookDescriptors.length) {
            bookDescriptors[i].serialize(doc, providerElement);
            ++i;
        }
    }
}

