/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model;

import java.util.Map;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.ITmfXmlAction;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.TmfXmlScenarioInfo;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.IXmlStateSystemContainer;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.pattern.stateprovider.XmlPatternStateProvider;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;

public class UpdateStoredFieldsAction
implements ITmfXmlAction {
    private final IXmlStateSystemContainer fParent;

    public UpdateStoredFieldsAction(IXmlStateSystemContainer parent) {
        this.fParent = parent;
    }

    @Override
    public void execute(ITmfEvent event, TmfXmlScenarioInfo scenarioInfo) {
        if (this.fParent instanceof XmlPatternStateProvider) {
            for (Map.Entry<String, String> entry : ((XmlPatternStateProvider)this.fParent).getStoredFields().entrySet()) {
                ITmfEventField eventField = event.getContent().getField(new String[]{entry.getKey()});
                TmfStateValue stateValue = null;
                if (eventField == null) continue;
                String alias = entry.getValue();
                Object field = eventField.getValue();
                if (field instanceof String) {
                    stateValue = TmfStateValue.newValueString((String)((String)field));
                } else if (field instanceof Long) {
                    stateValue = TmfStateValue.newValueLong((long)((Long)field));
                } else if (field instanceof Integer) {
                    stateValue = TmfStateValue.newValueInt((int)((Integer)field));
                } else if (field instanceof Double) {
                    stateValue = TmfStateValue.newValueDouble((double)((Double)field));
                }
                if (stateValue == null) {
                    throw new IllegalStateException("State value is null. Invalid type.");
                }
                ((XmlPatternStateProvider)this.fParent).getHistoryBuilder().updateStoredFields(this.fParent, alias, (ITmfStateValue)stateValue, scenarioInfo, event);
            }
        }
    }
}

