/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile;

import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.Activator;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.AnalysisCompilationData;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.IDataDrivenCompilationUnit;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.TmfXmlConditionCu;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.TmfXmlStateSystemPathCu;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.TmfXmlStateValueCu;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenAction;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenActionConditional;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenActionStateChange;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenCondition;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenStateSystemPath;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.values.DataDrivenValue;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.XmlUtils;
import org.eclipse.tracecompass.tmf.analysis.xml.core.module.TmfXmlUtils;
import org.w3c.dom.Element;

public abstract class TmfXmlStateChangeCu
implements IDataDrivenCompilationUnit {
    @Override
    public abstract DataDrivenAction generate();

    public static @Nullable TmfXmlStateChangeCu compile(AnalysisCompilationData analysisData, Element stateChange) {
        List<Element> childElements = TmfXmlUtils.getChildElements(stateChange, "if");
        if (childElements.size() == 1) {
            return TmfXmlStateChangeCu.compileConditionalChange(analysisData, stateChange, childElements.get(0));
        }
        if (childElements.size() > 1) {
            Activator.logError("Conditional State Change: There should be only 1 if node");
            return null;
        }
        return TmfXmlStateChangeCu.compileAssignationChange(analysisData, stateChange);
    }

    private static @Nullable TmfXmlStateChangeCu compileConditionalChange(AnalysisCompilationData analysisData, Element stateChange, Element ifNode) {
        List<@Nullable Element> childElements = XmlUtils.getChildElements(ifNode);
        if (childElements.size() != 1) {
            Activator.logError("There should be only one element under this condition");
            return null;
        }
        Element subCondition = Objects.requireNonNull(childElements.get(0));
        TmfXmlConditionCu condition = TmfXmlConditionCu.compile(analysisData, subCondition);
        if (condition == null) {
            return null;
        }
        List<Element> thenElements = TmfXmlUtils.getChildElements(stateChange, "then");
        if (thenElements.size() != 1) {
            Activator.logError("Conditional State Change: There should be 1 and only 1 then element");
            return null;
        }
        TmfXmlStateChangeCu thenChange = TmfXmlStateChangeCu.compile(analysisData, thenElements.get(0));
        if (thenChange == null) {
            return null;
        }
        List<Element> elseElements = TmfXmlUtils.getChildElements(stateChange, "else");
        if (elseElements.isEmpty()) {
            return new TmfXmlConditionalStateChangeCu(condition, thenChange, null);
        }
        if (thenElements.size() != 1) {
            Activator.logError("Conditional State Change: There should be at most 1 else element");
            return null;
        }
        TmfXmlStateChangeCu elseChange = TmfXmlStateChangeCu.compile(analysisData, elseElements.get(0));
        if (elseChange == null) {
            return null;
        }
        return new TmfXmlConditionalStateChangeCu(condition, thenChange, elseChange);
    }

    private static @Nullable TmfXmlStateChangeCu compileAssignationChange(AnalysisCompilationData analysisContent, Element stateChange) {
        List<@NonNull Element> leftOperands = TmfXmlUtils.getChildElements(stateChange, "stateAttribute");
        List<@NonNull Element> rightOperands = TmfXmlUtils.getChildElements(stateChange, "stateValue");
        List<@NonNull Element> futureTimes = TmfXmlUtils.getChildElements(stateChange, "futureTime");
        if (rightOperands.size() != 1) {
            Activator.logError("There should only be one state Value in this state change");
        }
        Element rightOperand = rightOperands.get(0);
        TmfXmlStateSystemPathCu path = TmfXmlStateSystemPathCu.compile(analysisContent, leftOperands);
        if (path == null) {
            return null;
        }
        if (futureTimes.size() > 1) {
            Activator.logError("There should at most one future time for this state change");
        }
        Element futureTime = futureTimes.isEmpty() ? null : futureTimes.get(0);
        TmfXmlStateValueCu futureTimeCu = null;
        if (futureTime != null && (futureTimeCu = TmfXmlStateValueCu.compileValue(analysisContent, futureTime)) == null) {
            return null;
        }
        TmfXmlStateValueCu rightOperandCu = TmfXmlStateValueCu.compileValue(analysisContent, rightOperand);
        if (rightOperandCu == null) {
            return null;
        }
        boolean increment = Boolean.parseBoolean(rightOperand.getAttribute("increment"));
        boolean update = Boolean.parseBoolean(rightOperand.getAttribute("update"));
        String stack = rightOperand.getAttribute("stack");
        DataDrivenActionStateChange.StackAction stackAction = DataDrivenActionStateChange.StackAction.getTypeFromString(stack);
        if (update && stackAction != DataDrivenActionStateChange.StackAction.NONE) {
            Activator.logError("State change: Update cannot be done with stack action " + (Object)((Object)stackAction));
            return null;
        }
        if (increment && stackAction != DataDrivenActionStateChange.StackAction.NONE) {
            Activator.logError("State change: Increment cannot be done with stack action " + (Object)((Object)stackAction));
            return null;
        }
        return new TmfXmlStateChangeAssignationCu(path, rightOperandCu, increment, update, stackAction, futureTimeCu);
    }

    private static class TmfXmlConditionalStateChangeCu
    extends TmfXmlStateChangeCu {
        private final TmfXmlConditionCu fCondition;
        private final TmfXmlStateChangeCu fThen;
        private final @Nullable TmfXmlStateChangeCu fElse;

        public TmfXmlConditionalStateChangeCu(TmfXmlConditionCu condition, TmfXmlStateChangeCu thenChange, @Nullable TmfXmlStateChangeCu elseChange) {
            this.fCondition = condition;
            this.fThen = thenChange;
            this.fElse = elseChange;
        }

        @Override
        public DataDrivenAction generate() {
            DataDrivenCondition condition = this.fCondition.generate();
            DataDrivenAction thenChange = this.fThen.generate();
            DataDrivenAction elseChange = this.fElse != null ? this.fElse.generate() : null;
            return new DataDrivenActionConditional(condition, thenChange, elseChange);
        }
    }

    private static class TmfXmlStateChangeAssignationCu
    extends TmfXmlStateChangeCu {
        private TmfXmlStateSystemPathCu fPath;
        private TmfXmlStateValueCu fRightOperand;
        private boolean fIncrement;
        private boolean fUpdate;
        private DataDrivenActionStateChange.StackAction fStackAction;
        private @Nullable TmfXmlStateValueCu fFutureTime;

        public TmfXmlStateChangeAssignationCu(TmfXmlStateSystemPathCu path, TmfXmlStateValueCu rightOperandCu, boolean increment, boolean update, DataDrivenActionStateChange.StackAction stackAction, @Nullable TmfXmlStateValueCu futureTime) {
            this.fPath = path;
            this.fRightOperand = rightOperandCu;
            this.fIncrement = increment;
            this.fUpdate = update;
            this.fStackAction = stackAction;
            this.fFutureTime = futureTime;
        }

        @Override
        public DataDrivenAction generate() {
            DataDrivenStateSystemPath path = this.fPath.generate();
            DataDrivenValue rightOperand = this.fRightOperand.generate();
            DataDrivenValue futureTime = null;
            if (this.fFutureTime != null) {
                futureTime = this.fFutureTime.generate();
            }
            return new DataDrivenActionStateChange(path, rightOperand, this.fIncrement, this.fUpdate, this.fStackAction, futureTime);
        }
    }
}

