/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro.universal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.ui.internal.intro.universal.BaseData;
import org.eclipse.ui.internal.intro.universal.ExtensionData;
import org.eclipse.ui.internal.intro.universal.SeparatorData;

public class ExtensionDataTransfer
extends ByteArrayTransfer {
    private static final String MYTYPENAME = "ExtensionData";
    private static final int MYTYPEID = ExtensionDataTransfer.registerType((String)"ExtensionData");
    private static ExtensionDataTransfer _instance = new ExtensionDataTransfer();

    public static ExtensionDataTransfer getInstance() {
        return _instance;
    }

    protected String[] getTypeNames() {
        return new String[]{MYTYPENAME};
    }

    protected int[] getTypeIds() {
        return new int[]{MYTYPEID};
    }

    public void javaToNative(Object object, TransferData transferData) {
        if (!this.checkMyType(object) || !this.isSupportedType(transferData)) {
            DND.error((int)2003);
        }
        BaseData[] myTypes = (BaseData[])object;
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            DataOutputStream writeOut = new DataOutputStream(out);
            int i = 0;
            int length = myTypes.length;
            while (i < length) {
                BaseData bd = myTypes[i];
                boolean separator = bd instanceof SeparatorData;
                writeOut.writeBoolean(separator);
                byte[] buffer = bd.getId().getBytes();
                writeOut.writeInt(bd.getId().length());
                writeOut.write(buffer);
                if (bd instanceof ExtensionData) {
                    ExtensionData ed = (ExtensionData)bd;
                    writeOut.writeInt(ed.getName().length());
                    buffer = ed.getName().getBytes();
                    writeOut.write(buffer);
                    writeOut.writeInt(ed.getImportance());
                }
                ++i;
            }
            byte[] buffer = out.toByteArray();
            writeOut.close();
            super.javaToNative((Object)buffer, transferData);
        }
        catch (IOException iOException) {}
    }

    public Object nativeToJava(TransferData transferData) {
        if (this.isSupportedType(transferData)) {
            byte[] buffer = (byte[])super.nativeToJava(transferData);
            if (buffer == null) {
                return null;
            }
            BaseData[] myData = new BaseData[]{};
            try {
                ByteArrayInputStream in = new ByteArrayInputStream(buffer);
                DataInputStream readIn = new DataInputStream(in);
                while (readIn.available() > 4) {
                    int importance = 0;
                    String name = null;
                    boolean separator = readIn.readBoolean();
                    int size = readIn.readInt();
                    byte[] buff = new byte[size];
                    readIn.read(buff);
                    String id = new String(buff);
                    if (!separator) {
                        size = readIn.readInt();
                        buff = new byte[size];
                        readIn.read(buff);
                        name = new String(buff);
                        importance = readIn.readInt();
                    }
                    BaseData[] newMyData = new BaseData[myData.length + 1];
                    System.arraycopy(myData, 0, newMyData, 0, myData.length);
                    newMyData[myData.length] = separator ? new SeparatorData(id) : new ExtensionData(id, name, importance);
                    myData = newMyData;
                }
                readIn.close();
            }
            catch (IOException iOException) {
                return null;
            }
            return myData;
        }
        return null;
    }

    boolean checkMyType(Object object) {
        if (object == null || !(object instanceof BaseData[]) || ((BaseData[])object).length == 0) {
            return false;
        }
        BaseData[] myTypes = (BaseData[])object;
        int i = 0;
        while (i < myTypes.length) {
            if (myTypes[i] == null || myTypes[i].getId() == null || myTypes[i] instanceof ExtensionData && ((ExtensionData)myTypes[i]).getName() == null) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected boolean validate(Object object) {
        return this.checkMyType(object);
    }
}

