/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal;

import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.IContext;
import org.eclipse.help.IContext2;
import org.eclipse.help.IHelpResource;
import org.eclipse.help.UAContentFilter;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.base.HelpEvaluationContext;
import org.eclipse.help.ui.internal.DefaultHelpUI;
import org.eclipse.help.ui.internal.HelpUIPlugin;
import org.eclipse.help.ui.internal.HelpUIResources;
import org.eclipse.help.ui.internal.HyperlinkAdapter;
import org.eclipse.help.ui.internal.HyperlinkHandler;
import org.eclipse.help.ui.internal.HyperlinkLabel;
import org.eclipse.help.ui.internal.Messages;
import org.eclipse.help.ui.internal.StyledLineWrapper;
import org.eclipse.help.ui.internal.views.HelpTray;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ContextHelpDialog {
    private Color backgroundColour = null;
    private IContext context;
    private Color foregroundColour = null;
    private Color linkColour = null;
    private static HyperlinkHandler linkManager = new HyperlinkHandler();
    protected Shell parentShell;
    protected Shell shell;
    protected String infopopText;

    ContextHelpDialog(IContext context, int x, int y) {
        this.context = context;
        Display display = Display.getCurrent();
        if (display == null) {
            return;
        }
        this.backgroundColour = display.getSystemColor(29);
        this.foregroundColour = display.getSystemColor(28);
        this.linkColour = display.getSystemColor(9);
        this.parentShell = PlatformUI.getWorkbench().getModalDialogShellProvider().getShell();
        if (this.parentShell != null) {
            boolean isModal;
            boolean bl = isModal = (this.parentShell.getStyle() & 0x38000) > 0;
            if (HelpUIPlugin.DEBUG_INFOPOP) {
                System.out.println("ContextHelpDialog.ContextHelpDialog(): ParentShell: " + this.parentShell.toString() + " is " + (isModal ? "modal" : "modeless"));
            }
        }
        this.shell = new Shell(this.parentShell, 0);
        if (HelpUIPlugin.DEBUG_INFOPOP) {
            System.out.println("ContextHelpDialog.ContextHelpDialog(): Shell is:" + this.shell.toString());
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.shell, "org.eclipse.help.ui.f1Shell");
        this.shell.addListener(27, e -> {
            if (HelpUIPlugin.DEBUG_INFOPOP) {
                System.out.println("ContextHelpDialog shell deactivate listener: SWT.Deactivate called. ");
            }
            this.close();
        });
        this.shell.addTraverseListener(e -> {
            if (e.detail == 2) {
                if (HelpUIPlugin.DEBUG_INFOPOP) {
                    System.out.println("ContextHelpDialog: shell traverse listener: SWT.TRAVERSE_ESCAPE called. ");
                }
                e.doit = true;
            }
        });
        this.shell.addControlListener((ControlListener)new ControlAdapter(){

            public void controlMoved(ControlEvent e) {
                if (HelpUIPlugin.DEBUG_INFOPOP) {
                    System.out.println("ContextHelpDialog: shell control adapter called.");
                }
                Rectangle clientArea = ContextHelpDialog.this.shell.getClientArea();
                ContextHelpDialog.this.shell.redraw(clientArea.x, clientArea.y, clientArea.width, clientArea.height, true);
                ContextHelpDialog.this.shell.update();
            }
        });
        if (HelpUIPlugin.DEBUG_INFOPOP) {
            System.out.println("ContextHelpDialog.ContextHelpDialog(): Focus owner is: " + Display.getCurrent().getFocusControl().toString());
        }
        linkManager.setHyperlinkUnderlineMode(3);
        this.createContents((Composite)this.shell);
        this.shell.pack();
        int width = this.shell.getBounds().width;
        int height = this.shell.getBounds().height;
        Rectangle screen = display.getClientArea();
        x = x >= screen.x ? x : screen.x;
        y = y >= screen.y ? y : screen.y;
        x = x + width <= screen.width ? x : screen.width - width;
        y = y + height <= screen.height ? y : screen.height - height;
        this.shell.setLocation(x, y);
        this.initAccessible((Control)this.shell);
    }

    public synchronized void close() {
        try {
            if (HelpUIPlugin.DEBUG_INFOPOP) {
                System.out.println("ContextHelpDialog.close()");
            }
            if (this.shell != null) {
                this.shell.close();
                if (!this.shell.isDisposed()) {
                    this.shell.dispose();
                }
                this.shell = null;
            }
        }
        catch (Throwable throwable) {}
    }

    protected Control createContents(Composite contents) {
        this.initAccessible((Control)contents);
        contents.setBackground(this.backgroundColour);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        contents.setLayout((Layout)layout);
        contents.setLayoutData((Object)new GridData(1808));
        this.createInfoArea(contents);
        Control c = this.createLinksArea(contents);
        if (c != null) {
            contents.setTabList(new Control[]{c});
        }
        return contents;
    }

    private Control createInfoArea(Composite parent) {
        String styledText = null;
        if (this.context instanceof IContext2) {
            styledText = ((IContext2)this.context).getStyledText();
        }
        if (styledText == null && this.context.getText() != null) {
            styledText = this.context.getText();
            styledText = styledText.replaceAll("<b>", "<@#\\$b>");
            styledText = styledText.replaceAll("</b>", "</@#\\$b>");
        }
        if (styledText == null) {
            styledText = Messages.ContextHelpPart_noDescription;
        }
        Description text = new Description(parent, 10);
        text.addTraverseListener(e -> {
            if (e.detail == 2) {
                if (HelpUIPlugin.DEBUG_INFOPOP) {
                    System.out.println("ContextHelpDialog text TraverseListener.handleEvent(): SWT.TRAVERSE_ESCAPE.");
                }
                e.doit = true;
            }
        });
        text.getCaret().setVisible(false);
        text.setBackground(this.backgroundColour);
        text.setForeground(this.foregroundColour);
        text.setFont(parent.getFont());
        int linkWidth = this.getLinksWidth(text);
        StyledLineWrapper content = new StyledLineWrapper(styledText, (Drawable)text, linkWidth + 70);
        text.setContent(content);
        text.setStyleRanges(content.getStyles());
        this.infopopText = text.getText();
        this.initAccessible((Control)text);
        return text;
    }

    private int getLinksWidth(Description text) {
        int linkWidth = 0;
        IHelpResource[] relatedTopics = this.context.getRelatedTopics();
        if (relatedTopics != null) {
            GC gc = new GC((Drawable)text);
            int i = 0;
            while (i < relatedTopics.length) {
                linkWidth = Math.max(linkWidth, gc.textExtent((String)relatedTopics[i].getLabel()).x);
                ++i;
            }
            gc.dispose();
        }
        return linkWidth;
    }

    private Control createLink(Composite parent, IHelpResource topic) {
        Label image = new Label(parent, 0);
        image.setImage(this.getImage());
        image.setBackground(this.backgroundColour);
        GridData data = new GridData();
        data.horizontalAlignment = 32;
        data.verticalAlignment = 2;
        image.setLayoutData((Object)data);
        HyperlinkLabel link = new HyperlinkLabel(parent, 0);
        link.setText(topic.getLabel());
        link.setBackground(this.backgroundColour);
        link.setForeground(this.linkColour);
        link.setFont(parent.getFont());
        linkManager.registerHyperlink((Control)link, new LinkListener(topic));
        return link;
    }

    private Control createLinksArea(Composite parent) {
        IHelpResource[] relatedTopics = this.context.getRelatedTopics();
        if (relatedTopics == null) {
            return null;
        }
        Composite composite = new Composite(parent, 0);
        this.initAccessible((Control)composite);
        composite.setBackground(this.backgroundColour);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 2;
        layout.marginWidth = 0;
        layout.verticalSpacing = 3;
        layout.horizontalSpacing = 2;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        composite.setFont(parent.getFont());
        GridData data = new GridData(1844);
        composite.setLayoutData((Object)data);
        Label label = new Label(composite, 258);
        label.setBackground(this.backgroundColour);
        label.setForeground(this.foregroundColour);
        data = new GridData(802);
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        int i = 0;
        while (i < relatedTopics.length) {
            if (!UAContentFilter.isFiltered((Object)relatedTopics[i], (IEvaluationContext)HelpEvaluationContext.getContext())) {
                this.createLink(composite, relatedTopics[i]);
            }
            ++i;
        }
        IWorkbenchWindow wbWindow = HelpUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        if (DefaultHelpUI.isActiveShell(this.parentShell, wbWindow) || HelpTray.isAppropriateFor(this.parentShell)) {
            label = new Label(composite, 258);
            label.setBackground(this.backgroundColour);
            label.setForeground(this.foregroundColour);
            data = new GridData(802);
            data.horizontalSpan = 2;
            label.setLayoutData((Object)data);
            this.createDynamicHelpLink(composite);
        }
        return composite;
    }

    private Control createDynamicHelpLink(Composite parent) {
        Label image = new Label(parent, 0);
        Image img = HelpUIResources.getImage("view16/help_view.gif");
        image.setImage(img);
        image.setBackground(this.backgroundColour);
        GridData data = new GridData();
        data.horizontalAlignment = 32;
        data.verticalAlignment = 2;
        image.setLayoutData((Object)data);
        HyperlinkLabel link = new HyperlinkLabel(parent, 0);
        link.setText(Messages.ContextHelpDialog_showInDynamicHelp);
        link.setBackground(this.backgroundColour);
        link.setForeground(this.linkColour);
        link.setFont(parent.getFont());
        linkManager.registerHyperlink((Control)link, new HyperlinkAdapter(){

            @Override
            public void linkActivated(Control label) {
                ContextHelpDialog.this.openDynamicHelp();
            }
        });
        return link;
    }

    protected void launchLinks(IHelpResource selectedTopic) {
        this.close();
        if (HelpUIPlugin.DEBUG_INFOPOP) {
            System.out.println("ContextHelpDialog.launchLinks(): closed shell");
        }
        BaseHelpSystem.getHelpDisplay().displayHelp(this.context, selectedTopic, DefaultHelpUI.isDisplayModal(this.parentShell) && !"win32".equalsIgnoreCase(Platform.getOS()));
    }

    private void openDynamicHelp() {
        BusyIndicator.showWhile((Display)this.shell.getDisplay(), () -> {
            this.close();
            DefaultHelpUI.getInstance().displayContext(this.context, 0, 0, true);
        });
    }

    public synchronized void open() {
        try {
            this.shell.open();
            if (HelpUIPlugin.DEBUG_INFOPOP) {
                System.out.println("ContextHelpDialog.open(): Focus owner after open is: " + Display.getCurrent().getFocusControl().toString());
            }
        }
        catch (Throwable e) {
            HelpUIPlugin.logError("An error occurred when opening context-sensitive help pop-up.", e);
        }
    }

    private Image getImage() {
        return HelpUIResources.getImage("obj16/topic_small.gif");
    }

    public boolean isShowing() {
        return this.shell != null && !this.shell.isDisposed() && this.shell.isVisible();
    }

    private void initAccessible(final Control control) {
        Accessible accessible = control.getAccessible();
        accessible.addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = ContextHelpDialog.this.infopopText;
            }

            public void getHelp(AccessibleEvent e) {
                e.result = control.getToolTipText();
            }
        });
        accessible.addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent e) {
                Point pt = control.toControl(new Point(e.x, e.y));
                e.childID = control.getBounds().contains(pt) ? -3 : -2;
            }

            public void getLocation(AccessibleControlEvent e) {
                Rectangle location = control.getBounds();
                Point pt = control.toDisplay(new Point(location.x, location.y));
                e.x = pt.x;
                e.y = pt.y;
                e.width = location.width;
                e.height = location.height;
            }

            public void getChildCount(AccessibleControlEvent e) {
                e.detail = 1;
            }

            public void getRole(AccessibleControlEvent e) {
                e.detail = 41;
            }

            public void getState(AccessibleControlEvent e) {
                e.detail = 64;
            }
        });
    }

    public class Description
    extends StyledText {
        public Description(Composite parent, int style) {
            super(parent, style);
        }

        public boolean setFocus() {
            return false;
        }

        public boolean isFocusControl() {
            return false;
        }
    }

    class LinkListener
    extends HyperlinkAdapter {
        IHelpResource topic;

        public LinkListener(IHelpResource topic) {
            this.topic = topic;
        }

        @Override
        public void linkActivated(Control c) {
            ContextHelpDialog.this.launchLinks(this.topic);
        }
    }
}

