/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.wizard;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.tools.transfer.IDataTransferConsumer;
import org.jkiss.dbeaver.tools.transfer.IDataTransferProducer;
import org.jkiss.dbeaver.tools.transfer.IDataTransferSettings;
import org.jkiss.dbeaver.tools.transfer.internal.DTActivator;
import org.jkiss.dbeaver.tools.transfer.internal.DTMessages;
import org.jkiss.dbeaver.tools.transfer.wizard.DataTransferJob;
import org.jkiss.dbeaver.tools.transfer.wizard.DataTransferPageFinal;
import org.jkiss.dbeaver.tools.transfer.wizard.DataTransferPagePipes;
import org.jkiss.dbeaver.tools.transfer.wizard.DataTransferPipe;
import org.jkiss.dbeaver.tools.transfer.wizard.DataTransferSettings;
import org.jkiss.dbeaver.ui.UIUtils;

public class DataTransferWizard
extends Wizard
implements IExportWizard {
    private static final String RS_EXPORT_WIZARD_DIALOG_SETTINGS = "DataTransfer";
    private DataTransferSettings settings;
    private IStructuredSelection currentSelection;

    public DataTransferWizard(@Nullable IDataTransferProducer[] producers, @Nullable IDataTransferConsumer[] consumers) {
        this.settings = new DataTransferSettings(producers, consumers);
        this.setDialogSettings(UIUtils.getSettingsSection((IDialogSettings)DTActivator.getDefault().getDialogSettings(), (String)RS_EXPORT_WIZARD_DIALOG_SETTINGS));
        this.loadSettings();
    }

    public IStructuredSelection getCurrentSelection() {
        return this.currentSelection;
    }

    public DataTransferSettings getSettings() {
        return this.settings;
    }

    public <T extends IDataTransferSettings> T getPageSettings(IWizardPage page, Class<T> type) {
        return (T)((IDataTransferSettings)type.cast(this.settings.getNodeSettings(page)));
    }

    public void addPages() {
        super.addPages();
        if (this.settings.isConsumerOptional() || this.settings.isProducerOptional()) {
            this.addPage((IWizardPage)new DataTransferPagePipes());
        }
        this.settings.addWizardPages(this);
        this.addPage((IWizardPage)new DataTransferPageFinal());
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        this.setWindowTitle(DTMessages.data_transfer_wizard_name);
        this.setNeedsProgressMonitor(true);
        this.currentSelection = currentSelection;
    }

    @Nullable
    public IWizardPage getNextPage(IWizardPage page) {
        IWizardPage[] pages = this.getPages();
        int curIndex = -1;
        int i = 0;
        while (i < pages.length) {
            if (pages[i] == page) {
                curIndex = i;
                break;
            }
            ++i;
        }
        if (curIndex == pages.length - 1) {
            return null;
        }
        if (curIndex != -1) {
            i = curIndex + 1;
            while (i < pages.length) {
                if (this.settings.isPageValid(pages[i])) {
                    return pages[i];
                }
                ++i;
            }
        }
        return pages[pages.length - 1];
    }

    @Nullable
    public IWizardPage getPreviousPage(IWizardPage page) {
        IWizardPage[] pages = this.getPages();
        int curIndex = -1;
        int i = 0;
        while (i < pages.length) {
            if (pages[i] == page) {
                curIndex = i;
                break;
            }
            ++i;
        }
        if (curIndex == 0) {
            return null;
        }
        if (curIndex != -1) {
            i = curIndex - 1;
            while (i > 0) {
                if (this.settings.isPageValid(pages[i])) {
                    return pages[i];
                }
                --i;
            }
        }
        return pages[0];
    }

    public boolean canFinish() {
        IWizardPage[] iWizardPageArray = this.getPages();
        int n = iWizardPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardPage page = iWizardPageArray[n2];
            if (this.settings.isPageValid(page) && !page.isPageComplete()) {
                return false;
            }
            if (page instanceof DataTransferPageFinal && !((DataTransferPageFinal)page).isActivated()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean performCancel() {
        this.saveSettings();
        return super.performCancel();
    }

    public boolean performFinish() {
        this.saveSettings();
        DTActivator.getDefault().saveDialogSettings();
        try {
            UIUtils.run((IRunnableContext)this.getContainer(), (boolean)true, (boolean)true, (DBRRunnableWithProgress)new DBRRunnableWithProgress(){

                public void run(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        for (DataTransferPipe pipe : DataTransferWizard.this.settings.getDataPipes()) {
                            pipe.getConsumer().startTransfer(monitor);
                        }
                    }
                    catch (DBException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            DBWorkbench.getPlatformUI().showError("Transfer init failed", "Can't start data transfer", e.getTargetException());
            return false;
        }
        catch (InterruptedException e) {
            return false;
        }
        this.executeJobs();
        return true;
    }

    private void loadSettings() {
        this.settings.loadFrom((IRunnableContext)UIUtils.getActiveWorkbenchWindow(), this.getDialogSettings());
    }

    private void saveSettings() {
        this.settings.saveTo(this.getDialogSettings());
    }

    private void executeJobs() {
        int totalJobs = this.settings.getDataPipes().size();
        if (totalJobs > this.settings.getMaxJobCount()) {
            totalJobs = this.settings.getMaxJobCount();
        }
        int i = 0;
        while (i < totalJobs) {
            new DataTransferJob(this.settings).schedule();
            ++i;
        }
    }
}

