/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.data.aggregate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.data.aggregate.FunctionNumeric;
import org.jkiss.dbeaver.model.data.aggregate.IAggregateFunction;

public class FunctionMedian
implements IAggregateFunction {
    private static final Log log = Log.getLog(FunctionMedian.class);
    private List<Comparable> cache = new ArrayList<Comparable>();

    @Override
    public boolean accumulate(Object value) {
        if ((value = FunctionNumeric.getComparable(value)) != null) {
            this.cache.add((Comparable)value);
            return true;
        }
        return false;
    }

    @Override
    public Object getResult(int valueCount) {
        try {
            Collections.sort(this.cache);
        }
        catch (Exception e) {
            log.debug("Can't sort value collection", e);
            return null;
        }
        int size = this.cache.size();
        int middle = size / 2;
        if (size % 2 == 1) {
            return this.cache.get(middle);
        }
        Comparable val1 = this.cache.get(middle - 1);
        Comparable val2 = this.cache.get(middle);
        if (val1 instanceof Number && val2 instanceof Number) {
            return (((Number)((Object)val1)).doubleValue() + ((Number)((Object)val2)).doubleValue()) / 2.0;
        }
        return val1;
    }
}

