/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.ui.tipoftheday;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jkiss.utils.xml.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TipsXmlHandler
extends DefaultHandler {
    private static final String TIP = "tip";
    private boolean tipTagStarted;
    private StringBuilder tipTagContent = new StringBuilder();
    private List<String> tips = new ArrayList<String>();
    private static final String BR = "br";
    private static final List<String> HTML_TAGS = Arrays.asList("br", "b", "i", "u", "q", "a", "p", "div");
    private static final String TAG_BRACKET_BEGIN = "<";
    private static final String TAG_BRACKET_END = ">";
    private static final String SLASH = "/";

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (HTML_TAGS.contains(qName) && this.tipTagStarted) {
            this.tipTagContent.append(TAG_BRACKET_BEGIN).append(qName);
            int i = 0;
            while (i < attributes.getLength()) {
                this.tipTagContent.append(" ").append(attributes.getQName(i)).append("=\"").append(XMLUtils.escapeXml((CharSequence)attributes.getValue(i))).append("\"");
                ++i;
            }
            this.tipTagContent.append(TAG_BRACKET_END);
        }
        if (qName.equalsIgnoreCase(TIP)) {
            this.tipTagStarted = true;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.tipTagStarted) {
            this.tipTagContent.append(new String(ch, start, length));
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equalsIgnoreCase(TIP)) {
            this.tips.add(this.tipTagContent.toString());
            this.tipTagStarted = false;
            this.tipTagContent = new StringBuilder();
        }
        if (!qName.equals(BR) && HTML_TAGS.contains(qName) && this.tipTagStarted) {
            this.tipTagContent.append(TAG_BRACKET_BEGIN).append(SLASH).append(qName).append(TAG_BRACKET_END);
        }
    }

    public List<String> getTips() {
        return this.tips;
    }
}

