/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.generic.edit;

import java.util.Map;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericTable;
import org.jkiss.dbeaver.ext.generic.model.GenericTableColumn;
import org.jkiss.dbeaver.model.DBConstants;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.impl.DBSObjectCache;
import org.jkiss.dbeaver.model.impl.edit.DBECommandAbstract;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTable;
import org.jkiss.dbeaver.model.impl.sql.edit.struct.SQLTableColumnManager;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.editors.object.struct.AttributeEditPage;
import org.jkiss.utils.CommonUtils;

public class GenericTableColumnManager
extends SQLTableColumnManager<GenericTableColumn, GenericTable> {
    @Nullable
    public DBSObjectCache<? extends DBSObject, GenericTableColumn> getObjectsCache(GenericTableColumn object) {
        return ((GenericStructContainer)((GenericTable)object.getParentObject()).getContainer()).getTableCache().getChildrenCache((DBSObject)((GenericTable)object.getParentObject()));
    }

    protected GenericTableColumn createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, GenericTable parent, Object copyFrom) throws DBException {
        DBSDataType columnType = GenericTableColumnManager.findBestDataType((DBPDataSource)parent.getDataSource(), (String[])DBConstants.DEFAULT_DATATYPE_NAMES);
        int columnSize = columnType != null && columnType.getDataKind() == DBPDataKind.STRING ? 100 : 0;
        final GenericTableColumn column = ((GenericDataSource)parent.getDataSource()).getMetaModel().createTableColumnImpl(monitor, parent, this.getNewColumnName(monitor, context, parent), columnType == null ? "INTEGER" : columnType.getName(), columnType == null ? 4 : columnType.getTypeID(), columnType == null ? 4 : columnType.getTypeID(), -1, columnSize, columnSize, null, null, 10, false, null, null, false, false);
        column.setPersisted(false);
        return (GenericTableColumn)((Object)new UITask<GenericTableColumn>(){

            protected GenericTableColumn runTask() {
                AttributeEditPage page = new AttributeEditPage(null, (DBSEntityAttribute)column);
                if (!page.edit()) {
                    return null;
                }
                return column;
            }
        }.execute());
    }

    public StringBuilder getNestedDeclaration(DBRProgressMonitor monitor, GenericTable owner, DBECommandAbstract<GenericTableColumn> command, Map<String, Object> options) {
        String autoIncrementClause;
        StringBuilder decl = super.getNestedDeclaration(monitor, (JDBCTable)owner, command, options);
        GenericTableColumn column = (GenericTableColumn)command.getObject();
        if (column.isAutoIncrement() && (autoIncrementClause = column.getDataSource().getMetaModel().getAutoIncrementClause(column)) != null && !autoIncrementClause.isEmpty()) {
            decl.append(" ").append(autoIncrementClause);
        }
        return decl;
    }

    protected SQLTableColumnManager.ColumnModifier[] getSupportedModifiers(GenericTableColumn column, Map<String, Object> options) {
        return new SQLTableColumnManager.ColumnModifier[]{this.DataTypeModifier, this.DefaultModifier, this.NotNullModifier};
    }

    protected long getDDLFeatures(GenericTableColumn object) {
        long features = 0L;
        Object shortDrop = object.getDataSource().getContainer().getDriver().getDriverParameter("ddl-drop-column-short");
        if (shortDrop != null && CommonUtils.toBoolean((Object)shortDrop)) {
            features |= 1L;
        }
        return features;
    }
}

