/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.model.plan;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.db2.model.plan.DB2PlanAnalyser;
import org.jkiss.dbeaver.ext.db2.model.plan.DB2PlanInstance;
import org.jkiss.dbeaver.ext.db2.model.plan.DB2PlanNode;
import org.jkiss.dbeaver.ext.db2.model.plan.DB2PlanNodeType;
import org.jkiss.dbeaver.ext.db2.model.plan.DB2PlanObject;
import org.jkiss.dbeaver.ext.db2.model.plan.DB2PlanOperator;
import org.jkiss.dbeaver.ext.db2.model.plan.DB2PlanOperatorType;
import org.jkiss.dbeaver.ext.db2.model.plan.DB2PlanStream;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;

public class DB2PlanStatement {
    private static final Log LOG = Log.getLog(DB2PlanAnalyser.class);
    private static final String SEL_BASE_SELECT;
    private Map<String, DB2PlanOperator> mapOperators;
    private Map<String, DB2PlanObject> mapDataObjects;
    private List<DB2PlanStream> listStreams;
    private DB2PlanNode rootNode;
    private DB2PlanInstance planInstance;
    private String planTableSchema;
    private String explainRequester;
    private Timestamp explainTime;
    private String sourceName;
    private String sourceSchema;
    private String sourceVersion;
    private String explainLevel;
    private Integer stmtNo;
    private Integer sectNo;
    private Double totalCost;
    private String statementText;
    private Integer queryDegree;

    static {
        StringBuilder sb = new StringBuilder(1024);
        sb.append("SELECT *");
        sb.append("  FROM %s.%s");
        sb.append(" WHERE EXPLAIN_REQUESTER = ?");
        sb.append("   AND EXPLAIN_TIME = ?");
        sb.append("   AND SOURCE_NAME = ?");
        sb.append("   AND SOURCE_SCHEMA = ?");
        sb.append("   AND SOURCE_VERSION = ?");
        sb.append("   AND EXPLAIN_LEVEL = ?");
        sb.append("   AND STMTNO = ?");
        sb.append("   AND SECTNO = ?");
        sb.append(" ORDER BY %s");
        sb.append(" WITH UR");
        SEL_BASE_SELECT = sb.toString();
    }

    public DB2PlanStatement(JDBCSession session, JDBCResultSet dbResult, String planTableSchema) throws SQLException {
        this.planTableSchema = planTableSchema;
        this.explainRequester = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"EXPLAIN_REQUESTER");
        this.explainTime = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"EXPLAIN_TIME");
        this.sourceName = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"SOURCE_NAME");
        this.sourceSchema = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"SOURCE_SCHEMA");
        this.sourceVersion = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"SOURCE_VERSION");
        this.explainLevel = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"EXPLAIN_LEVEL");
        this.stmtNo = JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"STMTNO");
        this.sectNo = JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"SECTNO");
        this.totalCost = JDBCUtils.safeGetDouble((ResultSet)dbResult, (String)"TOTAL_COST");
        this.queryDegree = JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"QUERY_DEGREE");
        this.statementText = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"STATEMENT_TEXT");
        this.loadChildren(session);
    }

    public Collection<DB2PlanNode> buildNodes() {
        for (DB2PlanStream planStream : this.listStreams) {
            DB2PlanNode targetNode;
            DB2PlanNode sourceNode;
            if (planStream.getSourceType().equals((Object)DB2PlanNodeType.D)) {
                sourceNode = this.mapDataObjects.get(planStream.getSourceName());
                sourceNode = new DB2PlanObject((DB2PlanObject)sourceNode);
            } else {
                sourceNode = this.mapOperators.get(planStream.getSourceName());
            }
            if (planStream.getTargetType().equals((Object)DB2PlanNodeType.D)) {
                targetNode = this.mapDataObjects.get(planStream.getTargetName());
                targetNode = new DB2PlanObject((DB2PlanObject)targetNode);
                sourceNode.getNested().add(targetNode);
                targetNode.setParent(sourceNode);
                continue;
            }
            targetNode = this.mapOperators.get(planStream.getTargetName());
            targetNode.getNested().add(sourceNode);
            targetNode.setEstimatedCardinality(planStream.getStreamCount());
            sourceNode.setParent(targetNode);
        }
        return Collections.singletonList(this.rootNode);
    }

    private void loadChildren(JDBCSession session) throws SQLException {
        JDBCResultSet res;
        Object var6_15;
        Throwable throwable;
        JDBCPreparedStatement sqlStmt;
        this.mapDataObjects = new HashMap<String, DB2PlanObject>(32);
        Throwable throwable2 = null;
        Object var3_6 = null;
        try {
            sqlStmt = session.prepareStatement(String.format(SEL_BASE_SELECT, this.planTableSchema, "EXPLAIN_OBJECT", "OBJECT_SCHEMA,OBJECT_NAME"));
            try {
                this.setQueryParameters(sqlStmt);
                throwable = null;
                var6_15 = null;
                try {
                    res = sqlStmt.executeQuery();
                    try {
                        while (res.next()) {
                            DB2PlanObject db2PlanObject = new DB2PlanObject(res);
                            this.mapDataObjects.put(db2PlanObject.getNodeName(), db2PlanObject);
                        }
                    }
                    finally {
                        if (res != null) {
                            res.close();
                        }
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            finally {
                if (sqlStmt != null) {
                    sqlStmt.close();
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable2 == null) {
                throwable2 = throwable4;
            } else if (throwable2 != throwable4) {
                throwable2.addSuppressed(throwable4);
            }
            throw throwable2;
        }
        this.mapOperators = new HashMap<String, DB2PlanOperator>(64);
        throwable2 = null;
        var3_6 = null;
        try {
            sqlStmt = session.prepareStatement(String.format(SEL_BASE_SELECT, this.planTableSchema, "EXPLAIN_OPERATOR", "OPERATOR_ID"));
            try {
                this.setQueryParameters(sqlStmt);
                throwable = null;
                var6_15 = null;
                try {
                    res = sqlStmt.executeQuery();
                    try {
                        while (res.next()) {
                            DB2PlanOperator db2PlanOperator = new DB2PlanOperator(session, res, this, this.planTableSchema);
                            this.mapOperators.put(db2PlanOperator.getNodeName(), db2PlanOperator);
                            if (db2PlanOperator.getOperatorType() != DB2PlanOperatorType.RETURN) continue;
                            this.rootNode = db2PlanOperator;
                        }
                    }
                    finally {
                        if (res != null) {
                            res.close();
                        }
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable == null) {
                        throwable = throwable5;
                    } else if (throwable != throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    throw throwable;
                }
            }
            finally {
                if (sqlStmt != null) {
                    sqlStmt.close();
                }
            }
        }
        catch (Throwable throwable6) {
            if (throwable2 == null) {
                throwable2 = throwable6;
            } else if (throwable2 != throwable6) {
                throwable2.addSuppressed(throwable6);
            }
            throw throwable2;
        }
        this.listStreams = new ArrayList<DB2PlanStream>();
        throwable2 = null;
        var3_6 = null;
        try {
            sqlStmt = session.prepareStatement(String.format(SEL_BASE_SELECT, this.planTableSchema, "EXPLAIN_STREAM", "STREAM_ID DESC"));
            try {
                this.setQueryParameters(sqlStmt);
                throwable = null;
                var6_15 = null;
                try {
                    res = sqlStmt.executeQuery();
                    try {
                        while (res.next()) {
                            this.listStreams.add(new DB2PlanStream(res, this));
                        }
                    }
                    finally {
                        if (res != null) {
                            res.close();
                        }
                    }
                }
                catch (Throwable throwable7) {
                    if (throwable == null) {
                        throwable = throwable7;
                    } else if (throwable != throwable7) {
                        throwable.addSuppressed(throwable7);
                    }
                    throw throwable;
                }
            }
            finally {
                if (sqlStmt != null) {
                    sqlStmt.close();
                }
            }
        }
        catch (Throwable throwable8) {
            if (throwable2 == null) {
                throwable2 = throwable8;
            } else if (throwable2 != throwable8) {
                throwable2.addSuppressed(throwable8);
            }
            throw throwable2;
        }
    }

    private void setQueryParameters(JDBCPreparedStatement sqlStmt) throws SQLException {
        sqlStmt.setString(1, this.explainRequester);
        sqlStmt.setTimestamp(2, this.explainTime);
        sqlStmt.setString(3, this.sourceName);
        sqlStmt.setString(4, this.sourceSchema);
        sqlStmt.setString(5, this.sourceVersion);
        sqlStmt.setString(6, this.explainLevel);
        sqlStmt.setInt(7, this.stmtNo.intValue());
        sqlStmt.setInt(8, this.sectNo.intValue());
    }

    public DB2PlanInstance getPlanInstance() {
        return this.planInstance;
    }

    public String getExplainLevel() {
        return this.explainLevel;
    }

    public Integer getStmtNo() {
        return this.stmtNo;
    }

    public Integer getSectNo() {
        return this.sectNo;
    }

    public Double getTotalCost() {
        return this.totalCost;
    }

    public String getStatementText() {
        return this.statementText;
    }

    public Integer getQueryDegree() {
        return this.queryDegree;
    }

    public List<DB2PlanStream> getListStreams() {
        return this.listStreams;
    }

    public String getPlanTableSchema() {
        return this.planTableSchema;
    }

    public String getExplainRequester() {
        return this.explainRequester;
    }

    public Timestamp getExplainTime() {
        return this.explainTime;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public String getSourceSchema() {
        return this.sourceSchema;
    }

    public String getSourceVersion() {
        return this.sourceVersion;
    }
}

