/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.driver;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.nebula.jface.galleryviewer.FlatTreeContentProvider;
import org.eclipse.nebula.jface.galleryviewer.GalleryTreeViewer;
import org.eclipse.nebula.widgets.gallery.AbstractGalleryGroupRenderer;
import org.eclipse.nebula.widgets.gallery.AbstractGalleryItemRenderer;
import org.eclipse.nebula.widgets.gallery.DefaultGalleryGroupRenderer;
import org.eclipse.nebula.widgets.gallery.Gallery;
import org.eclipse.nebula.widgets.gallery.GalleryItem;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.registry.DataSourceProviderDescriptor;
import org.jkiss.dbeaver.registry.DataSourceRegistry;
import org.jkiss.dbeaver.registry.driver.DriverUtils;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.controls.ListContentProvider;
import org.jkiss.dbeaver.ui.dialogs.driver.DriverGalleryItemRenderer;
import org.jkiss.dbeaver.ui.editors.TextEditorUtils;
import org.jkiss.utils.CommonUtils;

public class DriverGalleryViewer
extends GalleryTreeViewer {
    public static final String GROUP_ALL = "all";
    public static final String GROUP_RECENT = "recent";
    private final List<DBPDriver> allDrivers = new ArrayList<DBPDriver>();

    public DriverGalleryViewer(Composite parent, final Object site, List<DataSourceProviderDescriptor> providers, boolean expandRecent) {
        super(new Gallery(parent, 2562));
        this.setContentProvider((IContentProvider)new FlatTreeContentProvider((IStructuredContentProvider)new ListContentProvider()));
        this.gallery.setBackground(TextEditorUtils.getDefaultTextBackground());
        this.gallery.setForeground(TextEditorUtils.getDefaultTextForeground());
        this.gallery.setLayoutData((Object)new GridData(1808));
        this.gallery.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (site instanceof ISelectionChangedListener) {
                    ((ISelectionChangedListener)site).selectionChanged(new SelectionChangedEvent((ISelectionProvider)DriverGalleryViewer.this, DriverGalleryViewer.this.getSelection()));
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                if (site instanceof IDoubleClickListener) {
                    ((IDoubleClickListener)site).doubleClick(new DoubleClickEvent((Viewer)DriverGalleryViewer.this, DriverGalleryViewer.this.getSelection()));
                }
            }
        });
        this.gallery.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                GalleryItem[] items = DriverGalleryViewer.this.gallery.getSelection();
                if (items.length == 0) {
                    items = DriverGalleryViewer.this.gallery.getItems();
                }
                if (items.length > 0) {
                    if (items[0].getItemCount() > 0) {
                        items[0] = items[0].getItem(0);
                    }
                    DriverGalleryViewer.this.gallery.setSelection(new GalleryItem[]{items[0]});
                }
            }
        });
        DefaultGalleryGroupRenderer groupRenderer = new DefaultGalleryGroupRenderer();
        groupRenderer.setMaxImageHeight(16);
        groupRenderer.setMaxImageWidth(16);
        groupRenderer.setItemHeight(60);
        groupRenderer.setItemWidth(200);
        groupRenderer.setTitleBackground(this.gallery.getDisplay().getSystemColor(31));
        this.gallery.setGroupRenderer((AbstractGalleryGroupRenderer)groupRenderer);
        DriverGalleryItemRenderer ir = new DriverGalleryItemRenderer(parent);
        this.gallery.setItemRenderer((AbstractGalleryItemRenderer)ir);
        for (DataSourceProviderDescriptor dpd : providers) {
            this.allDrivers.addAll(dpd.getEnabledDrivers());
        }
        this.allDrivers.sort(Comparator.comparing(DBPNamedObject::getName));
        this.createDriverGallery();
    }

    private void createDriverGallery() {
        this.gallery.removeAll();
        GalleryItem groupRecent = new GalleryItem(this.gallery, 0);
        groupRecent.setText("Recent drivers");
        groupRecent.setImage(DBeaverIcons.getImage((DBPImage)DBIcon.TREE_SCHEMA));
        groupRecent.setData((Object)GROUP_RECENT);
        groupRecent.setExpanded(true);
        GalleryItem groupAll = new GalleryItem(this.gallery, 0);
        groupAll.setText("All drivers");
        groupAll.setImage(DBeaverIcons.getImage((DBPImage)DBIcon.TREE_DATABASE));
        groupAll.setData((Object)GROUP_ALL);
        groupAll.setExpanded(true);
        this.fillDriverGroup(groupRecent);
        if (groupRecent.getItemCount() == 0) {
            groupRecent.dispose();
        }
        this.fillDriverGroup(groupAll);
    }

    private void fillDriverGroup(GalleryItem group) {
        List<DBPDataSourceContainer> allDataSources = DataSourceRegistry.getAllDataSources();
        ViewerFilter[] filters = this.getFilters();
        List<Object> drivers = GROUP_ALL.equals(group.getData()) ? this.allDrivers : (GROUP_RECENT.equals(group.getData()) ? this.getRecentDrivers(allDataSources, 6) : Collections.emptyList());
        for (DBPDriver driver : drivers) {
            boolean isVisible = true;
            ViewerFilter[] viewerFilterArray = filters;
            int n = filters.length;
            int n2 = 0;
            while (n2 < n) {
                ViewerFilter filter = viewerFilterArray[n2];
                if (!filter.select((Viewer)this, null, (Object)driver)) {
                    isVisible = false;
                    break;
                }
                ++n2;
            }
            if (!isVisible) continue;
            GalleryItem item = new GalleryItem(group, 0);
            item.setImage(DBeaverIcons.getImage((DBPImage)driver.getIcon()));
            item.setText(driver.getName());
            item.setText(0, driver.getName());
            List<DBPDataSourceContainer> usedBy = DriverUtils.getUsedBy(driver, allDataSources);
            if (!usedBy.isEmpty()) {
                item.setText(1, "Connections: " + usedBy.size());
            }
            if (!CommonUtils.isEmpty((String)driver.getCategory())) {
                item.setText(2, driver.getCategory());
            }
            item.setData((Object)driver);
        }
    }

    private List<DBPDriver> getRecentDrivers(List<DBPDataSourceContainer> allDataSources, int total) {
        HashMap<DBPDriver, Integer> connCountMap = new HashMap<DBPDriver, Integer>();
        for (DBPDriver driver : this.allDrivers) {
            connCountMap.put(driver, DriverUtils.getUsedBy(driver, allDataSources).size());
        }
        ArrayList<DBPDriver> recentDrivers = new ArrayList<DBPDriver>(this.allDrivers);
        recentDrivers.sort((o1, o2) -> {
            int ub2;
            int ub1 = DriverUtils.getUsedBy(o1, allDataSources).size();
            if (ub1 == (ub2 = DriverUtils.getUsedBy(o2, allDataSources).size())) {
                if (o1.isPromoted()) {
                    return 1;
                }
                if (o2.isPromoted()) {
                    return -1;
                }
                return o1.getName().compareTo(o2.getName());
            }
            return ub2 - ub1;
        });
        if (recentDrivers.size() > total) {
            return recentDrivers.subList(0, total);
        }
        return recentDrivers;
    }

    public Control getControl() {
        return this.getGallery();
    }

    public Object getInput() {
        return this.allDrivers;
    }

    public Gallery getGallery() {
        return this.gallery;
    }

    public void addTraverseListener(TraverseListener traverseListener) {
        if (traverseListener != null) {
            this.gallery.addTraverseListener(traverseListener);
        }
    }

    public void refresh(boolean updateLabels) {
        this.createDriverGallery();
    }
}

