/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.connection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.DBPDataSourceFolder;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPConnectionType;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObjectFilter;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.dbeaver.registry.DataSourceDescriptor;
import org.jkiss.dbeaver.registry.DataSourceProviderRegistry;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.CSmartCombo;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageInitialization;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageSettings;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageShellCommands;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionWizard;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionWizardPage;
import org.jkiss.dbeaver.ui.dialogs.connection.EditWizardPageDialog;
import org.jkiss.dbeaver.ui.navigator.dialogs.EditObjectFilterDialog;
import org.jkiss.utils.CommonUtils;

class ConnectionPageGeneral
extends ConnectionWizardPage {
    static final String PAGE_NAME = ConnectionPageGeneral.class.getSimpleName();
    private ConnectionWizard wizard;
    private DataSourceDescriptor dataSourceDescriptor;
    private Text connectionNameText;
    private CSmartCombo<DBPConnectionType> connectionTypeCombo;
    private Combo connectionFolderCombo;
    private Text descriptionText;
    private boolean connectionNameChanged = false;
    private boolean activated = false;
    private DBPDataSourceFolder dataSourceFolder;
    private List<DBPDataSourceFolder> connectionFolders = new ArrayList<DBPDataSourceFolder>();
    private Button showSystemObjects;
    private Button showUtilityObjects;
    private Button readOnlyConnection;
    private List<FilterInfo> filters = new ArrayList<FilterInfo>();
    private Group filtersGroup;
    private Font boldFont;

    ConnectionPageGeneral(ConnectionWizard wizard) {
        super(PAGE_NAME);
        this.wizard = wizard;
        this.setTitle(CoreMessages.dialog_connection_edit_wizard_general);
        this.setDescription(CoreMessages.dialog_connection_wizard_final_description);
        this.filters.add(new FilterInfo(DBSCatalog.class, CoreMessages.dialog_connection_wizard_final_filter_catalogs));
        this.filters.add(new FilterInfo(DBSSchema.class, CoreMessages.dialog_connection_wizard_final_filter_schemas_users));
        this.filters.add(new FilterInfo(DBSTable.class, CoreMessages.dialog_connection_wizard_final_filter_tables));
        this.filters.add(new FilterInfo(DBSEntityAttribute.class, CoreMessages.dialog_connection_wizard_final_filter_attributes));
    }

    ConnectionPageGeneral(ConnectionWizard wizard, DataSourceDescriptor dataSourceDescriptor) {
        this(wizard);
        this.dataSourceDescriptor = dataSourceDescriptor;
        for (FilterInfo filterInfo : this.filters) {
            filterInfo.filter = dataSourceDescriptor.getObjectFilter(filterInfo.type, null, false);
        }
    }

    public void dispose() {
        UIUtils.dispose((Resource)this.boldFont);
        super.dispose();
    }

    public void activatePage() {
        if (this.connectionNameText != null) {
            if (this.dataSourceDescriptor != null && !CommonUtils.isEmpty((String)this.dataSourceDescriptor.getName())) {
                this.connectionNameText.setText(this.dataSourceDescriptor.getName());
                this.connectionNameChanged = true;
            } else {
                ConnectionPageSettings settings = this.wizard.getPageSettings();
                if (CommonUtils.isEmpty((String)this.connectionNameText.getText()) || !this.connectionNameChanged) {
                    String newName = this.generateConnectionName(settings);
                    if (newName != null) {
                        this.connectionNameText.setText(newName);
                    }
                    this.connectionNameChanged = false;
                }
            }
        }
        if (this.dataSourceDescriptor != null) {
            if (!this.activated) {
                DBPConnectionConfiguration conConfig = this.dataSourceDescriptor.getConnectionConfiguration();
                this.connectionTypeCombo.select((Object)conConfig.getConnectionType());
                this.dataSourceFolder = this.dataSourceDescriptor.getFolder();
                if (this.dataSourceDescriptor.getFolder() == null) {
                    this.connectionFolderCombo.select(0);
                } else {
                    this.connectionFolderCombo.select(this.connectionFolders.indexOf(this.dataSourceFolder));
                }
                if (this.dataSourceDescriptor.getDescription() != null) {
                    this.descriptionText.setText(this.dataSourceDescriptor.getDescription());
                }
                this.showSystemObjects.setSelection(this.dataSourceDescriptor.isShowSystemObjects());
                this.showUtilityObjects.setSelection(this.dataSourceDescriptor.isShowUtilityObjects());
                this.readOnlyConnection.setSelection(this.dataSourceDescriptor.isConnectionReadOnly());
                this.activated = true;
            }
        } else {
            this.connectionTypeCombo.select(0);
            if (this.dataSourceFolder != null) {
                this.connectionFolderCombo.select(this.connectionFolders.indexOf(this.dataSourceFolder));
            } else {
                this.connectionFolderCombo.select(0);
            }
            this.showSystemObjects.setSelection(true);
            this.showUtilityObjects.setSelection(false);
            this.readOnlyConnection.setSelection(false);
        }
        long features = ((ConnectionWizard)this.getWizard()).getSelectedDriver().getDataSourceProvider().getFeatures();
        for (FilterInfo filterInfo : this.filters) {
            if (DBSCatalog.class.isAssignableFrom(filterInfo.type)) {
                this.enableFilter(filterInfo, (features & 1L) != 0L);
                continue;
            }
            if (DBSSchema.class.isAssignableFrom(filterInfo.type)) {
                this.enableFilter(filterInfo, (features & 2L) != 0L);
                continue;
            }
            this.enableFilter(filterInfo, true);
        }
        this.filtersGroup.layout();
    }

    private void enableFilter(FilterInfo filterInfo, boolean enable) {
        filterInfo.link.setEnabled(enable);
        if (enable) {
            filterInfo.link.setText("<a>" + filterInfo.title + "</a>");
            filterInfo.link.setToolTipText(NLS.bind((String)CoreMessages.dialog_connection_wizard_final_filter_link_tooltip, (Object)filterInfo.title));
            if (filterInfo.filter != null && !filterInfo.filter.isNotApplicable()) {
                filterInfo.link.setFont(this.boldFont);
            } else {
                filterInfo.link.setFont(this.getFont());
            }
        } else {
            filterInfo.link.setText(NLS.bind((String)CoreMessages.dialog_connection_wizard_final_filter_link_not_supported_text, (Object)filterInfo.title));
            filterInfo.link.setToolTipText(NLS.bind((String)CoreMessages.dialog_connection_wizard_final_filter_link_not_supported_tooltip, (Object)filterInfo.title, (Object)((ConnectionWizard)this.getWizard()).getSelectedDriver().getName()));
        }
    }

    private String generateConnectionName(ConnectionPageSettings settings) {
        String newName;
        if (settings != null) {
            DBPConnectionConfiguration connectionInfo = settings.getActiveDataSource().getConnectionConfiguration();
            String string = newName = this.dataSourceDescriptor == null ? "" : settings.getActiveDataSource().getName();
            if (CommonUtils.isEmpty((String)newName)) {
                newName = connectionInfo.getDatabaseName();
                if (CommonUtils.isEmpty((String)newName)) {
                    newName = connectionInfo.getHostName();
                }
                if (CommonUtils.isEmpty((String)newName)) {
                    newName = connectionInfo.getServerName();
                }
                if (CommonUtils.isEmpty((String)newName)) {
                    newName = CoreMessages.dialog_connection_wizard_final_default_new_connection_name;
                }
                StringTokenizer st = new StringTokenizer(newName, "/\\:,?=%$#@!^&*()");
                while (st.hasMoreTokens()) {
                    newName = st.nextToken();
                }
                newName = !CommonUtils.isEmpty((String)settings.getDriver().getCategory()) ? String.valueOf(settings.getDriver().getCategory()) + " - " + newName : String.valueOf(settings.getDriver().getName()) + " - " + newName;
                newName = CommonUtils.truncateString((String)newName, (int)50);
            }
            String baseName = newName;
            int i = 2;
            while (settings.getDataSourceRegistry().findDataSourceByName(newName) != null) {
                newName = String.valueOf(baseName) + " " + i;
                ++i;
            }
        } else {
            newName = this.wizard.getSelectedDriver().getName();
        }
        return newName;
    }

    @NotNull
    private DataSourceDescriptor getActiveDataSource() {
        ConnectionPageSettings pageSettings = ((ConnectionWizard)this.getWizard()).getPageSettings();
        return pageSettings == null ? this.wizard.getActiveDataSource() : pageSettings.getActiveDataSource();
    }

    public void deactivatePage() {
    }

    public void createControl(Composite parent) {
        this.boldFont = UIUtils.makeBoldFont((Font)parent.getFont());
        Composite group = UIUtils.createPlaceholder((Composite)parent, (int)1, (int)5);
        String connectionName = this.dataSourceDescriptor == null ? "" : this.dataSourceDescriptor.getName();
        this.connectionNameText = UIUtils.createLabelText((Composite)group, (String)CoreMessages.dialog_connection_wizard_final_label_connection_name, (String)CommonUtils.toString((Object)connectionName));
        this.connectionNameText.addModifyListener(e -> {
            this.connectionNameChanged = true;
            this.getContainer().updateButtons();
        });
        UIUtils.createControlLabel((Composite)group, (String)CoreMessages.dialog_connection_wizard_final_label_connection_type);
        Composite ctGroup = UIUtils.createPlaceholder((Composite)group, (int)2, (int)5);
        this.connectionTypeCombo = new CSmartCombo(ctGroup, 2060, (ILabelProvider)new ConnectionTypeLabelProvider());
        this.loadConnectionTypes();
        this.connectionTypeCombo.select(0);
        this.connectionTypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DBPConnectionType type = (DBPConnectionType)ConnectionPageGeneral.this.connectionTypeCombo.getItem(ConnectionPageGeneral.this.connectionTypeCombo.getSelectionIndex());
                ((ConnectionWizard)ConnectionPageGeneral.this.getWizard()).firePropertyChangeEvent("connection-type", ConnectionPageGeneral.this.getActiveDataSource().getConnectionConfiguration().getConnectionType(), type);
            }
        });
        Button pickerButton = new Button(ctGroup, 8);
        pickerButton.setText(CoreMessages.dialog_connection_wizard_final_label_edit);
        pickerButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataSourceDescriptor dataSource = ConnectionPageGeneral.this.getActiveDataSource();
                UIUtils.showPreferencesFor((Shell)ConnectionPageGeneral.this.getControl().getShell(), (Object)dataSource.getConnectionConfiguration().getConnectionType(), (String[])new String[]{"org.jkiss.dbeaver.preferences.connectionTypes"});
                ConnectionPageGeneral.this.loadConnectionTypes();
                DBPConnectionType connectionType = dataSource.getConnectionConfiguration().getConnectionType();
                ConnectionPageGeneral.this.connectionTypeCombo.select((Object)connectionType);
                ((ConnectionWizard)ConnectionPageGeneral.this.getWizard()).firePropertyChangeEvent("connection-type", connectionType, connectionType);
            }
        });
        UIUtils.createControlLabel((Composite)group, (String)CoreMessages.dialog_connection_wizard_final_label_connection_folder);
        this.connectionFolderCombo = new Combo(group, 2060);
        GridData gd = new GridData(32);
        gd.widthHint = UIUtils.getFontHeight((Control)this.connectionFolderCombo) * 30;
        this.connectionFolderCombo.setLayoutData((Object)gd);
        this.loadConnectionFolders();
        this.connectionFolderCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConnectionPageGeneral.this.dataSourceFolder = (DBPDataSourceFolder)ConnectionPageGeneral.this.connectionFolders.get(ConnectionPageGeneral.this.connectionFolderCombo.getSelectionIndex());
            }
        });
        Label descLabel = UIUtils.createControlLabel((Composite)group, (String)CoreMessages.dialog_connection_wizard_description);
        this.descriptionText = new Text(group, 2626);
        GridData gd2 = new GridData(768);
        gd2.horizontalSpan = 2;
        gd2.heightHint = this.descriptionText.getLineHeight() * 3;
        this.descriptionText.setLayoutData((Object)gd2);
        Composite refsGroup = UIUtils.createPlaceholder((Composite)group, (int)2, (int)5);
        gd2 = new GridData(768);
        gd2.horizontalSpan = 2;
        refsGroup.setLayoutData((Object)gd2);
        Group miscGroup = UIUtils.createControlGroup((Composite)refsGroup, (String)CoreMessages.dialog_connection_wizard_final_group_misc, (int)1, (int)2, (int)0);
        miscGroup.setLayoutData((Object)new GridData(32));
        this.showSystemObjects = UIUtils.createCheckbox((Composite)miscGroup, (String)CoreMessages.dialog_connection_wizard_final_checkbox_show_system_objects, (this.dataSourceDescriptor == null || this.dataSourceDescriptor.isShowSystemObjects() ? 1 : 0) != 0);
        this.showSystemObjects.setLayoutData((Object)new GridData(32));
        this.showUtilityObjects = UIUtils.createCheckbox((Composite)miscGroup, (String)CoreMessages.dialog_connection_wizard_final_checkbox_show_util_objects, (this.dataSourceDescriptor != null && this.dataSourceDescriptor.isShowUtilityObjects() ? 1 : 0) != 0);
        this.showUtilityObjects.setLayoutData((Object)new GridData(32));
        this.readOnlyConnection = UIUtils.createCheckbox((Composite)miscGroup, (String)CoreMessages.dialog_connection_wizard_final_checkbox_connection_readonly, (this.dataSourceDescriptor != null && this.dataSourceDescriptor.isConnectionReadOnly() ? 1 : 0) != 0);
        gd2 = new GridData(32);
        this.readOnlyConnection.setLayoutData((Object)gd2);
        this.filtersGroup = UIUtils.createControlGroup((Composite)refsGroup, (String)CoreMessages.dialog_connection_wizard_final_group_filters, (int)2, (int)770, (int)0);
        for (final FilterInfo filterInfo : this.filters) {
            filterInfo.link = UIUtils.createLink((Composite)this.filtersGroup, (String)("<a>" + filterInfo.title + "</a>"), (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    EditObjectFilterDialog dialog = new EditObjectFilterDialog(ConnectionPageGeneral.this.getShell(), ((ConnectionWizard)ConnectionPageGeneral.this.getWizard()).getDataSourceRegistry(), filterInfo.title, filterInfo.filter != null ? filterInfo.filter : new DBSObjectFilter(), true);
                    if (dialog.open() == 0) {
                        filterInfo.filter = dialog.getFilter();
                        if (filterInfo.filter != null && !filterInfo.filter.isNotApplicable()) {
                            filterInfo.link.setFont(ConnectionPageGeneral.this.boldFont);
                        } else {
                            filterInfo.link.setFont(ConnectionPageGeneral.this.getFont());
                        }
                    }
                }
            });
        }
        Composite linkGroup = UIUtils.createPlaceholder((Composite)refsGroup, (int)1, (int)5);
        gd2 = new GridData(32);
        gd2.horizontalSpan = 2;
        linkGroup.setLayoutData((Object)gd2);
        Link initConfigLink = new Link(linkGroup, 0);
        initConfigLink.setText("<a>" + CoreMessages.dialog_connection_wizard_connection_init_description + "</a>");
        initConfigLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((ConnectionWizard)ConnectionPageGeneral.this.getWizard()).isNew()) {
                    DataSourceDescriptor dataSource = ConnectionPageGeneral.this.getActiveDataSource();
                    EditWizardPageDialog dialog = new EditWizardPageDialog((ConnectionWizard)ConnectionPageGeneral.this.getWizard(), new ConnectionPageInitialization(dataSource), dataSource);
                    dialog.open();
                } else {
                    ((ConnectionWizard)ConnectionPageGeneral.this.getWizard()).openSettingsPage(ConnectionPageInitialization.PAGE_NAME);
                }
            }
        });
        initConfigLink.setLayoutData((Object)new GridData(32));
        Link shellConfigLink = new Link(linkGroup, 0);
        shellConfigLink.setText("<a>" + CoreMessages.dialog_connection_edit_wizard_shell_cmd + "</a>");
        shellConfigLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((ConnectionWizard)ConnectionPageGeneral.this.getWizard()).isNew()) {
                    DataSourceDescriptor dataSource = ConnectionPageGeneral.this.getActiveDataSource();
                    EditWizardPageDialog dialog = new EditWizardPageDialog((ConnectionWizard)ConnectionPageGeneral.this.getWizard(), new ConnectionPageShellCommands(dataSource), dataSource);
                    dialog.open();
                } else {
                    ((ConnectionWizard)ConnectionPageGeneral.this.getWizard()).openSettingsPage(ConnectionPageShellCommands.PAGE_NAME);
                }
            }
        });
        shellConfigLink.setLayoutData((Object)new GridData(32));
        this.setControl((Control)group);
        UIUtils.setHelp((Control)group, (String)"con-wizard-final");
    }

    private void loadConnectionTypes() {
        this.connectionTypeCombo.removeAll();
        for (DBPConnectionType ct : DataSourceProviderRegistry.getInstance().getConnectionTypes()) {
            this.connectionTypeCombo.addItem((Object)ct);
        }
    }

    private void loadConnectionFolders() {
        this.connectionFolderCombo.removeAll();
        this.connectionFolderCombo.add(CoreMessages.toolbar_datasource_selector_empty);
        this.connectionFolders.clear();
        this.connectionFolders.add(null);
        for (DBPDataSourceFolder folder : DBUtils.makeOrderedObjectList((Collection)((ConnectionWizard)this.getWizard()).getDataSourceRegistry().getRootFolders())) {
            this.loadConnectionFolder(0, folder);
        }
    }

    private void loadConnectionFolder(int level, DBPDataSourceFolder folder) {
        String prefix = "";
        int i = 0;
        while (i < level) {
            prefix = String.valueOf(prefix) + "   ";
            ++i;
        }
        this.connectionFolders.add(folder);
        this.connectionFolderCombo.add(String.valueOf(prefix) + folder.getName());
        for (DBPDataSourceFolder child : DBUtils.makeOrderedObjectList((DBPNamedObject[])folder.getChildren())) {
            this.loadConnectionFolder(level + 1, child);
        }
    }

    public boolean isPageComplete() {
        return true;
    }

    @Override
    public void saveSettings(DataSourceDescriptor dataSource) {
        String description;
        if (this.dataSourceDescriptor != null && !this.activated) {
            return;
        }
        DBPConnectionConfiguration confConfig = dataSource.getConnectionConfiguration();
        String name = this.connectionNameChanged ? this.connectionNameText.getText() : this.generateConnectionName(((ConnectionWizard)this.getWizard()).getPageSettings());
        dataSource.setName(name);
        dataSource.setFolder(this.dataSourceFolder);
        if (this.connectionTypeCombo.getSelectionIndex() >= 0) {
            confConfig.setConnectionType((DBPConnectionType)this.connectionTypeCombo.getItem(this.connectionTypeCombo.getSelectionIndex()));
        }
        if ((description = this.descriptionText.getText()).isEmpty()) {
            dataSource.setDescription(null);
        } else {
            dataSource.setDescription(description);
        }
        dataSource.setShowSystemObjects(this.showSystemObjects.getSelection());
        dataSource.setShowUtilityObjects(this.showUtilityObjects.getSelection());
        dataSource.setConnectionReadOnly(this.readOnlyConnection.getSelection());
        for (FilterInfo filterInfo : this.filters) {
            if (filterInfo.filter == null) continue;
            dataSource.setObjectFilter(filterInfo.type, null, filterInfo.filter);
        }
    }

    public void setDataSourceFolder(DBPDataSourceFolder dataSourceFolder) {
        this.dataSourceFolder = dataSourceFolder;
    }

    private static class ConnectionTypeLabelProvider
    extends LabelProvider
    implements IColorProvider {
        private ConnectionTypeLabelProvider() {
        }

        public String getText(Object element) {
            return ((DBPConnectionType)element).getName();
        }

        public Color getForeground(Object element) {
            return null;
        }

        public Color getBackground(Object element) {
            return UIUtils.getConnectionTypeColor((DBPConnectionType)((DBPConnectionType)element));
        }
    }

    private static class FilterInfo {
        final Class<?> type;
        final String title;
        Link link;
        DBSObjectFilter filter;

        private FilterInfo(Class<?> type, String title) {
            this.type = type;
            this.title = title;
        }
    }
}

