/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.scripts;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.tools.scripts.ScriptsExportData;
import org.jkiss.dbeaver.tools.scripts.ScriptsExportWizardPage;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.utils.IOUtils;

public class ScriptsExportWizard
extends Wizard
implements IExportWizard {
    private static final Log log = Log.getLog(ScriptsExportWizard.class);
    private ScriptsExportWizardPage mainPage;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(CoreMessages.dialog_scripts_export_wizard_window_title);
        this.setDefaultPageImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.SQL_SCRIPT));
        this.setNeedsProgressMonitor(true);
        this.mainPage = new ScriptsExportWizardPage(CoreMessages.dialog_scripts_export_wizard_page_name);
    }

    public void addPages() {
        super.addPages();
        this.addPage((IWizardPage)this.mainPage);
    }

    public boolean performFinish() {
        final ScriptsExportData exportData = this.mainPage.getExportData();
        try {
            UIUtils.run((IRunnableContext)this.getContainer(), (boolean)true, (boolean)true, (DBRRunnableWithProgress)new DBRRunnableWithProgress(){

                public void run(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        ScriptsExportWizard.this.exportScripts(monitor, exportData);
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InterruptedException ex) {
            return false;
        }
        catch (InvocationTargetException ex) {
            DBWorkbench.getPlatformUI().showError("Export error", "Cannot export scripts", ex.getTargetException());
            return false;
        }
        return true;
    }

    public void exportScripts(DBRProgressMonitor monitor, ScriptsExportData exportData) throws IOException, CoreException, InterruptedException {
        Collection<IResource> scripts = exportData.getScripts();
        int totalFiles = 0;
        for (IResource res : scripts) {
            if (res instanceof IFolder) {
                totalFiles += this.countFiles((IFolder)res);
                continue;
            }
            ++totalFiles;
        }
        monitor.beginTask("Export scripts", totalFiles);
        for (IResource res : scripts) {
            if (res instanceof IContainer) {
                this.exportFolder(monitor, (IContainer)res, exportData);
                continue;
            }
            this.exportScript(monitor, (IFile)res, exportData);
        }
        monitor.done();
    }

    private int countFiles(IFolder folder) {
        try {
            int count = 0;
            IResource[] iResourceArray = folder.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource res = iResourceArray[n2];
                if (res instanceof IFile) {
                    ++count;
                } else if (res instanceof IFolder) {
                    count += this.countFiles((IFolder)res);
                }
                ++n2;
            }
            return count;
        }
        catch (CoreException e) {
            return 0;
        }
    }

    private void exportFolder(DBRProgressMonitor monitor, IContainer folder, ScriptsExportData exportData) throws CoreException, IOException {
        if (monitor.isCanceled()) {
            return;
        }
        File fsDir = this.makeExternalFile((IResource)folder, exportData.getOutputFolder());
        if (!fsDir.exists() && !fsDir.mkdirs()) {
            throw new IOException("Can't create directory '" + fsDir.getAbsolutePath() + "'");
        }
        IResource[] iResourceArray = folder.members();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource res = iResourceArray[n2];
            if (monitor.isCanceled()) {
                return;
            }
            if (!(res.isLinked() || res.isHidden() || res.isPhantom())) {
                if (res instanceof IFile) {
                    this.exportScript(monitor, (IFile)res, exportData);
                } else if (res instanceof IContainer) {
                    this.exportFolder(monitor, (IContainer)res, exportData);
                }
            }
            ++n2;
        }
    }

    private File makeExternalFile(IResource folder, File outputFolder) {
        ArrayList<IResource> path = new ArrayList<IResource>();
        IResource f = folder;
        while (f.getParent() instanceof IContainer) {
            path.add(0, f);
            f = f.getParent();
        }
        File fsDir = outputFolder;
        for (IResource pathItem : path) {
            fsDir = new File(fsDir, pathItem.getName());
        }
        return fsDir;
    }

    private void exportScript(DBRProgressMonitor monitor, IFile file, ScriptsExportData exportData) throws IOException, CoreException {
        File fileDir;
        File fsFile = this.makeExternalFile((IResource)file, exportData.getOutputFolder());
        if (fsFile.exists()) {
            if (fsFile.isDirectory()) {
                throw new IOException("Target file '" + fsFile.getAbsolutePath() + "' is a directory");
            }
            if (!exportData.isOverwriteFiles()) {
                log.warn((Object)("File '" + fsFile.getAbsolutePath() + "' already exists - skipped"));
                return;
            }
            log.warn((Object)("Overwriting file '" + fsFile.getAbsolutePath() + "'"));
        }
        if (!(fileDir = fsFile.getParentFile()).exists() && !fileDir.mkdirs()) {
            throw new IOException("Can't create directory '" + fileDir.getAbsolutePath() + "'");
        }
        Throwable throwable = null;
        Object var7_8 = null;
        try (InputStream scriptContents = file.getContents(true);){
            Throwable throwable2 = null;
            Object var10_13 = null;
            try (FileOutputStream out = new FileOutputStream(fsFile);){
                IOUtils.copyStream((InputStream)scriptContents, (OutputStream)out);
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        monitor.worked(1);
    }
}

