/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.tools;

import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.jkiss.dbeaver.ext.postgresql.PostgreMessages;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.runtime.encode.EncryptionException;
import org.jkiss.dbeaver.runtime.encode.SecuredPasswordEncrypter;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.BaseAuthDialog;
import org.jkiss.dbeaver.ui.dialogs.tools.AbstractToolWizard;
import org.jkiss.dbeaver.ui.dialogs.tools.AbstractToolWizardPage;

public abstract class PostgreWizardPageSettings<WIZARD extends AbstractToolWizard>
extends AbstractToolWizardPage<WIZARD> {
    public PostgreWizardPageSettings(WIZARD wizard, String title) {
        super(wizard, title);
    }

    public void createSecurityGroup(Composite parent) {
        try {
            String authCredentials;
            int divPos;
            final SecuredPasswordEncrypter encrypter = new SecuredPasswordEncrypter();
            final DBPConnectionConfiguration connectionInfo = this.wizard.getConnectionInfo();
            final String authProperty = "@dbeaver--auth-" + this.wizard.getObjectsName() + "@";
            String authUser = null;
            String authPassword = null;
            String authValue = connectionInfo.getProviderProperty(authProperty);
            if (authValue != null && (divPos = (authCredentials = encrypter.decrypt(authValue)).indexOf(58)) != -1) {
                authUser = authCredentials.substring(0, divPos);
                authPassword = authCredentials.substring(divPos + 1);
            }
            this.wizard.setToolUserName(authUser == null ? connectionInfo.getUserName() : authUser);
            this.wizard.setToolUserPassword(authPassword == null ? connectionInfo.getUserPassword() : authPassword);
            final boolean savePassword = authUser != null;
            Group securityGroup = UIUtils.createControlGroup((Composite)parent, (String)PostgreMessages.wizard_backup_page_setting_group_security, (int)2, (int)32, (int)0);
            Label infoLabel = new Label((Composite)securityGroup, 0);
            infoLabel.setText(NLS.bind((String)PostgreMessages.wizard_backup_page_setting_group_security_label_info, (Object)this.wizard.getConnectionInfo().getUserName(), (Object)this.wizard.getObjectsName()));
            GridData gd = new GridData(768);
            gd.horizontalSpan = 2;
            infoLabel.setLayoutData((Object)gd);
            Button authButton = new Button((Composite)securityGroup, 8);
            authButton.setText(PostgreMessages.wizard_backup_page_setting_group_security_btn_authentication);
            authButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    BaseAuthDialog authDialog = new BaseAuthDialog(PostgreWizardPageSettings.this.getShell(), PostgreMessages.wizard_backup_page_setting_group_security_btn_authentication, false, true);
                    authDialog.setUserName(PostgreWizardPageSettings.this.wizard.getToolUserName());
                    authDialog.setUserPassword(PostgreWizardPageSettings.this.wizard.getToolUserPassword());
                    authDialog.setSavePassword(savePassword);
                    if (authDialog.open() == 0) {
                        PostgreWizardPageSettings.this.wizard.setToolUserName(authDialog.getUserName());
                        PostgreWizardPageSettings.this.wizard.setToolUserPassword(authDialog.getUserPassword());
                        if (authDialog.isSavePassword()) {
                            try {
                                connectionInfo.setProviderProperty(authProperty, encrypter.encrypt(String.valueOf(PostgreWizardPageSettings.this.wizard.getToolUserName()) + ':' + PostgreWizardPageSettings.this.wizard.getToolUserPassword()));
                            }
                            catch (EncryptionException encryptionException) {
                                // empty catch block
                            }
                        }
                    }
                }
            });
            Button resetButton = new Button((Composite)securityGroup, 8);
            resetButton.setText(PostgreMessages.wizard_backup_page_setting_group_security_btn_reset_default);
            resetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    connectionInfo.getProviderProperties().remove(authProperty);
                    PostgreWizardPageSettings.this.wizard.setToolUserName(connectionInfo.getUserName());
                    PostgreWizardPageSettings.this.wizard.setToolUserPassword(connectionInfo.getUserPassword());
                }
            });
        }
        catch (EncryptionException encryptionException) {
            // empty catch block
        }
    }
}

