/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.PostgreMessages;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.ui.PostgreCreateDatabaseDialog;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.impl.DBSObjectCache;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistActionAtomic;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.utils.CommonUtils;

public class PostgreDatabaseManager
extends SQLObjectEditor<PostgreDatabase, PostgreDataSource>
implements DBEObjectRenamer<PostgreDatabase> {
    public long getMakerOptions(DBPDataSource dataSource) {
        return 1L;
    }

    @Nullable
    public DBSObjectCache<PostgreDataSource, PostgreDatabase> getObjectsCache(PostgreDatabase object) {
        return object.getDataSource().getDatabaseCache();
    }

    public void deleteObject(DBECommandContext commandContext, PostgreDatabase object, Map<String, Object> options) throws DBException {
        if (object == object.getDataSource().getDefaultInstance()) {
            throw new DBException("Cannot drop the currently open database.\nSwitch to another database and try again\n(Note: enable '" + PostgreMessages.dialog_setting_connection_nondefaultDatabase + "' option to see them).");
        }
        super.deleteObject(commandContext, (DBSObject)object, options);
    }

    protected PostgreDatabase createDatabaseObject(final DBRProgressMonitor monitor, DBECommandContext context, final PostgreDataSource parent, Object copyFrom) {
        return (PostgreDatabase)new UITask<PostgreDatabase>(){

            protected PostgreDatabase runTask() {
                PostgreCreateDatabaseDialog dialog = new PostgreCreateDatabaseDialog(UIUtils.getActiveWorkbenchShell(), parent);
                if (dialog.open() != 0) {
                    return null;
                }
                try {
                    return new PostgreDatabase(monitor, parent, dialog.getName(), dialog.getOwner(), dialog.getTemplateName(), dialog.getTablespace(), dialog.getEncoding());
                }
                catch (DBException e) {
                    return null;
                }
            }
        }.execute();
    }

    protected void addObjectCreateActions(DBRProgressMonitor monitor, List<DBEPersistAction> actions, SQLObjectEditor.ObjectCreateCommand command, Map<String, Object> options) {
        PostgreDatabase database = (PostgreDatabase)command.getObject();
        StringBuilder sql = new StringBuilder();
        sql.append("CREATE DATABASE ").append(DBUtils.getQuotedIdentifier((DBSObject)database));
        if (database.getInitialOwner() != null) {
            sql.append("\nOWNER = ").append(database.getInitialOwner().getName());
        }
        if (!CommonUtils.isEmpty((String)database.getTemplateName())) {
            sql.append("\nTEMPLATE = ").append(database.getTemplateName());
        }
        if (database.getInitialEncoding() != null) {
            sql.append("\nENCODING = '").append(database.getInitialEncoding().getName()).append("'");
        }
        if (database.getInitialTablespace() != null) {
            sql.append("\nTABLESPACE = ").append(database.getInitialTablespace().getName());
        }
        actions.add((DBEPersistAction)new CreateDatabaseAction(database, sql));
    }

    protected void addObjectDeleteActions(List<DBEPersistAction> actions, SQLObjectEditor.ObjectDeleteCommand command, Map<String, Object> options) {
        actions.add((DBEPersistAction)new DeleteDatabaseAction(command));
    }

    public void renameObject(DBECommandContext commandContext, PostgreDatabase database, String newName) throws DBException {
        this.processObjectRename(commandContext, database, newName);
    }

    protected void addObjectRenameActions(DBRProgressMonitor monitor, List<DBEPersistAction> actions, SQLObjectEditor.ObjectRenameCommand command, Map<String, Object> options) {
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Rename database", "ALTER DATABASE " + DBUtils.getQuotedIdentifier((DBPDataSource)((PostgreDatabase)command.getObject()).getDataSource(), (String)command.getOldName()) + " RENAME TO " + DBUtils.getQuotedIdentifier((DBPDataSource)((PostgreDatabase)command.getObject()).getDataSource(), (String)command.getNewName())));
    }

    protected void addObjectModifyActions(DBRProgressMonitor monitor, List<DBEPersistAction> actionList, SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) {
        if (command.getProperties().size() > 1 || command.getProperty((Object)"description") == null) {
            try {
                this.generateAlterActions(monitor, actionList, command);
            }
            catch (DBException e) {
                log.error((Object)e);
            }
        }
    }

    private void generateAlterActions(DBRProgressMonitor monitor, List<DBEPersistAction> actionList, SQLObjectEditor.ObjectChangeCommand command) throws DBException {
        PostgreDatabase database = (PostgreDatabase)command.getObject();
        String alterPrefix = "ALTER DATABASE " + DBUtils.getQuotedIdentifier((DBSObject)((DBSObject)command.getObject())) + " ";
        if (command.hasProperty((Object)"defaultTablespace")) {
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction(String.valueOf(alterPrefix) + "SET TABLESPACE " + DBUtils.getQuotedIdentifier((DBSObject)database.getDefaultTablespace(monitor))));
        }
        if (command.hasProperty((Object)"defaultEncoding")) {
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction(String.valueOf(alterPrefix) + "SET ENCODING " + DBUtils.getQuotedIdentifier((DBSObject)database.getDefaultEncoding(monitor))));
        }
        if (command.hasProperty((Object)"dBA")) {
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction(String.valueOf(alterPrefix) + "OWNER TO " + DBUtils.getQuotedIdentifier((DBSObject)database.getDBA(monitor))));
        }
    }

    protected void validateObjectProperties(SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) throws DBException {
        super.validateObjectProperties(command, options);
        options.put("avoidTransactions", true);
    }

    private static class CreateDatabaseAction
    extends SQLDatabasePersistActionAtomic {
        private final PostgreDatabase database;

        public CreateDatabaseAction(PostgreDatabase database, StringBuilder sql) {
            super("Create database", sql.toString());
            this.database = database;
        }

        public void afterExecute(DBCSession session, Throwable error) throws DBCException {
            super.afterExecute(session, error);
            if (error == null) {
                try {
                    this.database.initializeMetaContext(session.getProgressMonitor());
                }
                catch (DBException e) {
                    log.error((Object)"Can't connect to the new database");
                }
            }
        }
    }

    private static class DeleteDatabaseAction
    extends SQLDatabasePersistActionAtomic {
        private final PostgreDatabase database;

        public DeleteDatabaseAction(SQLObjectEditor.ObjectDeleteCommand command) {
            super("Drop database", "DROP DATABASE " + DBUtils.getQuotedIdentifier((DBSObject)((DBSObject)command.getObject())));
            this.database = (PostgreDatabase)command.getObject();
        }

        public void beforeExecute(DBCSession session) throws DBCException {
            super.beforeExecute(session);
            this.database.shutdown(session.getProgressMonitor());
        }
    }
}

