/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.oracle.model.OracleObjectType;
import org.jkiss.dbeaver.ext.oracle.model.OracleObjectValidateAction;
import org.jkiss.dbeaver.ext.oracle.model.OraclePackage;
import org.jkiss.dbeaver.ext.oracle.model.OracleSchema;
import org.jkiss.dbeaver.ext.oracle.model.OracleUtils;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPScriptObject;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.impl.DBSObjectCache;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.editors.object.struct.EntityEditPage;
import org.jkiss.utils.CommonUtils;

public class OraclePackageManager
extends SQLObjectEditor<OraclePackage, OracleSchema> {
    @Nullable
    public DBSObjectCache<? extends DBSObject, OraclePackage> getObjectsCache(OraclePackage object) {
        return object.getSchema().packageCache;
    }

    protected OraclePackage createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, final OracleSchema parent, Object copyFrom) {
        return (OraclePackage)new UITask<OraclePackage>(){

            protected OraclePackage runTask() {
                EntityEditPage editPage = new EntityEditPage((DBPDataSource)parent.getDataSource(), DBSEntityType.PACKAGE);
                if (!editPage.edit()) {
                    return null;
                }
                String packName = editPage.getEntityName();
                OraclePackage oraclePackage = new OraclePackage(parent, packName);
                oraclePackage.setObjectDefinitionText("CREATE OR REPLACE PACKAGE " + packName + "\n" + "AS\n" + "-- Package header\n" + "END " + packName + ";");
                oraclePackage.setExtendedDefinitionText("CREATE OR REPLACE PACKAGE BODY " + packName + "\n" + "AS\n" + "-- Package body\n" + "END " + packName + ";");
                return oraclePackage;
            }
        }.execute();
    }

    protected void addObjectCreateActions(DBRProgressMonitor monitor, List<DBEPersistAction> actions, SQLObjectEditor.ObjectCreateCommand objectCreateCommand, Map<String, Object> options) {
        this.createOrReplaceProcedureQuery(actions, (OraclePackage)objectCreateCommand.getObject());
    }

    protected void addObjectDeleteActions(List<DBEPersistAction> actions, SQLObjectEditor.ObjectDeleteCommand objectDeleteCommand, Map<String, Object> options) {
        OraclePackage object = (OraclePackage)objectDeleteCommand.getObject();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Drop package", "DROP PACKAGE " + object.getFullyQualifiedName(DBPEvaluationContext.DDL)));
    }

    protected void addObjectModifyActions(DBRProgressMonitor monitor, List<DBEPersistAction> actionList, SQLObjectEditor.ObjectChangeCommand objectChangeCommand, Map<String, Object> options) {
        this.createOrReplaceProcedureQuery(actionList, (OraclePackage)objectChangeCommand.getObject());
    }

    public long getMakerOptions(DBPDataSource dataSource) {
        return 4L;
    }

    private void createOrReplaceProcedureQuery(List<DBEPersistAction> actionList, OraclePackage pack) {
        try {
            String body;
            String header = pack.getObjectDefinitionText((DBRProgressMonitor)new VoidProgressMonitor(), DBPScriptObject.EMPTY_OPTIONS);
            if (!CommonUtils.isEmpty((String)header)) {
                actionList.add((DBEPersistAction)new OracleObjectValidateAction(pack, OracleObjectType.PACKAGE, "Create package header", header));
            }
            if (!CommonUtils.isEmpty((String)(body = pack.getExtendedDefinitionText((DBRProgressMonitor)new VoidProgressMonitor())))) {
                actionList.add((DBEPersistAction)new OracleObjectValidateAction(pack, OracleObjectType.PACKAGE_BODY, "Create package body", body));
            } else {
                actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Drop package header", "DROP PACKAGE BODY " + pack.getFullyQualifiedName(DBPEvaluationContext.DDL), DBEPersistAction.ActionType.OPTIONAL));
            }
        }
        catch (DBException e) {
            log.warn((Object)e);
        }
        OracleUtils.addSchemaChangeActions(actionList, pack);
    }
}

