/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.greenplum.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.greenplum.model.GreenplumExternalTable;
import org.jkiss.dbeaver.ext.greenplum.model.GreenplumTable;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTable;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class GreenplumSchema
extends PostgreSchema {
    private GreenplumTableCache greenplumTableCache = new GreenplumTableCache();

    public GreenplumSchema(PostgreDatabase owner, String name, JDBCResultSet resultSet) throws SQLException {
        super(owner, name, (ResultSet)resultSet);
    }

    public Collection<? extends JDBCTable> getTables(DBRProgressMonitor monitor) throws DBException {
        return Stream.concat(this.greenplumTableCache.getTypedObjects(monitor, (DBSObject)this, GreenplumExternalTable.class).stream(), this.greenplumTableCache.getTypedObjects(monitor, (DBSObject)this, GreenplumTable.class).stream().filter(table -> !table.isPartition())).collect(Collectors.toCollection(ArrayList::new));
    }

    public class GreenplumTableCache
    extends PostgreSchema.TableCache {
        protected GreenplumTableCache() {
            super((PostgreSchema)GreenplumSchema.this);
        }

        @NotNull
        public JDBCStatement prepareLookupStatement(@NotNull JDBCSession session, @NotNull PostgreSchema postgreSchema, @Nullable PostgreTableBase object, @Nullable String objectName) throws SQLException {
            String sqlQuery = "SELECT c.oid,d.description, c.*,\nCASE WHEN x.urilocation IS NOT NULL THEN array_to_string(x.urilocation, ',') ELSE '' END AS urilocation,\nx.fmttype, x.fmtopts,\ncoalesce(x.rejectlimit, 0) AS rejectlimit,\ncoalesce(x.rejectlimittype, '') AS rejectlimittype,\narray_to_string(x.execlocation, ',') AS execlocation,\npg_encoding_to_char(x.encoding) AS encoding,\ncase when c.relstorage = 'x' then true else false end as \"is_ext_table\"\nFROM pg_catalog.pg_class c\ninner join pg_catalog.pg_namespace ns\n\ton ns.oid = c.relnamespace\nLEFT OUTER JOIN pg_catalog.pg_description d\n\tON d.objoid=c.oid AND d.objsubid=0\nleft outer join pg_catalog.pg_exttable x\n\ton x.reloid = c.oid\nleft outer join pg_catalog.pg_partitions p\n\ton c.relname = p.partitiontablename and ns.nspname = p.schemaname\nWHERE c.relnamespace= ? AND c.relkind not in ('i','c') AND p.partitiontablename is null " + (object == null && objectName == null ? "" : " AND relname=?");
            JDBCPreparedStatement dbStat = session.prepareStatement(sqlQuery);
            dbStat.setLong(1, GreenplumSchema.this.getObjectId());
            if (object != null || objectName != null) {
                dbStat.setString(2, object != null ? object.getName() : objectName);
            }
            return dbStat;
        }
    }
}

