/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.tools;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.wizard.IWizardPage;
import org.jkiss.dbeaver.ext.mysql.MySQLDataSourceProvider;
import org.jkiss.dbeaver.ext.mysql.MySQLMessages;
import org.jkiss.dbeaver.ext.mysql.MySQLServerHome;
import org.jkiss.dbeaver.ext.mysql.model.MySQLCatalog;
import org.jkiss.dbeaver.ext.mysql.tools.MySQLScriptExecuteWizardPageSettings;
import org.jkiss.dbeaver.ext.mysql.tools.MySQLToolScript;
import org.jkiss.dbeaver.model.connection.DBPNativeClientLocation;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.ui.dialogs.tools.AbstractScriptExecuteWizard;
import org.jkiss.dbeaver.ui.dialogs.tools.AbstractToolWizard;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

class MySQLScriptExecuteWizard
extends AbstractScriptExecuteWizard<MySQLCatalog, MySQLCatalog> {
    private LogLevel logLevel;
    private boolean noBeep;
    private boolean isImport;
    private MySQLScriptExecuteWizardPageSettings mainPage;

    public MySQLScriptExecuteWizard(MySQLCatalog catalog, boolean isImport) {
        super(Collections.singleton(catalog), isImport ? MySQLMessages.tools_script_execute_wizard_db_import : MySQLMessages.tools_script_execute_wizard_execute_script);
        this.isImport = isImport;
        this.logLevel = LogLevel.Normal;
        this.noBeep = true;
        this.mainPage = new MySQLScriptExecuteWizardPageSettings(this);
    }

    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(LogLevel logLevel) {
        this.logLevel = logLevel;
    }

    public boolean isImport() {
        return this.isImport;
    }

    public boolean isVerbose() {
        return this.logLevel == LogLevel.Verbose || this.logLevel == LogLevel.Debug;
    }

    public void addPages() {
        this.addPage((IWizardPage)this.mainPage);
        super.addPages();
    }

    public void fillProcessParameters(List<String> cmd, MySQLCatalog arg) throws IOException {
        String dumpPath = RuntimeUtils.getNativeClientBinary((DBPNativeClientLocation)this.getClientHome(), (String)"bin", (String)"mysql").getAbsolutePath();
        cmd.add(dumpPath);
        if (this.logLevel == LogLevel.Debug) {
            cmd.add("--debug-info");
        }
        if (this.noBeep) {
            cmd.add("--no-beep");
        }
        this.addExtraCommandArgs(cmd);
    }

    protected void setupProcessParameters(ProcessBuilder process) {
        if (!CommonUtils.isEmpty((String)this.getToolUserPassword())) {
            process.environment().put("MYSQL_PWD", this.getToolUserPassword());
        }
    }

    public MySQLServerHome findNativeClientHome(String clientHomeId) {
        return MySQLDataSourceProvider.getServerHome(clientHomeId);
    }

    public Collection<MySQLCatalog> getRunInfo() {
        return this.getDatabaseObjects();
    }

    protected List<String> getCommandLine(MySQLCatalog arg) throws IOException {
        List<String> cmd = MySQLToolScript.getMySQLToolCommandLine(this, arg);
        cmd.add(arg.getName());
        return cmd;
    }

    protected void startProcessHandler(DBRProgressMonitor monitor, MySQLCatalog arg, ProcessBuilder processBuilder, Process process) {
        if (this.isImport) {
            this.logPage.startLogReader(processBuilder, process.getInputStream());
            new AbstractToolWizard.BinaryFileTransformerJob((AbstractToolWizard)this, monitor, this.getInputFile(), process.getOutputStream()).start();
        } else {
            super.startProcessHandler(monitor, (Object)arg, processBuilder, process);
        }
    }

    static enum LogLevel {
        Normal,
        Verbose,
        Debug;

    }
}

